/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.customaudience;

import android.adservices.common.AdSelectionSignals;
import android.adservices.common.AdTechIdentifier;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import java.util.Objects;

public class AddCustomAudienceOverrideRequest {
    @NonNull
    private final AdTechIdentifier mBuyer;
    @NonNull
    private final String mName;
    @NonNull
    private final String mBiddingLogicJs;
    private final long mBiddingLogicJsVersion;
    @NonNull
    private final AdSelectionSignals mTrustedBiddingSignals;

    public AddCustomAudienceOverrideRequest(@NonNull AdTechIdentifier buyer, @NonNull String name, @NonNull String biddingLogicJs, @NonNull AdSelectionSignals trustedBiddingSignals) {
        this(buyer, name, biddingLogicJs, 0L, trustedBiddingSignals);
    }

    private AddCustomAudienceOverrideRequest(@NonNull AdTechIdentifier buyer, @NonNull String name, @NonNull String biddingLogicJs, long biddingLogicJsVersion, @NonNull AdSelectionSignals trustedBiddingSignals) {
        this.mBuyer = buyer;
        this.mName = name;
        this.mBiddingLogicJs = biddingLogicJs;
        this.mBiddingLogicJsVersion = biddingLogicJsVersion;
        this.mTrustedBiddingSignals = trustedBiddingSignals;
    }

    @NonNull
    public AdTechIdentifier getBuyer() {
        return this.mBuyer;
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    @NonNull
    public String getBiddingLogicJs() {
        return this.mBiddingLogicJs;
    }

    @FlaggedApi(value="com.android.adservices.flags.fledge_ad_selection_filtering_enabled")
    public long getBiddingLogicJsVersion() {
        return this.mBiddingLogicJsVersion;
    }

    @NonNull
    public AdSelectionSignals getTrustedBiddingSignals() {
        return this.mTrustedBiddingSignals;
    }

    public static class Builder {
        @Nullable
        private AdTechIdentifier mBuyer;
        @Nullable
        private String mName;
        @Nullable
        private String mBiddingLogicJs;
        private long mBiddingLogicJsVersion;
        @Nullable
        private AdSelectionSignals mTrustedBiddingSignals;

        @NonNull
        public Builder setBuyer(@NonNull AdTechIdentifier buyer) {
            Objects.requireNonNull(buyer);
            this.mBuyer = buyer;
            return this;
        }

        @NonNull
        public Builder setName(@NonNull String name) {
            Objects.requireNonNull(name);
            this.mName = name;
            return this;
        }

        @NonNull
        public Builder setTrustedBiddingSignals(@NonNull AdSelectionSignals trustedBiddingSignals) {
            Objects.requireNonNull(trustedBiddingSignals);
            this.mTrustedBiddingSignals = trustedBiddingSignals;
            return this;
        }

        @NonNull
        public Builder setBiddingLogicJs(@NonNull String biddingLogicJs) {
            Objects.requireNonNull(biddingLogicJs);
            this.mBiddingLogicJs = biddingLogicJs;
            return this;
        }

        @FlaggedApi(value="com.android.adservices.flags.fledge_ad_selection_filtering_enabled")
        @NonNull
        public Builder setBiddingLogicJsVersion(long biddingLogicJsVersion) {
            this.mBiddingLogicJsVersion = biddingLogicJsVersion;
            return this;
        }

        @NonNull
        public AddCustomAudienceOverrideRequest build() {
            Objects.requireNonNull(this.mBuyer);
            Objects.requireNonNull(this.mName);
            Objects.requireNonNull(this.mBiddingLogicJs);
            Objects.requireNonNull(this.mTrustedBiddingSignals);
            return new AddCustomAudienceOverrideRequest(this.mBuyer, this.mName, this.mBiddingLogicJs, this.mBiddingLogicJsVersion, this.mTrustedBiddingSignals);
        }
    }
}

