/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.common;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.util.Objects;

@SystemApi
public class EnableAdServicesResponse
implements Parcelable {
    private final int mStatusCode;
    private final String mErrorMessage;
    private final boolean mIsSuccess;
    private final boolean mIsApiEnabled;
    @NonNull
    public static final Parcelable.Creator<EnableAdServicesResponse> CREATOR = new Parcelable.Creator<EnableAdServicesResponse>(){

        @Override
        public EnableAdServicesResponse createFromParcel(@NonNull Parcel in) {
            Objects.requireNonNull(in);
            return new EnableAdServicesResponse(in);
        }

        public EnableAdServicesResponse[] newArray(int size) {
            return new EnableAdServicesResponse[size];
        }
    };

    private EnableAdServicesResponse(int statusCode, @Nullable String errorMessage, boolean isSuccess, boolean isApiEnabled) {
        this.mStatusCode = statusCode;
        this.mErrorMessage = errorMessage;
        this.mIsSuccess = isSuccess;
        this.mIsApiEnabled = isApiEnabled;
    }

    private EnableAdServicesResponse(@NonNull Parcel in) {
        this.mStatusCode = in.readInt();
        this.mErrorMessage = in.readString();
        this.mIsSuccess = in.readBoolean();
        this.mIsApiEnabled = in.readBoolean();
    }

    int getStatusCode() {
        return this.mStatusCode;
    }

    public boolean isSuccess() {
        return this.mIsSuccess;
    }

    public boolean isApiEnabled() {
        return this.mIsApiEnabled;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        dest.writeInt(this.mStatusCode);
        dest.writeString(this.mErrorMessage);
        dest.writeBoolean(this.mIsSuccess);
        dest.writeBoolean(this.mIsApiEnabled);
    }

    public String toString() {
        return "EnableAdServicesResponse{mStatusCode=" + this.mStatusCode + ", mErrorMessage=" + this.mErrorMessage + ", mIsSuccess=" + this.mIsSuccess + ", mIsApiEnabled=" + this.mIsApiEnabled + "'}";
    }

    public static class Builder {
        private int mStatusCode = -1;
        @Nullable
        private String mErrorMessage;
        private boolean mIsSuccess;
        private boolean mIsApiEnabled;

        @NonNull
        public Builder setStatusCode(int statusCode) {
            this.mStatusCode = statusCode;
            return this;
        }

        @NonNull
        public Builder setErrorMessage(@Nullable String errorMessage) {
            this.mErrorMessage = errorMessage;
            return this;
        }

        @NonNull
        public Builder setSuccess(boolean isSuccess) {
            this.mIsSuccess = isSuccess;
            return this;
        }

        @NonNull
        public Builder setApiEnabled(boolean isApiEnabled) {
            this.mIsApiEnabled = isApiEnabled;
            return this;
        }

        @NonNull
        public EnableAdServicesResponse build() {
            Preconditions.checkArgument(this.mStatusCode != -1, "Status code has not been set!");
            return new EnableAdServicesResponse(this.mStatusCode, this.mErrorMessage, this.mIsSuccess, this.mIsApiEnabled);
        }
    }
}

