/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.common;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseIntArray;
import com.android.internal.util.Preconditions;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.adservices.flags.adservices_enable_per_module_overrides_api")
public class AdServicesModuleStatesResponse
implements Parcelable {
    private final int mStatusCode;
    private final String mErrorMessage;
    private final SparseIntArray mModuleStates;
    @NonNull
    public static final Parcelable.Creator<AdServicesModuleStatesResponse> CREATOR = new Parcelable.Creator<AdServicesModuleStatesResponse>(){

        @Override
        public AdServicesModuleStatesResponse createFromParcel(@NonNull Parcel in) {
            Objects.requireNonNull(in);
            return new AdServicesModuleStatesResponse(in);
        }

        public AdServicesModuleStatesResponse[] newArray(int size) {
            return new AdServicesModuleStatesResponse[size];
        }
    };

    private AdServicesModuleStatesResponse(int statusCode, @Nullable String errorMessage, SparseIntArray moduleStates) {
        this.mStatusCode = statusCode;
        this.mErrorMessage = errorMessage;
        this.mModuleStates = moduleStates;
    }

    private AdServicesModuleStatesResponse(@NonNull Parcel in) {
        this.mStatusCode = in.readInt();
        this.mErrorMessage = in.readString();
        int moduleStatesSize = in.readInt();
        this.mModuleStates = new SparseIntArray(moduleStatesSize);
        for (int i = 0; i < moduleStatesSize; ++i) {
            this.mModuleStates.put(in.readInt(), in.readInt());
        }
    }

    int getStatusCode() {
        return this.mStatusCode;
    }

    @NonNull
    public SparseIntArray getModuleStates() {
        return this.mModuleStates;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        Objects.requireNonNull(out);
        out.writeInt(this.mStatusCode);
        out.writeString(this.mErrorMessage);
        int size = this.mModuleStates.size();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeInt(this.mModuleStates.keyAt(i));
            out.writeInt(this.mModuleStates.valueAt(i));
        }
    }

    public String toString() {
        return "EnableAdServicesResponse{mStatusCode=" + this.mStatusCode + ", mErrorMessage=" + this.mErrorMessage + ", mModuleStates=" + this.mModuleStates + "'}";
    }

    public static class Builder {
        private int mStatusCode = -1;
        @Nullable
        private String mErrorMessage;
        private SparseIntArray mModuleStates;

        @NonNull
        public Builder setStatusCode(int statusCode) {
            this.mStatusCode = statusCode;
            return this;
        }

        @NonNull
        public Builder setErrorMessage(@Nullable String errorMessage) {
            this.mErrorMessage = errorMessage;
            return this;
        }

        @NonNull
        public Builder setModuleStates(@Nullable SparseIntArray moduleStates) {
            this.mModuleStates = moduleStates;
            return this;
        }

        @NonNull
        public AdServicesModuleStatesResponse build() {
            Preconditions.checkArgument(this.mStatusCode != -1, "Status code has not been set!");
            return new AdServicesModuleStatesResponse(this.mStatusCode, this.mErrorMessage, this.mModuleStates);
        }
    }
}

