/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.common.AdTechIdentifier;
import android.annotation.NonNull;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class UpdateAdCounterHistogramRequest {
    public static final String UNSET_AD_EVENT_TYPE_MESSAGE = "Ad event type must be set";
    public static final String DISALLOW_AD_EVENT_TYPE_WIN_MESSAGE = "Win event types cannot be manually updated";
    public static final String INVALID_AD_EVENT_TYPE_MESSAGE = "Ad event type must be one of AD_EVENT_TYPE_IMPRESSION, AD_EVENT_TYPE_VIEW, or AD_EVENT_TYPE_CLICK";
    public static final String UNSET_CALLER_ADTECH_MESSAGE = "Caller ad tech must not be null";
    private final long mAdSelectionId;
    private final int mAdEventType;
    @NonNull
    private final AdTechIdentifier mCallerAdTech;

    private UpdateAdCounterHistogramRequest(@NonNull Builder builder) {
        Objects.requireNonNull(builder);
        this.mAdSelectionId = builder.mAdSelectionId;
        this.mAdEventType = builder.mAdEventType;
        this.mCallerAdTech = builder.mCallerAdTech;
    }

    public long getAdSelectionId() {
        return this.mAdSelectionId;
    }

    public int getAdEventType() {
        return this.mAdEventType;
    }

    @NonNull
    public AdTechIdentifier getCallerAdTech() {
        return this.mCallerAdTech;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateAdCounterHistogramRequest)) {
            return false;
        }
        UpdateAdCounterHistogramRequest that = (UpdateAdCounterHistogramRequest)o;
        return this.mAdSelectionId == that.mAdSelectionId && this.mAdEventType == that.mAdEventType && this.mCallerAdTech.equals(that.mCallerAdTech);
    }

    public int hashCode() {
        return Objects.hash(this.mAdSelectionId, this.mAdEventType, this.mCallerAdTech);
    }

    public String toString() {
        return "UpdateAdCounterHistogramRequest{mAdSelectionId=" + this.mAdSelectionId + ", mAdEventType=" + this.mAdEventType + ", mCallerAdTech=" + this.mCallerAdTech + '}';
    }

    public static class Builder {
        private long mAdSelectionId;
        private int mAdEventType;
        @NonNull
        private AdTechIdentifier mCallerAdTech;

        public Builder(long adSelectionId, int adEventType, @NonNull AdTechIdentifier callerAdTech) {
            Preconditions.checkArgument(adSelectionId != 0L, "Non-zero ad selection ID must be set");
            Preconditions.checkArgument(adEventType != 0, UpdateAdCounterHistogramRequest.DISALLOW_AD_EVENT_TYPE_WIN_MESSAGE);
            Preconditions.checkArgument(adEventType >= 0 && adEventType <= 3, UpdateAdCounterHistogramRequest.INVALID_AD_EVENT_TYPE_MESSAGE);
            Objects.requireNonNull(callerAdTech, UpdateAdCounterHistogramRequest.UNSET_CALLER_ADTECH_MESSAGE);
            this.mAdSelectionId = adSelectionId;
            this.mAdEventType = adEventType;
            this.mCallerAdTech = callerAdTech;
        }

        @NonNull
        public Builder setAdSelectionId(long adSelectionId) {
            Preconditions.checkArgument(adSelectionId != 0L, "Non-zero ad selection ID must be set");
            this.mAdSelectionId = adSelectionId;
            return this;
        }

        @NonNull
        public Builder setAdEventType(int adEventType) {
            Preconditions.checkArgument(adEventType != 0, UpdateAdCounterHistogramRequest.DISALLOW_AD_EVENT_TYPE_WIN_MESSAGE);
            Preconditions.checkArgument(adEventType >= 0 && adEventType <= 3, UpdateAdCounterHistogramRequest.INVALID_AD_EVENT_TYPE_MESSAGE);
            this.mAdEventType = adEventType;
            return this;
        }

        @NonNull
        public Builder setCallerAdTech(@NonNull AdTechIdentifier callerAdTech) {
            Objects.requireNonNull(callerAdTech, UpdateAdCounterHistogramRequest.UNSET_CALLER_ADTECH_MESSAGE);
            this.mCallerAdTech = callerAdTech;
            return this;
        }

        @NonNull
        public UpdateAdCounterHistogramRequest build() {
            return new UpdateAdCounterHistogramRequest(this);
        }
    }
}

