/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.common.AdTechIdentifier;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class RemoveAdCounterHistogramOverrideInput
implements Parcelable {
    private final int mAdEventType;
    private final int mAdCounterKey;
    @NonNull
    private final AdTechIdentifier mBuyer;
    @NonNull
    public static final Parcelable.Creator<RemoveAdCounterHistogramOverrideInput> CREATOR = new Parcelable.Creator<RemoveAdCounterHistogramOverrideInput>(){

        @Override
        public RemoveAdCounterHistogramOverrideInput createFromParcel(@NonNull Parcel in) {
            Objects.requireNonNull(in);
            return new RemoveAdCounterHistogramOverrideInput(in);
        }

        public RemoveAdCounterHistogramOverrideInput[] newArray(int size) {
            return new RemoveAdCounterHistogramOverrideInput[size];
        }
    };

    private RemoveAdCounterHistogramOverrideInput(@NonNull Builder builder) {
        Objects.requireNonNull(builder);
        this.mAdEventType = builder.mAdEventType;
        this.mAdCounterKey = builder.mAdCounterKey;
        this.mBuyer = builder.mBuyer;
    }

    private RemoveAdCounterHistogramOverrideInput(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        this.mAdEventType = in.readInt();
        this.mAdCounterKey = in.readInt();
        this.mBuyer = AdTechIdentifier.fromString(in.readString());
    }

    public int getAdEventType() {
        return this.mAdEventType;
    }

    @NonNull
    public int getAdCounterKey() {
        return this.mAdCounterKey;
    }

    @NonNull
    public AdTechIdentifier getBuyer() {
        return this.mBuyer;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "RemoveAdCounterHistogramOverrideInput{mAdEventType=" + this.mAdEventType + ", mAdCounterKey=" + this.mAdCounterKey + ", mBuyer=" + this.mBuyer + '}';
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        dest.writeInt(this.mAdEventType);
        dest.writeInt(this.mAdCounterKey);
        dest.writeString(this.mBuyer.toString());
    }

    public static class Builder {
        private int mAdEventType = -1;
        private int mAdCounterKey;
        @Nullable
        private AdTechIdentifier mBuyer;

        @NonNull
        public Builder setAdEventType(int adEventType) {
            this.mAdEventType = adEventType;
            return this;
        }

        @NonNull
        public Builder setAdCounterKey(int adCounterKey) {
            this.mAdCounterKey = adCounterKey;
            return this;
        }

        @NonNull
        public Builder setBuyer(@NonNull AdTechIdentifier buyer) {
            Objects.requireNonNull(buyer, "Buyer must not be null");
            this.mBuyer = buyer;
            return this;
        }

        @NonNull
        public RemoveAdCounterHistogramOverrideInput build() throws NullPointerException, IllegalArgumentException {
            Preconditions.checkArgument(this.mAdEventType != -1, "Ad event type must be set");
            Objects.requireNonNull(this.mBuyer, "Buyer must not be null");
            return new RemoveAdCounterHistogramOverrideInput(this);
        }
    }
}

