/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.adselection.SellerConfiguration;
import android.adservices.common.AdTechIdentifier;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.adservices.AdServicesParcelableUtil;
import java.util.Objects;

public class GetAdSelectionDataInput
implements Parcelable {
    @Nullable
    private final AdTechIdentifier mSeller;
    @NonNull
    private final String mCallerPackageName;
    @Nullable
    private final Uri mCoordinatorOriginUri;
    @Nullable
    private final SellerConfiguration mSellerConfiguration;
    @NonNull
    public static final Parcelable.Creator<GetAdSelectionDataInput> CREATOR = new Parcelable.Creator<GetAdSelectionDataInput>(){

        @Override
        public GetAdSelectionDataInput createFromParcel(Parcel in) {
            return new GetAdSelectionDataInput(in);
        }

        public GetAdSelectionDataInput[] newArray(int size) {
            return new GetAdSelectionDataInput[size];
        }
    };

    private GetAdSelectionDataInput(@Nullable AdTechIdentifier seller, @NonNull String callerPackageName, @Nullable Uri coordinatorOriginUri, @Nullable SellerConfiguration sellerConfiguration) {
        Objects.requireNonNull(callerPackageName);
        this.mSeller = seller;
        this.mCallerPackageName = callerPackageName;
        this.mCoordinatorOriginUri = coordinatorOriginUri;
        this.mSellerConfiguration = sellerConfiguration;
    }

    private GetAdSelectionDataInput(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        this.mSeller = AdServicesParcelableUtil.readNullableFromParcel(in, AdTechIdentifier.CREATOR::createFromParcel);
        this.mCallerPackageName = in.readString();
        this.mCoordinatorOriginUri = AdServicesParcelableUtil.readNullableFromParcel(in, Uri.CREATOR::createFromParcel);
        this.mSellerConfiguration = AdServicesParcelableUtil.readNullableFromParcel(in, SellerConfiguration.CREATOR::createFromParcel);
    }

    public boolean equals(Object o) {
        if (o instanceof GetAdSelectionDataInput) {
            GetAdSelectionDataInput obj = (GetAdSelectionDataInput)o;
            return Objects.equals(this.mSeller, obj.mSeller) && Objects.equals(this.mCallerPackageName, obj.mCallerPackageName) && Objects.equals(this.mCoordinatorOriginUri, obj.mCoordinatorOriginUri) && Objects.equals(this.mSellerConfiguration, obj.mSellerConfiguration);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mSeller, this.mCallerPackageName, this.mCoordinatorOriginUri, this.mSellerConfiguration);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mSeller, (targetParcel, sourceSignals) -> sourceSignals.writeToParcel(targetParcel, flags));
        dest.writeString(this.mCallerPackageName);
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mCoordinatorOriginUri, (targetParcel, sourceOrigin) -> sourceOrigin.writeToParcel(targetParcel, flags));
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mSellerConfiguration, (targetParcel, sourceOrigin) -> sourceOrigin.writeToParcel(targetParcel, flags));
    }

    @Nullable
    public AdTechIdentifier getSeller() {
        return this.mSeller;
    }

    @NonNull
    public String getCallerPackageName() {
        return this.mCallerPackageName;
    }

    @Nullable
    public Uri getCoordinatorOriginUri() {
        return this.mCoordinatorOriginUri;
    }

    @Nullable
    public SellerConfiguration getSellerConfiguration() {
        return this.mSellerConfiguration;
    }

    public static class Builder {
        @Nullable
        private AdTechIdentifier mSeller;
        @Nullable
        private String mCallerPackageName;
        @Nullable
        private Uri mCoordinatorOrigin;
        @Nullable
        private SellerConfiguration mSellerConfiguration;

        @NonNull
        public Builder setSeller(@Nullable AdTechIdentifier seller) {
            this.mSeller = seller;
            return this;
        }

        @NonNull
        public Builder setCallerPackageName(@NonNull String callerPackageName) {
            Objects.requireNonNull(callerPackageName);
            this.mCallerPackageName = callerPackageName;
            return this;
        }

        @NonNull
        public Builder setCoordinatorOriginUri(@Nullable Uri coordinatorOrigin) {
            this.mCoordinatorOrigin = coordinatorOrigin;
            return this;
        }

        @NonNull
        public Builder setSellerConfiguration(@Nullable SellerConfiguration sellerConfiguration) {
            this.mSellerConfiguration = sellerConfiguration;
            return this;
        }

        @NonNull
        public GetAdSelectionDataInput build() {
            Objects.requireNonNull(this.mCallerPackageName);
            return new GetAdSelectionDataInput(this.mSeller, this.mCallerPackageName, this.mCoordinatorOrigin, this.mSellerConfiguration);
        }
    }
}

