/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.accessibilityservice.AccessibilityInputMethodSession;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Handler;
import android.os.Looper;
import android.view.inputmethod.EditorInfo;
import com.android.internal.inputmethod.IAccessibilityInputMethodSession;
import com.android.internal.inputmethod.IRemoteAccessibilityInputConnection;
import java.util.concurrent.atomic.AtomicReference;

class AccessibilityInputMethodSessionWrapper
extends IAccessibilityInputMethodSession.Stub {
    private final Handler mHandler;
    @NonNull
    private final AtomicReference<AccessibilityInputMethodSession> mSessionRef;

    AccessibilityInputMethodSessionWrapper(@NonNull Looper looper, @NonNull AccessibilityInputMethodSession session) {
        this.mSessionRef = new AtomicReference<AccessibilityInputMethodSession>(session);
        this.mHandler = Handler.createAsync(looper);
    }

    @Nullable
    AccessibilityInputMethodSession getSession() {
        return this.mSessionRef.get();
    }

    @Override
    public void updateSelection(int oldSelStart, int oldSelEnd, int newSelStart, int newSelEnd, int candidatesStart, int candidatesEnd) {
        if (this.mHandler.getLooper().isCurrentThread()) {
            this.doUpdateSelection(oldSelStart, oldSelEnd, newSelStart, newSelEnd, candidatesStart, candidatesEnd);
        } else {
            this.mHandler.post(() -> this.doUpdateSelection(oldSelStart, oldSelEnd, newSelStart, newSelEnd, candidatesStart, candidatesEnd));
        }
    }

    private void doUpdateSelection(int oldSelStart, int oldSelEnd, int newSelStart, int newSelEnd, int candidatesStart, int candidatesEnd) {
        AccessibilityInputMethodSession session = this.mSessionRef.get();
        if (session != null) {
            session.updateSelection(oldSelStart, oldSelEnd, newSelStart, newSelEnd, candidatesStart, candidatesEnd);
        }
    }

    @Override
    public void finishInput() {
        if (this.mHandler.getLooper().isCurrentThread()) {
            this.doFinishInput();
        } else {
            this.mHandler.post(this::doFinishInput);
        }
    }

    private void doFinishInput() {
        AccessibilityInputMethodSession session = this.mSessionRef.get();
        if (session != null) {
            session.finishInput();
        }
    }

    @Override
    public void finishSession() {
        if (this.mHandler.getLooper().isCurrentThread()) {
            this.doFinishSession();
        } else {
            this.mHandler.post(this::doFinishSession);
        }
    }

    private void doFinishSession() {
        this.mSessionRef.set(null);
    }

    @Override
    public void invalidateInput(EditorInfo editorInfo, IRemoteAccessibilityInputConnection connection, int sessionId) {
        if (this.mHandler.getLooper().isCurrentThread()) {
            this.doInvalidateInput(editorInfo, connection, sessionId);
        } else {
            this.mHandler.post(() -> this.doInvalidateInput(editorInfo, connection, sessionId));
        }
    }

    private void doInvalidateInput(EditorInfo editorInfo, IRemoteAccessibilityInputConnection connection, int sessionId) {
        AccessibilityInputMethodSession session = this.mSessionRef.get();
        if (session != null) {
            session.invalidateInput(editorInfo, connection, sessionId);
        }
    }
}

