/*
 * Decompiled with CFR 0.152.
 */
package com.google.targetsdkversionassistant.plan;

import com.google.targetsdkversionassistant.dsl.ElementListBuilder;
import com.google.targetsdkversionassistant.dsl.Ordering;
import com.google.targetsdkversionassistant.dsl.Par;
import com.google.targetsdkversionassistant.dsl.Seq;
import com.google.targetsdkversionassistant.plan.ApiUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/google/targetsdkversionassistant/plan/Api36;", "", "<init>", "()V", "label", "", "getLabel", "()Ljava/lang/String;", "api36ChangesLink", "description", "getDescription", "edgeToEdge", "Lcom/google/targetsdkversionassistant/dsl/Seq;", "predictiveBack", "removeUiFonts", "scheduleAtFixedRate", "adaptiveLayouts", "healthFitnessPermissions", "bondLossHandlingChange", "bondRemovalApi", "mediastoreLockdown", "saferIntents", "localNetworkPermission", "photoPickerOwnedPhotos", "behaviorChanges16", "Lcom/google/targetsdkversionassistant/dsl/Par;", "steps", "getSteps", "()Lcom/google/targetsdkversionassistant/dsl/Seq;", "targetsdkversion-upgrade-assistant"})
public final class Api36 {
    @NotNull
    public static final Api36 INSTANCE = new Api36();
    @NotNull
    private static final String label = ApiUtils.INSTANCE.rarrow$targetsdkversion_upgrade_assistant("Android 15 / API level 35", "Android 16 / API level 36");
    @NotNull
    private static final String api36ChangesLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Android 16 behavior changes", "https://developer.android.com/about/versions/16/behavior-changes-16");
    @NotNull
    private static final String description = StringsKt.trimIndent((String)("\n    Here are the major steps required to migrate from Android 15 (API level 35) to Android 16 (API level 36).\n    " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n    For the complete list of changes introduced in Android 16 (API level 36), see the " + api36ChangesLink + ".\n    "));
    @NotNull
    private static final Seq edgeToEdge = Ordering.Companion.seq((Function1<? super Seq, Unit>)((Function1)Api36::edgeToEdge$lambda$0));
    @NotNull
    private static final Seq predictiveBack = Ordering.Companion.seq((Function1<? super Seq, Unit>)((Function1)Api36::predictiveBack$lambda$0));
    @NotNull
    private static final Seq removeUiFonts = Ordering.Companion.seq((Function1<? super Seq, Unit>)((Function1)Api36::removeUiFonts$lambda$0));
    @NotNull
    private static final Seq scheduleAtFixedRate = Ordering.Companion.seq((Function1<? super Seq, Unit>)((Function1)Api36::scheduleAtFixedRate$lambda$0));
    @NotNull
    private static final Seq adaptiveLayouts = Ordering.Companion.seq((Function1<? super Seq, Unit>)((Function1)Api36::adaptiveLayouts$lambda$0));
    @NotNull
    private static final Seq healthFitnessPermissions = Ordering.Companion.seq((Function1<? super Seq, Unit>)((Function1)Api36::healthFitnessPermissions$lambda$0));
    @NotNull
    private static final Seq bondLossHandlingChange = Ordering.Companion.seq((Function1<? super Seq, Unit>)((Function1)Api36::bondLossHandlingChange$lambda$0));
    @NotNull
    private static final Seq bondRemovalApi = Ordering.Companion.seq((Function1<? super Seq, Unit>)((Function1)Api36::bondRemovalApi$lambda$0));
    @NotNull
    private static final Seq mediastoreLockdown = Ordering.Companion.seq((Function1<? super Seq, Unit>)((Function1)Api36::mediastoreLockdown$lambda$0));
    @NotNull
    private static final Seq saferIntents = Ordering.Companion.seq((Function1<? super Seq, Unit>)((Function1)Api36::saferIntents$lambda$0));
    @NotNull
    private static final Seq localNetworkPermission = Ordering.Companion.seq((Function1<? super Seq, Unit>)((Function1)Api36::localNetworkPermission$lambda$0));
    @NotNull
    private static final Seq photoPickerOwnedPhotos = Ordering.Companion.seq((Function1<? super Seq, Unit>)((Function1)Api36::photoPickerOwnedPhotos$lambda$0));
    @NotNull
    private static final Par behaviorChanges16 = Ordering.Companion.par((Function1<? super Par, Unit>)((Function1)Api36::behaviorChanges16$lambda$0));
    @NotNull
    private static final Seq steps = Ordering.Companion.seq((Function1<? super Seq, Unit>)((Function1)Api36::steps$lambda$0));

    private Api36() {
    }

    @NotNull
    public final String getLabel() {
        return label;
    }

    @NotNull
    public final String getDescription() {
        return description;
    }

    @NotNull
    public final Seq getSteps() {
        return steps;
    }

    private static final Unit edgeToEdge$lambda$0(Seq $this$seq) {
        Intrinsics.checkNotNullParameter((Object)$this$seq, (String)"$this$seq");
        $this$seq.raw("Edge to edge opt-out going away", (Function1<? super ElementListBuilder, Unit>)((Function1)Api36::edgeToEdge$lambda$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit edgeToEdge$lambda$0$0(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        String api15e2e = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Android 15 enforced edge-to-edge", "https://developer.android.com/about/versions/15/behavior-changes-15#edge-to-edge");
        String optOutAttr = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("R.attr#windowOptOutEdgeToEdgeEnforcement");
        String optOutLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(optOutAttr, "https://developer.android.com/reference/android/R.attr#windowOptOutEdgeToEdgeEnforcement");
        String compose = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Compose", "https://developer.android.com/develop/ui/compose/layouts/insets");
        String views = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Views", "https://developer.android.com/develop/ui/views/layout/edge-to-edge");
        $this$raw.text(StringsKt.trimIndent((String)("\n          " + api15e2e + " for apps targeting Android 15 (API level 35),\n          but your app could opt-out by setting " + optOutLink + " to " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("true") + ".\n          For apps targeting Android 16 (API level 36), " + optOutAttr + "\n          is deprecated and disabled, and your app can't opt-out of going edge-to-edge.\n          " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              If your app targets Android 16 (API level 36) and is running on an Android 15 device,\n              " + optOutAttr + " continues to work.\n              "))) + "\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              If your app targets Android 16 (API level 36) and is running on an Android 16 device,\n              " + optOutAttr + " is disabled.\n              "))) + "\n          "))) + "\n          For testing in Android 16, ensure your app supports edge-to-edge and remove any\n          use of " + optOutAttr + " so that your app also supports edge-to-edge on an Android 15 device.\n          To support edge-to-edge, see the " + compose + " and " + views + " guidance.\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit predictiveBack$lambda$0(Seq $this$seq) {
        Intrinsics.checkNotNullParameter((Object)$this$seq, (String)"$this$seq");
        $this$seq.raw("Migration or opt-out required for predictive back", (Function1<? super ElementListBuilder, Unit>)((Function1)Api36::predictiveBack$lambda$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit predictiveBack$lambda$0$0(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        String backEvent = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("KeyEvent.KEYCODE_BACK"), "https://developer.android.com/reference/android/view/KeyEvent#KEYCODE_BACK");
        String newApiLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("update your app to use supported back navigation APIs", "https://developer.android.com/guide/navigation/custom-back/predictive-back-gesture#update-custom");
        String optOutLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("android:enableOnBackInvokedCallback"), "https://developer.android.com/guide/topics/manifest/activity-element#enableOnBackInvokedCallback");
        String app = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.angle$targetsdkversion_upgrade_assistant("application"));
        String act = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.angle$targetsdkversion_upgrade_assistant("activity"));
        $this$raw.text(StringsKt.trimIndent((String)("\n          For apps targeting Android 16 (API level 36) or higher and running on an Android 16 or\n          higher device, the predictive back system animations (back-to-home, cross-task, and\n          cross-activity) are enabled by default. Additionally, " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("onBackPressed") + " is\n          not called and " + backEvent + " is not dispatched anymore.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          If your app intercepts the back event and you haven't migrated to predictive back yet,\n          " + newApiLink + ", or temporarily opt out by setting the " + optOutLink + " attribute to\n          " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("false") + " in the " + app + " or " + act + " tag of your app's\n          " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("AndroidManifest.xml") + " file.\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit removeUiFonts$lambda$0(Seq $this$seq) {
        Intrinsics.checkNotNullParameter((Object)$this$seq, (String)"$this$seq");
        $this$seq.raw("Elegant font APIs deprecated and disabled", (Function1<? super ElementListBuilder, Unit>)((Function1)Api36::removeUiFonts$lambda$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit removeUiFonts$lambda$0$0(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        String ethCode = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("elegantTextHeight");
        String ethLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ethCode, "https://developer.android.com/reference/android/R.attr#elegantTextHeight");
        String tv = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("TextView"), "https://developer.android.com/reference/android/widget/TextView");
        String f = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("false");
        $this$raw.text(StringsKt.trimIndent((String)("\n          Apps targeting Android 15 (API level 35) have the " + ethLink + " " + tv + " attribute set to\n          " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("true") + " by default, replacing the compact font with one that is much more\n          readable. You could override this by setting the " + ethCode + " attribute to " + f + ".\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          Android 16 deprecates the " + ethLink + " attribute, and the attribute will be ignored once your\n          app targets Android 16. The \"UI fonts\" controlled by these APIs are being discontinued,\n          so you should adapt any layouts to ensure consistent and future proof text rendering in\n          Arabic, Lao, Myanmar, Tamil, Gujarati, Kannada, Malayalam, Odia, Telugu or Thai.\n          ")));
        ApiUtils.captioned$targetsdkversion_upgrade_assistant$default(ApiUtils.INSTANCE, $this$raw, StringsKt.trimIndent((String)("\n            " + ethCode + " behavior for apps targeting Android 14 (API level 34) and lower, or for apps\n            targeting Android 15 (API level 35) that overrode the default by setting the " + ethCode + "\n            attribute to " + f + ".\n            ")), "/plan/api36/elegant-text-height-before.png", 0, 0, 12, null);
        ApiUtils.captioned$targetsdkversion_upgrade_assistant$default(ApiUtils.INSTANCE, $this$raw, StringsKt.trimIndent((String)("\n            " + ethCode + " behavior for apps targeting Android 16 (API level 36), or for apps targeting\n            Android 15 (API level 35) that didn't override the default by setting the " + ethCode + "\n            attribute to " + f + ".\n            ")), "/plan/api36/elegant-text-height-after.png", 0, 0, 12, null);
        return Unit.INSTANCE;
    }

    private static final Unit scheduleAtFixedRate$lambda$0(Seq $this$seq) {
        Intrinsics.checkNotNullParameter((Object)$this$seq, (String)"$this$seq");
        $this$seq.filtered("Fixed rate work scheduling optimization", "scheduleAtFixedRate", (Function1<? super ElementListBuilder, Unit>)((Function1)Api36::scheduleAtFixedRate$lambda$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit scheduleAtFixedRate$lambda$0$0(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        String safr = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("scheduleAtFixedRate"), "https://developer.android.com/reference/java/util/concurrent/ScheduledExecutorService#scheduleAtFixedRate(java.lang.Runnable,%20long,%20long,%20java.util.concurrent.TimeUnit)");
        String pl = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("process lifecycle", "https://developer.android.com/guide/components/activities/process-lifecycle");
        String acf = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("app compatibility framework", "https://developer.android.com/guide/app-compatibility/test-debug");
        String smmpt = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("STPE_SKIP_MULTIPLE_MISSED_PERIODIC_TASKS");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          Prior to targeting Android 16, when " + safr + " missed a task execution due to being outside a\n          valid " + pl + ", " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("all") + " missed executions immediately execute when the app returns to a\n          valid lifecycle.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          When targeting Android 16, at most " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("one") + " missed execution of " + safr + " is immediately\n          executed when the app returns to a valid lifecycle. This behavior change is expected to\n          improve app performance. Test this behavior in your app to check if your app is impacted.\n          You can also test by using the " + acf + " and enabling the " + smmpt + " compat flag.\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit adaptiveLayouts$lambda$0(Seq $this$seq) {
        Intrinsics.checkNotNullParameter((Object)$this$seq, (String)"$this$seq");
        $this$seq.raw("Adaptive layouts", (Function1<? super ElementListBuilder, Unit>)((Function1)Api36::adaptiveLayouts$lambda$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit adaptiveLayouts$lambda$0$0(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text("With Android apps now running on a variety of devices (such as phones, tablets, foldables,\ndesktops, cars, and TVs) and windowing modes on large screens (such as split screen and\ndesktop windowing), developers should build Android apps that adapt to any screen and\nwindow size, regardless of device orientation. Paradigms like restricting orientation and\nresizability are too restrictive in today's multidevice world.");
        String newModel = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Android is moving toward a model", "https://android-developers.googleblog.com/2025/01/orientation-and-resizability-changes-in-android-16.html");
        String adapt = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("making your app adaptive", "https://developer.android.com/adaptive-apps");
        String acf = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("app compatibility framework", "https://developer.android.com/guide/app-compatibility/test-debug");
        String urbd = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("UNIVERSAL_RESIZABLE_BY_DEFAULT");
        $this$raw.text(StringsKt.trimIndent((String)("\n          " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Ignore orientation, resizability, and aspect ratio restrictions") + "\n          For apps targeting Android 16 (API level 36), Android 16 includes changes to how the\n          system manages orientation, resizability, and aspect ratio restrictions. On displays with\n          smallest width >= 600dp, the restrictions no longer apply. Apps also fill the entire\n          display window, regardless of aspect ratio or a user's preferred orientation, and\n          pillarboxing isn't used.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          This change introduces a new standard platform behavior. " + newModel + " where apps are expected\n          to adapt to various orientations, display sizes, and aspect ratios. Restrictions like\n          fixed orientation or limited resizability hinder app adaptability, so we recommend " + adapt + "\n          to deliver the best possible user experience.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          You can also test this behavior by using the " + acf + " and enabling the " + urbd + " compat flag.\n          ")));
        String adComp = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Learn more", "https://developer.android.com/develop/ui/compose/layouts/adaptive");
        String saveUiSt = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Save UI states", "https://developer.android.com/topic/libraries/architecture/saving-states");
        $this$raw.text(StringsKt.trimIndent((String)("\n          " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Common breaking changes") + "\n          Ignoring orientation, resizability, and aspect ratio restrictions might impact your app's\n          UI on some devices, especially elements that were designed for small layouts locked in\n          portrait orientation: for example, issues like stretched layouts and off-screen animations\n          and components. Any assumptions about aspect ratio or orientation can cause visual issues\n          with your app. " + adComp + " about how to avoid them and improve your app's adaptive behaviour.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          Allowing device rotation results in more activity re-creation, which can result in losing\n          user state if not properly preserved. Learn how to correctly save UI state in " + saveUiSt + ".\n          ")));
        String so = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("screenOrientation");
        String sro = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("setRequestedOrientation()");
        String gro = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("getRequestedOrientation()");
        String ra = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("android:resizeableActivity=\"false\"");
        String minar = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("android:minAspectRatio");
        String maxar = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("android:maxAspectRatio");
        String[] stringArray = new String[]{ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(so, "https://developer.android.com/guide/topics/manifest/activity-element#screen"), ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("resizableActivity"), "https://developer.android.com/guide/topics/manifest/activity-element#resizeableActivity"), ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("minAspectRatio"), "https://developer.android.com/guide/topics/manifest/activity-element#minaspectratio"), ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("maxAspectRatio"), "https://developer.android.com/guide/topics/manifest/activity-element#maxaspectratio"), ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(sro, "https://developer.android.com/reference/android/app/Activity#setRequestedOrientation(int)"), ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(gro, "https://developer.android.com/reference/android/app/Activity#getRequestedOrientation()")};
        String string = ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(stringArray);
        stringArray = new String[]{ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("portrait"), ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("reversePortrait"), ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("sensorPortrait"), ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("userPortrait"), ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("landscape"), ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("reverseLandscape"), ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("sensorLandscape"), ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("userLandscape")};
        $this$raw.text(StringsKt.trimIndent((String)("\n          " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Implementation details") + "\n          The following manifest attributes and runtime APIs are ignored across large screen devices\n          in full-screen and multi-window modes:\n          " + string + "\n          The following values for " + so + ", " + sro + ", and " + gro + " are ignored:\n          " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(stringArray) + "\n          Regarding display resizability, " + ra + ", " + minar + ", and " + maxar + " have no effect.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          For apps targeting Android 16 (API level 36), app orientation, resizability, and aspect\n          ratio constraints are ignored on large screens by default, but every app that isn't fully\n          ready can temporarily override this behavior by opting out (which results in the previous\n          behavior of being placed in compatibility mode).\n          ")));
        String appCat = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("android:appCategory"), "https://developer.android.com/guide/topics/manifest/application-element#appCategory");
        String[] stringArray2 = new String[]{"Games (based on the " + appCat + " flag)", "Users explicitly opting in to the app's default behavior in aspect ratio settings of the device", "Screens that are smaller than " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("sw600dp")};
        $this$raw.text(StringsKt.trimIndent((String)("\n          " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Exceptions") + "\n          The Android 16 orientation, resizability, and aspect ratio restrictions don't apply in the\n          following situations:\n          " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(stringArray2) + "\n          ")));
        String pcarr = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("PROPERTY_COMPAT_ALLOW_RESTRICTED_RESIZABILITY");
        $this$raw.text(StringsKt.trimIndent((String)("\n          " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Opt out temporarily") + "\n          To opt out a specific activity, declare the " + pcarr + " manifest property:\n          ")));
        $this$raw.xml("<activity ...>\n  <property android:name=\"android.window.PROPERTY_COMPAT_ALLOW_RESTRICTED_RESIZABILITY\" android:value=\"true\" />\n  ...\n</activity>");
        $this$raw.text("If too many parts of your app aren't ready for Android 16, you can opt out completely by\napplying the same property at the application level:");
        $this$raw.xml("<application ...>\n  <property android:name=\"android.window.PROPERTY_COMPAT_ALLOW_RESTRICTED_RESIZABILITY\" android:value=\"true\" />\n</application>");
        $this$raw.text(StringsKt.trimIndent((String)("\n          " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Important:") + " The opt-out is temporary and won't apply when targeting API level 37\n          in a future Android release. That is, for apps targeting API level 37, orientation,\n          resizability, and aspect ratio restrictions are ignored on displays that are at least\n          " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("sw600dp") + ".\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit healthFitnessPermissions$lambda$0(Seq $this$seq) {
        Intrinsics.checkNotNullParameter((Object)$this$seq, (String)"$this$seq");
        $this$seq.relevanceOnly("Health and fitness permissions", "bodySensorPermissions", (Function1<? super ElementListBuilder, Unit>)((Function1)Api36::healthFitnessPermissions$lambda$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit healthFitnessPermissions$lambda$0$0(ElementListBuilder $this$relevanceOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$relevanceOnly, (String)"$this$relevanceOnly");
        String bsC = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BODY_SENSORS");
        String bsL = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(bsC, "https://developer.android.com/reference/android/Manifest.permission#BODY_SENSORS");
        String aph = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("android.permissions.health");
        String hc = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Health Connect", "https://developer.android.com/health-and-fitness/guides/health-connect");
        String bsbC = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BODY_SENSORS_BACKGROUND");
        String hrb = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("HEART_RATE_BPM"), "https://developer.android.com/reference/kotlin/androidx/health/services/client/data/DataType#HEART_RATE_BPM()");
        String sthr = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Sensor.TYPE_HEART_RATE"), "https://developer.android.com/reference/android/hardware/Sensor#TYPE_HEART_RATE");
        String hra = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("heartRateAccuracy"), "https://developer.android.com/reference/androidx/wear/protolayout/expression/PlatformHealthSources#heartRateAccuracy()");
        String hrb2 = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("heartRateBpm"), "https://developer.android.com/reference/androidx/wear/protolayout/expression/PlatformHealthSources#heartRateBpm()");
        String fsth = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("FOREGROUND_SERVICE_TYPE_HEALTH"), "https://developer.android.com/develop/background-work/services/fgs/service-types#health");
        String rhrC = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_HEART_RATE");
        String rhrL = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(rhrC, "https://developer.android.com/reference/android/health/connect/HealthPermissions#READ_HEART_RATE");
        String rhdib = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_HEALTH_DATA_IN_BACKGROUND"), "https://developer.android.com/reference/android/health/connect/HealthPermissions#READ_HEALTH_DATA_IN_BACKGROUND");
        String bsbL = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(bsbC, "https://developer.android.com/reference/android/Manifest.permission#BODY_SENSORS_BACKGROUND");
        String[] stringArray = new String[]{hrb + " from Health Services on Wear OS", sthr + " from Android Sensor Manager", hra + " and " + hrb2 + " from " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("ProtoLayout") + " on Wear OS", fsth + " where the respective " + aph + " permission is needed in place of " + bsC};
        String string = ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(stringArray);
        stringArray = new String[]{StringsKt.trimMargin$default((String)("For while-in-use monitoring of Heart Rate, SpO2, or Skin Temperature: request the\n              |granular permission under " + aph + ", such as " + rhrL + " instead of " + bsL + "."), null, (int)1, null), "For background sensor access: request " + rhdib + " instead of " + bsbL + "."};
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n          For apps targeting Android 16 (API level 36) or higher, " + bsL + " permissions use more granular\n          permissions under " + aph + ", which " + hc + " also uses. As of Android 16, any API previously\n          requiring " + bsC + " or " + bsbC + " requires the corresponding " + aph + " permission instead. This affects\n          the following data types, APIs, and foreground service types:\n          " + string + "\n          If your app uses these APIs, it should request the respective granular permissions:\n          " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(stringArray) + "\n          These permissions are the same as those that guard access to reading data from " + hc + ", the\n          Android datastore for health, fitness, and wellness data.\n          ")));
        String act = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("declare an activity", "https://developer.android.com/health-and-fitness/guides/health-connect/develop/get-started#show-privacy-policy");
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n          " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Mobile apps") + "\n          Mobile apps migrating to use the " + rhrC + " and other granular permissions must also " + act + " to\n          display the app's privacy policy. This is the same requirement as Health Connect.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Important:") + " Failure to provide the rationale for mobile apps will result in the\n          permission being revoked.\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit bondLossHandlingChange$lambda$0(Seq $this$seq) {
        Intrinsics.checkNotNullParameter((Object)$this$seq, (String)"$this$seq");
        $this$seq.relevanceOnly("New intents to handle bond loss and encryption changes", "newIntentsForBondLoss", (Function1<? super ElementListBuilder, Unit>)((Function1)Api36::bondLossHandlingChange$lambda$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit bondLossHandlingChange$lambda$0$0(ElementListBuilder $this$relevanceOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$relevanceOnly, (String)"$this$relevanceOnly");
        String iblhURL = "https://developer.android.com/about/versions/16/behavior-changes-all#improved-bond-loss-handling";
        String iblh = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Improved bond loss handling", iblhURL);
        String akm = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("ACTION_KEY_MISSING"), "https://developer.android.com/reference/android/bluetooth/BluetoothDevice#ACTION_KEY_MISSING");
        String aec = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("ACTION_ENCRYPTION_CHANGE"), "https://developer.android.com/reference/android/bluetooth/BluetoothDevice#ACTION_ENCRYPTION_CHANGE");
        String[] stringArray = new String[]{StringsKt.trimMargin$default((String)("Receive an " + akm + " intent when remote bond loss is detected, allowing them to provide\n              |more informative user feedback and take appropriate actions."), null, (int)1, null), StringsKt.trimMargin$default((String)("Receive an " + aec + " intent whenever encryption status of the link changes. This includes\n              |encryption status change, encryption algorithm change, and encryption key size\n              |change. Apps must consider the bond restored if the link is successfully encrypted\n              |upon receiving " + aec + " intent later."), null, (int)1, null)};
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n          As part of the " + iblh + ", Android 16 also introduces 2 new intents to provide apps with\n          greater awareness of bond loss and encryption changes.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          Apps targeting Android 16 can now:\n          " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(stringArray) + "\n          ")));
        String aclBondInfo = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("here", iblhURL);
        String[] stringArray2 = new String[]{StringsKt.trimIndent((String)("\n            If the " + akm + " intent is broadcast:\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            The ACL (Asynchronous Connection-Less) link will be disconnected by the system, but the\n            bond information for the device will be retained (as described " + aclBondInfo + ").\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            Your app should use this intent as the primary signal for bond loss detection and\n            guiding the user to confirm the remote device is in range before initiating device\n            forgetting or re-pairing.\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            If a device disconnects after " + akm + " is received, your app should be cautious about\n            reconnecting, as the device may no longer be bonded with the system.\n            ")), StringsKt.trimIndent((String)("\n            If the " + akm + " intent is NOT broadcast:\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            The ACL link will remain connected, and the bond information for the device will be\n            removed by the system, same to behavior in Android 15.\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            In this scenario, your app should continue its existing bond loss handling mechanisms as\n            in previous Android releases, to detect and manage bond loss events.\n            "))};
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n          " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Adapting to varying OEM implementations") + "\n          While Android 16 introduces these new intents, their implementation and broadcasting can\n          vary across different device manufacturers (OEMs). To ensure your app provides a\n          consistent and reliable experience across all devices, developers should design their bond\n          loss handling to gracefully adapt to these potential variations.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          We recommend the following app behaviors:\n          " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(stringArray2) + "\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit bondRemovalApi$lambda$0(Seq $this$seq) {
        Intrinsics.checkNotNullParameter((Object)$this$seq, (String)"$this$seq");
        $this$seq.relevanceOnly("New way to remove bluetooth bond", "newWayToRemoveBluetoothBond", (Function1<? super ElementListBuilder, Unit>)((Function1)Api36::bondRemovalApi$lambda$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit bondRemovalApi$lambda$0$0(ElementListBuilder $this$relevanceOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$relevanceOnly, (String)"$this$relevanceOnly");
        String cdm = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("CompanionDeviceManager"), "https://developer.android.com/reference/android/companion/CompanionDeviceManager");
        String rb = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("removeBond(int)"), "https://developer.android.com/reference/android/companion/CompanionDeviceManager#removeBond(int)");
        String absc = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("ACTION_BOND_STATE_CHANGED"), "https://developer.android.com/reference/android/bluetooth/BluetoothDevice#ACTION_BOND_STATE_CHANGED");
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n          All apps targeting Android 16 are now able to unpair bluetooth devices using a public API\n          in " + cdm + ". If a companion device is being managed as a CDM association, then the app can\n          trigger bluetooth bond removal by using the new " + rb + " API on the associated device. The app\n          can monitor the bond state changes by listening to the bluetooth device broadcast event\n          " + absc + ".\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit mediastoreLockdown$lambda$0(Seq $this$seq) {
        Intrinsics.checkNotNullParameter((Object)$this$seq, (String)"$this$seq");
        $this$seq.filtered("MediaStore version lockdown", "mediaStoreLockdown", (Function1<? super ElementListBuilder, Unit>)((Function1)Api36::mediastoreLockdown$lambda$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit mediastoreLockdown$lambda$0$0(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        String msgv = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("MediaStore#getVersion()"), "https://developer.android.com/reference/android/provider/MediaStore#getVersion(android.content.Context)");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          For apps targeting Android 16 or higher, " + msgv + " will now be unique to each app. This\n          eliminates identifying properties from the version string to prevent abuse and usage for\n          fingerprinting techniques. Apps shouldn't make any assumptions around the format of this\n          version. Apps should already handle version changes when using this API and in most cases\n          shouldn't need to change their current behavior, unless the developer has attempted to\n          infer additional information that is beyond the intended scope of this API.\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit saferIntents$lambda$0(Seq $this$seq) {
        Intrinsics.checkNotNullParameter((Object)$this$seq, (String)"$this$seq");
        $this$seq.relevanceOnly("Safer Intents", "api36SaferIntents", (Function1<? super ElementListBuilder, Unit>)((Function1)Api36::saferIntents$lambda$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit saferIntents$lambda$0$0(ElementListBuilder $this$relevanceOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$relevanceOnly, (String)"$this$relevanceOnly");
        String a15 = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Android 15", "https://developer.android.com/about/versions/15/behavior-changes-15#safer-intents");
        String[] stringArray = new String[]{"Explicit Intents Must Match the Target Component's Intent Filter: If an intent\nexplicitly targets a component, it should match that component's intent filter.", "Intents Without an Action Cannot Match any Intent Filter: Intents that don't have an\naction specified shouldn't be resolved to any intent filter."};
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n          The Safer Intents feature is a multi-phase security initiative designed to improve the\n          security of Android's intent resolution mechanism. The goal is to protect apps from\n          malicious actions by adding checks during intent processing and filtering intents that\n          don't meet specific criteria.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          In " + a15 + " the feature focused on the sending app, now with Android 16, shifts control to the\n          receiving app, allowing developers to opt-in to strict intent resolution using their app\n          manifest.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          Two key changes are being implemented:\n          " + ApiUtils.INSTANCE.olist$targetsdkversion_upgrade_assistant(1, stringArray) + "\n          These changes only apply when multiple apps are involved and don't affect intent handling\n          within a single app.\n          ")));
        stringArray = new String[]{"Are aware of the Safer Intents feature and its benefits.", "Actively choose to incorporate stricter intent handling practices into their apps."};
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n          " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Impact") + "\n          The opt-in nature means that developers must explicitly enable it in their app manifest\n          for it to take effect. As a result, the feature's impact will be limited to apps whose\n          developers:\n          " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(stringArray) + "\n          This opt-in approach minimizes the risk of breaking existing apps that may rely on the\n          current less-secure intent resolution behavior.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          While the initial impact in Android 16 may be limited, the Safer Intents initiative has a\n          roadmap for broader impact in future Android releases. The plan is to eventually make\n          strict intent resolution the default behavior.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          The Safer Intents feature has the potential to significantly enhance the security of the\n          Android ecosystem by making it more difficult for malicious apps to exploit\n          vulnerabilities in the intent resolution mechanism.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          However, the transition to opt-out and mandatory enforcement must be carefully managed to\n          address potential compatibility issues with existing apps.\n          ")));
        String imf = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("intentMatchingFlags");
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n          " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Implementation") + "\n          Developers need to explicitly enable stricter intent matching using the " + imf + " attribute in\n          their app manifest. Here is an example where the feature is opt-in for the entire app, but\n          disabled/opt-out on a receiver:\n          ")));
        $this$relevanceOnly.xml("<application android:intentMatchingFlags=\"enforceIntentFilter\">\n    <receiver android:name=\".MyBroadcastReceiver\" android:exported=\"true\" android:intentMatchingFlags=\"none\">\n        <intent-filter>\n            <action android:name=\"com.example.MY_CUSTOM_ACTION\" />\n        </intent-filter>\n        <intent-filter>\n            <action android:name=\"com.example.MY_ANOTHER_CUSTOM_ACTION\" />\n        </intent-filter>\n    </receiver>\n</application>");
        String app = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.angle$targetsdkversion_upgrade_assistant("application"));
        String act = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.angle$targetsdkversion_upgrade_assistant("activity"));
        String aa = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.angle$targetsdkversion_upgrade_assistant("activity-alias"));
        String r = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.angle$targetsdkversion_upgrade_assistant("receiver"));
        String s = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.angle$targetsdkversion_upgrade_assistant("service"));
        String p = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.angle$targetsdkversion_upgrade_assistant("provider"));
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n          " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Note:") + " The attribute can be specified on the " + app + " tag as well as at the\n          component tags such as " + act + ", " + aa + ", " + r + ", " + s + ", " + p + " and the attribute on the component can be\n          used to override what's on the " + app + " tag\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          More on the supported flags:\n          <table>\n            <tr>\n              <th align=\"left\">Flag Name</th>\n              <th align=\"left\">Description</th>\n            </tr>\n            <tr>\n              <td>enforceIntentFilter</td>\n              <td>Enforces stricter matching for incoming intents</td>\n            </tr>\n            <tr>\n              <td>none</td>\n              <td>\n              Disables all special matching rules for incoming intents. When specifying multiple\n              flags, conflicting values are resolved by giving precedence to the \"none\" flag\n              </td>\n            </tr>\n            <tr>\n              <td>allowNullAction</td>\n              <td>\n              Relaxes the matching rules to allow intents without an action to match. This flag to\n              be used in conjunction with \"enforceIntentFilter\" to achieve a specific behavior\n              </td>\n            </tr>\n          </table>\n          ")));
        String log1 = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("\"Intent does not match component's intent filter:\"");
        String log2 = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("\"Access blocked:\"");
        String log3 = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("\"PackageManager.\"");
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n          " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Testing and Debugging") + "\n          When the enforcement is active, apps should function correctly if the intent caller has\n          properly populated the intent. However, blocked intents will trigger warning log messages\n          like " + log1 + " and " + log2 + " with the tag " + log3 + " This indicates a potential issue that could impact\n          the app and requires attention.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          Logcat filter:\n          ")));
        $this$relevanceOnly.shell("tag=:PackageManager & (message:\"Intent does not match component's intent filter:\" | message: \"Access blocked:\")");
        return Unit.INSTANCE;
    }

    private static final Unit localNetworkPermission$lambda$0(Seq $this$seq) {
        Intrinsics.checkNotNullParameter((Object)$this$seq, (String)"$this$seq");
        $this$seq.relevanceOnly("Local Network Permission", "localNetworkPermission", (Function1<? super ElementListBuilder, Unit>)((Function1)Api36::localNetworkPermission$lambda$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit localNetworkPermission$lambda$0$0(ElementListBuilder $this$relevanceOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$relevanceOnly, (String)"$this$relevanceOnly");
        String internet = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("INTERNET");
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n          Devices on the LAN can be accessed by any app that has the " + internet + " permission.\n          This makes it easy for apps to connect to local devices but it also has privacy\n          implications such as forming a fingerprint of the user, and being a proxy for location.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          The Local Network Protections project aims to protect the user's privacy by gating access\n          to the local network behind a new runtime permission.\n          ")));
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n          " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Release plan") + "\n          This change will be deployed between two releases, " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("25Q2 and TBD") + " respectively.\n          It is imperative that developers follow this guidance for " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("25Q2") + " and share\n          feedback because these protections " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("will be enforced at a later Android release") + ".\n          Moreover, they will need to update scenarios which depend on implicit local network access\n          by using the following guidance and prepare for user rejection and revocation of the new\n          permission.\n          ")));
        String[] stringArray = new String[]{"Direct or library use of raw sockets on local network addresses (e.g. mDNS or SSDP service discovery protocol)", "Use of framework level classes that access the local network (e.g. NsdManager)"};
        String string = ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(stringArray);
        stringArray = new String[]{"Making an outgoing TCP connection", "Accepting incoming TCP connections", "Sending a UDP unicast, multicast, broadcast", "Receiving an incoming UDP unicast, multicast, broadcast"};
        String string2 = ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(stringArray);
        stringArray = new String[]{"If a device's DNS server is on a local network, traffic to or from it (at port 53)\ndoesn't require local network access permission.", "Applications using Output Switcher as their in-app picker won't need local network\npermissions (more guidance to come in 2025Q4)."};
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n          " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Impact") + "\n          At the current stage, LNP is an opt-in feature which means only the apps that opt in will\n          be affected. The goal of the opt-in phase is for app developers to understand which parts\n          of their app depend on implicit local network access such that they can prepare to\n          permission guard them for the next release.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          Apps will be affected if they access the user's local network using:\n          " + string + "\n          Traffic " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("to") + " and " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("from") + " a local network address requires local network\n          access permission. The following table lists some common cases:\n          " + string2 + "\n          These restrictions are implemented deep in the networking stack, and thus they apply to\n          " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("all networking APIs") + ". This includes sockets created in native or managed code,\n          networking libraries like Cronet and OkHttp, and any APIs implemented on top of those.\n          Trying to resolve services on the local network (i.e. those with a .local suffix) will\n          require local network permission.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Note:") + " Traffic originating from Android Webviews that require local network\n          access will inherit permission state from the host app.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          Exceptions to the rules above:\n          " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(stringArray) + "\n          " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Note:") + " Many media casting scenarios depend on access to the local network and\n          will be impacted by this change. However, not all apps which offer casting will need to\n          request the new permission. Future APIs and guidance for dealing with casting scenarios\n          will be provided in 25Q4.\n          ")));
        stringArray = new String[]{"Flash the device to a build with 25Q2 Beta 3 or later.", "Install the app to be tested.", "Toggle the Appcompat flag in adb:"};
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n          " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Developer Guidance (Opt-in)") + "\n          To opt into local network restrictions, do the following:\n          " + ApiUtils.INSTANCE.olist$targetsdkversion_upgrade_assistant(1, stringArray) + "\n          ")));
        $this$relevanceOnly.shell("adb shell am compat enable RESTRICT_LOCAL_NETWORK <package_name>");
        $this$relevanceOnly.text(ApiUtils.INSTANCE.olist$targetsdkversion_upgrade_assistant(4, ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Reboot The device"))));
        String nwd = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("NEARBY_WIFI_DEVICES");
        String settingPath = ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Settings > Apps > [Application Name] > Permissions > Nearby devices > Allow");
        String[] stringArray2 = new String[]{"Ensure the app declares the " + nwd + " permission in its manifest.", "Go to " + settingPath + "."};
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n          Now your app's access to the local network is restricted and any attempt to access the\n          local network will lead to socket errors. If you are using APIs that perform local network\n          operations outside of your app process (ex: NsdManager),\n          " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("they won't be impacted during the opt-in phase") + ".\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          To restore access, you must grant your app permission to " + nwd + ".\n          " + ApiUtils.INSTANCE.olist$targetsdkversion_upgrade_assistant(1, stringArray2) + "\n          " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Note:") + " In a future Android release, this feature will be guarded by a\n          " + ApiUtils.INSTANCE.italic$targetsdkversion_upgrade_assistant("new") + " permission in the Nearby devices permission group.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          Now your app's access to the local network should be restored and all your scenarios\n          should work as they did prior to opting the app in.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          Once enforcement for local network protection begins, here is how the app network traffic\n          will be impacted.\n          <table>\n            <tr>\n              <th align=\"left\">Permission</th>\n              <th align=\"left\">Outbound LAN Request</th>\n              <th align=\"left\">Outbound/Inbound Internet Request</th>\n              <th align=\"left\">Inbound LAN Request</th>\n            </tr>\n            <tr>\n              <td>Granted</td>\n              <td>Works</td>\n              <td>Works</td>\n              <td>Works</td>\n            </tr>\n            <tr>\n              <td>Not Granted</td>\n              <td>Fails</td>\n              <td>Works</td>\n              <td>Fails</td>\n            </tr>\n          </table>\n          Use the following command to toggle-off the App-Compat flag\n          ")));
        $this$relevanceOnly.shell("adb shell am compat disable RESTRICT_LOCAL_NETWORK <package_name>");
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n          " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Errors") + "\n          Errors arising from these restrictions will be returned to the calling socket whenever it\n          invokes send or a send variant to a local network address.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          Example errors:\n          ")));
        $this$relevanceOnly.shell("sendto failed: EPERM (Operation not permitted)\n\nsendto failed: ECONNABORTED (Operation not permitted)");
        stringArray2 = new String[]{"169.254.0.0/16 // Link Local", "100.64.0.0/10 // CGNAT", "10.0.0.0/8 // RFC1918", "172.16.0.0/12 // RFC1918", "192.168.0.0/16 // RFC1918"};
        String string3 = ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(stringArray2);
        stringArray2 = new String[]{"Link-local", "Directly-connected routes", "Stub networks like Thread", "Multiple-subnets (TBD)"};
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n          " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Local Network Definition") + "\n          A local network in this project refers to an IP network that utilizes a broadcast-capable\n          network interface, such as Wi-Fi or Ethernet, but excludes cellular (WWAN) or VPN\n          connections.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          The following are considered local networks:\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("IPv4:") + "\n          " + string3 + "\n          " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("IPv6:") + "\n          " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(stringArray2) + "\n          Additionally, both multicast addresses (224.0.0.0/4, ff00::/8) and the IPv4 broadcast\n          address (255.255.255.255) are classified as local network addresses.\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit photoPickerOwnedPhotos$lambda$0(Seq $this$seq) {
        Intrinsics.checkNotNullParameter((Object)$this$seq, (String)"$this$seq");
        $this$seq.raw("App-owned photos", (Function1<? super ElementListBuilder, Unit>)((Function1)Api36::photoPickerOwnedPhotos$lambda$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit photoPickerOwnedPhotos$lambda$0$0(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text("When prompted for photo and video permissions by an app targeting SDK 36 or higher on\ndevices running Android 16 or higher, users who choose to limit access to selected media\nwill see any photos owned by the app pre-selected in the photo picker. Users can deselect\nany of these pre-selected items, which will revoke the app's access to those photos and\nvideos.");
        return Unit.INSTANCE;
    }

    private static final Unit behaviorChanges16$lambda$0(Par $this$par) {
        Intrinsics.checkNotNullParameter((Object)$this$par, (String)"$this$par");
        $this$par.par((Function1<? super Par, Unit>)((Function1)Api36::behaviorChanges16$lambda$0$0));
        $this$par.par((Function1<? super Par, Unit>)((Function1)Api36::behaviorChanges16$lambda$0$1));
        $this$par.par((Function1<? super Par, Unit>)((Function1)Api36::behaviorChanges16$lambda$0$2));
        $this$par.par((Function1<? super Par, Unit>)((Function1)Api36::behaviorChanges16$lambda$0$3));
        $this$par.par((Function1<? super Par, Unit>)((Function1)Api36::behaviorChanges16$lambda$0$4));
        $this$par.par((Function1<? super Par, Unit>)((Function1)Api36::behaviorChanges16$lambda$0$5));
        $this$par.par((Function1<? super Par, Unit>)((Function1)Api36::behaviorChanges16$lambda$0$6));
        return Unit.INSTANCE;
    }

    private static final Unit behaviorChanges16$lambda$0$0(Par $this$par) {
        Intrinsics.checkNotNullParameter((Object)$this$par, (String)"$this$par");
        $this$par.unaryMinus(edgeToEdge);
        $this$par.unaryMinus(predictiveBack);
        $this$par.unaryMinus(removeUiFonts);
        return Unit.INSTANCE;
    }

    private static final Unit behaviorChanges16$lambda$0$1(Par $this$par) {
        Intrinsics.checkNotNullParameter((Object)$this$par, (String)"$this$par");
        $this$par.unaryMinus(scheduleAtFixedRate);
        return Unit.INSTANCE;
    }

    private static final Unit behaviorChanges16$lambda$0$2(Par $this$par) {
        Intrinsics.checkNotNullParameter((Object)$this$par, (String)"$this$par");
        $this$par.unaryMinus(adaptiveLayouts);
        return Unit.INSTANCE;
    }

    private static final Unit behaviorChanges16$lambda$0$3(Par $this$par) {
        Intrinsics.checkNotNullParameter((Object)$this$par, (String)"$this$par");
        $this$par.unaryMinus(healthFitnessPermissions);
        return Unit.INSTANCE;
    }

    private static final Unit behaviorChanges16$lambda$0$4(Par $this$par) {
        Intrinsics.checkNotNullParameter((Object)$this$par, (String)"$this$par");
        $this$par.unaryMinus(bondLossHandlingChange);
        $this$par.unaryMinus(bondRemovalApi);
        return Unit.INSTANCE;
    }

    private static final Unit behaviorChanges16$lambda$0$5(Par $this$par) {
        Intrinsics.checkNotNullParameter((Object)$this$par, (String)"$this$par");
        $this$par.unaryMinus(mediastoreLockdown);
        $this$par.unaryMinus(saferIntents);
        return Unit.INSTANCE;
    }

    private static final Unit behaviorChanges16$lambda$0$6(Par $this$par) {
        Intrinsics.checkNotNullParameter((Object)$this$par, (String)"$this$par");
        $this$par.unaryMinus(localNetworkPermission);
        $this$par.unaryMinus(photoPickerOwnedPhotos);
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0(Seq $this$seq) {
        Intrinsics.checkNotNullParameter((Object)$this$seq, (String)"$this$seq");
        $this$seq.unaryMinus(behaviorChanges16);
        $this$seq.raw("Update the SDK version", (Function1<? super ElementListBuilder, Unit>)((Function1)Api36::steps$lambda$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n          Once you've finished migrating your code, update " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("targetSdkVersion") + " to 36.\n          ")));
        return Unit.INSTANCE;
    }
}

