/*
 * Decompiled with CFR 0.152.
 */
package com.google.targetsdkversionassistant.plan;

import com.android.tools.idea.flags.StudioFlags;
import com.google.targetsdkversionassistant.dsl.ElementListBuilder;
import com.google.targetsdkversionassistant.dsl.Ordering;
import com.google.targetsdkversionassistant.dsl.Par;
import com.google.targetsdkversionassistant.dsl.Seq;
import com.google.targetsdkversionassistant.plan.Api35;
import com.google.targetsdkversionassistant.plan.ApiUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000#\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/google/targetsdkversionassistant/plan/Api35;", "", "<init>", "()V", "label", "", "getLabel", "()Ljava/lang/String;", "urls", "com/google/targetsdkversionassistant/plan/Api35$urls$1", "Lcom/google/targetsdkversionassistant/plan/Api35$urls$1;", "description", "getDescription", "steps", "Lcom/google/targetsdkversionassistant/dsl/Seq;", "getSteps", "()Lcom/google/targetsdkversionassistant/dsl/Seq;", "targetsdkversion-upgrade-assistant"})
public final class Api35 {
    @NotNull
    public static final Api35 INSTANCE = new Api35();
    @NotNull
    private static final String label = ApiUtils.INSTANCE.rarrow$targetsdkversion_upgrade_assistant("Android 14 / API level 34", "Android 15 / API level 35");
    @NotNull
    private static final urls.1 urls = new Object(){
        private final String behaviorChanges;
        private final String dataSync;
        private final String camera;
        private final String mediaPlayback;
        private final String phoneCall;
        private final String mediaProjection;
        private final String microphone;
        private final String foregroundServiceStartNotAllowed;
        private final String elegantTextHeight;
        private final String textView;
        private final String fallbackLineSpacing;
        private final String elegantTextHeightChange;
        private final String setNavigationBarColor;
        private final String setNavigationBarContrastEnforced;
        private final String setStatusBarColor;
        private final String setStatusBarContrastEnforced;
        private final String insets;
        private final String material3;
        private final String material2;
        private final String material2_160;
        private final String bottomAppBar;
        private final String topAppBar;
        private final String bottomNavigation;
        private final String navigationRail;
        private final String scaffold;
        private final String materialComponents;
        private final String scaffoldPadding;
        private final String windowInsets;
        private final String overlaps;
        private final String tappable;
        private final String statusBars;
        private final String e2eViews;
        private final String requestAudioFocus;
        private final String audioFocusRequestFailed;
        private final String manageAudioFocus;
        private final String mediaProcessing;
        private final String onTimeout;
        private final String stopSelf;
        private final String foregroundServiceStartNotAllowedException;
        private final String mediaProcessingAltApi;
        {
            this.behaviorChanges = "https://developer.android.com/about/versions/15/behavior-changes-15";
            this.dataSync = "https://developer.android.com/develop/background-work/services/fg-service-types#data-sync";
            this.camera = "https://developer.android.com/develop/background-work/services/fg-service-types#camera";
            this.mediaPlayback = "https://developer.android.com/develop/background-work/services/fg-service-types#media";
            this.phoneCall = "https://developer.android.com/develop/background-work/services/fg-service-types#phone-call";
            this.mediaProjection = "https://developer.android.com/develop/background-work/services/fg-service-types#media-projection";
            this.microphone = "https://developer.android.com/develop/background-work/services/fg-service-types#microphone";
            this.foregroundServiceStartNotAllowed = "https://developer.android.com/reference/android/app/ForegroundServiceStartNotAllowedException";
            this.elegantTextHeight = "https://developer.android.com/reference/android/R.attr#elegantTextHeight";
            this.textView = "https://developer.android.com/reference/android/widget/TextView";
            this.fallbackLineSpacing = "https://developer.android.com/reference/android/widget/TextView#attr_android:fallbackLineSpacing";
            this.elegantTextHeightChange = "https://developer.android.com/about/versions/15/behavior-changes-15#elegant-text-height";
            this.setNavigationBarColor = "https://developer.android.com/reference/android/view/Window#setNavigationBarColor(int)";
            this.setNavigationBarContrastEnforced = "https://developer.android.com/reference/android/view/Window#setNavigationBarContrastEnforced(boolean)";
            this.setStatusBarColor = "https://developer.android.com/reference/android/view/Window#setStatusBarColor(int)";
            this.setStatusBarContrastEnforced = "https://developer.android.com/reference/android/view/Window#setStatusBarContrastEnforced(boolean)";
            this.insets = "https://developer.android.com/develop/ui/compose/layouts/insets";
            this.material3 = "https://developer.android.com/reference/kotlin/androidx/compose/material3/package-summary";
            this.material2 = "https://developer.android.com/reference/kotlin/androidx/compose/material/package-summary";
            this.material2_160 = "https://developer.android.com/jetpack/androidx/releases/compose-material#1.6.0-alpha03";
            this.bottomAppBar = "https://developer.android.com/reference/kotlin/androidx/compose/material/package-summary#BottomAppBar(androidx.compose.foundation.layout.WindowInsets,androidx.compose.ui.Modifier,androidx.compose.ui.graphics.Color,androidx.compose.ui.graphics.Color,androidx.compose.ui.graphics.Shape,androidx.compose.ui.unit.Dp,androidx.compose.foundation.layout.PaddingValues,kotlin.Function1)";
            this.topAppBar = "https://developer.android.com/reference/kotlin/androidx/compose/material/package-summary#TopAppBar(androidx.compose.foundation.layout.WindowInsets,androidx.compose.ui.Modifier,androidx.compose.ui.graphics.Color,androidx.compose.ui.graphics.Color,androidx.compose.ui.unit.Dp,androidx.compose.foundation.layout.PaddingValues,kotlin.Function1)";
            this.bottomNavigation = "https://developer.android.com/reference/kotlin/androidx/compose/material/package-summary#BottomNavigation(androidx.compose.foundation.layout.WindowInsets,androidx.compose.ui.Modifier,androidx.compose.ui.graphics.Color,androidx.compose.ui.graphics.Color,androidx.compose.ui.unit.Dp,kotlin.Function1)";
            this.navigationRail = "https://developer.android.com/reference/kotlin/androidx/compose/material/package-summary#NavigationRail(androidx.compose.foundation.layout.WindowInsets,androidx.compose.ui.Modifier,androidx.compose.ui.graphics.Color,androidx.compose.ui.graphics.Color,androidx.compose.ui.unit.Dp,kotlin.Function1,kotlin.Function1)";
            this.scaffold = "https://developer.android.com/reference/kotlin/androidx/compose/material/package-summary#Scaffold(androidx.compose.foundation.layout.WindowInsets,androidx.compose.ui.Modifier,androidx.compose.material.ScaffoldState,kotlin.Function0,kotlin.Function0,kotlin.Function1,kotlin.Function0,androidx.compose.material.FabPosition,kotlin.Boolean,kotlin.Function1,kotlin.Boolean,androidx.compose.ui.graphics.Shape,androidx.compose.ui.unit.Dp,androidx.compose.ui.graphics.Color,androidx.compose.ui.graphics.Color,androidx.compose.ui.graphics.Color,androidx.compose.ui.graphics.Color,androidx.compose.ui.graphics.Color,kotlin.Function1)";
            this.materialComponents = "https://developer.android.com/reference/com/google/android/material/classes";
            this.scaffoldPadding = "https://developer.android.com/develop/ui/compose/layouts/insets#scaffold";
            this.windowInsets = "https://developer.android.com/develop/ui/compose/layouts/insets#inset-fundamentals";
            this.overlaps = "https://developer.android.com/develop/ui/views/layout/edge-to-edge#handle-overlaps";
            this.tappable = "https://developer.android.com/reference/android/view/WindowInsets.Type#tappableElement()";
            this.statusBars = "https://developer.android.com/reference/android/view/WindowInsets.Type#statusBars()";
            this.e2eViews = "https://developer.android.com/develop/ui/views/layout/edge-to-edge";
            this.requestAudioFocus = "https://developer.android.com/reference/android/media/AudioManager#requestAudioFocus(android.media.AudioFocusRequest)";
            this.audioFocusRequestFailed = "https://developer.android.com/reference/android/media/AudioManager#AUDIOFOCUS_REQUEST_FAILED";
            this.manageAudioFocus = "https://developer.android.com/media/optimize/audio-focus";
            this.mediaProcessing = "https://developer.android.com/about/versions/15/changes/foreground-service-types#media-processing";
            this.onTimeout = "https://developer.android.com/reference/android/app/Service#onTimeout(int,%20int)";
            this.stopSelf = "https://developer.android.com/reference/android/app/Service#stopSelf()";
            this.foregroundServiceStartNotAllowedException = "https://developer.android.com/reference/android/app/ForegroundServiceStartNotAllowedException";
            this.mediaProcessingAltApi = "https://developer.android.com/develop/background-work/services/foreground-services#purpose-built-apis";
        }

        public final String getBehaviorChanges() {
            return this.behaviorChanges;
        }

        public final String getDataSync() {
            return this.dataSync;
        }

        public final String getCamera() {
            return this.camera;
        }

        public final String getMediaPlayback() {
            return this.mediaPlayback;
        }

        public final String getPhoneCall() {
            return this.phoneCall;
        }

        public final String getMediaProjection() {
            return this.mediaProjection;
        }

        public final String getMicrophone() {
            return this.microphone;
        }

        public final String getForegroundServiceStartNotAllowed() {
            return this.foregroundServiceStartNotAllowed;
        }

        public final String getElegantTextHeight() {
            return this.elegantTextHeight;
        }

        public final String getTextView() {
            return this.textView;
        }

        public final String getFallbackLineSpacing() {
            return this.fallbackLineSpacing;
        }

        public final String getElegantTextHeightChange() {
            return this.elegantTextHeightChange;
        }

        public final String getSetNavigationBarColor() {
            return this.setNavigationBarColor;
        }

        public final String getSetNavigationBarContrastEnforced() {
            return this.setNavigationBarContrastEnforced;
        }

        public final String getSetStatusBarColor() {
            return this.setStatusBarColor;
        }

        public final String getSetStatusBarContrastEnforced() {
            return this.setStatusBarContrastEnforced;
        }

        public final String getInsets() {
            return this.insets;
        }

        public final String getMaterial3() {
            return this.material3;
        }

        public final String getMaterial2() {
            return this.material2;
        }

        public final String getMaterial2_160() {
            return this.material2_160;
        }

        public final String getBottomAppBar() {
            return this.bottomAppBar;
        }

        public final String getTopAppBar() {
            return this.topAppBar;
        }

        public final String getBottomNavigation() {
            return this.bottomNavigation;
        }

        public final String getNavigationRail() {
            return this.navigationRail;
        }

        public final String getScaffold() {
            return this.scaffold;
        }

        public final String getMaterialComponents() {
            return this.materialComponents;
        }

        public final String getScaffoldPadding() {
            return this.scaffoldPadding;
        }

        public final String getWindowInsets() {
            return this.windowInsets;
        }

        public final String getOverlaps() {
            return this.overlaps;
        }

        public final String getTappable() {
            return this.tappable;
        }

        public final String getStatusBars() {
            return this.statusBars;
        }

        public final String getE2eViews() {
            return this.e2eViews;
        }

        public final String getRequestAudioFocus() {
            return this.requestAudioFocus;
        }

        public final String getAudioFocusRequestFailed() {
            return this.audioFocusRequestFailed;
        }

        public final String getManageAudioFocus() {
            return this.manageAudioFocus;
        }

        public final String getMediaProcessing() {
            return this.mediaProcessing;
        }

        public final String getOnTimeout() {
            return this.onTimeout;
        }

        public final String getStopSelf() {
            return this.stopSelf;
        }

        public final String getForegroundServiceStartNotAllowedException() {
            return this.foregroundServiceStartNotAllowedException;
        }

        public final String getMediaProcessingAltApi() {
            return this.mediaProcessingAltApi;
        }
    };
    @NotNull
    private static final String description = StringsKt.trimIndent((String)("\n    Here are the major steps required to migrate from Android 14 (API level 34) to Android 15 (API level 35).\n    " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n    For the complete list of changes introduced in Android 15 (API level 35), see the " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Android 15 behavior changes", urls.getBehaviorChanges()) + ".\n  "));
    @NotNull
    private static final Seq steps = Ordering.Companion.seq((Function1<? super Seq, Unit>)((Function1)Api35::steps$lambda$0));

    private Api35() {
    }

    @NotNull
    public final String getLabel() {
        return label;
    }

    @NotNull
    public final String getDescription() {
        return description;
    }

    @NotNull
    public final Seq getSteps() {
        return steps;
    }

    private static final Unit steps$lambda$0(Seq $this$seq) {
        Intrinsics.checkNotNullParameter((Object)$this$seq, (String)"$this$seq");
        $this$seq.par((Function1<? super Par, Unit>)((Function1)Api35::steps$lambda$0$0));
        $this$seq.raw("Remember to check for other changes", (Function1<? super ElementListBuilder, Unit>)((Function1)Api35::steps$lambda$0$1));
        $this$seq.filtered("Update the SDK version", "targetSdkVersion35", (Function1<? super ElementListBuilder, Unit>)((Function1)Api35::steps$lambda$0$2));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0(Par $this$par) {
        Intrinsics.checkNotNullParameter((Object)$this$par, (String)"$this$par");
        $this$par.relevanceOnly("Data sync foreground service timeout behavior", "dataSyncMediaProcessingForegroundServices", (Function1<? super ElementListBuilder, Unit>)((Function1)Api35::steps$lambda$0$0$0));
        $this$par.relevanceOnly("Restrictions on BOOT_COMPLETED broadcast receivers", "bootCompletedForegroundServices", (Function1<? super ElementListBuilder, Unit>)((Function1)Api35::steps$lambda$0$0$1));
        $this$par.relevanceOnly("Restrictions while holding the SYSTEM_ALERT_WINDOW permission", "systemAlertWindowPermission", (Function1<? super ElementListBuilder, Unit>)((Function1)Api35::steps$lambda$0$0$2));
        $this$par.relevanceOnly("Changes to when apps can modify the global state of Do Not Disturb mode", "modifiedDND", (Function1<? super ElementListBuilder, Unit>)((Function1)Api35::steps$lambda$0$0$3));
        $this$par.raw("OpenJDK API: Changes to string formatting APIs", (Function1<? super ElementListBuilder, Unit>)((Function1)Api35::steps$lambda$0$0$4));
        $this$par.relevanceOnly("OpenJDK API: Changes to component type of Arrays.asList(...).toArray()", "collectionToArray", (Function1<? super ElementListBuilder, Unit>)((Function1)Api35::steps$lambda$0$0$5));
        $this$par.raw("OpenJDK API: Changes to language code handling", (Function1<? super ElementListBuilder, Unit>)((Function1)Api35::steps$lambda$0$0$6));
        $this$par.relevanceOnly("OpenJDK API: Changes to random int sequences", "randomIntSeqs", (Function1<? super ElementListBuilder, Unit>)((Function1)Api35::steps$lambda$0$0$7));
        $this$par.raw("OpenJDK API: SequencedCollection collisions", (Function1<? super ElementListBuilder, Unit>)((Function1)Api35::steps$lambda$0$0$8));
        $this$par.raw("Secured background activity launches", (Function1<? super ElementListBuilder, Unit>)((Function1)Api35::steps$lambda$0$0$9));
        $this$par.relevanceOnly("Safer intents", "saferIntents", (Function1<? super ElementListBuilder, Unit>)((Function1)Api35::steps$lambda$0$0$10));
        $this$par.seq((Function1<? super Seq, Unit>)((Function1)Api35::steps$lambda$0$0$11));
        $this$par.raw("elegantTextHeight attribute defaults to true", (Function1<? super ElementListBuilder, Unit>)((Function1)Api35::steps$lambda$0$0$12));
        $this$par.raw("TextView width changes for complex letter shapes", (Function1<? super ElementListBuilder, Unit>)((Function1)Api35::steps$lambda$0$0$13));
        $this$par.raw("Locale-aware default line height for EditText", (Function1<? super ElementListBuilder, Unit>)((Function1)Api35::steps$lambda$0$0$14));
        $this$par.relevanceOnly("Restrictions on requesting audio focus", "requestsAudioFocus", (Function1<? super ElementListBuilder, Unit>)((Function1)Api35::steps$lambda$0$0$15));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$0(ElementListBuilder $this$relevanceOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$relevanceOnly, (String)"$this$relevanceOnly");
        String ds = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("dataSync");
        String mp = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("mediaProcessing");
        String dsmp = ds + "/" + mp;
        String logcatLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Logcat", "https://developer.android.com/tools/logcat");
        String dataSyncAltApiLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("alternative API", "https://developer.android.com/develop/background-work/background-tasks/data-transfer-options");
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n            Android 15 introduces a new timeout behavior to " + ds + " for\n            apps targeting Android 15 (API level 35) or higher.\n            This behavior also applies to the new\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(mp + " foreground service type", urls.getMediaProcessing()) + ".\n            This service type is appropriate for operations like transcoding media files.\n            For example, a media app might download an audio file and need to convert it\n            to a different format before playing it. You can use a " + mp + " foreground service\n            to make sure the conversion continues even while the app is in the background.\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            The system permits an app's " + dsmp + " services to run for a total of 6 hours in a\n            24-hour period, after which the system calls the running service's\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Service.onTimeout(int, int)"), urls.getOnTimeout()) + " method\n            (introduced in Android 15). At this time, the service has a few seconds to call\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Service.stopSelf()"), urls.getStopSelf()) + ".\n            When " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Service.onTimeout()") + " is called,\n            the service is no longer considered a foreground service.\n            If the service does not call " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Service.stopSelf()") + ",\n            the system throws an internal exception.\n            The exception is logged in " + logcatLink + " with the following message:\n            ")));
        $this$relevanceOnly.shell("Fatal Exception: android.app.RemoteServiceException: \"A foreground service of\ntype [dataSync|mediaProcessing] did not stop within its timeout: [component name]\"");
        String adb = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("adb");
        String adbLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(adb, "https://developer.android.com/tools/adb");
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n            The 6-hour time limit is shared by all of an app's\n            " + dsmp + " foreground services. For example,\n            if an app runs a " + dsmp + " service for four hours,\n            then starts a different " + dsmp + " service,\n            that second service will only be allowed to run for two hours.\n            However, if the user brings the app to the foreground,\n            the timer resets and the app has 6 hours available.\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            To avoid problems with this behavior change, you can do one or more of the following:\n            " + ApiUtils.INSTANCE.olist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                Have your service implement the new\n                " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Service.onTimeout(int, int)") + " method. When your app receives the\n                callback, make sure to call " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("stopSelf()") + " within a few seconds.\n                (If you don't stop the app right away, the system generates a failure.)\n              "))) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                Make sure your app's " + dsmp + " services don't run for more than\n                a total of 6 hours in any 24-hour period (unless the user interacts with the\n                app, resetting the timer).\n              "))) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                Only start " + dsmp + " foreground services as a result of direct\n                user interaction; since your app is in the foreground when the service starts,\n                your service has the full six hours after the app goes to the background.\n              "))) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                Instead of using a " + ds + " foreground service, use an " + dataSyncAltApiLink + ".\n                Instead of using a " + mp + " foreground service, use an\n                " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("alternative API", urls.getMediaProcessingAltApi()) + " like WorkManager.\n              "))) + "\n            "))) + "\n            If your app's " + dsmp + " foreground services have run for 6 hours in\n            the last 24, you cannot start another " + dsmp + " foreground service\n            " + ApiUtils.INSTANCE.italic$targetsdkversion_upgrade_assistant("unless") + " the user has brought your app to the foreground (which resets\n            the timer). If you try to start another " + dsmp + " foreground service,\n            the system throws\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("ForegroundServiceStartNotAllowedException"), urls.getForegroundServiceStartNotAllowedException()) + " with an error message like\n            \"Time limit already exhausted for foreground service type dataSync\".\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            For more information about the " + mp + " service type, see\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Changes to foreground service types for Android 15: Media processing", urls.getMediaProcessing()) + ".\n            " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Testing") + "\n            To test your app's behavior,\n            you can enable data sync timeouts even if your app is not targeting Android 15\n            (as long as the app is running on an Android 15 device).\n            To enable timeouts, run the following " + adbLink + " command:\n          ")));
        $this$relevanceOnly.shell("adb shell am compat enable FGS_INTRODUCE_TIME_LIMITS <your-package-name>");
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n              You can also adjust the timeout period,\n              to make it easier to test how your app behaves when the limit is reached.\n              To set a new " + ds + " timeout period, run the following " + adb + " command:\n            ")));
        $this$relevanceOnly.shell("adb shell device_config put activity_manager data_sync_fgs_timeout_duration <duration-in-milliseconds>");
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n              To set a new " + mp + " timeout period, run the following " + adb + " command:\n            ")));
        $this$relevanceOnly.shell("adb shell device_config put activity_manager media_processing_fgs_timeout_duration <duration-in-milliseconds>");
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$1(ElementListBuilder $this$relevanceOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$relevanceOnly, (String)"$this$relevanceOnly");
        String adb = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("adb");
        String adbLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(adb, "https://developer.android.com/tools/adb");
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n            There are new restrictions on " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BOOT_COMPLETED") + " broadcast receivers launching foreground services.\n            " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BOOT_COMPLETED") + " receivers are " + ApiUtils.INSTANCE.italic$targetsdkversion_upgrade_assistant("not") + " allowed to launch the following types of foreground services:\n            " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("dataSync"), urls.getDataSync())) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("camera"), urls.getCamera())) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("mediaPlayback"), urls.getMediaPlayback())) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("phoneCall"), urls.getPhoneCall())) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("mediaProjection"), urls.getMediaProjection())) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("microphone"), urls.getMicrophone())) + "\n            "))) + "\n            If a " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BOOT_COMPLETED") + " receiver tries to launch any of those types of foreground services,\n            the system throws " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("ForegroundServiceStartNotAllowedException"), urls.getForegroundServiceStartNotAllowed()) + ".\n            " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Testing") + "\n            To test your app's behavior,\n            you can enable these new restrictions even if your app is not targeting Android 15\n            (as long as the app is running on an Android 15 device).\n            Run the following " + adbLink + " command:\n          ")));
        $this$relevanceOnly.shell("adb shell am compat enable FGS_BOOT_COMPLETED_RESTRICTIONS <your-package-name>");
        String bc = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BOOT_COMPLETED");
        $this$relevanceOnly.text("To send a " + bc + " broadcast without restarting the device, run the following " + adbLink + " command:");
        $this$relevanceOnly.shell("adb shell am broadcast -a android.intent.action.BOOT_COMPLETED <your-package-name>");
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$2(ElementListBuilder $this$relevanceOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$relevanceOnly, (String)"$this$relevanceOnly");
        String saw = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("SYSTEM_ALERT_WINDOW");
        String sawLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(saw, "https://developer.android.com/reference/android/Manifest.permission#SYSTEM_ALERT_WINDOW");
        String fssnae = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("ForegroundServiceStartNotAllowedException");
        String fssnaeLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(fssnae, urls.getForegroundServiceStartNotAllowedException());
        String tao = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("TYPE_APPLICATION_OVERLAY"), "https://developer.android.com/reference/android/view/WindowManager.LayoutParams#TYPE_APPLICATION_OVERLAY");
        String exemptLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("exemptions from background start restrictions", "https://developer.android.com/develop/background-work/services/foreground-services#background-start-restriction-exemptions)");
        String winViz = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("View.getWindowVisibility()"), "https://developer.android.com/reference/android/view/View#getWindowVisibility()");
        String winVizChange = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("View.onWindowVisibilityChanged()"), "https://developer.android.com/reference/android/view/View#onWindowVisibilityChanged(int)");
        String adbLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("adb"), "https://developer.android.com/tools/adb");
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n            Previously, if an app held the " + saw + " permission, it could launch a foreground service even\n            if the app was currently in the background (as discussed in " + exemptLink + ").\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            If an app targets Android 15, this exemption is now narrower. The app now needs to have the " + saw + " permission\n            and also have a visible overlay window. That is, the app needs to first launch a " + tao + " window\n            and the window needs to be visible before you start a foreground service.\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            If your app attempts to start a foreground service from the background without meeting these new requirements\n            (and it does not have some other exemption), the system throws " + fssnaeLink + ".\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            If your app declares the " + sawLink + " permission and launches foreground services from the background,\n            it may be affected by this change. If your app gets a " + fssnae + ",\n            check your app's order of operations and make sure your app already has an active overlay window\n            before it attempts to start a foreground service from the background. You can check if your overlay window\n            is currently visible by calling " + winViz + ", or you can override " + winVizChange + " to get notified whenever the visibility changes.\n            " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Testing") + "\n            To test your app's behavior,\n            you can enable these new restrictions even if your app is not targeting Android 15\n            (as long as the app is running on an Android 15 device).\n            To enable these new restrictions on starting foreground services from the background,\n            run the following " + adbLink + " command:\n          ")));
        $this$relevanceOnly.shell("adb shell am compat enable FGS_SAW_RESTRICTIONS <your-package-name>");
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$3(ElementListBuilder $this$relevanceOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$relevanceOnly, (String)"$this$relevanceOnly");
        String anz = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("AutomaticZenRule");
        String anzLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(anz, "https://developer.android.com/reference/android/app/AutomaticZenRule");
        String sifLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("setInterruptionFilter"), "https://developer.android.com/reference/android/app/NotificationManager#setInterruptionFilter(int)");
        String snpLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("setNotificationPolicy"), "https://developer.android.com/reference/android/app/NotificationManager#setNotificationPolicy(android.app.NotificationManager.Policy)");
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n            Apps that target Android 15 (API level 35) and higher can no longer change the global state\n            or policy of Do Not Disturb (DND) on a device\n            (either by modifying user settings, or turning off DND mode). Instead, apps must contribute an " + anzLink + ",\n            which the system combines into a global policy with the existing most-restrictive-policy-wins scheme.\n            Calls to existing APIs that previously affected global state (" + sifLink + ", " + snpLink + ")\n            result in the creation or update of an implicit " + anz + ",\n            which is toggled on and off depending on the call-cycle of those API calls.\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            Note that this change only affects observable behavior if the app is calling\n            " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("setInterruptionFilter(INTERRUPTION_FILTER_ALL)") + " and expects that call to deactivate\n            an " + anz + " that was previously activated by their owners.\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$4(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        String sfso = "https://developer.android.com/reference/java/lang/String#format(java.lang.String,%20java.lang.Object%5B%5D)";
        String sflso = "https://developer.android.com/reference/java/lang/String#format(java.util.Locale,%20java.lang.String,%20java.lang.Object%5B%5D)";
        String ffso = "https://developer.android.com/reference/java/util/Formatter#format(java.lang.String,%20java.lang.Object%5B%5D)";
        String fflso = "https://developer.android.com/reference/java/util/Formatter#format(java.util.Locale,%20java.lang.String,%20java.lang.Object%5B%5D)";
        $this$raw.text(StringsKt.trimIndent((String)("\n            Validation of argument index, flags, width, and precision are now more strict\n            when using the following " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("String.format()") + " and " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Formatter.format()") + " APIs:\n            " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("String.format(String, Object[])"), sfso)) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("String.format(Locale, String, Object[])"), sflso)) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Formatter.format(String, Object[])"), ffso)) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Formatter.format(Locale, String, Object[])"), fflso)) + "\n            "))) + "\n            For example, the following exception is thrown when an argument index of 0 is used (" + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("%0") + " in the format string):\n          ")));
        $this$raw.shell("IllegalFormatArgumentIndexException: Illegal format argument index = 0");
        $this$raw.text("In this case, the issue can be fixed by using an argument index of 1 (" + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("%1") + " in the format string).");
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$5(ElementListBuilder $this$relevanceOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$relevanceOnly, (String)"$this$relevanceOnly");
        String obj = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Object"), "https://developer.android.com/reference/java/lang/Object");
        String cce = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("ClassCastException"), "https://developer.android.com/reference/java/lang/ClassCastException");
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n            When using " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Arrays.asList(...).toArray()") + ",\n            the component type of the resulting array is now an " + obj + "\u2014not the type of the underlying array's elements.\n            So the following code throws a " + cce + ":\n          ")));
        $this$relevanceOnly.java("String[] elements = (String[]) Arrays.asList(\"one\", \"two\").toArray();");
        String str = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("String");
        String ctao = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Collection.toArray(Object[])"), "https://developer.android.com/reference/java/util/Collection#toArray(T%5B%5D)");
        $this$relevanceOnly.text("For this case, to preserve " + str + " as the component type in the resulting array, you could use " + ctao + " instead:");
        $this$relevanceOnly.java("String[] elements = Arrays.asList(\"two\", \"one\").toArray(new String[0]);");
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$6(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        String loc = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Locale"), "https://developer.android.com/reference/java/util/Locale");
        $this$raw.text(StringsKt.trimIndent((String)("\n            When using the " + loc + " API, language codes for Hebrew, Yiddish, and Indonesian are no longer converted to their\n            obsolete forms (Hebrew: " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("iw") + ", Yiddish: " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("ji") + ", and Indonesian: " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("in") + ").\n            When specifying the language code for one of these locales, use the codes from ISO 639-1\n            instead (Hebrew: " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("he") + ", Yiddish: " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("yi") + ", and Indonesian: " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("id") + ").\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$7(ElementListBuilder $this$relevanceOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$relevanceOnly, (String)"$this$relevanceOnly");
        String bug = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("https://bugs.openjdk.org/browse/JDK-8301574", "https://bugs.openjdk.org/browse/JDK-8301574");
        String ri = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Random.ints()");
        String rni = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Random.nextInt()");
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n            Following the changes made in " + bug + ",\n            the following " + ri + " methods now return a different sequence of numbers than the " + rni + " methods do:\n            " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Random.ints(long)"), "https://developer.android.com/reference/java/util/Random#ints(long)")) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Random.ints(long, int, int)"), "https://developer.android.com/reference/java/util/Random#ints(long,%20int,%20int)")) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Random.ints(int, int)"), "https://developer.android.com/reference/java/util/Random#ints(int,%20int)")) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Random.ints()"), "https://developer.android.com/reference/java/util/Random#ints()")) + "\n            "))) + "\n            Generally, this change shouldn't result in app-breaking behavior,\n            but your code shouldn't expect the sequence generated from " + ri + " methods to match " + rni + ".\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$8(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        String scLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("SequencedCollection"), "https://developer.android.com/reference/java/util/SequencedCollection");
        String updateCompileSDKLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("update " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("compileSdk") + " in your app's build configuration to use Android 15 (API level 35)", "https://developer.android.com/about/versions/15/setup-sdk#config");
        String mlrf = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("MutableList.removeFirst()"), "https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/remove-first.html");
        String mlrl = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("MutableList.removeLast()"), "https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/remove-last.html");
        String kstd = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("kotlin-stdlib");
        String ml = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("MutableList");
        String lrf = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("list.removeFirst()");
        String lrfLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("List.removeFirst()"), "https://developer.android.com/reference/java/util/List#removeFirst()");
        String lrl = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("List.removeLast()"), "https://developer.android.com/reference/java/util/List#removeLast()");
        String listLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("List"), "https://developer.android.com/reference/java/util/List");
        String csdk = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("compileSdk");
        String msdk = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("minSdk");
        String c34 = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("34");
        String c35 = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("35");
        String rf = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("removeFirst()");
        String rl = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("removeLast()");
        String ra0 = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("removeAt(0)");
        String ralli = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("removeAt(list.lastIndex)");
        $this$raw.text(StringsKt.trimIndent((String)("\n              The new " + scLink + " API can affect your app's compatibility after you " + updateCompileSDKLink + ":\n              " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Collision with " + mlrf + " and " + mlrl + " extension functions in " + kstd) + "\n              The " + listLink + " type in Java is mapped to the " + ml + " type in Kotlin.\n              Because the " + lrfLink + " and " + lrl + " APIs have been introduced in Android 15 (API level 35),\n              the Kotlin compiler resolves function calls, for example " + lrf + ",\n              statically to the new " + listLink + " APIs instead of to the extension functions in " + kstd + ".\n              " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n              If an app is re-compiled with " + csdk + " set to " + c35 + " and " + msdk + " set to " + c34 + " or lower,\n              and then the app is run on Android 14 and lower, a runtime error is thrown:\n            ")));
        $this$raw.shell("java.lang.NoSuchMethodError: No virtual method\nremoveFirst()Ljava/lang/Object; in class Ljava/util/ArrayList;");
        String napi = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("NewApi");
        $this$raw.text("The existing " + napi + " lint option in Android Gradle Plugin can catch these new API usages.");
        $this$raw.shell("$ ./gradlew lint\n\nMainActivity.kt:41: Error: Call requires API level 35 (current min is 34): java.util.List#removeFirst [NewApi]\n      list.removeFirst()");
        String supNApi = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("@SuppressLint(\"NewApi\")");
        String lodNApi = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("lintOptions { disable 'NewApi' }");
        String dequeLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Deque"), "https://developer.android.com/reference/java/util/Deque");
        String jc = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("javac");
        $this$raw.text(StringsKt.trimIndent((String)("\n              To fix the runtime exception and lint errors,\n              the " + rf + " and " + rl + " function calls can be replaced with " + ra0 + " and " + ralli + " respectively in Kotlin.\n              If you're using Android Studio Ladybug | 2024.1.3 or higher, it also provides a quick fix option for these errors.\n              " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n              Consider removing " + supNApi + " and " + lodNApi + " if the lint option has been disabled.\n              " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Collision with other methods in Java") + "\n              New methods have been added into the existing types, for example, " + listLink + " and " + dequeLink + ".\n              These new methods might not be compatible with the methods with\n              the same name and argument types in other interfaces and classes.\n              In the case of a method signature collision with incompatibility, the " + jc + " compiler outputs a build-time error. For example:\n              " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n              Example error 1:\n            ")));
        $this$raw.shell("$ javac MyList.java\n\nMyList.java:135: error: removeLast() in MyList cannot implement removeLast() in List\n  public void removeLast() {\n              ^\n  return type void is not compatible with Object\n  where E is a type-variable:\n    E extends Object declared in interface List");
        $this$raw.text("Example error 2:");
        $this$raw.shell("$ javac MyList.java\n\nMyList.java:7: error: types Deque<Object> and List<Object> are incompatible;\npublic class MyList implements  List<Object>, Deque<Object> {\n  both define reversed(), but with unrelated return types\n1 error");
        $this$raw.text("Example error 3:");
        $this$raw.shell("$ javac MyList.java\n\nMyList.java:43: error: types List<E#1> and MyInterface<E#2> are incompatible;\npublic static class MyList implements List<Object>, MyInterface<Object> {\n  class MyList inherits unrelated defaults for getFirst() from types List and MyInterface\n  where E#1,E#2 are type-variables:\n    E#1 extends Object declared in interface List\n    E#2 extends Object declared in interface MyInterface\n1 error");
        $this$raw.text("To fix these build errors,\nthe class implementing these interfaces should override the method with a compatible return type.\nFor example:");
        $this$raw.java("@Override\npublic Object getFirst() {\n    return List.super.getFirst();\n}");
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$9(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        if (((Boolean)StudioFlags.TSDKVUA_OMG_76167.get()).booleanValue()) {
            $this$raw.text("Android 15 protects users from malicious apps and gives them more control over their devices by adding\nchanges that prevent malicious background apps from bringing other apps to the foreground,\nelevating their privileges, and abusing user interaction.\nBackground activity launches have been restricted since Android 10 (API level 29).");
            String optIn = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("allowCrossUidActivitySwitchFromBelow"), "https://developer.android.com/guide/topics/manifest/application-element#allowCrossUidActivitySwitchFromBelow");
            $this$raw.text(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Block apps that don't match the top UID on the stack from launching activities") + "\n              Malicious apps can launch another app's activity within the same task, then overlay themselves on top,\n              creating the illusion of being that app. This \"task hijacking\" attack bypasses current background launch\n              restrictions because it all occurs within the same visible task. To mitigate this risk, Android 15 adds\n              a flag that blocks apps that don't match the top UID on the stack from launching activities.\n              To opt in for all of your app's activities, update the " + optIn + " attribute in your app's " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("AndroidManifest.xml") + " file:\n            ")));
            $this$raw.xml("<application android:allowCrossUidActivitySwitchFromBelow=\"false\" >");
            $this$raw.text(StringsKt.trimIndent((String)("\n                The new security measures are active if all of the following are true:\n                " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                    " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("The app performing the launch targets Android 15.") + "\n                    " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("The app on top of the task stack targets Android 15.") + "\n                    " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("Any visible activity has opted in to the new protections") + "\n                  "))) + "\n                If the security measures are enabled, apps might return home,\n                rather than the last visible app, if they finish their own task.\n              ")));
        }
        String pi = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("PendingIntent");
        String bbal = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("block background activity launches", "https://developer.android.com/guide/components/activities/background-starts");
        $this$raw.text(StringsKt.trimIndent((String)("\n            " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Other changes") + "\n            In addition to the restriction for UID matching, these other changes are also included:\n            " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Change " + pi + " creators to " + bbal + " by default") + ".\n                This helps prevent apps from accidentally creating a " + pi + " that could be abused by malicious actors.\n              "))) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Don't bring an app to the foreground unless the " + pi + " sender allows it") + ".\n                This change aims to prevent malicious apps from abusing the ability to start activities in the background.\n                By default, apps are not allowed to bring the task stack to the foreground unless the creator allows backgrounds\n                 activity launch privileges or the sender has background activity launch privileges.\n              "))) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Control how the top activity of a task stack can finish its task") + ".\n                If the top activity finishes a task, Android will go back to whichever task was last active.\n                Moreover, if a non-top activity finishes its task, Android will go back to the home screen;\n                it won't block the finish of this non-top activity.\n              "))) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Prevent launching arbitrary activities from other apps into your own task") + ".\n                This change prevents malicious apps from phishing users by creating activities that appear to be from other apps.\n              "))) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Block non-visible windows from being considered for background activity launches") + ".\n                This helps prevent malicious apps from abusing background activity\n                launches to display unwanted or malicious content to users.\n              "))) + "\n            "))) + "\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$10(ElementListBuilder $this$relevanceOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$relevanceOnly, (String)"$this$relevanceOnly");
        String sm = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Strict Mode", "https://developer.android.com/reference/android/os/StrictMode");
        String pi = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("PendingIntent");
        String i = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Intent");
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n            Android 15 introduces new optional security measures to make intents safer and more robust.\n            These changes are aimed at preventing potential vulnerabilities and misuse of intents that can be\n            exploited by malicious apps. There are two main improvements to the security of intents in Android 15:\n            " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Match target intent-filters:") + "\n                Intents that target specific components must accurately match the target's intent-filter specifications.\n                If you send an intent to launch another app's activity,\n                the target intent component needs to align with the receiving activity's declared intent-filters.\n              "))) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Intents must have actions:") + "\n                Intents without an action will no longer match any intent-filters.\n                This means that intents used to start activities or services must have a clearly defined action.\n              "))) + "\n            "))) + "\n            " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Important:") + " a " + pi + " acts as a wrapper for a standard " + i + ",\n            so these security measures apply to the " + i + " contained within the " + pi + ".\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            In order to check how your app responds to these changes, use " + sm + " in your app.\n            To see detailed logs about " + i + " usage violations, add the following method:\n          ")));
        $this$relevanceOnly.kotlin("fun onCreate() {\n    StrictMode.setVmPolicy(VmPolicy.Builder()\n        .detectUnsafeIntentLaunch()\n        .build()\n    )\n}");
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$11(Seq $this$seq) {
        Intrinsics.checkNotNullParameter((Object)$this$seq, (String)"$this$seq");
        $this$seq.raw("Window inset changes: edge-to-edge enforcement", (Function1<? super ElementListBuilder, Unit>)((Function1)Api35::steps$lambda$0$0$11$0));
        $this$seq.relevanceOnly("Window inset changes: stable configuration", "stableConfiguration", (Function1<? super ElementListBuilder, Unit>)((Function1)Api35::steps$lambda$0$0$11$1));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$11$0(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        String scaffoldLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Scaffold", "https://developer.android.com/reference/kotlin/androidx/compose/material/package-summary#Scaffold(androidx.compose.foundation.layout.WindowInsets,androidx.compose.ui.Modifier,androidx.compose.material.ScaffoldState,kotlin.Function0,kotlin.Function0,kotlin.Function1,kotlin.Function0,androidx.compose.material.FabPosition,kotlin.Boolean,kotlin.Function1,kotlin.Boolean,androidx.compose.ui.graphics.Shape,androidx.compose.ui.unit.Dp,androidx.compose.ui.graphics.Color,androidx.compose.ui.graphics.Color,androidx.compose.ui.graphics.Color,androidx.compose.ui.graphics.Color,androidx.compose.ui.graphics.Color,kotlin.Function1)");
        $this$raw.text(StringsKt.trimIndent((String)("\n              Apps are edge-to-edge by default on devices running Android 15\n              if the app is targeting Android 15 (API level 35).\n              " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n              If your app is not already edge-to-edge, portions of your app may be obscured and you must handle insets.\n              Depending on the app, this work may or may not be significant.\n              The Material 3 " + scaffoldLink + " component can reduce the work required\n              to be compatible with the Android 15 edge-to-edge enforcement.\n              " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n              This is a breaking change that might negatively impact your app's UI. The changes affect the following UI areas:\n              " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                  " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Gesture handle navigation bar") + "\n                  " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                    " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("Transparent by default.") + "\n                    " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("Bottom offset is disabled so content draws behind the system navigation bar unless insets are applied.") + "\n                    " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                      " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("setNavigationBarColor"), urls.getSetNavigationBarColor()) + " and\n                      " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("R.attr#navigationBarColor") + " are\n                      deprecated and don't affect gesture navigation.\n                    "))) + "\n                    " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                      " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("setNavigationBarContrastEnforced"), urls.getSetNavigationBarContrastEnforced()) + " and\n                      " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("R.attr#navigationBarContrastEnforced") + " continue\n                      to have no effect on gesture navigation.\n                    "))) + "\n                  "))) + "\n                "))) + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                  " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("3 button navigation") + "\n                  " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                    " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("Opacity set to 80% by default, with color possibly matching the window background.") + "\n                    " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("Bottom offset disabled so content draws behind the system navigation bar unless insets are applied.") + "\n                    " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                      " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("setNavigationBarColor"), urls.getSetNavigationBarColor()) + " and\n                      " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("R.attr#navigationBarColor") + " are set to match the window background by default.\n                      The window background must be a color drawable for this default to apply.\n                      This API is deprecated but continues to affect 3-button navigation.\n                    "))) + "\n                    " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                      " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("setNavigationBarContrastEnforced"), urls.getSetNavigationBarContrastEnforced()) + " and\n                      " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("R.attr#navigationBarContrastEnforced") + " is true by default,\n                      which adds an 80% opaque background across 3-button navigation.\n                    "))) + "\n                  "))) + "\n                "))) + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                  " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Status bar") + "\n                  " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                    " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("Transparent by default.") + "\n                    " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("The top offset is disabled so content draws behind the status bar unless insets are applied.") + "\n                    " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                      " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("setStatusBarColor"), urls.getSetStatusBarColor()) + " and\n                      " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("R.attr#statusBarColor") + " are\n                      deprecated and have no effect on Android 15.\n                    "))) + "\n                    " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                      " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("setStatusBarContrastEnforced"), urls.getSetStatusBarContrastEnforced()) + " and\n                      " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("R.attr#statusBarContrastEnforced") + " are\n                      deprecated but still have an effect on Android 15.\n                    "))) + "\n                  "))) + "\n                "))) + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                  " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Display cutout") + "\n                  " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                    " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                      " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("layoutInDisplayCutoutMode") + " of non-floating windows must be\n                      " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("LAYOUT_IN_DISPLAY_CUTOUT_MODE_ALWAYS") + ".\n                      " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("SHORT_EDGES") + ", " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("NEVER") + ", and " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("DEFAULT") + "\n                      are interpreted as " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("ALWAYS") + "\n                      so that users don't see a black bar caused by the display cutout and appear edge-to-edge.\n                    "))) + "\n                  "))) + "\n                "))) + "\n              "))) + "\n              The following example shows an app before and after targeting Android 15 (API level 35), and before and after applying insets.\n              This example is not comprehensive, this might appear differently on Android Auto.\n            ")));
        ApiUtils.captioned$targetsdkversion_upgrade_assistant$default(ApiUtils.INSTANCE, $this$raw, "An app that targets Android 14 and is not edge-to-edge on an Android 15 device", "/plan/api35/edge-to-edge-14.png", 0, 650, 4, null);
        ApiUtils.captioned$targetsdkversion_upgrade_assistant$default(ApiUtils.INSTANCE, $this$raw, "An app that targets Android 15 (API level 35) and is edge-to-edge on an Android 15 device.\nHowever, many elements are now hidden by the status bar, 3-button navigation bar,\nor display cutout due to the Android 15 edge-to-edge enforcements.\nHidden UI includes the Material 2 top app bar, floating action buttons, and list items.", "/plan/api35/edge-to-edge-15-broken.png", 0, 650, 4, null);
        ApiUtils.captioned$targetsdkversion_upgrade_assistant$default(ApiUtils.INSTANCE, $this$raw, "An app that targets Android 15 (API level 35), is edge to edge on an Android 15 device\nand applies insets so that UI is not hidden.", "/plan/api35/edge-to-edge-15-fixed.png", 0, 650, 4, null);
        String splashLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("core splashscreen", "https://developer.android.com/jetpack/androidx/releases/core#core_splashscreen_version_12_2");
        String enforceStatusBarContrast = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("R.attr#enforceStatusBarContrast"), "https://developer.android.com/reference/android/R.attr#enforceStatusBarContrast");
        String navigationBarColor = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("R.attr#navigationBarColor"), "https://developer.android.com/reference/android/R.attr#navigationBarColor");
        String naviBarDivColor = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("R.attr#navigationBarDividerColor"), "https://developer.android.com/reference/android/R.attr#navigationBarDividerColor");
        String statBarColor = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("R.attr#statusBarColor"), "https://developer.android.com/reference/android/R.attr#statusBarColor");
        String winGetNavBarColor = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Window#getNavigationBarColor"), "https://developer.android.com/reference/android/view/Window#getNavigationBarColor()");
        String winGetNavBarDivColor = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Window#getNavigationBarDividerColor"), "https://developer.android.com/reference/android/view/Window#getNavigationBarDividerColor()");
        String winGetStatBarColor = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Window#getStatusBarColor"), "https://developer.android.com/reference/android/view/Window#getStatusBarColor()");
        String winIsStatBarContrastEnforced = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Window#isStatusBarContrastEnforced"), "https://developer.android.com/reference/android/view/Window#isStatusBarContrastEnforced()");
        String winSetDecorFitsSysWin = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Window#setDecorFitsSystemWindows"), "https://developer.android.com/reference/android/view/Window#setDecorFitsSystemWindows(boolean)");
        String winSetNavBarColor = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Window#setNavigationBarColor"), "https://developer.android.com/reference/android/view/Window#setNavigationBarColor(int)");
        String winSetNavBarDivColor = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Window#setNavigationBarDividerColor"), "https://developer.android.com/reference/android/view/Window#setNavigationBarDividerColor(int)");
        String winSetStatBarColor = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Window#setStatusBarColor"), "https://developer.android.com/reference/android/view/Window#setStatusBarColor(int)");
        String winSetStatBarContrastEnforced = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Window#setStatusBarContrastEnforced"), "https://developer.android.com/reference/android/view/Window#setStatusBarContrastEnforced(boolean)");
        $this$raw.text(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "What to check if your app is already edge-to-edge") + "\n              If your app is already " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("edge-to-edge", urls.getInsets()) + " and\n              applies insets, you are mostly unimpacted, except in the following scenarios.\n              However, even if you feel you aren't impacted, we recommend you test your app.\n              " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                  You have a non-floating window, such as an " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Activity") + " that uses\n                  " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("SHORT_EDGES") + ", " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("NEVER") + " or " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("DEFAULT") + " instead of\n                  " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("LAYOUT_IN_DISPLAY_CUTOUT_MODE_ALWAYS") + ".\n                  If your app crashes on launch, this may be due to your splashscreen.\n                  You can either upgrade the " + splashLink + " dependency to 1.2.0-alpha01 or later, set\n                  " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("window.attributes.layoutInDisplayCutoutMode = WindowManager.LayoutInDisplayCutoutMode.always") + ".\n                "))) + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                  There may be lower traffic screens with occluded UI.\n                  Verify these less visited screens don't have occluded UI.\n                  Lower traffic screens include:\n                  " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                    " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("Onboarding or sign-in screens") + "\n                    " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("Settings pages") + "\n                  "))) + "\n                "))) + "\n              "))) + "\n              " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "What to check if you app is not already edge-to-edge") + "\n              If your app is not already edge-to-edge, you are most likely impacted.\n              In addition to the scenarios for apps that are already edge-to-edge,\n              you should consider the following:\n              " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                  If your app uses Material 3 Components\n                  (" + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("androidx.compose.material3", urls.getMaterial3()) + ") in compose, such as\n                  " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("TopAppBar") + ", " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BottomAppBar") + ", and " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("NavigationBar") + ",\n                  these components are likely " + ApiUtils.INSTANCE.italic$targetsdkversion_upgrade_assistant("not") + " impacted because they automatically handle insets.\n                "))) + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                  If your app is using Material 2 Components\n                  (" + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("androidx.compose.material", urls.getMaterial2()) + ") in Compose,\n                  these components don't automatically handle insets.\n                  However, you can get access to the insets and apply them manually. In\n                  " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("androidx.compose.material 1.6.0", urls.getMaterial2_160()) + " and\n                  later, use the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("windowInsets") + " parameter to apply the insets manually for\n                  " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BottomAppBar"), urls.getBottomAppBar()) + ",\n                  " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("TopAppBar"), urls.getTopAppBar()) + ",\n                  " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BottomNavigation"), urls.getBottomNavigation()) + ", and\n                  " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("NavigationRail"), urls.getNavigationRail()) + ".\n                  Likewise, use the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("contentWindowInsets") + " parameter for\n                  " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Scaffold", urls.getScaffold()) + ".\n                "))) + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                  If your app uses Views and Material Components (\n                  " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("com.google.android.material", urls.getMaterialComponents()) + "),\n                  most views-based Material Components such as\n                  " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BottomNavigationView") + ", " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BottomAppBar") + ",\n                  " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("NavigationRailView") + ", or " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("NavigationView") + ",\n                  handle insets and require no additional work. However, you need to add\n                  " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("android:fitsSystemWindows=\"true\"") + " if using " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("AppBarLayout") + ".\n                "))) + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                  For custom composables, apply the insets manually as padding.\n                  If your content is within a " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Scaffold") + ",\n                  you can consume insets using the " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Scaffold padding values", urls.getScaffoldPadding()) + ".\n                  Otherwise, apply padding using one of the " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("WindowInsets"), urls.getWindowInsets()) + ".\n                "))) + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                  If your app is using views and " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BottomSheet") + ",\n                  " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("SideSheet") + " or custom containers,\n                  apply padding using " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("ViewCompat.setOnApplyWindowInsetsListener"), urls.getOverlaps()) + ".\n                  For " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("RecyclerView") + ", apply padding using this listener and also add " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("clipToPadding=\"false\"") + ".\n                "))) + "\n              "))) + "\n              " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "What to check if your app must offer custom background protection") + "\n              If your app must offer custom background protection to 3-button navigation or the status bar,\n              your app should place a composable or view behind the system bar using\n              " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("WindowInsets.Type#tappableElement()"), urls.getTappable()) + " to get the 3-button navigation bar height\n              or " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("WindowInsets.Type#statusBars"), urls.getStatusBars()) + ".\n              " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Additional edge-to-edge resources") + "\n              See the " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Edge to Edge Views", urls.getE2eViews()) + " and\n              " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Edge to Edge Compose", urls.getInsets()) + " guides for additional considerations on applying insets.\n              " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Deprecated APIs") + "\n              The following APIs are deprecated but not disabled:\n              " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(enforceStatusBarContrast) + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(navigationBarColor + " (for 3 button navigation, with 80% alpha)") + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(winIsStatBarContrastEnforced) + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(winSetNavBarColor + " (for 3 button navigation, with 80% alpha)") + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(winSetStatBarContrastEnforced) + "\n              "))) + "\n              The following APIs are deprecated and disabled:\n              " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(navigationBarColor + " (for gesture navigation)") + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(naviBarDivColor) + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(statBarColor) + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(winSetDecorFitsSysWin) + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(winGetNavBarColor) + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(winGetNavBarDivColor) + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(winGetStatBarColor) + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(winSetNavBarColor + " (for gesture navigation)") + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(winSetNavBarDivColor) + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(winSetStatBarColor) + "\n              "))) + "\n            ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$11$1(ElementListBuilder $this$relevanceOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$relevanceOnly, (String)"$this$relevanceOnly");
        String c = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Configuration");
        String vg = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("ViewGroup");
        String wi = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("WindowInsets");
        String wmc = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("WindowMetricsCalculator");
        String coordinatorLayout = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("CoordinatorLayout");
        String constraintLayout = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("ConstraintLayout");
        String computeCurrentWindowMetrics = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("computeCurrentWindowMetrics");
        String swd = "screenWidthDp";
        String screenWidthDpLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Configuration." + swd), "https://developer.android.com/reference/android/content/res/Configuration#screenWidthDp");
        String shd = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("screenHeightDp");
        String screenHeightDpLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(shd, "https://developer.android.com/reference/android/content/res/Configuration#screenHeightDp");
        String smallestScreenWidthDp = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Configuration.smallestScreenWidthDp"), "https://developer.android.com/reference/android/content/res/Configuration#smallestScreenWidthDp");
        String orientation = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Configuration.orientation"), "https://developer.android.com/reference/android/content/res/Configuration#orientation");
        String getSize = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Display.getSize(Point)"), "https://developer.android.com/reference/android/view/Display#getSize(android.graphics.Point)");
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n              If your app targets Android 15 (API level 35) or higher, " + c + " no longer excludes the system bars.\n              If you use the screen size in the " + c + " class for layout calculation,\n              you should replace it with better alternatives like an appropriate " + vg + ", " + wi + ", or " + wmc + " depending on your need.\n              " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n              " + c + " has been available since API 1. It is typically obtained from " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Activity.onConfigurationChanged") + ".\n              It provides information like window density, orientation, and sizes.\n              One important characteristic about the window sizes returned from " + c + " is that it previously excluded the system bars.\n              " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n              The configuration size is typically used for resource selection, such as " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("/res/layout-h500dp") + ",\n              and this is still a valid use case. However, using it for layout calculation has always been discouraged.\n              If you do so, you should move away from it now.\n              You should replace the use of " + c + " with something more suitable depending on your use case.\n              " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n              If you use it to calculate the layout, use an appropriate " + vg + ", such as " + coordinatorLayout + " or " + constraintLayout + ".\n              If you use it to determine the height of the system navbar, use " + wi + ".\n              If you want to know the current size of your app window, use " + computeCurrentWindowMetrics + ".\n              " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n              The following list describes the fields affected by this change:\n              " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(screenWidthDpLink + " and " + screenHeightDpLink + " sizes no longer exclude the system bars.") + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(smallestScreenWidthDp + " is indirectly affected by changes to " + swd + " and " + shd + ".") + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(orientation + " is indirectly affected by changes to " + swd + " and " + shd + " on close-to-square devices.") + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(getSize + " is indirectly affected by the changes in " + c + ". This was deprecated beginning in API level 30.") + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Display.getMetrics()") + " has already worked like this since API level 33.") + "\n              "))) + "\n            ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$12(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n           For apps targeting Android 15 (API level 35), the " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("elegantTextHeight"), urls.getElegantTextHeight()) + "\n           " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("TextView"), urls.getTextView()) + " attribute becomes " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("true") + " by default,\n           replacing the compact font used by default with some scripts that have large vertical metrics with one\n           that is much more readable. The compact font was introduced to prevent breaking layouts; Android 13 (API level 33)\n           prevents many of these breakages by allowing the text layout to stretch the vertical height utilizing\n           the " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("fallbackLineSpacing"), urls.getFallbackLineSpacing()) + " attribute.\n           " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n           In Android 15, the compact font still remains in the system, so your app can set " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("elegantTextHeight") + "\n           to false to get the same behavior as before, but it is unlikely to be supported in upcoming releases.\n           So, if your app supports the following scripts: Arabic, Lao, Myanmar, Tamil, Gujarati, Kannada,\n           Malayalam, Odia, Telugu or Thai, test your app by setting " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("elegantTextHeight") + " to " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("true") + ".\n          ")));
        ApiUtils.captioned$targetsdkversion_upgrade_assistant$default(ApiUtils.INSTANCE, $this$raw, ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("elegantTextHeight") + " behavior for apps targeting Android 14 (API level 34) and lower", "/plan/api35/elegant-text-height-before.png", 0, 0, 12, null);
        ApiUtils.captioned$targetsdkversion_upgrade_assistant$default(ApiUtils.INSTANCE, $this$raw, ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("elegantTextHeight ") + " behavior for apps targeting Android 15 (API level 35)", "/plan/api35/elegant-text-height-after.png", 0, 0, 12, null);
        $this$raw.text(StringsKt.trimIndent((String)("\n           " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n           For more information, see " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("elegantTextHeight attribute defaults to true", urls.getElegantTextHeightChange()) + ".\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$13(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        String tw = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("TextView");
        String setUseBoundsForWidth = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("setUseBoundsForWidth");
        String setShiftDrawingOffsetForStartOverhang = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("setShiftDrawingOffsetForStartOverhang");
        $this$raw.text(StringsKt.trimIndent((String)("\n            In previous versions of Android,\n            some cursive fonts or languages that have complex shaping might draw the letters in the previous or next character's area.\n            In some cases, such letters were clipped at the beginning or ending position.\n            Starting in Android 15, a " + tw + " allocates width for drawing enough space for such letters\n            and allows apps to request extra paddings to the left to prevent clipping.\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            Because this change affects how a " + tw + " decides the width,\n            " + tw + " allocates more width by default if the app targets Android 15 (API level 35) or higher.\n            You can enable or disable this behavior by calling the " + setUseBoundsForWidth + " API on " + tw + ".\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            Because adding left padding might cause a misalignment for existing layouts,\n            the padding is not added by default even for apps that target Android 15 or higher.\n            However, you can add extra padding to preventing clipping by calling " + setShiftDrawingOffsetForStartOverhang + ".\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            The following examples show how these changes can improve text layout for some fonts and languages.\n          ")));
        ApiUtils.captioned$targetsdkversion_upgrade_assistant$default(ApiUtils.INSTANCE, $this$raw, "Standard layout for English text in a cursive font.\nSome of the letters are clipped.\nHere is the corresponding XML:", "/plan/api35/english-cursive-clipped.png", 0, 0, 12, null);
        $this$raw.xml("<TextView\n    android:fontFamily=\"cursive\"\n    android:text=\"java\" />");
        ApiUtils.captioned$targetsdkversion_upgrade_assistant$default(ApiUtils.INSTANCE, $this$raw, "Layout for the same English text with additional width and padding.\nHere is the corresponding XML:", "/plan/api35/english-cursive-noclipping.png", 0, 0, 12, null);
        $this$raw.xml("<TextView\n    android:fontFamily=\"cursive\"\n    android:text=\"java\"\n    android:useBoundsForWidth=\"true\"\n    android:shiftDrawingOffsetForStartOverhang=\"true\" />");
        ApiUtils.captioned$targetsdkversion_upgrade_assistant$default(ApiUtils.INSTANCE, $this$raw, "Standard layout for Thai text.\nSome of the letters are clipped.\nHere is the corresponding XML:", "/plan/api35/thai-clipped.png", 0, 0, 12, null);
        $this$raw.xml("<TextView\n    android:text=\"\u0e04\u0e2d\u0e21\u0e1e\u0e34\u0e27\u0e40\u0e15\u0e2d\u0e23\u0e4c\" />");
        ApiUtils.captioned$targetsdkversion_upgrade_assistant$default(ApiUtils.INSTANCE, $this$raw, "Layout for the same Thai text with additional width and padding.\nHere is the corresponding XML:", "/plan/api35/thai-noclipping.png", 0, 0, 12, null);
        $this$raw.xml("<TextView\n    android:text=\"\u0e04\u0e2d\u0e21\u0e1e\u0e34\u0e27\u0e40\u0e15\u0e2d\u0e23\u0e4c\"\n    android:useBoundsForWidth=\"true\"\n    android:shiftDrawingOffsetForStartOverhang=\"true\" />");
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$14(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        String editText = ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("EditText");
        String editTextLink = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(editText, "https://developer.android.com/reference/android/widget/EditText");
        $this$raw.text(StringsKt.trimIndent((String)("\n            In previous versions of Android,\n            the text layout stretched the height of the text to meet the line height of the font that matched the current locale.\n            For example, if the content was in Japanese,\n            because the line height of the Japanese font is slightly larger than the one of a Latin font,\n            the height of the text became slightly larger.\n            However, despite these differences in line heights,\n            the " + editTextLink + " element was sized uniformly,\n            regardless of the locale being used, as illustrated in the following image:\n          ")));
        ApiUtils.captioned$targetsdkversion_upgrade_assistant$default(ApiUtils.INSTANCE, $this$raw, StringsKt.trimIndent((String)("\n              Three boxes representing " + editText + " elements that can contain text from English (en), Japanese (ja), and Burmese (my).\n              The height of the " + editText + " is the same, even though these languages have different line heights from each other.\n            ")), "/plan/api35/locale-aware-line-height-before.png", 0, 650, 4, null);
        $this$raw.text(StringsKt.trimIndent((String)("\n            For apps targeting Android 15 (API level 35),\n            a minimum line height is now reserved for " + editText + " to match the reference font for the specified Locale,\n            as shown in the following image:\n          ")));
        ApiUtils.captioned$targetsdkversion_upgrade_assistant$default(ApiUtils.INSTANCE, $this$raw, StringsKt.trimIndent((String)("\n              Three boxes representing " + editText + " elements that can contain text from English (en), Japanese (ja), and Burmese (my).\n              The height of the " + editText + " now includes space to accommodate the default line height for these languages' fonts.\n            ")), "/plan/api35/locale-aware-line-height-after.png", 0, 650, 4, null);
        String ulplhfm = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("useLocalePreferredLineHeightForMinimum"), "https://developer.android.com/reference/android/R.attr#useLocalePreferredLineHeightForMinimum");
        String smfm = ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("setMinimumFontMetrics"), "https://developer.android.com/reference/android/text/DynamicLayout.Builder#setMinimumFontMetrics(android.graphics.Paint.FontMetrics)");
        $this$raw.text(StringsKt.trimIndent((String)("\n            If needed,\n            your app can restore the previous behavior by specifying the " + ulplhfm + " attribute to " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("false") + ",\n            and your app can set custom minimum vertical metrics using the " + smfm + " API in Kotlin and Java.\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$15(ElementListBuilder $this$relevanceOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$relevanceOnly, (String)"$this$relevanceOnly");
        $this$relevanceOnly.text(StringsKt.trimIndent((String)("\n            Apps that target Android 15 (API level 35) must be the top app or\n            running a foreground service in order to\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("request audio focus", urls.getRequestAudioFocus()) + ".\n            If an app attempts to request focus when it does not meet one of these requirements,\n            the call returns " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("AUDIOFOCUS_REQUEST_FAILED"), urls.getAudioFocusRequestFailed()) + ".\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            You can learn more about audio focus at " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Manage audio focus", urls.getManageAudioFocus()) + ".\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$1(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text("Make sure to review the " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("complete set of changes", urls.getBehaviorChanges()) + ".");
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$2(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          Once you've finished migrating your code, update " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("targetSdkVersion") + " to 35.\n        ")));
        return Unit.INSTANCE;
    }
}

