/*
 * Decompiled with CFR 0.152.
 */
package com.google.targetsdkversionassistant.metrics;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.google.targetsdkversionassistant.filter.LocationProvider;
import com.google.targetsdkversionassistant.metrics.FilterId;
import com.google.targetsdkversionassistant.metrics.Origin;
import com.google.targetsdkversionassistant.metrics.StateUpdateType;
import com.google.targetsdkversionassistant.metrics.UserMotion;
import com.google.targetsdkversionassistant.metrics.Utils;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.TSdkUAEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 02\u00020\u0001:\u00010B+\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\t\u0010\nB\u0017\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\t\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\t\u0010\u000eB%\b\u0017\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\t\u0010\u000fJ@\u0010\u0014\u001a\u00020\b\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u00020\u00170\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00150\u001cJ,\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0012\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$0#J2\u0010&\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010!2\u0012\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$0\u0003J\u000e\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020+J!\u0010,\u001a\u00020\b2\u0017\u0010-\u001a\u0013\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b/H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0002\u0010\u0011\u00a8\u00061"}, d2={"Lcom/google/targetsdkversionassistant/metrics/Tracker;", "", "getPackageId", "Lkotlin/Function0;", "", "studioLog", "Lkotlin/Function1;", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "(Lkotlin/jvm/functions/Function0;)V", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;)V", "packageId", "()Ljava/lang/String;", "packageId$delegate", "Lkotlin/Lazy;", "logState", "Step", "encoderVersion", "", "encode", "updateType", "Lcom/google/targetsdkversionassistant/metrics/StateUpdateType;", "remainingSteps", "", "logFilterRunResult", "id", "Lcom/google/targetsdkversionassistant/metrics/FilterId;", "filterOrigin", "Lcom/google/targetsdkversionassistant/metrics/Origin;", "timedResult", "Lcom/google/targetsdkversionassistant/metrics/Utils$TimedResult;", "", "Lcom/google/targetsdkversionassistant/filter/LocationProvider;", "runFilterWithTracking", "origin", "run", "logUserMotion", "motion", "Lcom/google/targetsdkversionassistant/metrics/UserMotion;", "log", "setUp", "Lcom/google/wireless/android/sdk/stats/TSdkUAEvent$Builder;", "Lkotlin/ExtensionFunctionType;", "Companion", "targetsdkversion-upgrade-assistant"})
public final class Tracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<AndroidStudioEvent.Builder, Unit> studioLog;
    @NotNull
    private final Lazy packageId$delegate;

    @VisibleForTesting
    public Tracker(@NotNull Function0<String> getPackageId, @NotNull Function1<? super AndroidStudioEvent.Builder, Unit> studioLog) {
        Intrinsics.checkNotNullParameter(getPackageId, (String)"getPackageId");
        Intrinsics.checkNotNullParameter(studioLog, (String)"studioLog");
        this.studioLog = studioLog;
        this.packageId$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, getPackageId);
    }

    private final String getPackageId() {
        Lazy lazy = this.packageId$delegate;
        return (String)lazy.getValue();
    }

    public Tracker(@NotNull Function0<String> getPackageId) {
        Intrinsics.checkNotNullParameter(getPackageId, (String)"getPackageId");
        this(getPackageId, (Function1<? super AndroidStudioEvent.Builder, Unit>)((Function1)new Function1<AndroidStudioEvent.Builder, Unit>((Object)UsageTracker.INSTANCE){

            public final void invoke(AndroidStudioEvent.Builder p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                UsageTracker.log((AndroidStudioEvent.Builder)p0);
            }
        }));
    }

    public Tracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this((Function0<String>)((Function0)() -> Tracker._init_$lambda$0(project)));
    }

    @TestOnly
    public Tracker(@NotNull Project project, @NotNull Function1<? super AndroidStudioEvent.Builder, Unit> studioLog) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(studioLog, (String)"studioLog");
        this((Function0<String>)((Function0)() -> Tracker._init_$lambda$1(project)), studioLog);
    }

    public final <Step> void logState(int encoderVersion, @NotNull Function1<? super Step, Integer> encode, @Nullable StateUpdateType updateType, @NotNull Collection<? extends Step> remainingSteps) {
        Intrinsics.checkNotNullParameter(encode, (String)"encode");
        Intrinsics.checkNotNullParameter(remainingSteps, (String)"remainingSteps");
        this.log((Function1<? super TSdkUAEvent.Builder, Unit>)((Function1)arg_0 -> Tracker.logState$lambda$0(encoderVersion, encode, remainingSteps, updateType, arg_0)));
    }

    public final void logFilterRunResult(@NotNull FilterId id, @Nullable Origin filterOrigin, @NotNull Utils.TimedResult<List<LocationProvider>> timedResult) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(timedResult, (String)"timedResult");
        this.log((Function1<? super TSdkUAEvent.Builder, Unit>)((Function1)arg_0 -> Tracker.logFilterRunResult$lambda$0(id, timedResult, filterOrigin, arg_0)));
    }

    @NotNull
    public final List<LocationProvider> runFilterWithTracking(@NotNull FilterId id, @Nullable Origin origin, @NotNull Function0<? extends List<? extends LocationProvider>> run) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(run, (String)"run");
        Utils.TimedResult<List<LocationProvider>> timedResult = Utils.TimedResult.Companion.of(run);
        this.logFilterRunResult(id, origin, timedResult);
        return timedResult.getResult().unpack();
    }

    public final void logUserMotion(@NotNull UserMotion motion) {
        Intrinsics.checkNotNullParameter((Object)motion, (String)"motion");
        this.log((Function1<? super TSdkUAEvent.Builder, Unit>)((Function1)arg_0 -> Tracker.logUserMotion$lambda$0(motion, arg_0)));
    }

    private final void log(Function1<? super TSdkUAEvent.Builder, Unit> setUp) {
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.TSDKUA_EVENT).setProjectId(AnonymizerUtil.anonymizeUtf8((String)this.getPackageId())).setTsdkUaEvent((TSdkUAEvent)Utils.INSTANCE.getTSdkUAEvent().invoke(setUp));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setTsdkUaEvent(...)");
        this.studioLog.invoke((Object)builder);
    }

    private static final String _init_$lambda$0(Project $project) {
        return Companion.projectId($project);
    }

    private static final String _init_$lambda$1(Project $project) {
        return Companion.projectId($project);
    }

    private static final Unit logState$lambda$0(int $encoderVersion, Function1 $encode, Collection $remainingSteps, StateUpdateType $updateType, TSdkUAEvent.Builder $this$log) {
        Intrinsics.checkNotNullParameter((Object)$this$log, (String)"$this$log");
        $this$log.setStateUpdate((TSdkUAEvent.StateUpdate)Utils.INSTANCE.getStateUpdate().invoke(arg_0 -> Tracker.logState$lambda$0$0($encoderVersion, $encode, $remainingSteps, $updateType, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit logState$lambda$0$0(int $encoderVersion, Function1 $encode, Collection $remainingSteps, StateUpdateType $updateType, TSdkUAEvent.StateUpdate.Builder $this$stateUpdate) {
        TSdkUAEvent.StateUpdate.Type type;
        $this$stateUpdate.setTimestampMs(System.currentTimeMillis());
        $this$stateUpdate.setMappingVersion($encoderVersion);
        $this$stateUpdate.setActiveSteps(Utils.INSTANCE.encodeSet($encode, $remainingSteps));
        StateUpdateType stateUpdateType = $updateType;
        if (Intrinsics.areEqual((Object)stateUpdateType, (Object)StateUpdateType.FinalizedInitial.INSTANCE)) {
            type = TSdkUAEvent.StateUpdate.Type.INIT;
        } else if (Intrinsics.areEqual((Object)stateUpdateType, (Object)StateUpdateType.CompletionDelta.INSTANCE)) {
            type = TSdkUAEvent.StateUpdate.Type.DELTA;
        } else if (stateUpdateType == null) {
            type = TSdkUAEvent.StateUpdate.Type.UNSPECIFIED_TYPE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $this$stateUpdate.setType(type);
        return Unit.INSTANCE;
    }

    private static final Unit logFilterRunResult$lambda$0(FilterId $id, Utils.TimedResult $timedResult, Origin $filterOrigin, TSdkUAEvent.Builder $this$log) {
        Intrinsics.checkNotNullParameter((Object)$this$log, (String)"$this$log");
        $this$log.setFilterRun((TSdkUAEvent.FilterRun)Utils.INSTANCE.getFilterRun().invoke(arg_0 -> Tracker.logFilterRunResult$lambda$0$0($id, $timedResult, $filterOrigin, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit logFilterRunResult$lambda$0$0(FilterId $id, Utils.TimedResult $timedResult, Origin $filterOrigin, TSdkUAEvent.FilterRun.Builder $this$filterRun) {
        TSdkUAEvent.FilterRun.Origin origin;
        $this$filterRun.setFilterId($id.getId());
        $this$filterRun.setFilterVersion($id.getVersion());
        $this$filterRun.setElapsedMs($timedResult.getElapsedMs());
        Utils.Result r = $timedResult.getResult();
        if (r instanceof Utils.Result.Value) {
            $this$filterRun.setCount(((List)((Utils.Result.Value)r).getUnboxed()).size());
        } else if (r instanceof Utils.Result.Error) {
            $this$filterRun.setProblem(TSdkUAEvent.FilterRun.Problem.ERROR);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Origin origin2 = $filterOrigin;
        if (Intrinsics.areEqual((Object)origin2, (Object)Origin.OnStart.INSTANCE)) {
            origin = TSdkUAEvent.FilterRun.Origin.RUN_ON_START;
        } else if (Intrinsics.areEqual((Object)origin2, (Object)Origin.ReverifyButton.INSTANCE)) {
            origin = TSdkUAEvent.FilterRun.Origin.RERUN_BUTTON;
        } else if (origin2 == null) {
            origin = TSdkUAEvent.FilterRun.Origin.UNSPECIFIED_ORIGIN;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $this$filterRun.setOrigin(origin);
        return Unit.INSTANCE;
    }

    private static final Unit logUserMotion$lambda$0(UserMotion $motion, TSdkUAEvent.Builder $this$log) {
        Intrinsics.checkNotNullParameter((Object)$this$log, (String)"$this$log");
        $this$log.setUserMotion($motion.toProto());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J&\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0007\u00a8\u0006\u000e"}, d2={"Lcom/google/targetsdkversionassistant/metrics/Tracker$Companion;", "", "<init>", "()V", "projectId", "", "p", "Lcom/intellij/openapi/project/Project;", "testTracker", "Lcom/google/targetsdkversionassistant/metrics/Tracker;", "onLog", "Lkotlin/Function1;", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "", "targetsdkversion-upgrade-assistant"})
    @SourceDebugExtension(value={"SMAP\nTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Tracker.kt\ncom/google/targetsdkversionassistant/metrics/Tracker$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,171:1\n24#2:172\n*S KotlinDebug\n*F\n+ 1 Tracker.kt\ncom/google/targetsdkversionassistant/metrics/Tracker$Companion\n*L\n128#1:172\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @NotNull
        public final String projectId(@NotNull Project p) {
            String string;
            String string2;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            try {
                string2 = (String)CollectionsKt.firstOrNull((Iterable)ProjectSystemUtil.getProjectSystem((Project)p).getKnownApplicationIds(p));
            }
            catch (UnsupportedOperationException e) {
                Companion $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(Companion.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("failed to fetch project ID", (Throwable)e);
                string2 = null;
            }
            if ((string = string2) == null) {
                string = "unknown";
            }
            return string;
        }

        @TestOnly
        @NotNull
        public final Tracker testTracker(@NotNull Project p, @NotNull Function1<? super AndroidStudioEvent.Builder, Unit> onLog) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter(onLog, (String)"onLog");
            return new Tracker(p, onLog);
        }

        public static /* synthetic */ Tracker testTracker$default(Companion companion, Project project, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = Companion::testTracker$lambda$0;
            }
            return companion.testTracker(project, (Function1<? super AndroidStudioEvent.Builder, Unit>)function1);
        }

        private static final Unit testTracker$lambda$0(AndroidStudioEvent.Builder it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

