/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.LocalProcessService;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0001\u001a\u001e\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u000f"}, d2={"terminateWinProcessGracefully", "", "processHandler", "Lcom/intellij/execution/process/KillableProcessHandler;", "processService", "Lcom/intellij/execution/process/LocalProcessService;", "terminateGracefully", "Lkotlin/Function0;", "awaitBatchQuestionAndDestroyInTests", "", "questionFoundOrTerminated", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "destroy", "isCmdBatchFile", "intellij.platform.ide.util.io"})
@JvmName(name="WinProcessTerminator")
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nWinProcessTerminator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WinProcessTerminator.kt\ncom/intellij/execution/process/WinProcessTerminator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,91:1\n14#2:92\n*S KotlinDebug\n*F\n+ 1 WinProcessTerminator.kt\ncom/intellij/execution/process/WinProcessTerminator\n*L\n78#1:92\n*E\n"})
public final class WinProcessTerminator {
    @JvmOverloads
    public static final boolean terminateWinProcessGracefully(@NotNull KillableProcessHandler processHandler, @NotNull LocalProcessService processService, @NotNull Function0<Boolean> terminateGracefully) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        Intrinsics.checkNotNullParameter((Object)processService, (String)"processService");
        Intrinsics.checkNotNullParameter(terminateGracefully, (String)"terminateGracefully");
        CompletableFuture<Void> questionFoundOrTerminated = new CompletableFuture<Void>();
        ProcessListener processListener2 = new ProcessListener(processHandler, questionFoundOrTerminated){
            final /* synthetic */ KillableProcessHandler $processHandler;
            final /* synthetic */ CompletableFuture<Void> $questionFoundOrTerminated;
            {
                this.$processHandler = $processHandler;
                this.$questionFoundOrTerminated = $questionFoundOrTerminated;
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                if (ProcessOutputType.isStdout(outputType)) {
                    String string = event.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    if (StringsKt.contains$default((CharSequence)string, (CharSequence)"?", (boolean)false, (int)2, null)) {
                        this.$processHandler.removeProcessListener(this);
                        this.$questionFoundOrTerminated.complete(null);
                    }
                }
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$processHandler.removeProcessListener(this);
                this.$questionFoundOrTerminated.complete(null);
            }
        };
        processHandler.addProcessListener(processListener2);
        Object object = terminateGracefully.invoke();
        boolean it = (Boolean)object;
        boolean bl = false;
        if (it) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                if (WinProcessTerminator.isCmdBatchFile(processHandler, processService)) {
                    WinProcessTerminator.awaitBatchQuestionAndDestroyInTests(questionFoundOrTerminated, processHandler);
                }
                processHandler.removeProcessListener(processListener2);
            } else {
                questionFoundOrTerminated.whenComplete((arg_0, arg_1) -> WinProcessTerminator.terminateWinProcessGracefully$lambda$3$lambda$2((arg_0, arg_1) -> WinProcessTerminator.terminateWinProcessGracefully$lambda$3$lambda$1(processHandler, processService, arg_0, arg_1), arg_0, arg_1));
            }
        } else {
            processHandler.removeProcessListener(processListener2);
        }
        return (Boolean)object;
    }

    public static /* synthetic */ boolean terminateWinProcessGracefully$default(KillableProcessHandler killableProcessHandler, LocalProcessService localProcessService, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = () -> WinProcessTerminator.terminateWinProcessGracefully$lambda$0(localProcessService, killableProcessHandler);
        }
        return WinProcessTerminator.terminateWinProcessGracefully(killableProcessHandler, localProcessService, (Function0<Boolean>)function0);
    }

    private static final void awaitBatchQuestionAndDestroyInTests(CompletableFuture<Void> questionFoundOrTerminated, KillableProcessHandler processHandler) {
        try {
            questionFoundOrTerminated.get(10L, TimeUnit.SECONDS);
            WinProcessTerminator.destroy(processHandler);
        }
        catch (Exception exception) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(KillableProcessHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Process hasn't been terminated gracefully: couldn't find \"Terminate batch job (Y/N)?\".");
        }
    }

    private static final void destroy(KillableProcessHandler processHandler) {
        processHandler.getProcess().destroy();
    }

    private static final boolean isCmdBatchFile(KillableProcessHandler processHandler, LocalProcessService processService) {
        Process process = processHandler.getProcess();
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"getProcess(...)");
        String it = (String)CollectionsKt.firstOrNull(processService.getCommand(process));
        boolean bl = false;
        return it != null && (StringsKt.endsWith$default((String)it, (String)".bat", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it, (String)".cmd", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it, (String)"\\cmd.exe", (boolean)false, (int)2, null));
    }

    @JvmOverloads
    public static final boolean terminateWinProcessGracefully(@NotNull KillableProcessHandler processHandler, @NotNull LocalProcessService processService) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        Intrinsics.checkNotNullParameter((Object)processService, (String)"processService");
        return WinProcessTerminator.terminateWinProcessGracefully$default(processHandler, processService, null, 4, null);
    }

    private static final boolean terminateWinProcessGracefully$lambda$0(LocalProcessService $processService, KillableProcessHandler $processHandler) {
        Process process = $processHandler.getProcess();
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"getProcess(...)");
        return $processService.sendWinProcessCtrlC(process);
    }

    private static final Unit terminateWinProcessGracefully$lambda$3$lambda$1(KillableProcessHandler $processHandler, LocalProcessService $processService, Void void_, Throwable throwable) {
        if (!$processHandler.isProcessTerminated() && WinProcessTerminator.isCmdBatchFile($processHandler, $processService)) {
            WinProcessTerminator.destroy($processHandler);
        }
        return Unit.INSTANCE;
    }

    private static final void terminateWinProcessGracefully$lambda$3$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

