/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.analysis.reflection.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ReflectionUtils {
    private static Map<String, String> primitiveMap;
    private static Map<String, String> primitiveMapInverse;

    private static Map<String, String> getInverse() {
        HashMap<String, String> temp = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : primitiveMap.entrySet()) {
            temp.put(entry.getValue(), entry.getKey());
        }
        return Collections.unmodifiableMap(temp);
    }

    public static String javaToDexName(String javaName) {
        if (javaName.charAt(0) == '[') {
            return javaName.replace('.', '/');
        }
        if (primitiveMap.containsKey(javaName)) {
            return primitiveMap.get(javaName);
        }
        return 'L' + javaName.replace('.', '/') + ';';
    }

    public static String dexToJavaName(String dexName) {
        if (dexName.charAt(0) == '[') {
            return dexName.replace('/', '.');
        }
        if (primitiveMapInverse.containsKey(dexName)) {
            return primitiveMapInverse.get(dexName);
        }
        return dexName.replace('/', '.').substring(1, dexName.length() - 1);
    }

    static {
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("boolean", "Z");
        temp.put("int", "I");
        temp.put("long", "J");
        temp.put("double", "D");
        temp.put("void", "V");
        temp.put("float", "F");
        temp.put("char", "C");
        temp.put("short", "S");
        temp.put("byte", "B");
        primitiveMap = Collections.unmodifiableMap(temp);
        primitiveMapInverse = ReflectionUtils.getInverse();
    }
}

