/*
 * Decompiled with CFR 0.152.
 */
package com.google.play.policy.insights;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.intellij.psi.PsiClass;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/google/play/policy/insights/AccessibilityServicePolicyDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "applicableSuperClasses", "", "visitClass", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UClass;", "Companion", "policyinsights"})
public final class AccessibilityServicePolicyDetector
extends Detector
implements XmlScanner,
SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ACCESSIBILITY_SERVICE_TAG = "accessibility-service";
    @NotNull
    public static final String SERVICE_TAG = "service";
    @NotNull
    public static final String IS_ACCESSIBILITY_SERVICE_ATTR = "isAccessibilityTool";
    @NotNull
    public static final String ACCESSIBILITY_SERVICE = "android.accessibilityservice.AccessibilityService";
    @NotNull
    public static final String BIND_ACCESSIBILITY_SERVICE = "android.permission.BIND_ACCESSIBILITY_SERVICE";
    @NotNull
    public static final String ID = "AccessibilityPolicy";
    @NotNull
    public static final String DESCRIPTION = "Accessibility Insights";
    @NotNull
    private static final String EXPLANATION = "Google Play permits the use of the AccessibilityService API across a wide range of \\\napplications. However, only services designed to help people with disabilities access their \\\ndevices or overcome challenges due to their disabilities are eligible to declare themselves \\\nas accessibility tools by setting `isAccessibilityTool=true` in their metadata. These apps \\\nare exempt from the prominent disclosure and consent requirements. For all other uses, or if \\\nnot declaring your app as an accessibility tool, you will be required to complete an \\\naccessibility declaration in Play Console and must implement a clear in-app disclosure \\\nexplaining data access and use, and obtain affirmative user consent. \n\n**Dos:**\n\n- Declare `isAccessibilityTool=true` accurately if your app\u2019s main goal is disability \\\nsupport in your service\u2019s metadata file.\n- Provide a clear Play Console declaration and demo video if using AccessibilityService API.\n- Implement clear in-app disclosure and obtain user consent if not a designated \\\naccessibility tool.\n- Complete an accessibility declaration when you submit a declaration form in your Play \\\nConsole if you have not declared your app to be an accessibility tool but use the \\\nAccessibilityService API\n- Limit data collection and use strictly to the disclosed and declared purposes.\n- Use more narrowly scoped APIs and permissions in lieu of the Accessibility API when \\\npossible to achieve the desired functionality. \n\n**Don'ts:**\n\n- Misuse the Accessibility API to bypass privacy settings or alter UI without consent.\n- Claim `isAccessibilityTool=true` if your app's core purpose is not supporting people with \\\ndisabilities.\n- Neglect the Play Console declaration, video, or necessary in-app disclosures.\n- Collect data beyond what's essential for the declared accessibility features.\n- Rely only on app descriptions or privacy policies for required user disclosures.\n\n**Helpful Links:**\n\nSee Policy page: https://goo.gle/play-policy-accessibility  \nSee Help Center article: https://goo.gle/play-help-accessibility \nSee Declaration form:  https://goo.gle/play-permission-decl-form\n\nAlways review the full policy in the Policy Center to ensure compliance.";
    @NotNull
    public static final String URL = "https://support.google.com/googleplay/android-developer/answer/10964491";
    @NotNull
    private static final String MESSAGE = "AccessibilityService API usage must align with the API policy guidelines.  It must not be \\\nused to bypass privacy controls or change settings without consent. ";
    @NotNull
    private static final Issue ISSUE;

    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[]{ACCESSIBILITY_SERVICE_TAG, SERVICE_TAG};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (Intrinsics.areEqual((Object)element.getTagName(), (Object)SERVICE_TAG)) {
            Attr permissionNode;
            Attr attr = permissionNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "permission");
            if (Intrinsics.areEqual((Object)(attr != null ? attr.getValue() : null), (Object)BIND_ACCESSIBILITY_SERVICE)) {
                XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getLocation((Node)permissionNode), (String)MESSAGE, null, (int)16, null);
            }
        } else if (Intrinsics.areEqual((Object)element.getTagName(), (Object)ACCESSIBILITY_SERVICE_TAG)) {
            Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", IS_ACCESSIBILITY_SERVICE_ATTR);
            if (attr == null) {
                return;
            }
            Attr node = attr;
            if (Intrinsics.areEqual((Object)node.getValue(), (Object)"true")) {
                XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getLocation((Node)node), (String)MESSAGE, null, (int)16, null);
            }
        }
    }

    @NotNull
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object)ACCESSIBILITY_SERVICE);
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        PsiClass psiClass = declaration.getJavaPsi().getSuperClass();
        if (psiClass == null) {
            return;
        }
        PsiClass superCls = psiClass;
        if (Intrinsics.areEqual((Object)superCls.getQualifiedName(), (Object)ACCESSIBILITY_SERVICE)) {
            context.report(ISSUE, declaration, context.getNameLocation(declaration), MESSAGE);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        String string = EXPLANATION;
        Category category = Category.Companion.create("Play Policy", 84);
        Severity severity = Severity.WARNING;
        EnumSet[] enumSetArray = new EnumSet[]{Scope.RESOURCE_FILE_SCOPE, Scope.JAVA_FILE_SCOPE, Scope.MANIFEST_SCOPE};
        Implementation implementation = new Implementation(AccessibilityServicePolicyDetector.class, EnumSet.of((Enum)Scope.RESOURCE_FILE, (Enum)Scope.JAVA_FILE, (Enum)Scope.MANIFEST), enumSetArray);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)ID, (String)DESCRIPTION, (String)string, (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/google/play/policy/insights/AccessibilityServicePolicyDetector$Companion;", "", "<init>", "()V", "ACCESSIBILITY_SERVICE_TAG", "", "SERVICE_TAG", "IS_ACCESSIBILITY_SERVICE_ATTR", "ACCESSIBILITY_SERVICE", "BIND_ACCESSIBILITY_SERVICE", "ID", "DESCRIPTION", "EXPLANATION", "getEXPLANATION", "()Ljava/lang/String;", "URL", "MESSAGE", "getMESSAGE", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "policyinsights"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getEXPLANATION() {
            return EXPLANATION;
        }

        @NotNull
        public final String getMESSAGE() {
            return MESSAGE;
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

