/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.visuallint.analyzers;

import android.widget.ScrollView;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.configurations.Configuration;
import com.android.tools.rendering.RenderResult;
import com.android.tools.visuallint.VisualLintAnalyzer;
import com.android.tools.visuallint.VisualLintErrorType;
import com.android.tools.visuallint.analyzers.BoundsAnalyzerKt;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0012H\u0002J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0012H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/visuallint/analyzers/BoundsAnalyzer;", "Lcom/android/tools/visuallint/VisualLintAnalyzer;", "<init>", "()V", "type", "Lcom/android/tools/visuallint/VisualLintErrorType;", "getType", "()Lcom/android/tools/visuallint/VisualLintErrorType;", "findIssues", "", "Lcom/android/tools/visuallint/VisualLintAnalyzer$VisualLintIssueContent;", "renderResult", "Lcom/android/tools/rendering/RenderResult;", "configuration", "Lcom/android/tools/configurations/Configuration;", "isOutOfBounds", "", "child", "Lcom/android/ide/common/rendering/api/ViewInfo;", "width", "", "height", "createIssueContent", "view", "isScrollingView", "intellij.android.visual-lint"})
@SourceDebugExtension(value={"SMAP\nBoundsAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoundsAnalyzer.kt\ncom/android/tools/visuallint/analyzers/BoundsAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,94:1\n827#2:95\n855#2,2:96\n1869#2,2:98\n12637#3,2:100\n*S KotlinDebug\n*F\n+ 1 BoundsAnalyzer.kt\ncom/android/tools/visuallint/analyzers/BoundsAnalyzer\n*L\n48#1:95\n48#1:96,2\n53#1:98,2\n91#1:100,2\n*E\n"})
public final class BoundsAnalyzer
extends VisualLintAnalyzer {
    @NotNull
    public static final BoundsAnalyzer INSTANCE = new BoundsAnalyzer();

    private BoundsAnalyzer() {
    }

    @Override
    @NotNull
    public VisualLintErrorType getType() {
        return VisualLintErrorType.BOUNDS;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<VisualLintAnalyzer.VisualLintIssueContent> findIssues(@NotNull RenderResult renderResult, @NotNull Configuration configuration) {
        ViewInfo it;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)renderResult, (String)"renderResult");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        List issues = new ArrayList();
        ImmutableList immutableList = renderResult.getRootViews();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"getRootViews(...)");
        Iterable $this$filterNot$iv = (Iterable)immutableList;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (ViewInfo)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (INSTANCE.isScrollingView(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection collection = (List)destination$iv$iv;
        ArrayDeque viewsToAnalyze = new ArrayDeque(collection);
        while (!((Collection)viewsToAnalyze).isEmpty()) {
            ViewInfo view = (ViewInfo)viewsToAnalyze.removeLast();
            int width = view.getRight() - view.getLeft();
            int height = view.getBottom() - view.getTop();
            List list = view.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ViewInfo)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (INSTANCE.isScrollingView(it)) continue;
                viewsToAnalyze.addLast((Object)it);
                if (!INSTANCE.isOutOfBounds(it, width, height)) continue;
                issues.add(INSTANCE.createIssueContent(it));
            }
        }
        return issues;
    }

    private final boolean isOutOfBounds(ViewInfo child, int width, int height) {
        return child.getTop() < 0 || child.getBottom() > height || child.getLeft() < 0 || child.getRight() > width;
    }

    private final VisualLintAnalyzer.VisualLintIssueContent createIssueContent(ViewInfo view) {
        String viewName = VisualLintAnalyzer.Companion.simpleName(view);
        String summary = VisualLintAnalyzer.Companion.nameWithId(view) + " is partially hidden in layout";
        Function1 provider = arg_0 -> BoundsAnalyzer.createIssueContent$lambda$0(viewName, arg_0);
        return new VisualLintAnalyzer.VisualLintIssueContent(view, summary, null, provider, 4, null);
    }

    private final boolean isScrollingView(ViewInfo view) {
        boolean bl;
        block2: {
            if (view.getViewObject() instanceof ScrollView) {
                return true;
            }
            Class<?>[] classArray = view.getViewObject().getClass().getInterfaces();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"getInterfaces(...)");
            Object[] $this$any$iv = classArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Class it = (Class)element$iv;
                boolean bl2 = false;
                if (!BoundsAnalyzerKt.access$getScrollViewInterfaces$p().contains(it.getName())) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    private static final HtmlBuilder createIssueContent$lambda$0(String $viewName, int count) {
        return new HtmlBuilder().add($viewName + " is partially hidden in layout because it is not contained within the bounds of its parent in " + VisualLintAnalyzer.Companion.previewConfigurations(count) + ".").newline().add("Fix this issue by adjusting the size or position of " + $viewName + ".");
    }
}

