/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface.layer;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.surface.SceneView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J.\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/uibuilder/surface/layer/BorderPainter;", "", "borderThickness", "", "colorInside", "Ljava/awt/Color;", "colorOutside", "useHighQuality", "", "<init>", "(ILjava/awt/Color;Ljava/awt/Color;Z)V", "getUseHighQuality", "()Z", "gradLeft", "Ljava/awt/GradientPaint;", "gradTop", "gradRight", "gradBottom", "gradCorner", "Ljava/awt/RadialGradientPaint;", "paint", "", "g2d", "Ljava/awt/Graphics2D;", "screenView", "Lcom/android/tools/idea/common/surface/SceneView;", "x", "y", "width", "height", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class BorderPainter {
    private final int borderThickness;
    private final boolean useHighQuality;
    @NotNull
    private final GradientPaint gradLeft;
    @NotNull
    private final GradientPaint gradTop;
    @NotNull
    private final GradientPaint gradRight;
    @NotNull
    private final GradientPaint gradBottom;
    @NotNull
    private final RadialGradientPaint gradCorner;
    public static final int $stable = 8;

    public BorderPainter(int borderThickness, @NotNull Color colorInside, @NotNull Color colorOutside, boolean useHighQuality) {
        Intrinsics.checkNotNullParameter((Object)colorInside, (String)"colorInside");
        Intrinsics.checkNotNullParameter((Object)colorOutside, (String)"colorOutside");
        this.borderThickness = borderThickness;
        this.useHighQuality = useHighQuality;
        this.gradLeft = new GradientPaint(0.0f, 0.0f, colorOutside, this.borderThickness, 0.0f, colorInside);
        this.gradTop = new GradientPaint(0.0f, 0.0f, colorOutside, 0.0f, this.borderThickness, colorInside);
        this.gradRight = new GradientPaint(0.0f, 0.0f, colorInside, this.borderThickness, 0.0f, colorOutside);
        this.gradBottom = new GradientPaint(0.0f, 0.0f, colorInside, 0.0f, this.borderThickness, colorOutside);
        Object[] objectArray = new float[]{0.0f, 1.0f};
        float[] fArray = objectArray;
        objectArray = new Color[2];
        objectArray[0] = (float)colorInside;
        objectArray[1] = (float)colorOutside;
        this.gradCorner = new RadialGradientPaint(this.borderThickness, (float)this.borderThickness, this.borderThickness, fArray, (Color[])objectArray);
    }

    public final boolean getUseHighQuality() {
        return this.useHighQuality;
    }

    public final void paint(@NotNull Graphics2D g2d, @NotNull SceneView screenView) {
        Intrinsics.checkNotNullParameter((Object)g2d, (String)"g2d");
        Intrinsics.checkNotNullParameter((Object)screenView, (String)"screenView");
        Dimension size = screenView.getScaledContentSize();
        this.paint(g2d, screenView.getX(), screenView.getY(), size.width, size.height);
    }

    public final void paint(@NotNull Graphics2D g2d, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)g2d, (String)"g2d");
        RenderingHints hints = g2d.getRenderingHints();
        AffineTransform tx = g2d.getTransform();
        Paint paint = g2d.getPaint();
        g2d.translate(x - this.borderThickness, y);
        g2d.scale(1.0, (double)height / (double)this.borderThickness);
        g2d.setPaint(this.gradLeft);
        g2d.fillRect(0, 0, this.borderThickness, this.borderThickness);
        g2d.translate(width + this.borderThickness, 0);
        g2d.setPaint(this.gradRight);
        g2d.fillRect(0, 0, this.borderThickness, this.borderThickness);
        g2d.translate(-width, 0);
        g2d.scale(1.0, (double)this.borderThickness / (double)height);
        g2d.translate(0, -this.borderThickness);
        g2d.scale((double)width / (double)this.borderThickness, 1.0);
        g2d.setPaint(this.gradTop);
        g2d.fillRect(0, 0, this.borderThickness, this.borderThickness);
        g2d.translate(0, height + this.borderThickness);
        g2d.setPaint(this.gradBottom);
        g2d.fillRect(0, 0, this.borderThickness, this.borderThickness);
        g2d.setTransform(tx);
        if (this.useHighQuality) {
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g2d.setPaint(this.gradCorner);
        g2d.translate(x - this.borderThickness, y - this.borderThickness);
        g2d.fillArc(0, 0, this.borderThickness * 2, this.borderThickness * 2, 90, 90);
        g2d.translate(width, 0);
        g2d.fillArc(0, 0, this.borderThickness * 2, this.borderThickness * 2, 0, 90);
        g2d.translate(0, height);
        g2d.fillArc(0, 0, this.borderThickness * 2, this.borderThickness * 2, 270, 90);
        g2d.translate(-width, 0);
        g2d.fillArc(0, 0, this.borderThickness * 2, this.borderThickness * 2, 180, 90);
        g2d.setTransform(tx);
        g2d.setRenderingHints(hints);
        g2d.setPaint(paint);
    }
}

