/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface.interaction;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.Pannable;
import com.android.tools.adtui.common.AdtUiCursorType;
import com.android.tools.adtui.common.AdtUiCursorsProvider;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionEvent;
import com.android.tools.idea.common.surface.InteractionInputEvent;
import com.android.tools.idea.common.surface.InteractionNonInputEvent;
import com.android.tools.idea.common.surface.MouseDraggedEvent;
import com.android.tools.idea.common.surface.MouseMovedEvent;
import com.android.tools.idea.common.surface.MousePressedEvent;
import com.android.tools.idea.common.surface.MouseReleasedEvent;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\f\"\b\b\u0000\u0010\u0010*\u00020\u00112\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u0014\u001a\u00020\f\"\b\b\u0000\u0010\u0010*\u00020\u00112\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/uibuilder/surface/interaction/PanInteraction;", "Lcom/android/tools/idea/common/surface/Interaction;", "pannable", "Lcom/android/tools/adtui/Pannable;", "<init>", "(Lcom/android/tools/adtui/Pannable;)V", "isGrabbing", "", "pannableOriginalPosition", "Ljava/awt/Point;", "startPoint", "begin", "", "event", "Lcom/android/tools/idea/common/surface/InteractionEvent;", "setupOriginalPoint", "T", "Ljava/awt/event/MouseEvent;", "Lcom/android/tools/idea/common/surface/InteractionInputEvent;", "update", "updateMouseScrollEvent", "commit", "cancel", "getCursor", "Ljava/awt/Cursor;", "intellij.android.designer"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPanInteraction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PanInteraction.kt\ncom/android/tools/idea/uibuilder/surface/interaction/PanInteraction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
public final class PanInteraction
implements Interaction {
    @NotNull
    private final Pannable pannable;
    private boolean isGrabbing;
    @Nullable
    private Point pannableOriginalPosition;
    @NotNull
    private final Point startPoint;
    public static final int $stable = 8;

    public PanInteraction(@NotNull Pannable pannable2) {
        Intrinsics.checkNotNullParameter((Object)pannable2, (String)"pannable");
        this.pannable = pannable2;
        this.pannableOriginalPosition = new Point();
        this.startPoint = new Point();
    }

    @Override
    public void begin(@NotNull InteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof MousePressedEvent) {
            this.setupOriginalPoint((InteractionInputEvent)event);
            this.isGrabbing = (event.getInfo().getModifiersEx() & 0xC00) > 0;
        }
    }

    private final <T extends MouseEvent> void setupOriginalPoint(InteractionInputEvent<? extends T> event) {
        MouseEvent mouseEvent = (MouseEvent)event.getEventObject();
        this.pannableOriginalPosition = this.pannable.getScrollPosition().getLocation();
        this.startPoint.setLocation(mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen());
    }

    @Override
    public void update(@NotNull InteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        InteractionEvent interactionEvent = event;
        if (interactionEvent instanceof MousePressedEvent) {
            if ((event.getInfo().getModifiersEx() & 0xC00) > 0) {
                this.setupOriginalPoint((InteractionInputEvent)event);
                this.isGrabbing = true;
            }
        } else if (interactionEvent instanceof MouseMovedEvent) {
            this.updateMouseScrollEvent((InteractionInputEvent)event);
        } else if (interactionEvent instanceof MouseDraggedEvent) {
            this.updateMouseScrollEvent((InteractionInputEvent)event);
        } else if (interactionEvent instanceof MouseReleasedEvent) {
            this.updateMouseScrollEvent((InteractionInputEvent)event);
        } else if (!(interactionEvent instanceof InteractionInputEvent) && !(interactionEvent instanceof InteractionNonInputEvent)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final <T extends MouseEvent> void updateMouseScrollEvent(InteractionInputEvent<? extends T> event) {
        MouseEvent mouseEvent = (MouseEvent)event.getEventObject();
        if ((mouseEvent.getModifiersEx() & 0xC00) > 0) {
            this.isGrabbing = true;
            Point point = this.pannableOriginalPosition;
            if (point == null) {
                return;
            }
            Point it = point;
            boolean bl = false;
            Point newPosition = new Point(it);
            int screenX = mouseEvent.getXOnScreen();
            int screenY = mouseEvent.getYOnScreen();
            newPosition.translate(this.startPoint.x - screenX, this.startPoint.y - screenY);
            this.pannable.setScrollPosition(newPosition);
        } else {
            this.isGrabbing = false;
        }
    }

    @Override
    public void commit(@NotNull InteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    @Override
    public void cancel(@NotNull InteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    @Override
    @Nullable
    public Cursor getCursor() {
        return AdtUiCursorsProvider.Companion.getInstance().getCursor(this.isGrabbing ? AdtUiCursorType.GRABBING : AdtUiCursorType.GRAB);
    }
}

