/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scout;

import com.android.tools.idea.uibuilder.scout.Direction;
import com.android.tools.idea.uibuilder.scout.ScoutChains;
import com.android.tools.idea.uibuilder.scout.ScoutWidget;
import com.android.tools.idea.uibuilder.scout.Utils;
import java.util.Arrays;

public class ScoutProbabilities {
    private static final boolean DEBUG = false;
    private static final float BASELINE_ERROR = 4.0f;
    private static final int RESULT_PROBABILITY = 0;
    private static final int RESULT_MARGIN = 1;
    private static final boolean SUPPORT_CENTER_TO_NON_ROOT = true;
    private static final int NEGATIVE_GAP_FLAG = -3;
    private static final int CONSTRAINT_FAILED_FLAG = -2;
    private static final float CENTER_ERROR = 2.0f;
    private static final float SLOPE_CENTER_CONNECTION = 20.0f;
    private static final int MAX_DIST_FOR_CENTER_OVERLAP = 40;
    private static final int ROOT_MARGIN_DISCOUNT = 16;
    private static final int MAX_ROOT_OVERHANG = 10;
    private static final boolean SKIP_SPARSE_COLUMNS = true;
    float[][][] mProbability;
    float[][][] mMargin;
    float[][][][] mBinaryBias;
    float[][][][] mBinaryProbability;
    int len;

    public void computeConstraints(ScoutWidget[] list) {
        if (list.length < 2) {
            throw new IllegalArgumentException("list must contain more than 1 widget");
        }
        for (int i = 1; i < list.length; ++i) {
            if (list[i].getParent() == list[0]) continue;
            for (int j = 0; j < list.length; ++j) {
                ScoutWidget scoutWidget = list[j];
                System.out.println("[" + j + "]" + String.valueOf(scoutWidget));
            }
            throw new IllegalArgumentException("list[0] must be parent of children");
        }
        this.len = list.length;
        this.mProbability = new float[this.len][][];
        this.mMargin = new float[this.len][][];
        float[] result = new float[2];
        for (int i = 1; i < this.len; ++i) {
            Direction[] all = Direction.getAllDirections();
            if (list[i].isGuideline()) continue;
            this.mProbability[i] = new float[all.length][];
            this.mMargin[i] = new float[all.length][];
            for (int dir = 0; dir < all.length; ++dir) {
                Direction direction = Direction.get(dir);
                int connectTypes = direction.connectTypes();
                this.mProbability[i][dir] = new float[this.len * connectTypes];
                this.mMargin[i][dir] = new float[this.len * connectTypes];
                for (int candidate = 0; candidate < this.mMargin[i][dir].length; ++candidate) {
                    int widgetNumber = candidate / connectTypes;
                    int opposite = candidate % connectTypes;
                    Direction connectTo = opposite == 0 ? direction : direction.getOpposite();
                    ScoutProbabilities.estimateProbability(list[i], direction, list[widgetNumber], connectTo, result);
                    this.mProbability[i][dir][candidate] = result[0];
                    this.mMargin[i][dir][candidate] = result[1];
                }
            }
        }
        this.mBinaryProbability = new float[this.len][2][this.len * 2][this.len * 2];
        this.mBinaryBias = new float[this.len][2][this.len * 2][this.len * 2];
        Direction[][] directions = new Direction[][]{{Direction.TOP, Direction.BOTTOM}, {Direction.LEFT, Direction.RIGHT}};
        for (int i = 1; i < this.len; ++i) {
            for (int horizontal = 0; horizontal < 2; ++horizontal) {
                Direction[] sides = directions[horizontal];
                for (int candidate1 = 0; candidate1 < this.len * 2; ++candidate1) {
                    for (int candidate2 = 0; candidate2 < this.len * 2; ++candidate2) {
                        int widget1Number = candidate1 / 2;
                        int widget2Number = candidate2 / 2;
                        Direction widget1Side = sides[candidate1 & 1];
                        Direction widget2Side = sides[candidate2 & 1];
                        ScoutProbabilities.estimateBinaryProbability(list[i], horizontal, list[widget1Number], widget1Side, list[widget2Number], widget2Side, result);
                        this.mBinaryProbability[i][horizontal][candidate1][candidate2] = result[0];
                        this.mBinaryBias[i][horizontal][candidate1][candidate2] = result[1];
                    }
                }
            }
        }
    }

    public void applyConstraints(ScoutWidget[] list) {
        ScoutChains.pick(list);
        this.pickCenterOverlap(list);
        this.pickBaseLineConnections(list);
        this.pickCenteredConnections(list, true);
        this.pickMarginConnections(list, 10);
        this.pickCenteredConnections(list, false);
        this.pickMarginConnections(list, 100);
    }

    private void pickCenterOverlap(ScoutWidget[] list) {
        for (int i = 0; i < list.length; ++i) {
            ScoutWidget scoutWidget = list[i];
            float centerX = scoutWidget.getX() + scoutWidget.getWidth() / 2.0f;
            float centerY = scoutWidget.getY() + scoutWidget.getHeight() / 2.0f;
            for (int j = 0; j < list.length; ++j) {
                if (i == j) continue;
                ScoutWidget widget = list[j];
                if (scoutWidget.isGuideline() || !widget.isGuideline() && ScoutWidget.distance(scoutWidget, widget) > 40.0f) continue;
                if (!widget.isGuideline() || widget.isVerticalGuideline()) {
                    if (Math.abs(widget.getX() - centerX) < 2.0f) {
                        scoutWidget.setEdgeCentered(1, widget, Direction.LEFT);
                    }
                    if (Math.abs(widget.getX() + widget.getWidth() - centerX) < 2.0f) {
                        scoutWidget.setEdgeCentered(1, widget, Direction.RIGHT);
                    }
                }
                if (widget.isGuideline() && !widget.isHorizontalGuideline()) continue;
                if (Math.abs(widget.getY() - centerY) < 2.0f) {
                    scoutWidget.setEdgeCentered(0, widget, Direction.TOP);
                }
                if (!(Math.abs(widget.getY() + widget.getHeight() - centerY) < 2.0f)) continue;
                scoutWidget.setEdgeCentered(0, widget, Direction.BOTTOM);
            }
        }
    }

    private void pickBaseLineConnections(ScoutWidget[] list) {
        int baseline = Direction.BASELINE.getDirection();
        int north = Direction.TOP.getDirection();
        int south = Direction.BOTTOM.getDirection();
        for (int i = 1; i < this.len; ++i) {
            float[][] widgetProbability = this.mProbability[i];
            if (widgetProbability == null || widgetProbability[baseline] == null) continue;
            float maxNorth = widgetProbability[north][Utils.max(widgetProbability[north])];
            float maxSouth = widgetProbability[south][Utils.max(widgetProbability[south])];
            int maxIndex = Utils.max(widgetProbability[baseline]);
            float maxBaseline = widgetProbability[baseline][maxIndex];
            if (maxBaseline < maxNorth || maxBaseline < maxSouth || !list[i].setConstraint(baseline, list[maxIndex], baseline, 0.0f)) continue;
            Utils.zero(this.mBinaryProbability[i][0]);
            Arrays.fill(widgetProbability[baseline], 0.0f);
            widgetProbability[north] = null;
            Arrays.fill(widgetProbability[south], 0.0f);
        }
    }

    private void pickCenteredConnections(ScoutWidget[] list, boolean checkResizeable) {
        Direction[][] side = new Direction[][]{{Direction.TOP, Direction.BOTTOM}, {Direction.LEFT, Direction.RIGHT}};
        int[] dualIndex = new int[2];
        for (int i = 1; i < this.len; ++i) {
            float[][][] widgetBinaryProbability = this.mBinaryProbability[i];
            float[][][] widgetBinaryBias = this.mBinaryBias[i];
            for (int horizontal = 0; horizontal < widgetBinaryProbability.length; ++horizontal) {
                float[][] pmatrix = widgetBinaryProbability[horizontal];
                float[][] bias = widgetBinaryBias[horizontal];
                if (pmatrix == null) continue;
                boolean worked = false;
                while (!worked) {
                    Utils.max(pmatrix, dualIndex);
                    int max1 = dualIndex[0];
                    int max2 = dualIndex[1];
                    int wNo1 = max1 / 2;
                    int wNo2 = max2 / 2;
                    Direction widget1Side = side[horizontal][max1 & 1];
                    Direction widget2Side = side[horizontal][max2 & 1];
                    float centerProbability = pmatrix[max1][max2];
                    worked = true;
                    if (!((double)centerProbability > 0.9) || checkResizeable && !list[i].isCandidateResizable(horizontal)) continue;
                    worked = list[i].setCentered(horizontal * 2, list[wNo1], list[wNo2], widget1Side, widget2Side, bias[max1][max2]);
                    if (worked) {
                        this.mProbability[i][horizontal * 2] = null;
                        this.mProbability[i][horizontal * 2 + 1] = null;
                        continue;
                    }
                    pmatrix[max1][max2] = 0.0f;
                }
            }
        }
    }

    private void pickMarginConnections(ScoutWidget[] list, int maxMarginPercent) {
        int baseline = Direction.BASELINE.getDirection();
        int north = Direction.TOP.getDirection();
        int south = Direction.BOTTOM.getDirection();
        int east = Direction.RIGHT.getDirection();
        int width = list[0].getWidthInt();
        int height = list[0].getHeightInt();
        int maxWidthMargin = width * maxMarginPercent / 100;
        int maxHeightMargin = height * maxMarginPercent / 100;
        int[] maxMargin = new int[]{maxHeightMargin, maxWidthMargin};
        int west = Direction.LEFT.getDirection();
        int[][] dirTypes = new int[][]{{north, south}, {west, east}};
        for (int i = this.len - 1; i > 0; --i) {
            float[][] widgetProbability = this.mProbability[i];
            for (int horizontal = 0; horizontal < 2; ++horizontal) {
                int[] dirs = dirTypes[horizontal];
                boolean found = false;
                while (!found) {
                    int cDir;
                    int m;
                    found = true;
                    int setlen = dirs.length;
                    int dir = dirs[0];
                    if (widgetProbability == null || widgetProbability[dir] == null) continue;
                    int maxIndex = 0;
                    int maxDirection = 0;
                    float maxValue = 0.0f;
                    for (int j = 0; j < setlen; ++j) {
                        int rowMaxIndex = Utils.max(widgetProbability[dirs[j]]);
                        if (!(maxValue < widgetProbability[dirs[j]][rowMaxIndex])) continue;
                        maxDirection = dirs[j];
                        maxIndex = rowMaxIndex;
                        maxValue = widgetProbability[dirs[j]][rowMaxIndex];
                    }
                    if (widgetProbability[maxDirection] == null) {
                        System.out.println(String.valueOf(list[i]) + " " + maxDirection);
                        continue;
                    }
                    if (maxDirection == baseline) {
                        m = maxIndex;
                        cDir = baseline;
                    } else {
                        m = maxIndex / 2;
                        cDir = maxDirection;
                        if (maxIndex % 2 == 1) {
                            cDir ^= 1;
                        }
                    }
                    if (this.mMargin[i][maxDirection][maxIndex] > (float)maxMargin[horizontal]) continue;
                    String s = String.valueOf(list[i]) + "(" + Direction.toString(maxDirection) + ") -> " + String.valueOf(list[m]) + " " + Direction.toString(cDir);
                    if (!list[i].setConstraint(maxDirection, list[m], cDir, this.mMargin[i][maxDirection][maxIndex])) {
                        if (!(widgetProbability[maxDirection][maxIndex] >= 0.0f)) continue;
                        widgetProbability[maxDirection][maxIndex] = -2.0f;
                        found = false;
                        continue;
                    }
                    this.mBinaryProbability[i][horizontal] = null;
                }
            }
        }
    }

    private static void estimateProbability(ScoutWidget from, Direction fromDir, ScoutWidget to, Direction toDir, float[] result) {
        result[0] = 0.0f;
        result[1] = 0.0f;
        if (from == to) {
            return;
        }
        if (from.isGuideline()) {
            return;
        }
        if (to.isGuideline()) {
            if ((toDir == Direction.TOP || toDir == Direction.BOTTOM) && to.isVerticalGuideline()) {
                return;
            }
            if ((toDir == Direction.RIGHT || toDir == Direction.LEFT) && to.isHorizontalGuideline()) {
                return;
            }
        }
        if ((toDir == Direction.TOP || toDir == Direction.BOTTOM) && from.hasBaseline() && from.hasConnection(Direction.BASELINE)) {
            return;
        }
        if (!(fromDir != Direction.BASELINE || from.hasBaseline() && to.hasBaseline())) {
            return;
        }
        float fromLocation = from.getLocation(fromDir);
        float toLocation = to.getLocation(toDir);
        float positionDiff = fromDir.reverse() ? fromLocation - toLocation : toLocation - fromLocation;
        float distance = 2.0f * ScoutWidget.distance(from, to);
        if (to.isRoot()) {
            distance = Math.abs(distance - 16.0f);
        }
        float probability = 1.0f / (1.0f + distance * distance + positionDiff * positionDiff);
        if (fromDir == Direction.BASELINE) {
            if (Math.abs(positionDiff) > 4.0f) {
                return;
            }
            probability *= 2.0f;
        }
        if (to.isRoot()) {
            probability *= 2.0f;
        }
        result[0] = positionDiff >= 0.0f ? probability : -3.0f;
        result[1] = positionDiff;
    }

    private static void estimateBinaryProbability(ScoutWidget from, int orientation, ScoutWidget to1, Direction toDir1, ScoutWidget to2, Direction toDir2, float[] result) {
        result[0] = 0.0f;
        result[1] = 0.0f;
        if (from == to1 || from == to2) {
            return;
        }
        if (from.isGuideline()) {
            return;
        }
        if (orientation == 0 && from.hasBaseline() && from.hasConnection(Direction.BASELINE)) {
            return;
        }
        float scale = 0.5f * (orientation == 0 ? from.getParent().getHeight() : from.getParent().getWidth());
        Direction fromLeft = Direction.getDirections(orientation)[0];
        Direction fromRight = Direction.getDirections(orientation)[1];
        float location1 = from.getLocation(fromLeft);
        float location2 = from.getLocation(fromRight);
        float toLoc1 = to1.getLocation(toDir1);
        float toLoc2 = to2.getLocation(toDir2);
        float positionDiff1 = location1 - toLoc1;
        float positionDiff2 = toLoc2 - location2;
        if (positionDiff1 < 0.0f || positionDiff2 < 0.0f) {
            boolean badCandidate = true;
            if (positionDiff2 < 0.0f && to2.isRoot() && positionDiff2 > -10.0f) {
                badCandidate = false;
                positionDiff2 = 0.0f;
            }
            if (positionDiff1 < 0.0f && to1.isRoot() && positionDiff2 > -10.0f) {
                badCandidate = false;
                positionDiff2 = 0.0f;
            }
            if (badCandidate) {
                result[0] = -3.0f;
                return;
            }
        }
        float distance1 = ScoutWidget.distance(from, to1) / scale;
        float distance2 = ScoutWidget.distance(from, to2) / scale;
        float diff = Math.abs(positionDiff1 - positionDiff2);
        float probability = diff < 20.0f ? 1 : 0;
        probability /= 1.0f + distance1 + distance2;
        probability += 1.0f / (1.0f + Math.abs(positionDiff1 - positionDiff2));
        result[0] = probability *= to1.isRoot() && to2.isRoot() ? 2.0f : 1.0f;
        result[1] = Math.min(positionDiff1, positionDiff2);
    }

    public void printTable(ScoutWidget[] list) {
        this.printCenterTable(list);
        this.printBaseTable(list);
    }

    public void printCenterTable(ScoutWidget[] list) {
        System.out.println("----------------- BASELINE TABLE --------------------");
        System.out.print("  ");
        for (int i = 0; i < this.len; ++i) {
            Object dbg = "[" + i + "] " + String.valueOf(list[i]) + "-------------------------";
            dbg = ((String)dbg).substring(0, 20);
            System.out.print((String)dbg + (i == this.len - 1 ? "\n" : ""));
        }
        Object str = "[";
        for (int con = 0; con < this.len * 2; ++con) {
            int opposite = con & 1;
            str = (String)str + (con / 2 + (opposite == 0 ? "->" : "<-") + "           ").substring(0, 10);
        }
        System.out.println("  " + (String)str);
        for (int i = 1; i < this.len; ++i) {
            for (int dir = 0; dir < this.mBinaryProbability[i].length; ++dir) {
                Object tab2 = "";
                for (int k = 0; k < this.mBinaryProbability[i][dir].length; ++k) {
                    tab2 = (String)tab2 + Utils.toS(this.mBinaryProbability[i][dir][k]) + "\n  ";
                }
                System.out.println(Direction.toString(dir) + " " + (String)tab2);
            }
        }
    }

    public void printBaseTable(ScoutWidget[] list) {
        System.out.println("----------------- CENTER TABLE --------------------");
        int SIZE = 10;
        String padd = new String(new char[10]).replace('\u0000', ' ');
        System.out.print(" ");
        for (int i = 0; i < this.len; ++i) {
            Object dbg = "[" + i + "] " + String.valueOf(list[i]) + "-------------------------";
            dbg = i == 0 ? padd + ((String)dbg).substring(0, 20) : ((String)dbg).substring(0, 20);
            System.out.print((String)dbg + (i == this.len - 1 ? "\n" : ""));
        }
        Object str = "[";
        for (int con = 0; con < this.len * 2; ++con) {
            int opposite = con & 1;
            str = (String)str + (con / 2 + (opposite == 0 ? "->" : "<-") + "           ").substring(0, 10);
        }
        String header = ("Connection " + padd).substring(0, 10);
        System.out.println(header + " " + (String)str);
        for (int i = 1; i < this.len; ++i) {
            if (this.mProbability[i] == null) continue;
            for (int dir = 0; dir < this.mProbability[i].length; ++dir) {
                System.out.println(Utils.leftTrim(padd + i + " " + Direction.toString(dir), 10) + " " + Utils.toS(this.mProbability[i][dir]));
                System.out.println(padd + " " + Utils.toS(this.mMargin[i][dir]));
            }
        }
    }
}

