/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.decorator;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.decorator.SceneDecorator;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawComponentBackground;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.handlers.linear.LinearLayoutHandler;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0002\f\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/uibuilder/scene/decorator/LinearLayoutDecorator;", "Lcom/android/tools/idea/common/scene/decorator/SceneDecorator;", "<init>", "()V", "addBackground", "", "list", "Lcom/android/tools/idea/common/scene/draw/DisplayList;", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "component", "Lcom/android/tools/idea/common/scene/SceneComponent;", "DrawLinearLayout", "Companion", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class LinearLayoutDecorator
extends SceneDecorator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable = 8;
    private static final float GRADIENT_SIZE = 12.0f;

    @Override
    protected void addBackground(@NotNull DisplayList list, @NotNull SceneContext sceneContext, @NotNull SceneComponent component) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)sceneContext, (String)"sceneContext");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Rectangle rect = new Rectangle();
        component.fillDrawRect(0L, rect);
        int l = sceneContext.getSwingXDip(rect.x);
        int t = sceneContext.getSwingYDip(rect.y);
        int w = sceneContext.getSwingDimensionDip(rect.width);
        int h = sceneContext.getSwingDimensionDip(rect.height);
        boolean vertical = false;
        Project project = sceneContext.getSurface();
        if (project != null && (project = project.getProject()) != null) {
            Project it = project;
            boolean bl = false;
            ViewHandler viewHandler = ViewHandlerManager.get(it).getHandler("LinearLayout", LinearLayoutDecorator::addBackground$lambda$0$0);
            Intrinsics.checkNotNull((Object)viewHandler, (String)"null cannot be cast to non-null type com.android.tools.idea.uibuilder.handlers.linear.LinearLayoutHandler");
            LinearLayoutHandler handler = (LinearLayoutHandler)viewHandler;
            vertical = handler.isVertical(component.getNlComponent());
        }
        ColorSet colorSet = sceneContext.getColorSet();
        Intrinsics.checkNotNullExpressionValue((Object)colorSet, (String)"getColorSet(...)");
        ColorSet colorSet2 = colorSet;
        Color solid = colorSet2.getFrames();
        int baseRgb = solid.getRGB();
        int darkRgb = solid.darker().darker().getRGB();
        Color transparent1 = new Color(darkRgb & 0xFFFFFF | 0x8F000000, true);
        Color transparent2 = new Color(baseRgb & 0xFFFFFF, true);
        GradientPaint paint = vertical ? new GradientPaint(0.0f, 0.0f, transparent1, 0.0f, GRADIENT_SIZE, transparent2) : new GradientPaint(0.0f, 0.0f, transparent1, GRADIENT_SIZE, 0.0f, transparent2);
        list.add(new DrawLinearLayout(l, t, w, h, paint, vertical, 0, 64, null));
        if (component.getDrawState() == SceneComponent.DrawState.HOVER) {
            super.addBackground(list, sceneContext, component);
        }
    }

    private static final void addBackground$lambda$0$0() {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/uibuilder/scene/decorator/LinearLayoutDecorator$Companion;", "", "<init>", "()V", "GRADIENT_SIZE", "", "getGRADIENT_SIZE", "()F", "intellij.android.designer"})
    public static final class Companion {
        private Companion() {
        }

        public final float getGRADIENT_SIZE() {
            return GRADIENT_SIZE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001BI\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0004\b\f\u0010\rB\u0011\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\f\u0010\u0010J\u0018\u0010\u0007\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/uibuilder/scene/decorator/LinearLayoutDecorator$DrawLinearLayout;", "Lcom/android/tools/idea/common/scene/draw/DrawComponentBackground;", "x", "", "y", "width", "height", "paint", "Ljava/awt/Paint;", "vertical", "", "mode", "<init>", "(IIIILjava/awt/Paint;ZI)V", "s", "", "(Ljava/lang/String;)V", "getPaint$intellij_android_designer", "()Ljava/awt/Paint;", "getVertical$intellij_android_designer", "()Z", "", "g", "Ljava/awt/Graphics2D;", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "intellij.android.designer"})
    @StabilityInferred(parameters=0)
    public static final class DrawLinearLayout
    extends DrawComponentBackground {
        @Nullable
        private final Paint paint;
        private final boolean vertical;
        public static final int $stable = 8;

        @Nullable
        public final Paint getPaint$intellij_android_designer() {
            return this.paint;
        }

        public final boolean getVertical$intellij_android_designer() {
            return this.vertical;
        }

        public DrawLinearLayout(int x, int y, int width, int height, @Nullable Paint paint, boolean vertical, int mode) {
            super(x, y, width, height, mode);
            this.paint = paint;
            this.vertical = vertical;
        }

        public /* synthetic */ DrawLinearLayout(int n, int n2, int n3, int n4, Paint paint, boolean bl, int n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n6 & 0x10) != 0) {
                paint = null;
            }
            if ((n6 & 0x20) != 0) {
                bl = false;
            }
            if ((n6 & 0x40) != 0) {
                n5 = 1;
            }
            this(n, n2, n3, n4, paint, bl, n5);
        }

        public DrawLinearLayout(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            super(s);
            this.paint = null;
            this.vertical = false;
        }

        @Override
        public void paint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)sceneContext, (String)"sceneContext");
            AffineTransform transform = g.getTransform();
            Paint savedPaint = g.getPaint();
            Paint paint = this.paint;
            if (paint == null) {
                paint = savedPaint;
            }
            g.setPaint(paint);
            g.translate(this.x, this.y);
            if (this.vertical) {
                g.fillRect(0, 0, this.width, (int)Companion.getGRADIENT_SIZE());
                g.rotate(Math.PI, (double)this.width / 2.0, (double)this.height / 2.0);
                g.fillRect(0, 0, this.width, (int)Companion.getGRADIENT_SIZE());
            } else {
                g.fillRect(0, 0, (int)Companion.getGRADIENT_SIZE(), this.height);
                g.rotate(Math.PI, (double)this.width / 2.0, (double)this.height / 2.0);
                g.fillRect(0, 0, (int)Companion.getGRADIENT_SIZE(), this.height);
            }
            g.setPaint(savedPaint);
            g.setTransform(transform);
        }
    }
}

