/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.support;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.tools.dom.attrs.AttributeDefinition;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.property.panel.api.HelpSupport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.html.HtmlEscapers;
import com.intellij.codeInsight.documentation.actions.ShowQuickDocInfoAction;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\rH\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/uibuilder/property/support/HelpActions;", "", "<init>", "()V", "help", "Lcom/intellij/codeInsight/documentation/actions/ShowQuickDocInfoAction;", "getHelp", "()Lcom/intellij/codeInsight/documentation/actions/ShowQuickDocInfoAction;", "secondaryHelp", "Lcom/intellij/openapi/actionSystem/AnAction;", "getSecondaryHelp", "()Lcom/intellij/openapi/actionSystem/AnAction;", "toHelpUrl", "", "componentName", "property", "Lcom/android/tools/idea/uibuilder/property/NlPropertyItem;", "getHelpUrl", "getAttributeAnchor", "createHelpText", "allowEmptyDescription", "", "findNamespacePrefix", "lineEndingRegex", "Lkotlin/text/Regex;", "filterRawAttributeComment", "comment", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class HelpActions {
    @NotNull
    public static final HelpActions INSTANCE = new HelpActions();
    @NotNull
    private static final ShowQuickDocInfoAction help = new ShowQuickDocInfoAction();
    @NotNull
    private static final AnAction secondaryHelp = new AnAction(){

        public void actionPerformed(AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            NlPropertyItem property = (NlPropertyItem)event.getDataContext().getData(HelpSupport.Companion.getPROPERTY_ITEM());
            Object object = property;
            if (object == null || (object = ((NlPropertyItem)object).getComponentName()) == null) {
                return;
            }
            Object componentName = object;
            String string = HelpActions.INSTANCE.toHelpUrl((String)componentName, property);
            if (string == null) {
                return;
            }
            String url = string;
            BrowserUtil.browse((String)url);
        }
    };
    @NotNull
    private static final Regex lineEndingRegex = new Regex("\n *");
    public static final int $stable = 8;

    private HelpActions() {
    }

    @NotNull
    public final ShowQuickDocInfoAction getHelp() {
        return help;
    }

    @NotNull
    public final AnAction getSecondaryHelp() {
        return secondaryHelp;
    }

    @VisibleForTesting
    @Nullable
    public final String toHelpUrl(@NotNull String componentName, @NotNull NlPropertyItem property) {
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        String string = this.getAttributeAnchor(componentName, property);
        if (string == null) {
            return null;
        }
        String anchor = string;
        return this.getHelpUrl(componentName, property) + anchor;
    }

    private final String getHelpUrl(String componentName, NlPropertyItem property) {
        String dotLayoutParams = Intrinsics.areEqual((Object)componentName, (Object)"android.view.ViewGroup") && StringsKt.startsWith$default((String)property.getName(), (String)"layout_margin", (boolean)false, (int)2, null) ? ".MarginLayoutParams" : (StringsKt.startsWith$default((String)property.getName(), (String)"layout_", (boolean)false, (int)2, null) ? ".LayoutParams" : "");
        return "https://developer.android.com/reference/" + StringsKt.replace$default((String)componentName, (char)'.', (char)'/', (boolean)false, (int)4, null) + dotLayoutParams + ".html";
    }

    private final String getAttributeAnchor(String componentName, NlPropertyItem property) {
        return StringsKt.startsWith$default((String)componentName, (String)"android.view.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)componentName, (String)"android.widget.", (boolean)false, (int)2, null) ? "#attr_android:" + property.getName() : (StringsKt.startsWith$default((String)componentName, (String)"android.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)componentName, (String)"androidx.", (boolean)false, (int)2, null) ? "" : null);
    }

    @NotNull
    public final String createHelpText(@NotNull NlPropertyItem property, boolean allowEmptyDescription) {
        StringBuilder sb;
        block8: {
            String description;
            block10: {
                block9: {
                    Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                    AttributeDefinition definition = property.getDefinition();
                    Object object = definition;
                    if (object == null || (object = object.getDescription(null)) == null) {
                        object = "";
                    }
                    if (((CharSequence)(description = this.filterRawAttributeComment((String)object))).length() == 0 && !allowEmptyDescription) {
                        return "";
                    }
                    sb = new StringBuilder(100).append("<html><body><b>").append(this.findNamespacePrefix(property)).append(property.getName()).append("</b><br/>").append("<br/>");
                    if (definition == null) break block8;
                    Set set = definition.getFormats();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFormats(...)");
                    if (!((Collection)set).isEmpty()) {
                        sb.append("Formats: ");
                        Set set2 = definition.getFormats();
                        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getFormats(...)");
                        Iterable iterable = set2;
                        Intrinsics.checkNotNull((Object)sb);
                        CollectionsKt.joinTo$default((Iterable)iterable, (Appendable)sb, null, null, null, (int)0, null, HelpActions::createHelpText$lambda$0, (int)62, null);
                        sb.append("<br/>");
                    }
                    String[] stringArray = definition.getValues();
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getValues(...)");
                    if (!(((Object[])stringArray).length == 0)) {
                        sb.append("Values: ");
                        String[] stringArray2 = definition.getValues();
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"getValues(...)");
                        Object[] objectArray = stringArray2;
                        Intrinsics.checkNotNull((Object)sb);
                        ArraysKt.joinTo$default((Object[])objectArray, (Appendable)sb, null, null, null, (int)0, null, null, (int)126, null);
                        sb.append("<br/>");
                    }
                    Set set3 = definition.getFormats();
                    Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"getFormats(...)");
                    if (!((Collection)set3).isEmpty()) break block9;
                    String[] stringArray3 = definition.getValues();
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"getValues(...)");
                    if (!(!(((Object[])stringArray3).length == 0))) break block10;
                }
                sb.append("<br/>");
            }
            if (((CharSequence)description).length() > 0) {
                sb.append(description);
            }
        }
        sb.append("</body></html>");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String findNamespacePrefix(NlPropertyItem property) {
        ResourceNamespace.Resolver resolver = property.getNamespaceResolver();
        if (Intrinsics.areEqual((Object)resolver, (Object)ResourceNamespace.Resolver.TOOLS_ONLY) && Intrinsics.areEqual((Object)property.getNamespace(), (Object)"http://schemas.android.com/apk/res/android")) {
            return "android:";
        }
        String string = resolver.uriToPrefix(property.getNamespace());
        if (string == null) {
            return "";
        }
        String prefix = string;
        return prefix + ":";
    }

    @VisibleForTesting
    @NotNull
    public final String filterRawAttributeComment(@NotNull String comment) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        CharSequence charSequence = comment;
        Regex regex = lineEndingRegex;
        String string = " ";
        String string2 = HtmlEscapers.htmlEscaper().escape(regex.replace(charSequence, string));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"escape(...)");
        return string2;
    }

    private static final CharSequence createHelpText$lambda$0(AttributeFormat it) {
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }
}

