/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.tools.idea.uibuilder.palette.CategoryListModel;
import com.android.tools.idea.uibuilder.palette.ListWithMargin;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class CategoryList
extends ListWithMargin<Palette.Group> {
    private static final String MATCH_COUNT_PATTERN = "55";
    private final int myMatchCountMargin = this.getFontMetrics(this.getFont()).stringWidth("55");

    public CategoryList() {
        this.setCellRenderer(new CategoryCellRenderer());
    }

    @Override
    protected int getRightMarginWidth() {
        return this.hasMatchCounts() ? this.myMatchCountMargin : 0;
    }

    private boolean displayMatchCounts() {
        CategoryListModel categoryModel = (CategoryListModel)this.getModel();
        assert (categoryModel != null);
        return categoryModel.hasMatchCounts();
    }

    private int getMatchCountAt(int index) {
        CategoryListModel categoryModel = (CategoryListModel)this.getModel();
        assert (categoryModel != null);
        return categoryModel.getMatchCountAt(index);
    }

    private boolean hasMatchCounts() {
        CategoryListModel categoryModel = (CategoryListModel)this.getModel();
        assert (categoryModel != null);
        return categoryModel.hasMatchCounts();
    }

    private static class CategoryCellRenderer
    implements ListCellRenderer<Palette.Group> {
        private final JPanel myPanel;
        private final TextCellRenderer myTextRenderer;
        private final JLabel myMatchCount = new JBLabel();

        private CategoryCellRenderer() {
            this.myTextRenderer = new TextCellRenderer();
            this.myPanel = new JPanel(new BorderLayout());
            this.myPanel.add((Component)((Object)this.myTextRenderer), "Center");
            this.myPanel.add((Component)this.myMatchCount, "East");
        }

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList<? extends Palette.Group> list, @NotNull Palette.Group group, int index, boolean selected, boolean hasFocus) {
            this.myTextRenderer.getListCellRendererComponent(list, group, index, selected, hasFocus);
            this.myPanel.setBackground(selected ? UIUtil.getTreeSelectionBackground((boolean)hasFocus) : null);
            this.myPanel.setForeground(UIUtil.getTreeForeground((boolean)selected, (boolean)hasFocus));
            this.myPanel.setBorder((Border)JBUI.Borders.empty((int)2, (int)3));
            CategoryList categoryList = (CategoryList)((Object)list);
            this.myMatchCount.setText(String.valueOf(categoryList.getMatchCountAt(index)));
            this.myMatchCount.setVisible(categoryList.displayMatchCounts());
            this.myMatchCount.setForeground(hasFocus ? UIUtil.getTreeSelectionForeground((boolean)true) : JBColor.GRAY);
            this.myPanel.setToolTipText(group.getName());
            return this.myPanel;
        }
    }

    private static class TextCellRenderer
    extends ColoredListCellRenderer<Palette.Group> {
        private static final SimpleTextAttributes SMALL_FONT = new SimpleTextAttributes(128, null);

        private TextCellRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList<? extends Palette.Group> list, @NotNull Palette.Group group, int index, boolean selected, boolean hasFocus) {
            String text = group.getName();
            this.setBackground(selected ? UIUtil.getTreeSelectionBackground((boolean)hasFocus) : null);
            this.mySelectionForeground = UIUtil.getTreeForeground((boolean)selected, (boolean)hasFocus);
            this.append(text, SMALL_FONT);
        }
    }
}

