/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.menu;

import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurfaceHelper;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.uibuilder.menu.MenuHandler;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.intellij.openapi.module.Module;
import icons.StudioIcons;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SearchItemHandler
extends MenuHandler {
    private static final String SEARCH_ICON = "ic_search_black_24dp";

    static boolean handles(@NotNull NlAttributesHolder item) {
        return "@drawable/ic_search_black_24dp".equals(item.getAndroidAttribute("icon"));
    }

    static void onChildInserted(@NotNull NlComponent newChild) {
        NlModel model = newChild.getModel();
        AndroidFacet facet = model.getFacet();
        if (!DesignSurfaceHelper.moduleContainsResource(facet, ResourceType.DRAWABLE, SEARCH_ICON)) {
            DesignSurfaceHelper.copyVectorAssetToMainModuleSourceSet(model.getProject(), facet, SEARCH_ICON);
        }
    }

    @Override
    public boolean onCreate(@Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType type) {
        if (!super.onCreate(parent, newChild, type)) {
            return false;
        }
        if (!type.equals((Object)InsertType.CREATE)) {
            return true;
        }
        NlModel model = newChild.getModel();
        AndroidVersion minSdkVersion = StudioAndroidModuleInfo.getInstance((AndroidFacet)model.getFacet()).getMinSdkVersion();
        NlWriteCommandActionUtil.run(newChild, "", () -> {
            String value = minSdkVersion.getApiLevel() < 11 ? "android.support.v7.widget.SearchView" : "android.widget.SearchView";
            String namespace = DependencyManagementUtil.dependsOnAppCompat((Module)model.getModule()) ? "http://schemas.android.com/apk/res-auto" : "http://schemas.android.com/apk/res/android";
            newChild.setAttribute(namespace, "actionViewClass", value);
        });
        return true;
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull NlComponent component) {
        return StudioIcons.LayoutEditor.Menu.SEARCH;
    }
}

