/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.ui;

import com.android.AndroidXConstants;
import com.android.annotations.concurrency.WorkerThread;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.repository.GoogleMavenArtifactId;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.RenderServiceUtilsKt;
import com.android.tools.idea.rendering.StudioRenderService;
import com.android.tools.idea.rendering.parsers.PsiXmlFile;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.ui.AppBarConfigurationUtilKt;
import com.android.tools.idea.uibuilder.handlers.ui.Templates;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.tools.rendering.RenderService;
import com.android.tools.rendering.imagepool.ImagePool;
import com.android.tools.rendering.parsers.RenderXmlFile;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppBarConfigurationDialog
extends JDialog {
    private static final String DIALOG_TITLE = "Configure App Bar";
    private static final String DEFAULT_BACKGROUND_IMAGE = "@android:drawable/sym_def_app_icon";
    private static final String DEFAULT_FAB_IMAGE = "@android:drawable/ic_input_add";
    private static final String PREVIEW_PLACEHOLDER_FILE = "preview.xml";
    private static final String SAMPLE_TEXT = "This text is present to test the Application Bar. ";
    private static final int SAMPLE_REPETITION = 200;
    private static final String PREVIEW_HEADER = "Preview:";
    private static final String RENDER_ERROR = "An error happened during rendering...";
    private static final String OVERLAP_TOP_FORMAT = "%1$s:behavior_overlapTop=\"%2$s\"";
    private static final double FUDGE_FACTOR = 0.95;
    private static final int MIN_WIDTH = 40;
    private static final int MIN_HEIGHT = 60;
    private static final int START_WIDTH = 225;
    private static final int START_HEIGHT = 400;
    private final NlModel myModel;
    private final Disposable myDisposable;
    private final JBLoadingPanel myLoadingPanel;
    private final boolean myUseAndroidxDependency;
    private JPanel myContentPane;
    private JButton myButtonOK;
    private JButton myButtonCancel;
    private JBLabel myPreview;
    private JCheckBox myCollapsing;
    private JCheckBox myShowBackgroundImage;
    private JCheckBox myFloatingActionButton;
    private JCheckBox myFitStatusBar;
    private JCheckBox myContentOverlap;
    private JCheckBox myWithTabs;
    private JButton myBackgroundImageSelector;
    private JButton myFloatingActionButtonImageSelector;
    private JPanel myPreviewPanel;
    private JBLabel myCollapsedPreview;
    private JBLabel myExpandedPreview;
    private Future<?> myCollapsedPreviewFuture;
    private Future<?> myExpandedPreviewFuture;
    private JBLabel myExpandedLabel;
    private JBLabel myCollapsedLabel;
    private JCheckBox myParallax;
    private JTextField myContentOverlapAmount;
    private JSpinner myTabCount;
    private boolean myWasAccepted;
    private BufferedImage myExpandedImage;
    private BufferedImage myCollapsedImage;
    private String myBackgroundImage;
    private String myFloatingActionButtonImage;

    public AppBarConfigurationDialog(@NotNull NlModel model, boolean useAndroidxDependency) {
        this.setupUI();
        this.myModel = model;
        this.myUseAndroidxDependency = useAndroidxDependency;
        this.myDisposable = Disposer.newDisposable();
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.myDisposable, 20);
        this.myLoadingPanel.add((Component)this.myContentPane);
        Disposer.register((Disposable)model, (Disposable)this.myDisposable);
        this.setTitle(DIALOG_TITLE);
        this.setContentPane((Container)this.myLoadingPanel);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.myButtonOK);
        this.myBackgroundImage = DEFAULT_BACKGROUND_IMAGE;
        this.myFloatingActionButtonImage = DEFAULT_FAB_IMAGE;
        ActionListener updatePreviewListener = event -> {
            this.updateControls();
            this.generatePreviews();
        };
        this.myWithTabs.addActionListener(updatePreviewListener);
        this.myTabCount.setValue(3);
        this.myCollapsing.addActionListener(updatePreviewListener);
        this.myShowBackgroundImage.addActionListener(updatePreviewListener);
        this.myFloatingActionButton.addActionListener(updatePreviewListener);
        this.myFitStatusBar.addActionListener(updatePreviewListener);
        this.myParallax.addActionListener(updatePreviewListener);
        this.myContentOverlap.addActionListener(updatePreviewListener);
        this.myContentOverlapAmount.addActionListener(updatePreviewListener);
        ((GridLayoutManager)this.myPreviewPanel.getLayout()).setRowStretch(0, 2);
        this.myTabCount.addChangeListener(event -> this.generatePreviews());
        ActionListener actionListener = event -> {
            if (event.getSource() == this.myBackgroundImageSelector) {
                String src = ViewEditor.displayResourceInput(this.myModel, EnumSet.of(ResourceType.DRAWABLE));
                if (src != null) {
                    this.myBackgroundImage = src;
                    this.generatePreviews();
                }
            } else if (event.getSource() == this.myFloatingActionButtonImageSelector) {
                String src = ViewEditor.displayResourceInput(this.myModel, EnumSet.of(ResourceType.DRAWABLE));
                if (src != null) {
                    this.myFloatingActionButtonImage = src;
                    this.generatePreviews();
                }
            } else if (event.getSource() == this.myButtonOK) {
                this.onOK();
            } else if (event.getSource() == this.myButtonCancel || event.getSource() == this.myContentPane) {
                this.onCancel();
            }
        };
        this.myBackgroundImageSelector.addActionListener(actionListener);
        this.myFloatingActionButtonImageSelector.addActionListener(actionListener);
        this.myButtonOK.addActionListener(actionListener);
        this.myButtonCancel.addActionListener(actionListener);
        this.myContentPane.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(27, 0), 1);
        this.myPreviewPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AppBarConfigurationDialog.this.updatePreviewImages();
            }
        });
        this.myCollapsedPreview.setName("CollapsedPreview");
        this.myExpandedPreview.setName("ExpandedPreview");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AppBarConfigurationDialog.this.onCancel();
            }
        });
    }

    public boolean open() {
        boolean hasDesignLib;
        Project project = this.myModel.getProject();
        Module module = this.myModel.getModule();
        boolean bl = hasDesignLib = DependencyManagementUtil.dependsOn((Module)module, (GoogleMavenArtifactId)GoogleMavenArtifactId.SUPPORT_DESIGN) || DependencyManagementUtil.dependsOn((Module)module, (GoogleMavenArtifactId)GoogleMavenArtifactId.MATERIAL);
        if (!hasDesignLib && !this.addDesignLibrary()) {
            return false;
        }
        this.myCollapsedPreview.setMinimumSize(new Dimension(225, 400));
        this.myExpandedPreview.setMinimumSize(new Dimension(225, 400));
        this.pack();
        this.myCollapsedPreview.setMinimumSize(null);
        this.myExpandedPreview.setMinimumSize(null);
        Dimension size = this.getSize();
        Rectangle screen = this.getGraphicsConfiguration().getBounds();
        this.setLocation(screen.x + (screen.width - size.width) / 2, screen.y + (screen.height - size.height) / 2);
        this.updateControls();
        this.myButtonOK.requestFocus();
        if (hasDesignLib) {
            this.generatePreviews();
        }
        this.setVisible(true);
        if (this.myWasAccepted) {
            XmlFile file2 = this.myModel.getFile();
            WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file2}).withName(DIALOG_TITLE).run(() -> this.applyChanges(file2));
        }
        return this.myWasAccepted;
    }

    private boolean addDesignLibrary() {
        this.myLoadingPanel.startLoading();
        Module module = this.myModel.getModule();
        GoogleMavenArtifactId artifact = this.myUseAndroidxDependency ? GoogleMavenArtifactId.MATERIAL : GoogleMavenArtifactId.SUPPORT_DESIGN;
        boolean designAdded = DependencyManagementUtil.addDependenciesWithUiConfirmation((Module)module, Set.of(artifact), (boolean)true, (boolean)false).isEmpty();
        if (!designAdded) {
            return false;
        }
        ListenableFuture syncResult = ProjectSystemUtil.getSyncManager((Project)module.getProject()).requestSyncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED);
        Futures.addCallback((ListenableFuture)syncResult, (FutureCallback)new FutureCallback<ProjectSystemSyncManager.SyncResult>(){

            public void onSuccess(@Nullable ProjectSystemSyncManager.SyncResult result) {
                if (result != null && result.isSuccessful()) {
                    AppBarConfigurationDialog.this.onDesignSourcesGenerated();
                } else {
                    AppBarConfigurationDialog.this.onBuildError();
                }
            }

            public void onFailure(@NotNull Throwable t) {
                AppBarConfigurationDialog.this.onBuildError();
            }
        }, (Executor)MoreExecutors.directExecutor());
        return true;
    }

    private void onDesignSourcesGenerated() {
        if (this.isVisible()) {
            ApplicationManager.getApplication().invokeLater(this::generatePreviews);
        }
    }

    private void onBuildError() {
        this.myPreview.setText("Preview is unavailable until after a successful project sync");
        this.myPreview.setIcon(AllIcons.General.Warning);
        this.myCollapsedLabel.setVisible(false);
        this.myExpandedLabel.setVisible(false);
        this.myLoadingPanel.stopLoading();
    }

    private void onOK() {
        this.myWasAccepted = true;
        this.dispose();
    }

    private void onCancel() {
        this.dispose();
    }

    @Override
    public void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.myDisposable);
    }

    @NotNull
    private Project getProject() {
        return this.myModel.getProject();
    }

    private void updateControls() {
        this.myTabCount.setEnabled(this.myWithTabs.isSelected());
        this.myShowBackgroundImage.setEnabled(!this.myWithTabs.isSelected());
        this.myBackgroundImageSelector.setEnabled(!this.myWithTabs.isSelected() && this.myShowBackgroundImage.isSelected());
        this.myFitStatusBar.setEnabled(!this.myWithTabs.isSelected() && this.myShowBackgroundImage.isSelected());
        this.myParallax.setEnabled(!this.myWithTabs.isSelected() && this.myShowBackgroundImage.isSelected());
        this.myFitStatusBar.setEnabled(!this.myWithTabs.isSelected() && this.myShowBackgroundImage.isSelected());
        this.myContentOverlap.setEnabled(!this.myWithTabs.isSelected() && this.myShowBackgroundImage.isSelected());
        this.myContentOverlapAmount.setEnabled(!this.myWithTabs.isSelected() && this.myShowBackgroundImage.isSelected() && this.myContentOverlap.isSelected());
        this.myFloatingActionButtonImageSelector.setEnabled(this.myFloatingActionButton.isSelected());
    }

    private void generatePreviews() {
        this.myExpandedPreviewFuture = AppBarConfigurationDialog.cancel(this.myExpandedPreviewFuture);
        this.myCollapsedPreviewFuture = AppBarConfigurationDialog.cancel(this.myCollapsedPreviewFuture);
        this.myExpandedPreviewFuture = this.updateExpandedImage();
        this.myCollapsedPreviewFuture = this.updateCollapsedImage();
    }

    private void setupUI() {
        this.myContentPane = new JPanel();
        this.myContentPane.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myContentPane.add((Component)panel1, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 1, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        panel1.add((Component)spacer1, new GridConstraints(0, 0, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        panel1.add((Component)panel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myButtonOK = new JButton();
        this.myButtonOK.setText("OK");
        panel2.add((Component)this.myButtonOK, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.myButtonCancel = new JButton();
        this.myButtonCancel.setText("Cancel");
        panel2.add((Component)this.myButtonCancel, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myContentPane.add((Component)panel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JSplitPane splitPane1 = new JSplitPane();
        panel3.add((Component)splitPane1, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null, 0, false));
        JPanel panel4 = new JPanel();
        panel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        splitPane1.setLeftComponent(panel4);
        JPanel panel5 = new JPanel();
        panel5.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(16, 8, 0, 0), -1, -1));
        panel4.add((Component)panel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myCollapsing = new JCheckBox();
        this.myCollapsing.setText("Collapsing Toolbar");
        panel5.add((Component)this.myCollapsing, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null, 0, false));
        this.myShowBackgroundImage = new JCheckBox();
        this.myShowBackgroundImage.setText("Image Background");
        panel5.add((Component)this.myShowBackgroundImage, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myFloatingActionButton = new JCheckBox();
        this.myFloatingActionButton.setText("Floating Action Button");
        panel5.add((Component)this.myFloatingActionButton, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null, 0, false));
        this.myWithTabs = new JCheckBox();
        this.myWithTabs.setText("With Tabs");
        panel5.add((Component)this.myWithTabs, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JPanel panel6 = new JPanel();
        panel6.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 12, 0, 0), -1, -1));
        panel5.add((Component)panel6, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, false));
        this.myFitStatusBar = new JCheckBox();
        this.myFitStatusBar.setActionCommand("");
        this.myFitStatusBar.setText("Fit Status Bar on Image");
        this.myFitStatusBar.setToolTipText("Makes the toolbar with the image appear below the status bar. The status bar can be set to draw transparent by setting the theme value for: statusBarColor to color/transparent.");
        panel6.add((Component)this.myFitStatusBar, new GridConstraints(0, 0, 1, 4, 8, 0, 3, 0, null, null, null, 0, false));
        this.myParallax = new JCheckBox();
        this.myParallax.setText("Parallax Scrolling");
        this.myParallax.setToolTipText("Makes the image scroll slower than the TabBar (only visible at runtime).");
        panel6.add((Component)this.myParallax, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myBackgroundImageSelector = new JButton();
        Font myBackgroundImageSelectorFont = this.getFont(null, -1, 8, this.myBackgroundImageSelector.getFont());
        if (myBackgroundImageSelectorFont != null) {
            this.myBackgroundImageSelector.setFont(myBackgroundImageSelectorFont);
        }
        this.myBackgroundImageSelector.setText("...");
        panel5.add((Component)this.myBackgroundImageSelector, new GridConstraints(1, 1, 1, 2, 4, 0, 3, 0, null, null, null, 0, false));
        this.myFloatingActionButtonImageSelector = new JButton();
        Font myFloatingActionButtonImageSelectorFont = this.getFont(null, -1, 8, this.myFloatingActionButtonImageSelector.getFont());
        if (myFloatingActionButtonImageSelectorFont != null) {
            this.myFloatingActionButtonImageSelector.setFont(myFloatingActionButtonImageSelectorFont);
        }
        this.myFloatingActionButtonImageSelector.setText("...");
        panel5.add((Component)this.myFloatingActionButtonImageSelector, new GridConstraints(3, 2, 1, 1, 4, 0, 3, 0, null, null, null, 0, false));
        this.myContentOverlap = new JCheckBox();
        this.myContentOverlap.setText("Overlapping content");
        panel5.add((Component)this.myContentOverlap, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myContentOverlapAmount = new JTextField();
        this.myContentOverlapAmount.setText("32dp");
        panel5.add((Component)this.myContentOverlapAmount, new GridConstraints(4, 2, 1, 1, 8, 1, 1, 0, null, new Dimension(60, -1), null, 0, false));
        this.myTabCount = new JSpinner();
        panel5.add((Component)this.myTabCount, new GridConstraints(5, 1, 1, 2, 8, 1, 4, 0, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        panel4.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.myPreviewPanel = new JPanel();
        this.myPreviewPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1));
        splitPane1.setRightComponent(this.myPreviewPanel);
        this.myPreview = new JBLabel();
        this.myPreview.setText(PREVIEW_HEADER);
        this.myPreviewPanel.add((Component)this.myPreview, new GridConstraints(0, 0, 1, 2, 2, 0, 5, 5, null, null, null, 0, false));
        this.myExpandedLabel = new JBLabel();
        this.myExpandedLabel.setAlignmentX(0.0f);
        this.myExpandedLabel.setText("Expanded");
        this.myPreviewPanel.add((Component)this.myExpandedLabel, new GridConstraints(2, 0, 1, 1, 1, 0, 5, 5, null, null, null, 0, false));
        this.myCollapsedLabel = new JBLabel();
        this.myCollapsedLabel.setAlignmentX(0.0f);
        this.myCollapsedLabel.setText("Collapsed");
        this.myPreviewPanel.add((Component)this.myCollapsedLabel, new GridConstraints(2, 1, 1, 1, 1, 0, 5, 5, null, null, null, 0, false));
        this.myExpandedPreview = new JBLabel();
        this.myPreviewPanel.add((Component)this.myExpandedPreview, new GridConstraints(1, 0, 1, 1, 0, 0, 5, 5, null, null, null, 0, false));
        this.myCollapsedPreview = new JBLabel();
        this.myPreviewPanel.add((Component)this.myCollapsedPreview, new GridConstraints(1, 1, 1, 1, 0, 0, 5, 5, null, null, null, 1, false));
        Spacer spacer3 = new Spacer();
        this.myPreviewPanel.add((Component)spacer3, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
    }

    private Font getFont(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }

    @Nullable
    private static Future<?> cancel(@Nullable Future<?> future) {
        if (future != null) {
            future.cancel(true);
        }
        return null;
    }

    @WorkerThread
    private XmlFile generateXml(boolean collapsed) {
        DumbService.getInstance((Project)this.getProject()).waitForSmartMode();
        StringBuilder text = new StringBuilder(200 * SAMPLE_TEXT.length());
        for (int i = 0; i < 200; ++i) {
            text.append(SAMPLE_TEXT);
        }
        Map<String, String> namespaces = AppBarConfigurationDialog.getNameSpaces(null, collapsed);
        String content = Templates.getTextView(namespaces.get("http://schemas.android.com/apk/res/android"), text.toString());
        String xml = this.getXml(content, collapsed, namespaces);
        Project project = this.getProject();
        return (XmlFile)ReadAction.compute(() -> PsiFileFactory.getInstance((Project)project).createFileFromText(PREVIEW_PLACEHOLDER_FILE, (FileType)XmlFileType.INSTANCE, (CharSequence)xml));
    }

    private void updatePreviewImages() {
        if (this.myCollapsedImage != null) {
            this.updatePreviewImage(this.myCollapsedImage, this.myCollapsedPreview);
        }
        if (this.myExpandedImage != null) {
            this.updatePreviewImage(this.myExpandedImage, this.myExpandedPreview);
        }
    }

    private void applyChanges(@NotNull XmlFile file2) {
        Map<String, String> namespaces = AppBarConfigurationDialog.getNameSpaces(file2.getRootTag(), false);
        String xml = this.getXml(AppBarConfigurationDialog.getDesignContent(file2), false, namespaces);
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)file2.getProject());
        XmlTag tag = elementFactory.createTagFromText((CharSequence)xml);
        if (file2.getRootTag() == null) {
            file2.add((PsiElement)tag);
        } else {
            file2.getRootTag().replace((PsiElement)tag);
        }
    }

    @NotNull
    private String getXml(@NotNull String content, boolean collapsed, @NotNull Map<String, String> namespaces) {
        return this.myWithTabs.isSelected() ? this.getXmlWithTabs(content, collapsed, namespaces) : this.getXmlWithoutTabs(content, collapsed, namespaces);
    }

    @NotNull
    private String getXmlWithoutTabs(@NotNull String content, boolean collapsed, @NotNull Map<String, String> namespaces) {
        return Templates.getCoordinatorLayout(this.getProject(), namespaces.get("http://schemas.android.com/apk/res/android"), namespaces.get("http://schemas.android.com/apk/res-auto"), AppBarConfigurationUtilKt.formatNamespaces(namespaces), this.getFitsSystemWindows(namespaces), this.getToolbarScrollBehavior(), this.getInterpolator(namespaces), this.getBackgroundImage(namespaces), this.getBehaviorOverlapTop(namespaces), AppBarConfigurationDialog.getScrollPos(collapsed, namespaces), content, this.getFloatingActionButton(namespaces));
    }

    @NotNull
    private String getXmlWithTabs(@NotNull String content, boolean collapsed, @NotNull Map<String, String> namespaces) {
        return Templates.getCoordinatorLayoutWithTabs(this.getProject(), namespaces.get("http://schemas.android.com/apk/res/android"), namespaces.get("http://schemas.android.com/apk/res-auto"), AppBarConfigurationUtilKt.formatNamespaces(namespaces), this.getTabLayoutScroll(namespaces), this.getTabItems(namespaces), AppBarConfigurationDialog.getScrollPos(collapsed, namespaces), content, this.getFloatingActionButton(namespaces));
    }

    @NotNull
    private String getFitsSystemWindows(@NotNull Map<String, String> namespaces) {
        if (!this.myShowBackgroundImage.isSelected() || !this.myFitStatusBar.isSelected()) {
            return "";
        }
        return String.format("    %1$s:fitsSystemWindows=\"true\"\n", namespaces.get("http://schemas.android.com/apk/res/android"));
    }

    @NotNull
    private String getToolbarScrollBehavior() {
        return this.myCollapsing.isSelected() ? "scroll|enterAlways|enterAlwaysCollapsed" : "scroll|exitUntilCollapsed";
    }

    @NotNull
    private String getTabLayoutScroll(@NotNull Map<String, String> namespaces) {
        if (!this.myCollapsing.isSelected()) {
            return "";
        }
        return String.format("        %1$s:layout_scrollFlags=\"scroll|enterAlways\"\n", namespaces.get("http://schemas.android.com/apk/res-auto"));
    }

    @NotNull
    private String getTabItems(@NotNull Map<String, String> namespaces) {
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < (Integer)this.myTabCount.getValue(); ++index) {
            builder.append(Templates.getTabItem(this.getProject(), namespaces.get("http://schemas.android.com/apk/res/android"), "Tab" + (index + 1)));
        }
        return builder.toString();
    }

    @NotNull
    private String getInterpolator(@NotNull Map<String, String> namespaces) {
        if (!this.myShowBackgroundImage.isSelected()) {
            return "";
        }
        return String.format("        %2$s:layout_scrollInterpolator=\"@%1$s:anim/decelerate_interpolator\"\n", namespaces.get("http://schemas.android.com/apk/res/android"), namespaces.get("http://schemas.android.com/apk/res-auto"));
    }

    @NotNull
    private String getBackgroundImage(@NotNull Map<String, String> namespaces) {
        if (!this.myShowBackgroundImage.isSelected()) {
            return "";
        }
        return Templates.getImageView(namespaces.get("http://schemas.android.com/apk/res/android"), this.getBackgroundImageCollapseMode(namespaces), this.myBackgroundImage);
    }

    @NotNull
    private String getBehaviorOverlapTop(@NotNull Map<String, String> namespaces) {
        if (!this.myContentOverlap.isSelected()) {
            return "";
        }
        return String.format(OVERLAP_TOP_FORMAT, namespaces.get("http://schemas.android.com/apk/res-auto"), this.myContentOverlapAmount.getText());
    }

    @NotNull
    private static String getScrollPos(boolean collapsed, @NotNull Map<String, String> namespaces) {
        if (!collapsed) {
            return "";
        }
        return String.format("        %1$s:scrollY=\"830px\"\n", namespaces.get("http://schemas.android.com/tools"));
    }

    @NotNull
    private String getBackgroundImageCollapseMode(@NotNull Map<String, String> namespaces) {
        if (this.myParallax.isSelected()) {
            return "";
        }
        return String.format("    %1$s:layout_collapseMode=\"parallax\"\n", namespaces.get("http://schemas.android.com/apk/res-auto"));
    }

    @NotNull
    private String getFloatingActionButton(@NotNull Map<String, String> namespaces) {
        if (!this.myFloatingActionButton.isSelected()) {
            return "";
        }
        return Templates.getTagFloatingActionButton(this.getProject(), namespaces.get("http://schemas.android.com/apk/res/android"), this.myFloatingActionButtonImage);
    }

    @NotNull
    private static Map<String, String> getNameSpaces(@Nullable XmlTag root, boolean includeToolsNamespace) {
        HashMap<String, String> reverse = new HashMap<String, String>();
        if (root != null) {
            Map namespaces = root.getLocalNamespaceDeclarations();
            for (String prefix : namespaces.keySet()) {
                reverse.put((String)namespaces.get(prefix), prefix);
            }
        }
        if (!reverse.containsKey("http://schemas.android.com/apk/res/android")) {
            reverse.put("http://schemas.android.com/apk/res/android", "android");
        }
        if (!reverse.containsKey("http://schemas.android.com/apk/res-auto")) {
            reverse.put("http://schemas.android.com/apk/res-auto", "app");
        }
        if (includeToolsNamespace && !reverse.containsKey("http://schemas.android.com/tools")) {
            reverse.put("http://schemas.android.com/tools", "tools");
        }
        return reverse;
    }

    @NotNull
    private static String getDesignContent(@NotNull XmlFile file2) {
        XmlTag content = file2.getRootTag();
        if (content != null && AndroidXConstants.COORDINATOR_LAYOUT.isEquals(content.getName())) {
            XmlTag root = content;
            content = null;
            XmlTag[] xmlTagArray = root.getSubTags();
            int n = xmlTagArray.length;
            for (int i = 0; i < n; ++i) {
                XmlTag tag = xmlTagArray[i];
                if (AndroidXConstants.APP_BAR_LAYOUT.isEquals(tag.getName()) || AndroidXConstants.FLOATING_ACTION_BUTTON.isEquals(tag.getName())) continue;
                if (AndroidXConstants.CLASS_NESTED_SCROLL_VIEW.isEquals(tag.getName())) {
                    content = tag.getSubTags().length > 0 ? tag.getSubTags()[0] : null;
                    break;
                }
                content = tag;
                break;
            }
        }
        if (content == null) {
            return "";
        }
        for (XmlAttribute attribute : content.getAttributes()) {
            if (attribute == null || !attribute.getName().startsWith("xmlns:")) continue;
            attribute.delete();
        }
        return content.getText();
    }

    private CompletableFuture<Void> updateCollapsedImage() {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.generateXml(true), AppExecutorUtil.getAppExecutorService()).thenCompose(file2 -> this.updateImage((XmlFile)file2, this.myCollapsedPreview))).thenAccept(image -> {
            this.myCollapsedImage = image;
        });
    }

    private CompletableFuture<Void> updateExpandedImage() {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.generateXml(false), AppExecutorUtil.getAppExecutorService()).thenCompose(file2 -> this.updateImage((XmlFile)file2, this.myExpandedPreview))).thenAcceptAsync(image -> {
            this.myExpandedImage = image;
            this.myLoadingPanel.stopLoading();
        }, (Executor)EdtExecutorService.getInstance());
    }

    @NotNull
    private CompletableFuture<BufferedImage> updateImage(@NotNull XmlFile xmlFile, @NotNull JBLabel preview) {
        return this.renderImage(xmlFile).whenCompleteAsync((image, ex) -> this.updatePreviewImage((BufferedImage)image, preview), (Executor)EdtExecutorService.getInstance());
    }

    private CompletableFuture<BufferedImage> renderImage(@NotNull XmlFile xmlFile) {
        AndroidFacet facet = this.myModel.getFacet();
        RenderService renderService = StudioRenderService.getInstance((Project)this.getProject());
        CompletableFuture taskFuture = RenderServiceUtilsKt.taskBuilderWithHtmlLogger(renderService, this.myModel.getBuildTarget(), this.myModel.getConfiguration()).withPsiFile((RenderXmlFile)new PsiXmlFile(xmlFile)).build();
        return taskFuture.thenCompose(task -> {
            if (task != null) {
                task.setRenderingMode(SessionParams.RenderingMode.NORMAL);
                task.getContext().setFolderType(ResourceFolderType.LAYOUT);
                return ((CompletableFuture)task.render().thenApply(result -> {
                    ImagePool.Image image = result.getRenderedImage();
                    if (!image.isValid() || image.getWidth() < 40 || image.getHeight() < 60) {
                        return null;
                    }
                    return result.getRenderedImage().getCopy();
                })).whenCompleteAsync((image, ex) -> task.dispose(), (Executor)AppExecutorUtil.getAppExecutorService());
            }
            return null;
        });
    }

    private void updatePreviewImage(@Nullable BufferedImage image, @NotNull JBLabel view) {
        if (image == null) {
            view.setIcon(null);
            this.myPreview.setText(RENDER_ERROR);
            return;
        }
        double width = (double)this.myPreviewPanel.getWidth() / 2.0;
        double height = this.myPreviewPanel.getHeight() - this.myPreview.getHeight() - Math.max(this.myExpandedLabel.getHeight(), this.myCollapsedLabel.getHeight());
        if (width < 40.0 || height < 60.0) {
            view.setIcon(null);
        }
        double scale = Math.min(width / (double)image.getWidth(), height / (double)image.getHeight()) * 0.95;
        image = ImageUtils.scale((BufferedImage)image, (double)scale, (double)scale);
        view.setIcon((Icon)new ImageIcon(image));
        this.myPreview.setText(PREVIEW_HEADER);
    }

    private static Logger getLogger() {
        return Logger.getInstance(AppBarConfigurationDialog.class);
    }
}

