/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.preference;

import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.tools.idea.uibuilder.handlers.preference.PreferenceCategoryDragHandler;
import com.android.xml.XmlBuilder;
import com.google.common.base.Strings;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PreferenceCategoryHandler
extends ViewGroupHandler {
    @Override
    @Language(value="XML")
    @NotNull
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        switch (xmlType) {
            case COMPONENT_CREATION: {
                return new XmlBuilder().startTag(tagName).androidAttribute("title", "Preference category").endTag(tagName).toString();
            }
            case PREVIEW_ON_PALETTE: 
            case DRAG_PREVIEW: {
                return "";
            }
        }
        throw new AssertionError((Object)xmlType);
    }

    @Override
    @NotNull
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull SceneComponent preferenceCategory, @NotNull List<NlComponent> preferences, @NotNull DragType type) {
        return new PreferenceCategoryDragHandler(editor, this, preferenceCategory, preferences, type);
    }

    @Override
    public boolean onCreate(@Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        if (insertType == InsertType.CREATE) {
            NlWriteCommandActionUtil.run(newChild, "Clearing Width and Height", () -> {
                newChild.removeAndroidAttribute("layout_width");
                newChild.removeAndroidAttribute("layout_height");
            });
        }
        return true;
    }

    @Override
    @NotNull
    public String getTitle(@NotNull NlComponent component) {
        String title = component.getAttribute("http://schemas.android.com/apk/res-auto", "title");
        return title != null ? title : Strings.nullToEmpty((String)component.getAndroidAttribute("title"));
    }
}

