/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.targets;

import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class ConstraintResizeTarget
extends ResizeBaseTarget {
    public ConstraintResizeTarget(@NotNull ResizeBaseTarget.Type type) {
        super(type);
    }

    @Override
    public int getPreferenceLevel() {
        if (this.myType == ResizeBaseTarget.Type.LEFT || this.myType == ResizeBaseTarget.Type.RIGHT || this.myType == ResizeBaseTarget.Type.TOP || this.myType == ResizeBaseTarget.Type.BOTTOM) {
            return 50;
        }
        return 60;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (this.myType == ResizeBaseTarget.Type.LEFT || this.myType == ResizeBaseTarget.Type.RIGHT || this.myType == ResizeBaseTarget.Type.TOP || this.myType == ResizeBaseTarget.Type.BOTTOM) {
            return;
        }
        super.render(list, sceneContext);
    }

    @Override
    public boolean canChangeSelection() {
        return false;
    }

    private static void updateWidth(@NotNull NlAttributesHolder attributes, int w) {
        if (w < 0) {
            w = 0;
        }
        String position = String.format(Locale.US, "%ddp", w);
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", position);
    }

    private static void updateHeight(@NotNull NlAttributesHolder attributes, int h) {
        if (h < 0) {
            h = 0;
        }
        String position = String.format(Locale.US, "%ddp", h);
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", position);
    }

    private static void updatePositionX(@NotNull NlAttributesHolder attributes, int x) {
        String positionX = String.format(Locale.US, "%ddp", x);
        attributes.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", positionX);
    }

    private static void updatePositionY(@NotNull NlAttributesHolder attributes, int y) {
        String positionY = String.format(Locale.US, "%ddp", y);
        attributes.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", positionY);
    }

    @Override
    protected void updateAttributes(@NotNull NlAttributesHolder attributes, int x, int y) {
        SceneComponent parent = this.myComponent.getParent();
        switch (this.myType) {
            case RIGHT_TOP: {
                ConstraintResizeTarget.updateWidth(attributes, x - this.myStartX1);
                ConstraintResizeTarget.updatePositionY(attributes, y - (parent != null ? parent.getDrawY() : 0));
                ConstraintResizeTarget.updateHeight(attributes, this.myStartY2 - y);
                break;
            }
            case RIGHT_BOTTOM: {
                ConstraintResizeTarget.updateWidth(attributes, x - this.myStartX1);
                ConstraintResizeTarget.updateHeight(attributes, y - this.myStartY1);
                break;
            }
            case LEFT_TOP: {
                ConstraintResizeTarget.updatePositionX(attributes, x - (parent != null ? parent.getDrawX() : 0));
                ConstraintResizeTarget.updateWidth(attributes, this.myStartX2 - x);
                ConstraintResizeTarget.updatePositionY(attributes, y - this.myComponent.getParent().getDrawY());
                ConstraintResizeTarget.updateHeight(attributes, this.myStartY2 - y);
                break;
            }
            case LEFT_BOTTOM: {
                ConstraintResizeTarget.updatePositionX(attributes, x - (parent != null ? parent.getDrawX() : 0));
                ConstraintResizeTarget.updateWidth(attributes, this.myStartX2 - x);
                ConstraintResizeTarget.updateHeight(attributes, y - this.myStartY1);
                break;
            }
            case LEFT: {
                ConstraintResizeTarget.updatePositionX(attributes, x - (parent != null ? parent.getDrawX() : 0));
                ConstraintResizeTarget.updateWidth(attributes, this.myStartX2 - x);
                break;
            }
            case TOP: {
                ConstraintResizeTarget.updatePositionY(attributes, y - (parent != null ? parent.getDrawY() : 0));
                ConstraintResizeTarget.updateHeight(attributes, this.myStartY2 - y);
                break;
            }
            case BOTTOM: {
                ConstraintResizeTarget.updateHeight(attributes, y - this.myStartY1);
                break;
            }
            case RIGHT: {
                ConstraintResizeTarget.updateWidth(attributes, x - this.myStartX1);
            }
        }
    }
}

