/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.common;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.target.CommonDragTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J*\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0012H\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/uibuilder/handlers/common/CommonDragHandler;", "Lcom/android/tools/idea/uibuilder/api/DragHandler;", "editor", "Lcom/android/tools/idea/uibuilder/api/ViewEditor;", "handler", "Lcom/android/tools/idea/uibuilder/api/ViewGroupHandler;", "layout", "Lcom/android/tools/idea/common/scene/SceneComponent;", "components", "", "Lcom/android/tools/idea/common/model/NlComponent;", "type", "Lcom/android/tools/idea/common/api/DragType;", "<init>", "(Lcom/android/tools/idea/uibuilder/api/ViewEditor;Lcom/android/tools/idea/uibuilder/api/ViewGroupHandler;Lcom/android/tools/idea/common/scene/SceneComponent;Ljava/util/List;Lcom/android/tools/idea/common/api/DragType;)V", "dragTarget", "Lcom/android/tools/idea/common/scene/target/CommonDragTarget;", "start", "", "x", "", "y", "modifiers", "update", "", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "commit", "insertType", "Lcom/android/tools/idea/common/api/InsertType;", "cancel", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class CommonDragHandler
extends DragHandler {
    @NotNull
    private final CommonDragTarget dragTarget;
    public static final int $stable = 8;

    public CommonDragHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @NotNull SceneComponent layout, @NotNull List<? extends NlComponent> components, @NotNull DragType type) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        Intrinsics.checkNotNullParameter(components, (String)"components");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        super(editor, handler, layout, components, type);
        NlComponent dragged = components.get(0);
        SceneComponent sceneComponent = layout.getScene().getSceneComponent(dragged);
        if (sceneComponent == null) {
            TemporarySceneComponent temporarySceneComponent;
            TemporarySceneComponent $this$_init__u24lambda_u240 = temporarySceneComponent = new TemporarySceneComponent(layout.getScene(), dragged);
            boolean bl = false;
            $this$_init__u24lambda_u240.setSize(editor.pxToDp(NlComponentHelperKt.getW(dragged)), editor.pxToDp(NlComponentHelperKt.getH(dragged)));
            sceneComponent = temporarySceneComponent;
        }
        SceneComponent component = sceneComponent;
        this.dragTarget = new CommonDragTarget(component, true);
        component.setTargetProvider(arg_0 -> CommonDragHandler._init_$lambda$1(this, arg_0));
        component.updateTargets();
        component.setComponentProvider(arg_0 -> CommonDragHandler._init_$lambda$2(components, arg_0));
        layout.addChild(component);
        component.setDrawState(SceneComponent.DrawState.DRAG);
    }

    @Override
    public void start(int x, int y, int modifiers) {
        super.start(x, y, modifiers);
        this.dragTarget.mouseDown(x, y);
    }

    @Override
    @Nullable
    public String update(int x, int y, int modifiers, @NotNull SceneContext sceneContext) {
        Intrinsics.checkNotNullParameter((Object)sceneContext, (String)"sceneContext");
        String result = super.update(x, y, modifiers, sceneContext);
        this.dragTarget.mouseDrag(x, y, CollectionsKt.emptyList(), sceneContext);
        this.dragTarget.getComponent().getScene().requestLayoutIfNeeded();
        return result;
    }

    @Override
    public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
        Intrinsics.checkNotNullParameter((Object)((Object)insertType), (String)"insertType");
        this.dragTarget.setInsertType(insertType);
        int dx = this.editor.pxToDp(x);
        int dy = this.editor.pxToDp(y);
        this.dragTarget.mouseRelease(dx, dy, CollectionsKt.emptyList());
        SceneComponent component = this.dragTarget.getComponent();
        if (component instanceof TemporarySceneComponent) {
            this.layout.getScene().removeComponent(component);
        }
        component.setDrawState(SceneComponent.DrawState.NORMAL);
        this.layout.getScene().requestLayoutIfNeeded();
    }

    @Override
    public void cancel() {
        if (this.dragTarget.getComponent() instanceof TemporarySceneComponent) {
            this.layout.getScene().removeComponent(this.dragTarget.getComponent());
        }
        this.dragTarget.getComponent().setDrawState(SceneComponent.DrawState.NORMAL);
        this.dragTarget.mouseCancel();
    }

    private static final List _init_$lambda$1(CommonDragHandler this$0, SceneComponent sceneComponent) {
        Intrinsics.checkNotNullParameter((Object)sceneComponent, (String)"<unused var>");
        Object[] objectArray = new Target[]{this$0.dragTarget};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    private static final NlComponent _init_$lambda$2(List $components, SceneComponent sceneComponent) {
        Intrinsics.checkNotNullParameter((Object)sceneComponent, (String)"<unused var>");
        return (NlComponent)$components.get(0);
    }
}

