/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.target.ComponentAssistantViewAction;
import com.android.tools.idea.res.PredefinedSampleDataResourceRepository;
import com.android.tools.idea.res.SampleDataResourceItem;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.assistant.ComponentAssistantFactory;
import com.android.tools.idea.uibuilder.handlers.actions.PickDrawableViewAction;
import com.android.tools.idea.uibuilder.handlers.actions.ScaleTypesViewActionMenu;
import com.android.tools.idea.uibuilder.handlers.assistant.ImageViewAssistant;
import com.android.tools.idea.uibuilder.model.NlModelHelperKt;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.xml.XmlBuilder;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import java.util.EnumSet;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageViewHandler
extends ViewHandler {
    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"src", (Object)"tools:src", (Object)"contentDescription", (Object)"background", (Object)"scaleType", (Object)"adjustViewBounds", (Object)"cropToPadding");
    }

    @Override
    @NotNull
    public String getPreferredProperty() {
        return "src";
    }

    @Override
    @NotNull
    @Language(value="XML")
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        return new XmlBuilder().startTag(tagName).androidAttribute("src", this.getSampleImageSrc()).androidAttribute("layout_width", "wrap_content").androidAttribute("layout_height", "wrap_content").endTag(tagName).toString();
    }

    @Override
    public boolean onCreate(@Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        if (insertType == InsertType.CREATE) {
            String src = ImageViewHandler.getSrcAttribute(newChild);
            if (src != null && !src.equals(this.getSampleImageSrc())) {
                this.setSrcAttribute(newChild, src);
                return true;
            }
            return this.showImageChooser(newChild);
        }
        return true;
    }

    private boolean showImageChooser(@NotNull NlComponent component) {
        String src = ViewEditor.displayResourceInput(component.getModel(), EnumSet.of(ResourceType.DRAWABLE, ResourceType.MIPMAP), true);
        if (src != null) {
            if (src.startsWith("@sample/") || src.startsWith("@tools:sample/")) {
                this.setToolsSrc(component, src);
                this.setSrcAttribute(component, null);
            } else {
                this.setSrcAttribute(component, src);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public String getSampleImageSrc() {
        return "@tools:sample/avatars";
    }

    private static String getSrcAttribute(@NotNull NlComponent newChild) {
        String src = newChild.getAttribute("http://schemas.android.com/apk/res/android", "src");
        if (src == null) {
            src = newChild.getAttribute("http://schemas.android.com/apk/res-auto", "srcCompat");
        }
        return src;
    }

    public void setSrcAttribute(@NotNull NlComponent component, @Nullable String imageSource) {
        NlWriteCommandActionUtil.run(component, "", () -> {
            if (ImageViewHandler.shouldUseSrcCompat(component.getModel())) {
                component.setAttribute("http://schemas.android.com/apk/res/android", "src", null);
                component.setAttribute("http://schemas.android.com/apk/res-auto", "srcCompat", imageSource);
            } else {
                component.setAttribute("http://schemas.android.com/apk/res/android", "src", imageSource);
                component.setAttribute("http://schemas.android.com/apk/res-auto", "srcCompat", null);
            }
        });
    }

    public void setToolsSrc(@NotNull NlComponent component, @Nullable SampleDataResourceItem item, int resourceValueIndex) {
        if (item != null) {
            Object suffix = resourceValueIndex >= 0 ? "[" + resourceValueIndex + "]" : "";
            this.setToolsSrc(component, ImageViewHandler.getResourcePrefix(item.getNamespace()) + item.getName() + (String)suffix);
        } else {
            this.setToolsSrc(component, null);
        }
    }

    public void setToolsSrc(@NotNull NlComponent component, @Nullable String value) {
        String attr2 = ImageViewHandler.shouldUseSrcCompat(component.getModel()) ? "srcCompat" : "src";
        NlWriteCommandActionUtil.run(component, "Set sample source", () -> component.setAttribute("http://schemas.android.com/tools", attr2, value));
    }

    @Nullable
    public String getToolsSrc(@NotNull NlComponent component) {
        String attr2 = ImageViewHandler.shouldUseSrcCompat(component.getModel()) ? "srcCompat" : "src";
        return component.getAttribute("http://schemas.android.com/tools", attr2);
    }

    @NotNull
    private static String getResourcePrefix(ResourceNamespace namespace) {
        String packageName;
        Object prefix = PredefinedSampleDataResourceRepository.NAMESPACE.equals((Object)namespace) ? "@tools:sample/" : (ResourceNamespace.TODO().equals((Object)namespace) ? "@sample/" : ((packageName = namespace.getPackageName()) != null ? "@" + packageName + ":" + "@sample/".substring(1) : "@sample/"));
        return prefix;
    }

    public static boolean shouldUseSrcCompat(@NotNull NlModel model) {
        return DependencyManagementUtil.dependsOnAppCompat((Module)model.getModule()) && NlModelHelperKt.currentActivityIsDerivedFromAppCompatActivity(model);
    }

    @Nullable
    private ComponentAssistantFactory getComponentAssistant(@NotNull NlComponent component) {
        return context -> new ImageViewAssistant(context, this).getComponent();
    }

    @Override
    public boolean addPopupMenuActions(@NotNull SceneComponent component, @NotNull List<ViewAction> actions) {
        boolean cacheable = super.addPopupMenuActions(component, actions);
        actions.add(new ComponentAssistantViewAction((Function1<? super NlComponent, ? extends ComponentAssistantFactory>)((Function1)this::getComponentAssistant)));
        return cacheable;
    }

    @Override
    public List<ViewAction> getPropertyActions(@NotNull List<NlComponent> components) {
        return ImmutableList.of((Object)new PickDrawableViewAction("http://schemas.android.com/apk/res/android", "src"), (Object)new ScaleTypesViewActionMenu("http://schemas.android.com/apk/res/android", "scaleType"));
    }
}

