/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.AndroidXConstants;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import java.util.EnumSet;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseFragmentHandler
extends ViewHandler {
    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"name", (Object)"layout", (Object)"class", (Object)"navGraph");
    }

    @Override
    @NotNull
    public String getTitleAttributes(@NotNull NlComponent component) {
        String name = component.getAttribute("http://schemas.android.com/apk/res/android", "name");
        return StringUtil.isEmpty((String)name) ? "" : name;
    }

    @Override
    @Language(value="XML")
    @NotNull
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        switch (xmlType) {
            case PREVIEW_ON_PALETTE: 
            case DRAG_PREVIEW: {
                return "";
            }
        }
        return super.getXml(tagName, xmlType);
    }

    @Override
    public boolean onCreate(@Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        if (insertType != InsertType.CREATE) {
            return true;
        }
        NlModel model = newChild.getModel();
        String className = newChild.getAttribute("http://schemas.android.com/apk/res/android", "name");
        if (className != null) {
            if (!"androidx.navigation.fragment.NavHostFragment".equals(className)) {
                return true;
            }
            String src = BaseFragmentHandler.browseNavs(model, null);
            if (src == null) {
                return false;
            }
            return (Boolean)NlWriteCommandActionUtil.compute(newChild, "Create Fragment", () -> {
                newChild.setAttribute("http://schemas.android.com/apk/res-auto", "navGraph", src);
                newChild.setAttribute("http://schemas.android.com/apk/res-auto", "defaultNavHost", "true");
                return true;
            });
        }
        String src = BaseFragmentHandler.browseClasses(model, null);
        if (src == null) {
            return false;
        }
        return (Boolean)NlWriteCommandActionUtil.compute(newChild, "Create Fragment", () -> {
            newChild.setAttribute("http://schemas.android.com/apk/res/android", "name", src);
            return true;
        });
    }

    @Nullable
    static String browseClasses(@NotNull NlModel model, @Nullable String existingValue) {
        return ViewEditor.displayClassInput(model, "Fragments", Sets.newHashSet((Object[])new String[]{"android.app.Fragment", AndroidXConstants.CLASS_V4_FRAGMENT.oldName(), AndroidXConstants.CLASS_V4_FRAGMENT.newName()}), existingValue);
    }

    @Nullable
    static String browseNavs(@NotNull NlModel model, @Nullable String existingValue) {
        return ViewEditor.displayResourceInput(model, "Navigation Graphs", EnumSet.of(ResourceType.NAVIGATION));
    }

    @Override
    public void onActivateInDesignSurface(@NotNull NlComponent component, int x, int y) {
        String graph = component.getAttribute("http://schemas.android.com/apk/res-auto", "navGraph");
        if (graph != null) {
            ViewEditor.openResourceFile(component.getModel(), graph);
        }
    }
}

