/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.api;

import com.android.ide.common.repository.GoogleMavenArtifactId;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.xml.XmlBuilder;
import icons.StudioIcons;
import javax.swing.Icon;
import org.intellij.lang.annotations.Language;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PaletteComponentHandler {
    @Language(value="XML")
    public static final String NO_PREVIEW = "";

    @NotNull
    public String getTitle(@NotNull String tagName) {
        return PaletteComponentHandler.getSimpleTagName(tagName);
    }

    @NotNull
    public Icon getIcon(@NotNull String tagName) {
        return this.loadBuiltinIcon(tagName);
    }

    @Nullable
    public GoogleMavenArtifactId getGradleCoordinateId(@NotNull String tagName) {
        if (tagName.startsWith("android.support.v4.")) {
            return GoogleMavenArtifactId.SUPPORT_V4;
        }
        if (tagName.startsWith("android.support.v7.")) {
            return GoogleMavenArtifactId.SUPPORT_APPCOMPAT_V7;
        }
        if (tagName.startsWith("android.support.design.")) {
            return GoogleMavenArtifactId.SUPPORT_DESIGN;
        }
        if (tagName.startsWith("com.google.android.material.")) {
            return GoogleMavenArtifactId.MATERIAL;
        }
        if (tagName.startsWith("android.support.v17.leanback.")) {
            return GoogleMavenArtifactId.SUPPORT_LEANBACK_V17;
        }
        if (tagName.startsWith("com.google.android.gms.ads.")) {
            return GoogleMavenArtifactId.PLAY_SERVICES_ADS;
        }
        if (tagName.startsWith("com.google.android.gms.maps.")) {
            return GoogleMavenArtifactId.PLAY_SERVICES_MAPS;
        }
        if (tagName.startsWith("android.support.constraint.")) {
            return GoogleMavenArtifactId.CONSTRAINT_LAYOUT;
        }
        if (tagName.startsWith("androidx.constraintlayout.")) {
            return GoogleMavenArtifactId.ANDROIDX_CONSTRAINTLAYOUT;
        }
        if (tagName.startsWith("androidx.recyclerview.")) {
            return GoogleMavenArtifactId.ANDROIDX_RECYCLERVIEW;
        }
        if (tagName.startsWith("androidx.cardview.")) {
            return GoogleMavenArtifactId.ANDROIDX_CARDVIEW;
        }
        if (tagName.startsWith("androidx.gridlayout.")) {
            return GoogleMavenArtifactId.ANDROIDX_GRIDLAYOUT;
        }
        if (tagName.startsWith("androidx.leanback.")) {
            return GoogleMavenArtifactId.ANDROIDX_LEANBACK;
        }
        if (tagName.startsWith("androidx.core.")) {
            return GoogleMavenArtifactId.ANDROIDX_LEGACY_SUPPORT_V4;
        }
        if (tagName.startsWith("androidx.viewpager.")) {
            return GoogleMavenArtifactId.ANDROIDX_VIEWPAGER;
        }
        if (tagName.startsWith("androidx.appcompat.")) {
            return GoogleMavenArtifactId.ANDROIDX_APPCOMPAT;
        }
        if (tagName.startsWith("androidx.coordinatorlayout.")) {
            return GoogleMavenArtifactId.ANDROIDX_COORDINATORLAYOUT;
        }
        return null;
    }

    @NotNull
    @Language(value="XML")
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        return new XmlBuilder().startTag(tagName).androidAttribute("layout_width", "wrap_content").androidAttribute("layout_height", "wrap_content").endTag(tagName).toString();
    }

    public double getPreviewScale(@NotNull String tagName) {
        return 1.0;
    }

    @NotNull
    protected static String getSimpleTagName(@NotNull String tagName) {
        int lastIndex = tagName.lastIndexOf(46);
        return lastIndex < 0 ? tagName : tagName.substring(lastIndex + 1);
    }

    @NotNull
    protected Icon loadBuiltinIcon(@NotNull String tagName) {
        Icon icon2 = AndroidDomElementDescriptorProvider.getIconForViewTag((String)PaletteComponentHandler.getSimpleTagName(tagName));
        return icon2 != null ? icon2 : StudioIcons.LayoutEditor.Palette.VIEW;
    }
}

