/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.preview.animation;

import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.adtui.util.ActionToolbarUtil;
import com.android.tools.idea.common.util.ControllableTicker;
import com.android.tools.idea.preview.PreviewBundle;
import com.android.tools.idea.preview.animation.AnimationTracker;
import com.android.tools.idea.preview.animation.SliderClockControl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.Component;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0005\"#$%&B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u001b\u001a\u00020\u001cH\u0003J\u0016\u0010\u001d\u001a\u00020\u00072\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\u0006\u0010!\u001a\u00020\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0017R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0018\u001a\f\u0012\b\u0012\u00060\u001aR\u00020\u00000\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/tools/idea/preview/animation/PlaybackControls;", "", "clockControl", "Lcom/android/tools/idea/preview/animation/SliderClockControl;", "tracker", "Lcom/android/tools/idea/preview/animation/AnimationTracker;", "rootComponent", "Ljavax/swing/JComponent;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/android/tools/idea/preview/animation/SliderClockControl;Lcom/android/tools/idea/preview/animation/AnimationTracker;Ljavax/swing/JComponent;Lcom/intellij/openapi/Disposable;)V", "getClockControl", "()Lcom/android/tools/idea/preview/animation/SliderClockControl;", "getTracker", "()Lcom/android/tools/idea/preview/animation/AnimationTracker;", "getRootComponent", "()Ljavax/swing/JComponent;", "playPauseAction", "Lcom/android/tools/idea/preview/animation/PlaybackControls$PlayPauseAction;", "loopAction", "Lcom/android/tools/idea/preview/animation/PlaybackControls$TimelineLoopAction;", "speedAction", "Lcom/android/tools/idea/preview/animation/PlaybackControls$TimelineSpeedAction;", "toolbars", "", "Lcom/android/tools/idea/preview/animation/PlaybackControls$PlaybackToolbar;", "updateActionsAsync", "", "createToolbar", "extraActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "pause", "TimelineSpeed", "PlaybackToolbar", "PlayPauseAction", "TimelineSpeedAction", "TimelineLoopAction", "intellij.android.preview-designer"})
@SourceDebugExtension(value={"SMAP\nPlaybackControls.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlaybackControls.kt\ncom/android/tools/idea/preview/animation/PlaybackControls\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,307:1\n1869#2,2:308\n1#3:310\n*S KotlinDebug\n*F\n+ 1 PlaybackControls.kt\ncom/android/tools/idea/preview/animation/PlaybackControls\n*L\n66#1:308,2\n*E\n"})
public final class PlaybackControls {
    @NotNull
    private final SliderClockControl clockControl;
    @NotNull
    private final AnimationTracker tracker;
    @NotNull
    private final JComponent rootComponent;
    @NotNull
    private final PlayPauseAction playPauseAction;
    @NotNull
    private final TimelineLoopAction loopAction;
    @NotNull
    private final TimelineSpeedAction speedAction;
    @NotNull
    private final List<PlaybackToolbar> toolbars;

    public PlaybackControls(@NotNull SliderClockControl clockControl, @NotNull AnimationTracker tracker, @NotNull JComponent rootComponent, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)clockControl, (String)"clockControl");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Intrinsics.checkNotNullParameter((Object)rootComponent, (String)"rootComponent");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.clockControl = clockControl;
        this.tracker = tracker;
        this.rootComponent = rootComponent;
        this.playPauseAction = new PlayPauseAction(parentDisposable);
        this.loopAction = new TimelineLoopAction();
        this.speedAction = new TimelineSpeedAction();
        this.toolbars = new ArrayList();
    }

    @NotNull
    public final SliderClockControl getClockControl() {
        return this.clockControl;
    }

    @NotNull
    public final AnimationTracker getTracker() {
        return this.tracker;
    }

    @NotNull
    public final JComponent getRootComponent() {
        return this.rootComponent;
    }

    @RequiresEdt
    private final void updateActionsAsync() {
        Iterable $this$forEach$iv = this.toolbars;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlaybackToolbar it = (PlaybackToolbar)element$iv;
            boolean bl = false;
            it.getPlaybackControls().updateActionsAsync();
        }
    }

    @NotNull
    public final JComponent createToolbar(@NotNull List<? extends AnAction> extraActions) {
        PlaybackToolbar playbackToolbar;
        Intrinsics.checkNotNullParameter(extraActions, (String)"extraActions");
        PlaybackToolbar it = playbackToolbar = new PlaybackToolbar(extraActions);
        boolean bl = false;
        this.toolbars.add(it);
        return playbackToolbar.getComponent();
    }

    public static /* synthetic */ JComponent createToolbar$default(PlaybackControls playbackControls, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        return playbackControls.createToolbar(list);
    }

    public final void pause() {
        this.playPauseAction.pause();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0002J\u0006\u0010\u0017\u001a\u00020\u0010J\b\u0010\u0018\u001a\u00020\u0010H\u0002J\b\u0010\u0019\u001a\u00020\u0010H\u0016R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/preview/animation/PlaybackControls$PlayPauseAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/Disposable;", "parentDisposable", "<init>", "(Lcom/android/tools/idea/preview/animation/PlaybackControls;Lcom/intellij/openapi/Disposable;)V", "tickPeriod", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "ticker", "Lcom/android/tools/idea/common/util/ControllableTicker;", "value", "", "isPlaying", "()Z", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "play", "pause", "handleLoopEnd", "dispose", "intellij.android.preview-designer"})
    private final class PlayPauseAction
    extends DumbAwareAction
    implements Disposable {
        private final Duration tickPeriod;
        @NotNull
        private final ControllableTicker ticker;
        private boolean isPlaying;

        public PlayPauseAction(Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            super(PreviewBundle.INSTANCE.message("animation.inspector.action.play", new Object[0]), null, StudioIcons.LayoutEditor.Motion.PLAY);
            this.tickPeriod = Duration.ofMillis(30L);
            Function0 function0 = () -> PlayPauseAction.ticker$lambda$0(this, PlaybackControls.this);
            Duration duration = this.tickPeriod;
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"tickPeriod");
            this.ticker = new ControllableTicker(function0, duration, null, 4, null);
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
        }

        public final boolean isPlaying() {
            return this.isPlaying;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.isPlaying) {
                this.pause();
                PlaybackControls.this.getTracker().triggerPauseAction();
            } else {
                this.play();
                PlaybackControls.this.getTracker().triggerPlayAction();
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation presentation;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabled(true);
            Presentation $this$update_u24lambda_u240 = presentation = e.getPresentation();
            boolean bl = false;
            if (this.isPlaying) {
                $this$update_u24lambda_u240.setIcon(AllIcons.Actions.Pause);
                $this$update_u24lambda_u240.setText(PreviewBundle.INSTANCE.message("animation.inspector.action.pause", new Object[0]));
            } else {
                $this$update_u24lambda_u240.setIcon(StudioIcons.LayoutEditor.Motion.PLAY);
                $this$update_u24lambda_u240.setText(PreviewBundle.INSTANCE.message("animation.inspector.action.play", new Object[0]));
            }
        }

        private final void play() {
            if (PlaybackControls.this.getClockControl().isAtEnd()) {
                PlaybackControls.this.getClockControl().jumpToStart();
            }
            this.isPlaying = true;
            this.ticker.start();
        }

        public final void pause() {
            this.isPlaying = false;
            this.ticker.stop();
        }

        private final void handleLoopEnd() {
            UIUtil.invokeLaterIfNeeded(() -> PlayPauseAction.handleLoopEnd$lambda$0(PlaybackControls.this));
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.ticker);
        }

        private static final Unit ticker$lambda$0(PlayPauseAction this$0, PlaybackControls this$1) {
            if (this$0.isPlaying) {
                UIUtil.invokeLaterIfNeeded(() -> PlayPauseAction.ticker$lambda$0$0(this$1, this$0));
                if (this$1.getClockControl().isAtEnd()) {
                    if (this$1.getClockControl().getPlayInLoop()) {
                        this$0.handleLoopEnd();
                    } else {
                        this$0.pause();
                        UIUtil.invokeLaterIfNeeded(() -> PlayPauseAction.ticker$lambda$0$1(this$1));
                    }
                }
            }
            return Unit.INSTANCE;
        }

        private static final void ticker$lambda$0$0(PlaybackControls this$0, PlayPauseAction this$1) {
            this$0.getClockControl().incrementClockBy((int)this$1.tickPeriod.toMillis());
        }

        private static final void ticker$lambda$0$1(PlaybackControls this$0) {
            this$0.updateActionsAsync();
        }

        private static final void handleLoopEnd$lambda$0(PlaybackControls this$0) {
            this$0.getClockControl().jumpToStart();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/preview/animation/PlaybackControls$PlaybackToolbar;", "", "extraActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "(Lcom/android/tools/idea/preview/animation/PlaybackControls;Ljava/util/List;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "playbackControls", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "Lorg/jetbrains/annotations/NotNull;", "getPlaybackControls", "()Lcom/intellij/openapi/actionSystem/ActionToolbar;", "playPauseComponent", "Ljava/awt/Component;", "getPlayPauseComponent", "()Ljava/awt/Component;", "GoToStartAction", "GoToEndAction", "intellij.android.preview-designer"})
    private final class PlaybackToolbar {
        @NotNull
        private final ActionToolbar playbackControls;

        /*
         * WARNING - void declaration
         */
        public PlaybackToolbar(List<? extends AnAction> extraActions) {
            void $this$playbackControls_u24lambda_u240;
            Intrinsics.checkNotNullParameter(extraActions, (String)"extraActions");
            AnAction[] anActionArray = new AnAction[]{PlaybackControls.this.loopAction, new GoToStartAction(), PlaybackControls.this.playPauseAction, new GoToEndAction(), PlaybackControls.this.speedAction, new Separator()};
            anActionArray = ActionManager.getInstance().createActionToolbar("Animation Preview", (ActionGroup)new DefaultActionGroup(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])anActionArray), (Iterable)extraActions)), true);
            PlaybackControls playbackControls = PlaybackControls.this;
            AnAction[] anActionArray2 = anActionArray;
            PlaybackToolbar playbackToolbar = this;
            boolean bl = false;
            $this$playbackControls_u24lambda_u240.setTargetComponent(playbackControls.getRootComponent());
            Intrinsics.checkNotNull((Object)$this$playbackControls_u24lambda_u240);
            ActionToolbarUtil.makeToolbarNavigable((ActionToolbar)$this$playbackControls_u24lambda_u240);
            AnAction[] anActionArray3 = anActionArray;
            Intrinsics.checkNotNullExpressionValue((Object)anActionArray3, (String)"apply(...)");
            playbackToolbar.playbackControls = anActionArray3;
        }

        @NotNull
        public final JComponent getComponent() {
            JComponent jComponent = this.playbackControls.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            return jComponent;
        }

        @NotNull
        public final ActionToolbar getPlaybackControls() {
            return this.playbackControls;
        }

        private final Component getPlayPauseComponent() {
            Object[] objectArray = this.playbackControls.getComponent().getComponents();
            return objectArray != null ? (Component)ArraysKt.getOrNull((Object[])objectArray, (int)2) : null;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/preview/animation/PlaybackControls$PlaybackToolbar$GoToEndAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "(Lcom/android/tools/idea/preview/animation/PlaybackControls$PlaybackToolbar;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.android.preview-designer"})
        public final class GoToEndAction
        extends DumbAwareAction {
            public GoToEndAction() {
                super(PreviewBundle.INSTANCE.message("animation.inspector.action.go.to.end", new Object[0]), null, StudioIcons.LayoutEditor.Motion.GO_TO_END);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    PlaybackControls.this.getClockControl().jumpToEnd();
                    PlaybackControls.this.getTracker().triggerJumpToEndAction();
                    if (PlaybackControls.this.playPauseAction.isPlaying() && PlaybackControls.this.getClockControl().getPlayInLoop()) break block1;
                    Component component = PlaybackToolbar.this.getPlayPauseComponent();
                    if (component != null) {
                        component.requestFocus();
                    }
                }
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(!PlaybackControls.this.getClockControl().isAtEnd());
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/preview/animation/PlaybackControls$PlaybackToolbar$GoToStartAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "(Lcom/android/tools/idea/preview/animation/PlaybackControls$PlaybackToolbar;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.android.preview-designer"})
        public final class GoToStartAction
        extends DumbAwareAction {
            public GoToStartAction() {
                super(PreviewBundle.INSTANCE.message("animation.inspector.action.go.to.start", new Object[0]), null, StudioIcons.LayoutEditor.Motion.GO_TO_START);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    PlaybackControls.this.getClockControl().jumpToStart();
                    PlaybackControls.this.getTracker().triggerJumpToStartAction();
                    if (PlaybackControls.this.playPauseAction.isPlaying()) break block1;
                    Component component = PlaybackToolbar.this.getPlayPauseComponent();
                    if (component != null) {
                        component.requestFocus();
                    }
                }
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(!PlaybackControls.this.getClockControl().isAtStart());
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/preview/animation/PlaybackControls$TimelineLoopAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "<init>", "(Lcom/android/tools/idea/preview/animation/PlaybackControls;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.android.preview-designer"})
    private final class TimelineLoopAction
    extends ToggleAction {
        public TimelineLoopAction() {
            super(PreviewBundle.INSTANCE.message("animation.inspector.action.loop", new Object[0]), PreviewBundle.INSTANCE.message("animation.inspector.action.loop", new Object[0]), StudioIcons.LayoutEditor.Motion.LOOP);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return PlaybackControls.this.getClockControl().getPlayInLoop();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            PlaybackControls.this.getClockControl().setPlayInLoop(state);
            if (state) {
                PlaybackControls.this.getTracker().enableLoopAction();
            } else {
                PlaybackControls.this.getTracker().disableLoopAction();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/preview/animation/PlaybackControls$TimelineSpeed;", "", "speedMultiplier", "", "displayText", "", "<init>", "(Ljava/lang/String;IFLjava/lang/String;)V", "getSpeedMultiplier", "()F", "getDisplayText", "()Ljava/lang/String;", "X_0_1", "X_0_25", "X_0_5", "X_0_75", "X_1", "X_2", "intellij.android.preview-designer"})
    public static final class TimelineSpeed
    extends Enum<TimelineSpeed> {
        private final float speedMultiplier;
        @NotNull
        private final String displayText;
        public static final /* enum */ TimelineSpeed X_0_1 = new TimelineSpeed(0.1f, "0.1x");
        public static final /* enum */ TimelineSpeed X_0_25 = new TimelineSpeed(0.25f, "0.25x");
        public static final /* enum */ TimelineSpeed X_0_5 = new TimelineSpeed(0.5f, "0.5x");
        public static final /* enum */ TimelineSpeed X_0_75 = new TimelineSpeed(0.75f, "0.75x");
        public static final /* enum */ TimelineSpeed X_1 = new TimelineSpeed(1.0f, "1x");
        public static final /* enum */ TimelineSpeed X_2 = new TimelineSpeed(2.0f, "2x");
        private static final /* synthetic */ TimelineSpeed[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private TimelineSpeed(float speedMultiplier, String displayText) {
            this.speedMultiplier = speedMultiplier;
            this.displayText = displayText;
        }

        public final float getSpeedMultiplier() {
            return this.speedMultiplier;
        }

        @NotNull
        public final String getDisplayText() {
            return this.displayText;
        }

        public static TimelineSpeed[] values() {
            return (TimelineSpeed[])$VALUES.clone();
        }

        public static TimelineSpeed valueOf(String value) {
            return Enum.valueOf(TimelineSpeed.class, value);
        }

        @NotNull
        public static EnumEntries<TimelineSpeed> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = timelineSpeedArray = new TimelineSpeed[]{TimelineSpeed.X_0_1, TimelineSpeed.X_0_25, TimelineSpeed.X_0_5, TimelineSpeed.X_0_75, TimelineSpeed.X_1, TimelineSpeed.X_2};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/preview/animation/PlaybackControls$TimelineSpeedAction;", "Lcom/android/tools/adtui/actions/DropDownAction;", "<init>", "(Lcom/android/tools/idea/preview/animation/PlaybackControls;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "SpeedAction", "intellij.android.preview-designer"})
    @SourceDebugExtension(value={"SMAP\nPlaybackControls.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlaybackControls.kt\ncom/android/tools/idea/preview/animation/PlaybackControls$TimelineSpeedAction\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,307:1\n13472#2,2:308\n*S KotlinDebug\n*F\n+ 1 PlaybackControls.kt\ncom/android/tools/idea/preview/animation/PlaybackControls$TimelineSpeedAction\n*L\n260#1:308,2\n*E\n"})
    private final class TimelineSpeedAction
    extends DropDownAction {
        public TimelineSpeedAction() {
            super(PreviewBundle.INSTANCE.message("animation.inspector.action.speed", new Object[0]), PreviewBundle.INSTANCE.message("animation.inspector.action.speed", new Object[0]), null);
            TimelineSpeed[] $this$forEach$iv = TimelineSpeed.values();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                TimelineSpeed element$iv;
                TimelineSpeed it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                this.addAction((AnAction)new SpeedAction(it));
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setText(PlaybackControls.this.getClockControl().getSpeed().getDisplayText());
            e.getPresentation().putClientProperty(ActionUtil.SHOW_TEXT_IN_TOOLBAR, (Object)true);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/preview/animation/PlaybackControls$TimelineSpeedAction$SpeedAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "speed", "Lcom/android/tools/idea/preview/animation/PlaybackControls$TimelineSpeed;", "<init>", "(Lcom/android/tools/idea/preview/animation/PlaybackControls$TimelineSpeedAction;Lcom/android/tools/idea/preview/animation/PlaybackControls$TimelineSpeed;)V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "setSelected", "", "state", "intellij.android.preview-designer"})
        private final class SpeedAction
        extends ToggleAction {
            @NotNull
            private final TimelineSpeed speed;

            public SpeedAction(TimelineSpeed speed) {
                Intrinsics.checkNotNullParameter((Object)((Object)speed), (String)"speed");
                super(speed.getDisplayText(), speed.getDisplayText(), null);
                this.speed = speed;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return PlaybackControls.this.getClockControl().getSpeed() == this.speed;
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                PlaybackControls.this.getClockControl().setSpeed(this.speed);
                PlaybackControls.this.getTracker().changeAnimationSpeed(this.speed.getSpeedMultiplier());
            }
        }
    }
}

