/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.preview.analytics;

import com.android.tools.idea.preview.analytics.PreviewRefreshTracker;
import com.google.wireless.android.sdk.stats.PreviewRefreshEvent;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J0\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u0006\u0010!\u001a\u00020\u0014J\u0006\u0010\"\u001a\u00020\u0014J\u0006\u0010#\u001a\u00020\u0014J\u000e\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&J\b\u0010'\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/idea/preview/analytics/PreviewRefreshEventBuilder;", "", "type", "Lcom/google/wireless/android/sdk/stats/PreviewRefreshEvent$PreviewType;", "tracker", "Lcom/android/tools/idea/preview/analytics/PreviewRefreshTracker;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "<init>", "(Lcom/google/wireless/android/sdk/stats/PreviewRefreshEvent$PreviewType;Lcom/android/tools/idea/preview/analytics/PreviewRefreshTracker;Lcom/intellij/openapi/diagnostic/Logger;)V", "eventBuilder", "Lcom/google/wireless/android/sdk/stats/PreviewRefreshEvent$Builder;", "kotlin.jvm.PlatformType", "enqueueMs", "", "Ljava/lang/Long;", "startMs", "tracked", "Ljava/util/concurrent/atomic/AtomicBoolean;", "withPreviewsToRefresh", "", "count", "", "withPreviewsCount", "addPreviewRenderDetails", "renderError", "", "inflate", "renderQuality", "", "renderTimeMillis", "renderExceptionSimpleName", "", "onRequestEnqueued", "onRequestSkipped", "onRefreshStarted", "onRefreshCompleted", "result", "Lcom/google/wireless/android/sdk/stats/PreviewRefreshEvent$RefreshResult;", "track", "intellij.android.preview-designer"})
@SourceDebugExtension(value={"SMAP\nPreviewRefreshTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewRefreshTracker.kt\ncom/android/tools/idea/preview/analytics/PreviewRefreshEventBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n1#2:187\n*E\n"})
public final class PreviewRefreshEventBuilder {
    @NotNull
    private final PreviewRefreshTracker tracker;
    @NotNull
    private final Logger logger;
    private final PreviewRefreshEvent.Builder eventBuilder;
    @Nullable
    private Long enqueueMs;
    @Nullable
    private Long startMs;
    @NotNull
    private final AtomicBoolean tracked;

    public PreviewRefreshEventBuilder(@NotNull PreviewRefreshEvent.PreviewType type, @NotNull PreviewRefreshTracker tracker, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.tracker = tracker;
        this.logger = logger;
        this.eventBuilder = PreviewRefreshEvent.newBuilder().setType(type);
        this.tracked = new AtomicBoolean(false);
    }

    public /* synthetic */ PreviewRefreshEventBuilder(PreviewRefreshEvent.PreviewType previewType, PreviewRefreshTracker previewRefreshTracker, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Logger logger2 = Logger.getInstance(PreviewRefreshEventBuilder.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger = logger2;
        }
        this(previewType, previewRefreshTracker, logger);
    }

    public final void withPreviewsToRefresh(int count) {
        this.eventBuilder.setPreviewsToRefresh(count);
    }

    public final void withPreviewsCount(int count) {
        this.eventBuilder.setPreviewsCount(count);
    }

    public final void addPreviewRenderDetails(boolean renderError, boolean inflate2, float renderQuality, long renderTimeMillis, @Nullable String renderExceptionSimpleName) {
        if (renderQuality < 0.0f || 1.0f < renderQuality) {
            this.logger.warn("Attempted to log a render with not valid quality: " + renderQuality);
        }
        PreviewRefreshEvent.SinglePreviewRender.Builder previewRenders = PreviewRefreshEvent.SinglePreviewRender.newBuilder().setResult(renderError ? PreviewRefreshEvent.SinglePreviewRender.RenderResult.ERROR : PreviewRefreshEvent.SinglePreviewRender.RenderResult.SUCCESS).setInflate(inflate2).setRenderQuality(RangesKt.coerceIn((float)renderQuality, (float)0.0f, (float)1.0f)).setRenderTimeMillis((int)renderTimeMillis);
        CharSequence charSequence = renderExceptionSimpleName;
        this.eventBuilder.addPreviewRenders(charSequence == null || charSequence.length() == 0 ? previewRenders : previewRenders.setRenderExceptionSimpleName(renderExceptionSimpleName));
    }

    public final void onRequestEnqueued() {
        this.enqueueMs = System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    public final void onRequestSkipped() {
        long l;
        PreviewRefreshEvent.Builder builder = this.eventBuilder;
        Long l2 = this.enqueueMs;
        if (l2 != null) {
            void it;
            long l3 = ((Number)l2).longValue();
            PreviewRefreshEvent.Builder builder2 = builder;
            boolean bl = false;
            long l4 = System.currentTimeMillis() - it;
            builder = builder2;
            l = l4;
        } else {
            l = 0L;
        }
        builder.setInQueueTimeMillis((int)l);
        this.eventBuilder.setResult(PreviewRefreshEvent.RefreshResult.SKIPPED);
        this.track();
    }

    public final void onRefreshStarted() {
        this.startMs = System.currentTimeMillis();
        if (this.enqueueMs == null) {
            this.logger.warn("Expected not null enqueueMs");
        } else {
            Long l = this.startMs;
            Intrinsics.checkNotNull((Object)l);
            long l2 = l;
            Long l3 = this.enqueueMs;
            Intrinsics.checkNotNull((Object)l3);
            this.eventBuilder.setInQueueTimeMillis((int)(l2 - l3));
        }
    }

    public final void onRefreshCompleted(@NotNull PreviewRefreshEvent.RefreshResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (this.startMs == null) {
            this.logger.warn("Expected not null startMs");
        } else {
            long l = System.currentTimeMillis();
            Long l2 = this.startMs;
            Intrinsics.checkNotNull((Object)l2);
            this.eventBuilder.setRefreshTimeMillis((int)(l - l2));
        }
        this.eventBuilder.setResult(result);
        this.track();
    }

    private final void track() {
        if (!this.tracked.getAndSet(true)) {
            PreviewRefreshEvent previewRefreshEvent = this.eventBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)previewRefreshEvent, (String)"build(...)");
            this.tracker.logEvent(previewRefreshEvent);
        } else {
            this.logger.warn("Attempted to log the same refresh event more than once");
        }
    }
}

