/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.property.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.naveditor.dialogs.AddActionDialog;
import com.android.tools.idea.naveditor.dialogs.AddActionDialogKt;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.property.inspector.ComponentListInspectorBuilder;
import com.android.tools.idea.naveditor.property.ui.ActionCellRenderer;
import com.android.tools.idea.uibuilder.property.NlPropertiesModel;
import com.google.wireless.android.sdk.stats.NavEditorEvent;
import com.intellij.openapi.Disposable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.components.JBList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0014J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0014J\u0016\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0014J\u001a\u0010\u0015\u001a\u00020\r2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/naveditor/property/inspector/ActionListInspectorBuilder;", "Lcom/android/tools/idea/naveditor/property/inspector/ComponentListInspectorBuilder;", "model", "Lcom/android/tools/idea/uibuilder/property/NlPropertiesModel;", "<init>", "(Lcom/android/tools/idea/uibuilder/property/NlPropertiesModel;)V", "title", "", "component", "Lcom/android/tools/idea/common/model/NlComponent;", "addActionText", "deleteActionText", "onAdd", "", "parent", "onEdit", "onSelectionChanged", "list", "Lcom/intellij/ui/components/JBList;", "isApplicable", "", "invokeDialog", "intellij.android.nav.editor"})
@SourceDebugExtension(value={"SMAP\nActionListInspectorBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionListInspectorBuilder.kt\ncom/android/tools/idea/naveditor/property/inspector/ActionListInspectorBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class ActionListInspectorBuilder
extends ComponentListInspectorBuilder {
    @NotNull
    private final NlPropertiesModel model;

    public ActionListInspectorBuilder(@NotNull NlPropertiesModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super("action", (ColoredListCellRenderer<NlComponent>)((ColoredListCellRenderer)new ActionCellRenderer()));
        this.model = model;
    }

    @Override
    @NotNull
    public String title(@NotNull NlComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return NavComponentHelperKt.isNavigation(component) ? "Global Actions" : "Actions";
    }

    @Override
    @NotNull
    protected String addActionText(@NotNull NlComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return NavComponentHelperKt.isNavigation(component) ? "Add global action" : "Add action";
    }

    @Override
    @NotNull
    protected String deleteActionText(@NotNull NlComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return NavComponentHelperKt.isNavigation(component) ? "Remove global action" : "Remove action";
    }

    @Override
    protected void onAdd(@NotNull NlComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.invokeDialog(null, parent);
    }

    @Override
    protected void onEdit(@NotNull NlComponent component) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            NlComponent nlComponent = component.getParent();
            if (nlComponent == null) break block0;
            NlComponent it = nlComponent;
            boolean bl = false;
            this.invokeDialog(component, it);
        }
    }

    @Override
    protected void onSelectionChanged(@NotNull JBList<NlComponent> list) {
        block4: {
            Disposable disposable;
            block3: {
                Intrinsics.checkNotNullParameter(list, (String)"list");
                boolean removed = false;
                int n = list.getModel().getSize();
                for (int i = 0; i < n; ++i) {
                    NlComponent element = (NlComponent)list.getModel().getElementAt(i);
                    if (element.removeClientProperty("actionHighlighted") == null) continue;
                    boolean bl = false;
                    removed = true;
                }
                for (NlComponent element : list.getSelectedValuesList()) {
                    element.putClientProperty("actionHighlighted", true);
                }
                if (removed) break block3;
                List list2 = list.getSelectedValuesList();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getSelectedValuesList(...)");
                if (!(!((Collection)list2).isEmpty())) break block4;
            }
            if ((disposable = this.model.getSurface()) != null && (disposable = disposable.getScene()) != null) {
                Disposable it = disposable;
                boolean bl = false;
                it.needsRebuildList();
                it.repaint();
            }
        }
    }

    @Override
    protected boolean isApplicable(@NotNull NlComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return NavComponentHelperKt.getSupportsActions(component);
    }

    private final void invokeDialog(NlComponent component, NlComponent parent) {
        AddActionDialog dialog = new AddActionDialog(AddActionDialog.Defaults.NORMAL, component, parent, NavEditorEvent.Source.PROPERTY_INSPECTOR);
        AddActionDialogKt.showAndUpdateFromDialog(dialog, parent.getModel(), component != null);
    }
}

