/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.dialogs;

import com.android.tools.adtui.model.stdui.CommonTextFieldModel;
import com.android.tools.adtui.stdui.CommonTextField;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.naveditor.dialogs.ActionTextFieldModel;
import com.android.tools.idea.naveditor.dialogs.MimeTypeTextFieldModel;
import com.android.tools.idea.naveditor.dialogs.UriTextFieldModel;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.SettableValue;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.ui.EnabledProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.Token;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.NavEditorEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddDeeplinkDialog
extends DialogWrapper {
    @VisibleForTesting
    CommonTextField<UriTextFieldModel> myUriField;
    @VisibleForTesting
    JCheckBox myAutoVerify;
    @VisibleForTesting
    CommonTextField<MimeTypeTextFieldModel> myMimeTypeField;
    @VisibleForTesting
    CommonTextField<ActionTextFieldModel> myActionField;
    JBLabel myMimeTypeLabel;
    JBLabel myActionLabel;
    private JPanel myContentPanel;
    @Nullable
    private final NlComponent myExistingComponent;
    @NotNull
    private final NlComponent myParent;
    private final BindingsManager myBindings = new BindingsManager();
    private final boolean myIsExtended;

    public AddDeeplinkDialog(@Nullable NlComponent existing, @NotNull NlComponent parent) {
        super(false);
        this.setupUI();
        List<String> argumentNames = NavComponentHelperKt.getArgumentNames(parent);
        ((UriTextFieldModel)this.myUriField.getEditorModel()).setArgumentNames(argumentNames);
        ((ActionTextFieldModel)this.myActionField.getEditorModel()).populateCompletions(parent.getModel().getModule());
        if (existing != null) {
            this.myUriField.setText(NavComponentHelperKt.getUri(existing));
            this.myAutoVerify.setSelected(Boolean.parseBoolean(existing.getAttribute("http://schemas.android.com/apk/res/android", "autoVerify")));
            this.myMimeTypeField.setText(NavComponentHelperKt.getDeepLinkMimeType(existing));
            this.myActionField.setText(NavComponentHelperKt.getDeepLinkAction(existing));
        }
        this.init();
        if (existing == null) {
            this.myOKAction.putValue("Name", "Add");
            this.setTitle("Add Deep Link");
        } else {
            this.myOKAction.putValue("Name", "Update");
            this.setTitle("Update Deep Link");
        }
        this.myExistingComponent = existing;
        this.myParent = parent;
        this.myIsExtended = AddDeeplinkDialog.isExtended(parent);
        if (this.myIsExtended) {
            ObservableBool isNotEmpty = new TextProperty(this.myUriField).isEmpty().not();
            this.myBindings.bind((SettableValue)new EnabledProperty((JComponent)this.myAutoVerify), (ObservableValue)isNotEmpty);
        } else {
            this.myMimeTypeField.setVisible(false);
            this.myActionField.setVisible(false);
            this.myMimeTypeLabel.setVisible(false);
            this.myActionLabel.setVisible(false);
        }
    }

    @Nullable
    protected ValidationInfo doValidate() {
        int index;
        String mimeType;
        String uri = this.myUriField.getText();
        if (!uri.isEmpty()) {
            try {
                new URI(uri.replaceAll("\\{[^}]*}", "dummy"));
            }
            catch (URISyntaxException e) {
                return new ValidationInfo("Invalid URI!", this.myUriField);
            }
        }
        if (!((mimeType = this.myMimeTypeField.getText()).isEmpty() || (index = mimeType.indexOf(47)) >= 1 && index != mimeType.length() - 1)) {
            return new ValidationInfo("Invalid MIME type.");
        }
        if (uri.isEmpty() && mimeType.isEmpty() && this.myActionField.getText().isEmpty()) {
            String text = this.myIsExtended ? "Uri, MIME type, and action cannot all be empty." : "URI must be set!";
            return new ValidationInfo(text, this.myUriField);
        }
        return null;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    @VisibleForTesting
    String getUri() {
        return this.myUriField.getText();
    }

    @VisibleForTesting
    public boolean getAutoVerify() {
        return this.myAutoVerify.isSelected();
    }

    @VisibleForTesting
    public String getMimeType() {
        return this.myMimeTypeField.getText();
    }

    @VisibleForTesting
    public String getAction() {
        return this.myActionField.getText();
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction()};
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myUriField;
    }

    public void save() {
        String name = this.myExistingComponent == null ? "Add Deep Link" : "Update Deep Link";
        NlWriteCommandActionUtil.run(this.myParent, name, () -> {
            NlComponent realComponent = this.myExistingComponent;
            if (realComponent == null) {
                realComponent = NlComponentHelperKt.createChild(this.myParent, "deepLink", false, null, null, null, InsertType.CREATE);
                if (realComponent == null) {
                    ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)this.myParent.getModel().getProject(), (String)"Failed to create Deep Link!", (String)"Error"));
                    return;
                }
                realComponent.ensureId();
            }
            NavComponentHelperKt.setUriAndLog(realComponent, this.getUri(), NavEditorEvent.Source.PROPERTY_INSPECTOR);
            NavComponentHelperKt.setAutoVerifyAndLog(realComponent, this.getAutoVerify() && !this.getUri().isEmpty(), NavEditorEvent.Source.PROPERTY_INSPECTOR);
            NavComponentHelperKt.setDeeplinkMimeTypeAndLog(realComponent, this.getMimeType(), NavEditorEvent.Source.PROPERTY_INSPECTOR);
            NavComponentHelperKt.setDeeplinkActionAndLog(realComponent, this.getAction(), NavEditorEvent.Source.PROPERTY_INSPECTOR);
        });
    }

    private void createUIComponents() {
        this.myUriField = new CommonTextField((CommonTextFieldModel)new UriTextFieldModel());
        this.myMimeTypeField = new CommonTextField((CommonTextFieldModel)new MimeTypeTextFieldModel());
        this.myActionField = new CommonTextField((CommonTextFieldModel)new ActionTextFieldModel());
    }

    private void setupUI() {
        this.createUIComponents();
        this.myContentPanel = new JPanel();
        this.myContentPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(15, 7, 0, 7), -1, -1));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("URI");
        this.myContentPanel.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Auto Verify");
        this.myContentPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myMimeTypeLabel = new JBLabel();
        this.myMimeTypeLabel.setText("MIME type");
        this.myContentPanel.add((Component)this.myMimeTypeLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myActionLabel = new JBLabel();
        this.myActionLabel.setText("Action");
        this.myContentPanel.add((Component)this.myActionLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myContentPanel.add((Component)spacer1, new GridConstraints(1, 1, 1, 1, 0, 1, 4, 1, null, new Dimension(20, -1), null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myContentPanel.add((Component)panel1, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myUriField.setText("");
        panel1.add((Component)this.myUriField, new GridConstraints(0, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(320, -1), null, 0, false));
        this.myAutoVerify = new JCheckBox();
        this.myAutoVerify.setText("");
        this.myContentPanel.add((Component)this.myAutoVerify, new GridConstraints(1, 2, 1, 1, 0, 1, 0, 0, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myContentPanel.add((Component)panel2, new GridConstraints(2, 2, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        panel2.add((Component)this.myMimeTypeField, new GridConstraints(0, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(320, -1), null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myContentPanel.add((Component)panel3, new GridConstraints(3, 2, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        panel3.add((Component)this.myActionField, new GridConstraints(0, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(320, -1), null, 0, false));
    }

    private static boolean isExtended(@NotNull NlComponent parent) {
        Project project = parent.getModel().getProject();
        AndroidProjectSystem projectSystem = ProjectSystemUtil.getProjectSystem((Project)project);
        Optional<AddDeeplinkDialogToken> token = AddDeeplinkDialogToken.EP_NAME.getExtensionList().stream().filter(it -> it.isApplicable(projectSystem)).findFirst();
        return token.map(it -> it.isExtended(projectSystem, parent)).orElse(true);
    }

    public static interface AddDeeplinkDialogToken<P extends AndroidProjectSystem>
    extends Token {
        public static final ExtensionPointName<AddDeeplinkDialogToken<AndroidProjectSystem>> EP_NAME = new ExtensionPointName("com.android.tools.idea.naveditor.dialogs.addDeeplinkDialogToken");

        public boolean isExtended(@NotNull P var1, @NotNull NlComponent var2);
    }
}

