/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.util;

import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.configurations.Configuration;
import com.android.tools.configurations.ConfigurationUtilKt;
import com.android.tools.configurations.DeviceSize;
import com.android.tools.idea.compose.pickers.preview.enumsupport.UiMode;
import com.android.tools.idea.compose.pickers.preview.enumsupport.Wallpaper;
import com.android.tools.idea.compose.preview.util.NightMode;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ReferenceDevice;
import com.android.tools.preview.ComposePreviewElementInstance;
import com.android.tools.preview.PreviewConfiguration;
import com.android.tools.preview.PreviewDisplaySettings;
import com.android.tools.preview.config.Cutout;
import com.android.tools.preview.config.DeviceConfig;
import com.android.tools.preview.config.DeviceUtilsKt;
import com.android.tools.preview.config.Navigation;
import com.android.tools.preview.config.Preview;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0005H\u0002\u001a$\u0010\u000b\u001a\u00060\fj\u0002`\r*\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002H\u0002\u001a\u0014\u0010\u0010\u001a\u00060\fj\u0002`\r*\u00060\fj\u0002`\rH\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a$\u0010\u0014\u001a\u00020\u00022\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0002H\u0000\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"referenceDeviceIds", "", "", "kotlin.jvm.PlatformType", "UI_MODE_NIGHT_MASK", "", "UI_MODE_TYPE_MASK", "uiModeToString", "uiMode", "wallpaperToString", "wallpaperValue", "appendParamValue", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "parameterName", "value", "appendSeparator", "createDeviceSpec", "configuration", "Lcom/android/tools/configurations/Configuration;", "toPreviewAnnotationText", "previewElement", "Lcom/android/tools/preview/ComposePreviewElementInstance;", "name", "intellij.android.compose-designer"})
@SourceDebugExtension(value={"SMAP\nPreviewAnnotationGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewAnnotationGenerator.kt\ncom/android/tools/idea/compose/preview/util/PreviewAnnotationGeneratorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,289:1\n1#2:290\n1563#3:291\n1634#3,3:292\n*S KotlinDebug\n*F\n+ 1 PreviewAnnotationGenerator.kt\ncom/android/tools/idea/compose/preview/util/PreviewAnnotationGeneratorKt\n*L\n43#1:291\n43#1:292,3\n*E\n"})
public final class PreviewAnnotationGeneratorKt {
    @NotNull
    private static final Set<String> referenceDeviceIds;
    private static final int UI_MODE_NIGHT_MASK = 48;
    private static final int UI_MODE_TYPE_MASK = 15;

    private static final String uiModeToString(int uiMode) {
        String string;
        String nightString;
        if (uiMode == 0) {
            return "";
        }
        int night = uiMode & 0x30;
        int type = uiMode & 0xF;
        if ((uiMode & ~(night | type)) != 0) {
            return String.valueOf(uiMode);
        }
        if (night != 0) {
            Object object = NightMode.Companion.fromInt(night);
            if (object != null && (object = object.getClassConstant()) != null) {
                Object it = object;
                boolean bl = false;
                v1 = "android.content.res.Configuration." + (String)it;
            } else {
                v1 = null;
            }
        } else {
            v1 = nightString = null;
        }
        if (type != 0) {
            Object object = UiMode.Companion.fromInt(type);
            if (object != null && (object = ((UiMode)object).getClassConstant()) != null) {
                Object it = object;
                boolean bl = false;
                string = "android.content.res.Configuration." + (String)it;
            } else {
                string = null;
            }
        } else {
            string = null;
        }
        String typeString = string;
        Object[] objectArray = new String[]{nightString, typeString};
        List parts = CollectionsKt.listOfNotNull((Object[])objectArray);
        if (night != 0 && nightString == null || type != 0 && typeString == null) {
            return String.valueOf(uiMode);
        }
        return parts.isEmpty() ? String.valueOf(uiMode) : CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)" or ", null, null, (int)0, null, null, (int)62, null);
    }

    private static final String wallpaperToString(int wallpaperValue) {
        Object v0;
        block1: {
            Iterable iterable = (Iterable)Wallpaper.getEntries();
            for (Object t : iterable) {
                Wallpaper it = (Wallpaper)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getResolvedValue(), (Object)String.valueOf(wallpaperValue))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Wallpaper wallpaper = v0;
        return wallpaper != null && wallpaper != Wallpaper.NONE ? "androidx.compose.ui.tooling.preview.Wallpapers." + wallpaper.getClassConstant() : String.valueOf(wallpaperValue);
    }

    private static final StringBuilder appendParamValue(StringBuilder $this$appendParamValue, String parameterName, String value) {
        StringBuilder stringBuilder = $this$appendParamValue.append(parameterName + "=" + value);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        return stringBuilder;
    }

    private static final StringBuilder appendSeparator(StringBuilder $this$appendSeparator) {
        StringBuilder stringBuilder = $this$appendSeparator.append(',');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        return stringBuilder;
    }

    @NotNull
    public static final String createDeviceSpec(@NotNull Configuration configuration) {
        DeviceConfig currentDeviceConfig;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Device device = configuration.getDevice();
        Intrinsics.checkNotNull((Object)device);
        Device device2 = device;
        State state = configuration.getDeviceState();
        Intrinsics.checkNotNull((Object)state);
        State deviceState = state;
        String string = deviceState.getOrientation().name();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String orientation = string2;
        Screen screen = deviceState.getHardware().getScreen();
        int dpi = screen.getPixelDensity().getDpiValue();
        DeviceSize deviceSize = ConfigurationUtilKt.deviceSizeDp((Configuration)configuration);
        int widthDp = deviceSize.component1();
        int heightDp = deviceSize.component2();
        StringBuilder builder = new StringBuilder("spec:");
        PreviewAnnotationGeneratorKt.appendParamValue(builder, "width", widthDp + "dp");
        PreviewAnnotationGeneratorKt.appendSeparator(builder);
        PreviewAnnotationGeneratorKt.appendParamValue(builder, "height", heightDp + "dp");
        if (dpi != 420) {
            PreviewAnnotationGeneratorKt.appendSeparator(builder);
            PreviewAnnotationGeneratorKt.appendParamValue(builder, "dpi", String.valueOf(dpi));
        }
        if (!Intrinsics.areEqual((Object)orientation, (Object)Preview.DeviceSpec.INSTANCE.getDEFAULT_ORIENTATION().name())) {
            PreviewAnnotationGeneratorKt.appendSeparator(builder);
            PreviewAnnotationGeneratorKt.appendParamValue(builder, "orientation", orientation);
        }
        if ((currentDeviceConfig = DeviceUtilsKt.toDeviceConfig((Device)device2)).isRound()) {
            PreviewAnnotationGeneratorKt.appendSeparator(builder);
            PreviewAnnotationGeneratorKt.appendParamValue(builder, "isRound", "true");
            if (!(currentDeviceConfig.getChinSize() == 0.0f)) {
                PreviewAnnotationGeneratorKt.appendSeparator(builder);
                PreviewAnnotationGeneratorKt.appendParamValue(builder, "chinSize", (int)currentDeviceConfig.getChinSize() + "dp");
            }
        }
        if (currentDeviceConfig.getCutout() != Cutout.none) {
            PreviewAnnotationGeneratorKt.appendSeparator(builder);
            PreviewAnnotationGeneratorKt.appendParamValue(builder, "cutout", currentDeviceConfig.getCutout().name());
        }
        if (currentDeviceConfig.getNavigation() != Navigation.gesture) {
            PreviewAnnotationGeneratorKt.appendSeparator(builder);
            PreviewAnnotationGeneratorKt.appendParamValue(builder, "navigation", currentDeviceConfig.getNavigation().name());
        }
        String string3 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    @NotNull
    public static final String toPreviewAnnotationText(@NotNull ComposePreviewElementInstance<?> previewElement, @NotNull Configuration configuration, @NotNull String name) {
        Device targetDevice;
        boolean isReferenceDevice;
        PreviewDisplaySettings.Background background;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(previewElement, (String)"previewElement");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        PreviewDisplaySettings displaySettings = previewElement.getDisplaySettings();
        PreviewConfiguration previewConfig = previewElement.getConfiguration();
        DeviceSize deviceSize = ConfigurationUtilKt.deviceSizeDp((Configuration)configuration);
        int currentWidthDp = deviceSize.component1();
        int currentHeightDp = deviceSize.component2();
        StringBuilder $this$toPreviewAnnotationText_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toPreviewAnnotationText_u24lambda_u240.append("@androidx.compose.ui.tooling.preview.Preview(\n");
        List params = new ArrayList();
        params.add("name = \"" + name + "\"");
        CharSequence charSequence = displaySettings.getGroup();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            params.add("group = \"" + displaySettings.getGroup() + "\"");
        }
        if ((background = displaySettings.getBackground()) instanceof PreviewDisplaySettings.Background.Color) {
            params.add("showBackground = true");
            String colorValue = ((PreviewDisplaySettings.Background.Color)background).getColor();
            if (StringsKt.startsWith$default((String)colorValue, (String)"#", (boolean)false, (int)2, null)) {
                String string = colorValue.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                colorValue = string;
            } else if (StringsKt.startsWith((String)colorValue, (String)"0x", (boolean)true)) {
                String string = colorValue.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                colorValue = string;
            }
            String string = colorValue.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            params.add("backgroundColor = 0x" + string);
        } else if (background instanceof PreviewDisplaySettings.Background.Default) {
            params.add("showBackground = true");
        } else if (!(background instanceof PreviewDisplaySettings.Background.Image) && !(background instanceof PreviewDisplaySettings.Background.None)) {
            throw new NoWhenBranchMatchedException();
        }
        if (previewConfig.getApiLevel() != -1) {
            params.add("apiLevel = " + previewConfig.getApiLevel());
        }
        if (!StringsKt.isBlank((CharSequence)previewConfig.getLocale())) {
            params.add("locale = \"" + previewConfig.getLocale() + "\"");
        }
        if (!(previewConfig.getFontScale() == 1.0f)) {
            params.add("fontScale = " + previewConfig.getFontScale() + "f");
        }
        if (previewConfig.getUiMode() != 0) {
            params.add("uiMode = " + PreviewAnnotationGeneratorKt.uiModeToString(previewConfig.getUiMode()));
        }
        if (!Intrinsics.areEqual((Object)String.valueOf(previewConfig.getWallpaper()), (Object)Wallpaper.NONE.getResolvedValue())) {
            params.add("wallpaper = " + PreviewAnnotationGeneratorKt.wallpaperToString(previewConfig.getWallpaper()));
        }
        if (displaySettings.getShowDecoration()) {
            params.add("showSystemUi = true");
        }
        boolean bl2 = isReferenceDevice = (targetDevice = configuration.getDevice()) != null && referenceDeviceIds.contains(targetDevice.getId());
        if (!(targetDevice == null || Intrinsics.areEqual((Object)targetDevice.getId(), (Object)"Custom") || isReferenceDevice || ConfigurationManager.isAvdDevice((Device)targetDevice))) {
            if (!Intrinsics.areEqual((Object)targetDevice.getId(), (Object)"pixel_5")) {
                params.add("device = \"id:" + targetDevice.getId() + "\"");
            }
        } else {
            String deviceSpec = PreviewAnnotationGeneratorKt.createDeviceSpec(configuration);
            if (displaySettings.getShowDecoration() || isReferenceDevice || targetDevice != null && ConfigurationManager.isAvdDevice((Device)targetDevice)) {
                v4 = params.add("device = \"" + deviceSpec + "\"");
            } else {
                if (!Intrinsics.areEqual((Object)previewConfig.getDeviceSpec(), (Object)"") && !Intrinsics.areEqual((Object)previewConfig.getDeviceSpec(), (Object)"Devices.DEFAULT")) {
                    params.add("device = \"" + deviceSpec + "\"");
                }
                params.add("widthDp = " + currentWidthDp);
                v4 = params.add("heightDp = " + currentHeightDp);
            }
        }
        CollectionsKt.joinTo$default((Iterable)params, (Appendable)$this$toPreviewAnnotationText_u24lambda_u240, (CharSequence)",\n    ", (CharSequence)"    ", null, (int)0, null, null, (int)120, null);
        $this$toPreviewAnnotationText_u24lambda_u240.append("\n)");
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ReferenceDevice.INSTANCE.getWindowSizeDevices();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Device device = (Device)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        referenceDeviceIds = CollectionsKt.toSet((Iterable)((List)var3_3));
    }
}

