/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.resize;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.configurations.Configuration;
import com.android.tools.configurations.ConfigurationListener;
import com.android.tools.configurations.ConfigurationUtilKt;
import com.android.tools.configurations.Configurations;
import com.android.tools.configurations.ConversionUtil;
import com.android.tools.configurations.DeviceSize;
import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.actions.DeviceChangeListener;
import com.android.tools.idea.actions.DeviceMenuAction;
import com.android.tools.idea.actions.DeviceMenuActionKt;
import com.android.tools.idea.common.model.NlDataProvider;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.compose.preview.ComposePreviewBundle;
import com.android.tools.idea.compose.preview.analytics.ComposeResizeToolingUsageTracker;
import com.android.tools.idea.compose.preview.analytics.ComposeResizeTrackerKt;
import com.android.tools.idea.compose.preview.resize.ConfigurationResizeListener;
import com.android.tools.idea.compose.preview.util.UtilsKt;
import com.android.tools.idea.preview.Colors;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneRenderConfiguration;
import com.android.tools.preview.ComposePreviewElementInstance;
import com.google.wireless.android.sdk.stats.ResizeComposePreviewEvent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u00022\u00020\u0003:\u0003567B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020'H\u0002J\u0006\u0010+\u001a\u00020'J\u0010\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020\u0016H\u0002J\u0010\u0010.\u001a\u00020'2\b\u0010/\u001a\u0004\u0018\u00010\u0012J\b\u00100\u001a\u00020'H\u0002J\b\u00101\u001a\u00020'H\u0016J\u0010\u00102\u001a\u00020'2\u0006\u00103\u001a\u00020\u001aH\u0016J\u001c\u00104\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0018\u00010\rj\u0004\u0018\u0001`\u0010H\u0007R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\f\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0018\u00010\rj\u0004\u0018\u0001`\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\"\u001a\u00060#R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/android/tools/idea/compose/preview/resize/ResizePanel;", "Lcom/intellij/ui/components/JBPanel;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "parentDisposable", "<init>", "(Lcom/intellij/openapi/Disposable;)V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "currentModuleForList", "Lcom/intellij/openapi/module/Module;", "currentFocusedPreviewElement", "Lcom/android/tools/preview/ComposePreviewElementInstance;", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "Lcom/android/tools/idea/compose/PsiComposePreviewElementInstance;", "currentSceneManager", "Lcom/android/tools/idea/uibuilder/scene/LayoutlibSceneManager;", "currentConfiguration", "Lcom/android/tools/configurations/Configuration;", "originalDeviceSnapshot", "Lcom/android/sdklib/devices/Device;", "originalDeviceStateSnapshot", "Lcom/android/sdklib/devices/State;", "value", "", "hasBeenResized", "getHasBeenResized", "()Z", "renderTriggerListener", "Lcom/android/tools/idea/compose/preview/resize/ConfigurationResizeListener;", "resizePanelUiUpdaterListener", "Lcom/android/tools/configurations/ConfigurationListener;", "dimensionInputsAction", "Lcom/android/tools/idea/compose/preview/resize/ResizePanel$DimensionInputsAction;", "createRevertButton", "Ljavax/swing/JComponent;", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "revertResizing", "clear", "handleDeviceSelection", "selectedItem", "setSceneManager", "sceneManager", "updatePanelFromConfiguration", "dispose", "setVisible", "isVisible", "getCurrentPreviewElementForTest", "RevertAction", "DevicePickerAction", "DimensionInputsAction", "intellij.android.compose-designer"})
@StabilityInferred(parameters=0)
public final class ResizePanel
extends JBPanel<ResizePanel>
implements Disposable,
UiDataProvider {
    @NotNull
    private final Logger log;
    @Nullable
    private Module currentModuleForList;
    @Nullable
    private ComposePreviewElementInstance<SmartPsiElementPointer<PsiElement>> currentFocusedPreviewElement;
    @Nullable
    private LayoutlibSceneManager currentSceneManager;
    @Nullable
    private Configuration currentConfiguration;
    @Nullable
    private Device originalDeviceSnapshot;
    @Nullable
    private State originalDeviceStateSnapshot;
    private volatile boolean hasBeenResized;
    @Nullable
    private ConfigurationResizeListener renderTriggerListener;
    @NotNull
    private final ConfigurationListener resizePanelUiUpdaterListener;
    @NotNull
    private final DimensionInputsAction dimensionInputsAction;
    public static final int $stable = 8;

    public ResizePanel(@NotNull Disposable parentDisposable) {
        DefaultActionGroup defaultActionGroup;
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Logger logger = Logger.getInstance(ResizePanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.log = logger;
        this.resizePanelUiUpdaterListener = arg_0 -> ResizePanel.resizePanelUiUpdaterListener$lambda$0(this, arg_0);
        this.dimensionInputsAction = new DimensionInputsAction();
        this.setLayout(new BorderLayout());
        this.setBorder((Border)new JBEmptyBorder(2));
        this.setBackground((Color)Colors.INSTANCE.getDEFAULT_BACKGROUND_COLOR());
        DefaultActionGroup $this$_init__u24lambda_u240 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        $this$_init__u24lambda_u240.add((AnAction)new DevicePickerAction());
        $this$_init__u24lambda_u240.add((AnAction)this.dimensionInputsAction);
        DefaultActionGroup mainActionGroup = defaultActionGroup;
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)mainActionGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar actionToolbar2 = actionToolbar;
        actionToolbar2.setTargetComponent((JComponent)((Object)this));
        actionToolbar2.getComponent().setOpaque(false);
        JBPanel $this$_init__u24lambda_u241 = bl = new JBPanel((LayoutManager)new FlowLayout(1, JBUI.scale((int)4), JBUI.scale((int)2)));
        boolean bl2 = false;
        $this$_init__u24lambda_u241.setOpaque(false);
        $this$_init__u24lambda_u241.add((Component)actionToolbar2.getComponent());
        JBPanel flowingComponentsPanel = bl;
        this.add((Component)flowingComponentsPanel, "Center");
        JComponent revertButton = this.createRevertButton();
        this.add(revertButton, "East");
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.setEnabled(false);
    }

    public final boolean getHasBeenResized() {
        return this.hasBeenResized;
    }

    private final JComponent createRevertButton() {
        JBPanel jBPanel;
        RevertAction revertAction = new RevertAction();
        AnAction[] anActionArray = new AnAction[]{revertAction};
        DefaultActionGroup actionGroup = new DefaultActionGroup(anActionArray);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)actionGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar actionToolbar2 = actionToolbar;
        actionToolbar2.setTargetComponent((JComponent)((Object)this));
        actionToolbar2.getComponent().setOpaque(false);
        JBPanel $this$createRevertButton_u24lambda_u240 = jBPanel = new JBPanel();
        boolean bl = false;
        $this$createRevertButton_u24lambda_u240.setOpaque(false);
        $this$createRevertButton_u24lambda_u240.setLayout((LayoutManager)new BoxLayout((Container)$this$createRevertButton_u24lambda_u240, 1));
        $this$createRevertButton_u24lambda_u240.add(Box.createVerticalGlue());
        $this$createRevertButton_u24lambda_u240.add((Component)actionToolbar2.getComponent());
        $this$createRevertButton_u24lambda_u240.add(Box.createVerticalGlue());
        return (JComponent)jBPanel;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        sink.set(DesignerDataKeys.CONFIGURATIONS, (Object)CollectionsKt.listOfNotNull((Object)this.currentConfiguration));
        sink.set(DeviceMenuActionKt.getHAS_BEEN_RESIZED(), (Object)this.hasBeenResized);
    }

    private final void revertResizing() {
        this.dimensionInputsAction.resetErrors();
        Object object = this.currentSceneManager;
        if (object != null && (object = ((LayoutlibSceneManager)object).getSceneRenderConfiguration()) != null) {
            ((LayoutlibSceneRenderConfiguration)object).setClearOverrideRenderSize(true);
        }
        LayoutlibSceneManager layoutlibSceneManager = this.currentSceneManager;
        if (layoutlibSceneManager != null) {
            layoutlibSceneManager.setForceNextResizeToUseOriginalSize(true);
        }
        Configuration configuration = this.currentConfiguration;
        if (configuration != null) {
            configuration.setEffectiveDevice(this.originalDeviceSnapshot, this.originalDeviceStateSnapshot);
        }
        this.dimensionInputsAction.updateTextFieldsFromConfiguration();
        Disposable disposable = this.currentSceneManager;
        DesignSurface<?> designSurface2 = disposable != null && (disposable = disposable.getScene()) != null ? disposable.getDesignSurface() : null;
        LayoutlibSceneManager layoutlibSceneManager2 = this.currentSceneManager;
        if (layoutlibSceneManager2 == null || (layoutlibSceneManager2 = ComposeResizeTrackerKt.getResizeMode(layoutlibSceneManager2)) == null) {
            layoutlibSceneManager2 = ResizeComposePreviewEvent.ResizeMode.COMPOSABLE_RESIZE;
        }
        ComposeResizeToolingUsageTracker.INSTANCE.logResizeReverted(designSurface2, (ResizeComposePreviewEvent.ResizeMode)layoutlibSceneManager2);
    }

    public final void clear() {
        Configuration configuration = this.currentConfiguration;
        if (configuration != null) {
            configuration.removeListener(this.resizePanelUiUpdaterListener);
        }
        ConfigurationResizeListener configurationResizeListener = this.renderTriggerListener;
        if (configurationResizeListener != null) {
            ConfigurationResizeListener existingListener = configurationResizeListener;
            boolean bl = false;
            Disposer.dispose((Disposable)existingListener);
            Configuration configuration2 = this.currentConfiguration;
            if (configuration2 != null) {
                configuration2.removeListener((ConfigurationListener)existingListener);
            }
        }
        this.renderTriggerListener = null;
        this.currentSceneManager = null;
        this.currentConfiguration = null;
        this.currentFocusedPreviewElement = null;
        this.currentModuleForList = null;
        this.hasBeenResized = false;
    }

    private final void handleDeviceSelection(Device selectedItem) {
        this.dimensionInputsAction.resetErrors();
        Configuration configuration = this.currentConfiguration;
        if (configuration != null) {
            configuration.setEffectiveDevice(selectedItem, selectedItem.getDefaultState());
        }
        this.dimensionInputsAction.updateTextFieldsFromConfiguration();
        Disposable disposable = this.currentSceneManager;
        DesignSurface<?> designSurface2 = disposable != null && (disposable = disposable.getScene()) != null ? disposable.getDesignSurface() : null;
        LayoutlibSceneManager layoutlibSceneManager = this.currentSceneManager;
        if (layoutlibSceneManager == null || (layoutlibSceneManager = ComposeResizeTrackerKt.getResizeMode(layoutlibSceneManager)) == null) {
            layoutlibSceneManager = ResizeComposePreviewEvent.ResizeMode.COMPOSABLE_RESIZE;
        }
        String string = selectedItem.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        ComposeResizeToolingUsageTracker.INSTANCE.logResizeStopped(designSurface2, (ResizeComposePreviewEvent.ResizeMode)layoutlibSceneManager, ResizeComposePreviewEvent.ResizeSource.DROPDOWN, string);
    }

    /*
     * WARNING - void declaration
     */
    public final void setSceneManager(@Nullable LayoutlibSceneManager sceneManager) {
        NlModel model;
        this.clear();
        this.currentSceneManager = sceneManager;
        LayoutlibSceneManager layoutlibSceneManager = sceneManager;
        NlModel nlModel = model = layoutlibSceneManager != null ? layoutlibSceneManager.getModel() : null;
        this.currentConfiguration = nlModel != null ? nlModel.getConfiguration() : null;
        NlModel nlModel2 = model;
        this.currentModuleForList = nlModel2 != null ? nlModel2.getModule() : null;
        Object object = model;
        this.currentFocusedPreviewElement = object != null && (object = ((NlModel)object).getDataProvider()) != null ? UtilsKt.previewElement((NlDataProvider)object) : null;
        Configuration configuration = this.currentConfiguration;
        this.originalDeviceSnapshot = configuration != null ? configuration.getDevice() : null;
        Configuration configuration2 = this.currentConfiguration;
        this.originalDeviceStateSnapshot = configuration2 != null ? configuration2.getDeviceState() : null;
        Configuration configuration3 = this.currentConfiguration;
        if (configuration3 != null) {
            configuration3.addListener(this.resizePanelUiUpdaterListener);
        }
        Configuration configuration4 = this.currentConfiguration;
        if (configuration4 != null) {
            Configuration configuration5 = configuration4;
            boolean bl = false;
            LayoutlibSceneManager layoutlibSceneManager2 = this.currentSceneManager;
            if (layoutlibSceneManager2 != null) {
                void it;
                ConfigurationResizeListener configurationResizeListener;
                LayoutlibSceneManager sceneManager2 = layoutlibSceneManager2;
                boolean bl2 = false;
                ConfigurationResizeListener configurationResizeListener2 = configurationResizeListener = new ConfigurationResizeListener(sceneManager2, configuration5, null, 4, null);
                ResizePanel resizePanel = this;
                boolean bl3 = false;
                configuration5.addListener((ConfigurationListener)it);
                resizePanel.renderTriggerListener = configurationResizeListener;
            }
        }
        this.updatePanelFromConfiguration();
    }

    private final void updatePanelFromConfiguration() {
        Configuration config = this.currentConfiguration;
        UIUtil.invokeLaterIfNeeded(() -> ResizePanel.updatePanelFromConfiguration$lambda$0(config, this));
    }

    public void dispose() {
        this.clear();
    }

    public void setVisible(boolean isVisible) {
        if (this.isVisible() == isVisible) {
            return;
        }
        if (isVisible) {
            this.dimensionInputsAction.updateTextFieldsFromConfiguration();
        }
        super.setVisible(isVisible);
    }

    @TestOnly
    @Nullable
    public final ComposePreviewElementInstance<SmartPsiElementPointer<PsiElement>> getCurrentPreviewElementForTest() {
        return this.currentFocusedPreviewElement;
    }

    /*
     * Unable to fully structure code
     */
    private static final boolean resizePanelUiUpdaterListener$lambda$0(ResizePanel this$0, int flags) {
        block2: {
            block3: {
                if ((flags & 2) == 0) break block2;
                if (this$0.currentConfiguration == null) break block3;
                v0 = this$0.currentConfiguration;
                if (!Objects.equals(v0 != null ? v0.getDevice() : null, this$0.originalDeviceSnapshot)) ** GOTO lbl-1000
                v1 = this$0.currentConfiguration;
                if (!Objects.equals(v1 != null ? v1.getDeviceState() : null, this$0.originalDeviceStateSnapshot)) lbl-1000:
                // 2 sources

                {
                    v2 = true;
                } else {
                    v2 = false;
                }
                this$0.hasBeenResized = v2;
            }
            this$0.updatePanelFromConfiguration();
        }
        return true;
    }

    private static final void updatePanelFromConfiguration$lambda$0(Configuration $config, ResizePanel this$0) {
        if ($config == null || $config.getDeviceState() == null) {
            this$0.setEnabled(false);
            return;
        }
        this$0.setEnabled(true);
    }

    public static final /* synthetic */ void access$handleDeviceSelection(ResizePanel $this, Device selectedItem) {
        $this.handleDeviceSelection(selectedItem);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0081\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/compose/preview/resize/ResizePanel$DevicePickerAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "<init>", "(Lcom/android/tools/idea/compose/preview/resize/ResizePanel;)V", "deviceMenuAction", "Lcom/android/tools/idea/actions/DeviceMenuAction;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.android.compose-designer"})
    @VisibleForTesting
    public final class DevicePickerAction
    extends DumbAwareAction
    implements CustomComponentAction {
        @NotNull
        private final DeviceMenuAction deviceMenuAction;

        public DevicePickerAction() {
            super("Device", "Select a device to resize the preview", AllIcons.General.ArrowDown);
            this.deviceMenuAction = new DeviceMenuAction(new DeviceChangeListener(ResizePanel.this){
                final /* synthetic */ ResizePanel this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onDeviceChanged(Device oldDevice, Device newDevice) {
                    Intrinsics.checkNotNullParameter((Object)newDevice, (String)"newDevice");
                    ResizePanel.access$handleDeviceSelection(this.this$0, newDevice);
                }

                public void onRevertToOriginal() {
                    ResizePanel.access$revertResizing(this.this$0);
                }
            });
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.deviceMenuAction.actionPerformed(e);
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            ActionButtonWithText button = new ActionButtonWithText((AnAction)this, presentation, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            button.setFocusable(true);
            button.setHorizontalTextPosition(10);
            return (JComponent)button;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.deviceMenuAction.update(e);
            e.getPresentation().setEnabled(ResizePanel.this.isEnabled());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\tJ\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\b\u0010\u0018\u001a\u00020\tH\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\tH\u0002J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u000fH\u0002J\u0010\u0010 \u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J\b\u0010!\u001a\u00020\tH\u0002J\u0010\u0010\"\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/tools/idea/compose/preview/resize/ResizePanel$DimensionInputsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "<init>", "(Lcom/android/tools/idea/compose/preview/resize/ResizePanel;)V", "widthTextField", "Lcom/intellij/ui/components/fields/IntegerField;", "heightTextField", "resetErrors", "", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "updateTextFieldsFromConfiguration", "createDimensionTextField", "valueName", "setUpTextFieldListeners", "hasErrors", "", "commitDimensionChanges", "validate", "field", "setError", "message", "clearError", "updateConfigurationFromTextFields", "actionPerformed", "intellij.android.compose-designer"})
    private final class DimensionInputsAction
    extends DumbAwareAction
    implements CustomComponentAction {
        @NotNull
        private final IntegerField widthTextField = this.createDimensionTextField("Width");
        @NotNull
        private final IntegerField heightTextField = this.createDimensionTextField("Height");

        public DimensionInputsAction() {
            this.setUpTextFieldListeners();
        }

        public final void resetErrors() {
            this.clearError(this.widthTextField);
            this.clearError(this.heightTextField);
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            JPanel jPanel;
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            JPanel $this$createCustomComponent_u24lambda_u240 = jPanel = new JPanel(new FlowLayout(1, JBUI.scale((int)4), JBUI.scale((int)2)));
            boolean bl = false;
            $this$createCustomComponent_u24lambda_u240.setOpaque(false);
            $this$createCustomComponent_u24lambda_u240.add((Component)this.widthTextField);
            $this$createCustomComponent_u24lambda_u240.add((Component)new JBLabel("X"));
            $this$createCustomComponent_u24lambda_u240.add((Component)this.heightTextField);
            $this$createCustomComponent_u24lambda_u240.add((Component)new JBLabel("dp"));
            JPanel panel = jPanel;
            this.updateTextFieldsFromConfiguration();
            return panel;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            boolean isEnabled = ResizePanel.this.isEnabled();
            e.getPresentation().setEnabled(isEnabled);
            this.widthTextField.setEnabled(isEnabled);
            this.heightTextField.setEnabled(isEnabled);
            if (!(this.widthTextField.hasFocus() || this.heightTextField.hasFocus() || this.hasErrors())) {
                this.updateTextFieldsFromConfiguration();
            }
        }

        public final void updateTextFieldsFromConfiguration() {
            this.resetErrors();
            Configuration configuration = ResizePanel.this.currentConfiguration;
            if (configuration == null) {
                return;
            }
            Configuration config = configuration;
            DeviceSize deviceSize = ConfigurationUtilKt.deviceSizeDp((Configuration)config);
            int wDp = deviceSize.component1();
            int hDp = deviceSize.component2();
            Integer n = this.widthTextField.getValue();
            int n2 = wDp;
            if (n == null || n != n2) {
                this.widthTextField.setValue(Integer.valueOf(wDp));
            }
            Integer n3 = this.heightTextField.getValue();
            n2 = hDp;
            if (n3 == null || n3 != n2) {
                this.heightTextField.setValue(Integer.valueOf(hDp));
            }
        }

        private final IntegerField createDimensionTextField(String valueName) {
            IntegerField integerField;
            IntegerField $this$createDimensionTextField_u24lambda_u240 = integerField = new IntegerField(valueName, 1, 2000);
            boolean bl = false;
            $this$createDimensionTextField_u24lambda_u240.setColumns(4);
            Document document = $this$createDimensionTextField_u24lambda_u240.getDocument();
            AbstractDocument abstractDocument = document instanceof AbstractDocument ? (AbstractDocument)document : null;
            if (abstractDocument != null) {
                abstractDocument.setDocumentFilter(new DocumentFilter(){

                    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) {
                        boolean bl;
                        block2: {
                            Intrinsics.checkNotNullParameter((Object)fb, (String)"fb");
                            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
                            CharSequence $this$all$iv = string;
                            boolean $i$f$all = false;
                            for (int i = 0; i < $this$all$iv.length(); ++i) {
                                char element$iv;
                                char it = element$iv = $this$all$iv.charAt(i);
                                boolean bl2 = false;
                                if (Character.isDigit(it)) continue;
                                bl = false;
                                break block2;
                            }
                            bl = true;
                        }
                        if (bl) {
                            super.insertString(fb, offset, string, attr);
                        }
                    }

                    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter((Object)fb, (String)"fb");
                        String string = text;
                        if (string != null) {
                            boolean bl2;
                            block4: {
                                CharSequence $this$all$iv = string;
                                boolean $i$f$all = false;
                                for (int i = 0; i < $this$all$iv.length(); ++i) {
                                    char element$iv;
                                    char it = element$iv = $this$all$iv.charAt(i);
                                    boolean bl3 = false;
                                    if (Character.isDigit(it)) continue;
                                    bl2 = false;
                                    break block4;
                                }
                                bl2 = true;
                            }
                            bl = !bl2;
                        } else {
                            bl = false;
                        }
                        if (!bl) {
                            super.replace(fb, offset, length, text, attrs);
                        }
                    }
                });
            }
            $this$createDimensionTextField_u24lambda_u240.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(this, $this$createDimensionTextField_u24lambda_u240){
                final /* synthetic */ DimensionInputsAction this$0;
                final /* synthetic */ IntegerField $this_apply;
                {
                    this.this$0 = $receiver;
                    this.$this_apply = $receiver2;
                }

                protected void textChanged(DocumentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    DimensionInputsAction.access$validate(this.this$0, this.$this_apply);
                }
            });
            return integerField;
        }

        private final void setUpTextFieldListeners() {
            ActionListener onEnterListener = arg_0 -> DimensionInputsAction.setUpTextFieldListeners$lambda$0(this, arg_0);
            this.widthTextField.addActionListener(onEnterListener);
            this.heightTextField.addActionListener(onEnterListener);
            FocusAdapter focusListener2 = new FocusAdapter(this){
                final /* synthetic */ DimensionInputsAction this$0;
                {
                    this.this$0 = $receiver;
                }

                public void focusLost(FocusEvent e) {
                    DimensionInputsAction.access$commitDimensionChanges(this.this$0);
                    if (DimensionInputsAction.access$hasErrors(this.this$0)) {
                        this.this$0.updateTextFieldsFromConfiguration();
                    }
                }
            };
            this.widthTextField.addFocusListener((FocusListener)focusListener2);
            this.heightTextField.addFocusListener((FocusListener)focusListener2);
        }

        private final boolean hasErrors() {
            return Intrinsics.areEqual((Object)this.widthTextField.getClientProperty((Object)"JComponent.outline"), (Object)"error") || Intrinsics.areEqual((Object)this.heightTextField.getClientProperty((Object)"JComponent.outline"), (Object)"error");
        }

        private final void commitDimensionChanges() {
            boolean widthIsValid = this.validate(this.widthTextField);
            boolean heightIsValid = this.validate(this.heightTextField);
            if (widthIsValid && heightIsValid) {
                this.updateConfigurationFromTextFields();
            }
        }

        private final boolean validate(IntegerField field) {
            try {
                field.validateContent();
                this.clearError(field);
                return true;
            }
            catch (ConfigurationException e) {
                String string = e.getLocalizedMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedMessage(...)");
                this.setError(field, string);
                return false;
            }
        }

        private final void setError(IntegerField field, String message) {
            field.putClientProperty((Object)"JComponent.outline", (Object)"error");
            field.setToolTipText(message);
        }

        private final void clearError(IntegerField field) {
            field.putClientProperty((Object)"JComponent.outline", null);
            field.setToolTipText(null);
        }

        private final void updateConfigurationFromTextFields() {
            Configuration configuration = ResizePanel.this.currentConfiguration;
            if (configuration == null) {
                return;
            }
            Configuration config = configuration;
            Integer n = this.widthTextField.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getValue(...)");
            int newWidthDp = ((Number)n).intValue();
            Integer n2 = this.heightTextField.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"getValue(...)");
            int newHeightDp = ((Number)n2).intValue();
            DeviceSize deviceSize = ConfigurationUtilKt.deviceSizeDp((Configuration)config);
            int currentConfigWidthDp = deviceSize.component1();
            int currentConfigHeightDp = deviceSize.component2();
            if (newWidthDp == currentConfigWidthDp && newHeightDp == currentConfigHeightDp) {
                return;
            }
            int dpi = config.getDensity().getDpiValue();
            if (dpi <= 0) {
                ResizePanel.this.log.warn("Cannot update screen size, invalid DPI: " + dpi);
                return;
            }
            Configurations.updateScreenSize$default((Configuration)config, (int)ConversionUtil.INSTANCE.dpToPx(newWidthDp, dpi), (int)ConversionUtil.INSTANCE.dpToPx(newHeightDp, dpi), null, (int)4, null);
            Disposable disposable = ResizePanel.this.currentSceneManager;
            DesignSurface<?> designSurface2 = disposable != null && (disposable = disposable.getScene()) != null ? disposable.getDesignSurface() : null;
            LayoutlibSceneManager layoutlibSceneManager = ResizePanel.this.currentSceneManager;
            if (layoutlibSceneManager == null || (layoutlibSceneManager = ComposeResizeTrackerKt.getResizeMode(layoutlibSceneManager)) == null) {
                layoutlibSceneManager = ResizeComposePreviewEvent.ResizeMode.COMPOSABLE_RESIZE;
            }
            ComposeResizeToolingUsageTracker.INSTANCE.logResizeStopped(designSurface2, (ResizeComposePreviewEvent.ResizeMode)layoutlibSceneManager, newWidthDp, newHeightDp, dpi, ResizeComposePreviewEvent.ResizeSource.TEXT_FIELD);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }

        private static final void setUpTextFieldListeners$lambda$0(DimensionInputsAction this$0, ActionEvent it) {
            this$0.commitDimensionChanges();
        }

        public static final /* synthetic */ void access$commitDimensionChanges(DimensionInputsAction $this) {
            $this.commitDimensionChanges();
        }

        public static final /* synthetic */ boolean access$hasErrors(DimensionInputsAction $this) {
            return $this.hasErrors();
        }

        public static final /* synthetic */ boolean access$validate(DimensionInputsAction $this, IntegerField field) {
            return $this.validate(field);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0081\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/compose/preview/resize/ResizePanel$RevertAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "(Lcom/android/tools/idea/compose/preview/resize/ResizePanel;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.android.compose-designer"})
    @VisibleForTesting
    public final class RevertAction
    extends DumbAwareAction {
        public RevertAction() {
            super(ComposePreviewBundle.message("resize.panel.revert.tooltip", new Object[0]), null, AllIcons.Actions.Rollback);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ResizePanel.this.revertResizing();
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabledAndVisible(ResizePanel.this.getHasBeenResized());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }
}

