/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.animation;

import androidx.compose.animation.tooling.ComposeAnimatedProperty;
import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.model.stdui.EditingErrorCategory;
import com.android.tools.adtui.model.stdui.EditingSupportKt;
import com.android.tools.idea.compose.preview.ComposePreviewBundle;
import com.android.tools.idea.compose.preview.animation.picker.AnimatedPropertyItem;
import com.android.tools.idea.compose.preview.animation.validation.DoubleValidation;
import com.android.tools.idea.compose.preview.animation.validation.FloatValidationKt;
import com.android.tools.idea.compose.preview.animation.validation.IntValidation;
import com.android.tools.idea.preview.animation.AnimationUnit;
import com.intellij.ui.ColorUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c7\u0002\u0018\u00002\u00020\u0001:\t\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0002J\u0014\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0001J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0001H\u0002J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0012\u001a\u00020\u000e\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit;", "", "<init>", "()V", "parse", "Lcom/android/tools/idea/preview/animation/AnimationUnit$Unit;", "property", "Landroidx/compose/animation/tooling/ComposeAnimatedProperty;", "parseUnit", "value", "parseStateUnit", "findMethodByName", "Ljava/lang/reflect/Method;", "methodName", "", "createProperties", "", "Lcom/android/tools/idea/compose/preview/animation/picker/AnimatedPropertyItem;", "prefix", "ComposeUnit", "IntSize", "IntOffset", "ComposeParseException", "Dp", "Size", "Rect", "Offset", "Color", "intellij.android.compose-designer"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nComposeUnit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeUnit.kt\ncom/android/tools/idea/compose/preview/animation/ComposeUnit\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,419:1\n3170#2,11:420\n1#3:431\n1573#4:432\n1604#4,4:433\n1573#4:437\n1604#4,4:438\n*S KotlinDebug\n*F\n+ 1 ComposeUnit.kt\ncom/android/tools/idea/compose/preview/animation/ComposeUnit\n*L\n394#1:420,11\n410#1:432\n410#1:433,4\n414#1:437\n414#1:438,4\n*E\n"})
public final class ComposeUnit {
    @NotNull
    public static final ComposeUnit INSTANCE = new ComposeUnit();
    public static final int $stable;

    private ComposeUnit() {
    }

    @NotNull
    public final AnimationUnit.Unit<?> parse(@NotNull ComposeAnimatedProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        return this.parseUnit(property.getValue());
    }

    /*
     * Enabled aggressive block sorting
     */
    private final AnimationUnit.Unit<?> parseUnit(Object value) {
        AnimationUnit.Unit unit;
        if (value == null) {
            return new AnimationUnit.UnitUnknown(value);
        }
        String string = Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName();
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 1098275025: {
                    if (!string.equals("androidx.compose.ui.unit.IntOffset")) break;
                    n = 1;
                    break;
                }
                case -1323466364: {
                    if (!string.equals("androidx.compose.ui.geometry.Size")) break;
                    n = 2;
                    break;
                }
                case -658722474: {
                    if (!string.equals("androidx.compose.ui.geometry.Offset")) break;
                    n = 3;
                    break;
                }
                case -1323500697: {
                    if (!string.equals("androidx.compose.ui.geometry.Rect")) break;
                    n = 4;
                    break;
                }
                case 1906416637: {
                    if (!string.equals("androidx.compose.ui.unit.Dp")) break;
                    n = 5;
                    break;
                }
                case 195471769: {
                    if (!string.equals("androidx.compose.ui.graphics.Color")) break;
                    n = 6;
                    break;
                }
                case -1518285889: {
                    if (!string.equals("androidx.compose.ui.unit.IntSize")) break;
                    n = 7;
                    break;
                }
            }
            switch (n) {
                case 6: {
                    unit = Color.Companion.create(value);
                    return unit;
                }
                case 5: {
                    unit = Dp.Companion.create(value);
                    return unit;
                }
                case 2: {
                    unit = Size.Companion.create(value);
                    return unit;
                }
                case 4: {
                    unit = Rect.Companion.create(value);
                    return unit;
                }
                case 1: {
                    unit = IntOffset.Companion.create(value);
                    return unit;
                }
                case 7: {
                    unit = IntSize.Companion.create(value);
                    return unit;
                }
                case 3: {
                    unit = Offset.Companion.create(value);
                    return unit;
                }
            }
        }
        AnimationUnit.NumberUnit<?> numberUnit = AnimationUnit.INSTANCE.parseNumberUnit(value);
        if (numberUnit != null) {
            unit = numberUnit;
            return unit;
        }
        unit = new AnimationUnit.UnitUnknown(value);
        return unit;
    }

    @NotNull
    public final AnimationUnit.Unit<?> parseStateUnit(@Nullable Object value) {
        AnimationUnit.Unit<?> unit = this.parseUnit(value);
        if (!(unit instanceof AnimationUnit.UnitUnknown)) {
            return unit;
        }
        return value instanceof String ? (AnimationUnit.Unit)new AnimationUnit.StringUnit((String)value) : (AnimationUnit.Unit)new AnimationUnit.UnitUnknown(value);
    }

    /*
     * WARNING - void declaration
     */
    private final Method findMethodByName(String methodName, Object property) {
        Object object;
        Object v1;
        Object object2;
        block4: {
            void $this$singleOrNull$iv;
            Method[] methodArray = property.getClass().getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
            object2 = methodArray;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (void element$iv : $this$singleOrNull$iv) {
                Method it = (Method)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)methodName)) continue;
                if (found$iv) {
                    v1 = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        Method method = v1;
        if (method != null) {
            Object $this$findMethodByName_u24lambda_u241 = object2 = method;
            boolean bl = false;
            ((Method)$this$findMethodByName_u24lambda_u241).setAccessible(true);
            object = object2;
        } else {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AnimatedPropertyItem> createProperties(@NotNull AnimationUnit.Unit<?> $this$createProperties, @NotNull String prefix) {
        List list;
        Intrinsics.checkNotNullParameter($this$createProperties, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        AnimationUnit.Unit<?> unit = $this$createProperties;
        if (unit instanceof ComposeUnit) {
            list = ((ComposeUnit)$this$createProperties).createProperties(prefix);
        } else if (unit instanceof AnimationUnit.StringUnit) {
            list = CollectionsKt.listOf((Object)new AnimatedPropertyItem(prefix, (String)((AnimationUnit.StringUnit)$this$createProperties).getComponents().get(0), (Function1<? super String, ? extends Pair<? extends EditingErrorCategory, String>>)((Function1)ComposeUnit::createProperties$lambda$0), "String"));
        } else if (unit instanceof AnimationUnit.IntUnit) {
            list = CollectionsKt.listOf((Object)new AnimatedPropertyItem(prefix, String.valueOf(((Number)((AnimationUnit.IntUnit)$this$createProperties).getComponents().get(0)).intValue()), (Function1<? super String, ? extends Pair<? extends EditingErrorCategory, String>>)((Function1)IntValidation.INSTANCE), "Int"));
        } else if (unit instanceof AnimationUnit.DoubleUnit) {
            list = CollectionsKt.listOf((Object)new AnimatedPropertyItem(prefix, String.valueOf(((Number)((AnimationUnit.DoubleUnit)$this$createProperties).getComponents().get(0)).doubleValue()), (Function1<? super String, ? extends Pair<? extends EditingErrorCategory, String>>)((Function1)DoubleValidation.INSTANCE), "Double"));
        } else if (unit instanceof AnimationUnit.FloatUnit) {
            list = CollectionsKt.listOf((Object)new AnimatedPropertyItem(prefix, String.valueOf(((Number)((AnimationUnit.FloatUnit)$this$createProperties).getComponents().get(0)).floatValue()), FloatValidationKt.getFloatValidation(), "Float"));
        } else if (unit instanceof AnimationUnit.UnitUnknown) {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = ((AnimationUnit.UnitUnknown)$this$createProperties).getComponents();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void component;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new AnimatedPropertyItem(prefix + "." + (int)index, String.valueOf(component), (Function1<? super String, ? extends Pair<? extends EditingErrorCategory, String>>)((Function1)ComposeUnit::createProperties$lambda$1$0), "Any"));
            }
            list = (List)destination$iv$iv;
        } else {
            Iterable $this$mapIndexed$iv = $this$createProperties.getComponents();
            boolean $i$f$mapIndexed = false;
            Iterable $this$mapIndexedTo$iv$iv = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object component = item$iv$iv;
                int index = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new AnimatedPropertyItem(prefix + "." + index, String.valueOf(component), (Function1<? super String, ? extends Pair<? extends EditingErrorCategory, String>>)((Function1)ComposeUnit::createProperties$lambda$2$0), "Any"));
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private static final Pair createProperties$lambda$0(String it) {
        return EditingSupportKt.EDITOR_NO_ERROR;
    }

    private static final Pair createProperties$lambda$1$0(String it) {
        return EditingSupportKt.EDITOR_NO_ERROR;
    }

    private static final Pair createProperties$lambda$2$0(String it) {
        return EditingSupportKt.EDITOR_NO_ERROR;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0003:\u0001\u001dB'\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J$\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00182\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u0015H\u0016R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Color;", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$ComposeUnit;", "", "Lcom/android/tools/idea/preview/animation/AnimationUnit$Color;", "component1", "component2", "component3", "component4", "<init>", "(FFFF)V", "color", "Ljava/awt/Color;", "getColor", "()Ljava/awt/Color;", "create", "property", "", "createProperties", "", "Lcom/android/tools/idea/compose/preview/animation/picker/AnimatedPropertyItem;", "prefix", "", "toString", "parseUnit", "Lcom/android/tools/idea/preview/animation/AnimationUnit$Unit;", "getValue", "Lkotlin/Function1;", "", "getPickerTitle", "Companion", "intellij.android.compose-designer"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nComposeUnit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeUnit.kt\ncom/android/tools/idea/compose/preview/animation/ComposeUnit$Color\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,419:1\n1573#2:420\n1604#2,4:421\n1#3:425\n*S KotlinDebug\n*F\n+ 1 ComposeUnit.kt\ncom/android/tools/idea/compose/preview/animation/ComposeUnit$Color\n*L\n365#1:420\n365#1:421,4\n*E\n"})
    public static final class Color
    extends ComposeUnit<Float>
    implements AnimationUnit.Color<Float, Color> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final java.awt.Color color;
        public static final int $stable = 8;
        @NotNull
        public static final String CLASS_NAME = "androidx.compose.ui.graphics.Color";
        @NotNull
        private static final String[] COMPONENT_NAMES;

        public Color(float component1, float component2, float component3, float component4) {
            Color color;
            Object object = new Float[]{Float.valueOf(component1), Float.valueOf(component2), Float.valueOf(component3), Float.valueOf(component4)};
            Float[] floatArray = object;
            object = new String[]{"red", "green", "blue", "alpha"};
            super((A[])floatArray, (String[])object);
            Color color2 = this;
            try {
                color = color2;
                object = new java.awt.Color(component1, component2, component3, component4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                color = color2;
                object = null;
            }
            color.color = object;
        }

        @Override
        @Nullable
        public java.awt.Color getColor() {
            return this.color;
        }

        @NotNull
        public Color create(@NotNull Object property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            return Companion.create(property);
        }

        @Override
        @NotNull
        public Color create(@NotNull java.awt.Color color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            return Companion.create(color);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<AnimatedPropertyItem> createProperties(@NotNull String prefix) {
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Iterable $this$mapIndexed$iv = this.getComponents();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void component;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                float f = ((Number)item$iv$iv).floatValue();
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new AnimatedPropertyItem(COMPONENT_NAMES[index], String.valueOf((float)component), FloatValidationKt.getFloatValidation(), "Color"));
            }
            return (List)destination$iv$iv;
        }

        @Override
        @NotNull
        public String toString() {
            Object object;
            block3: {
                block2: {
                    object = this.getColor();
                    if (object == null) break block2;
                    java.awt.Color it = object;
                    boolean bl = false;
                    String string = ColorUtil.toHex((java.awt.Color)it, (boolean)true);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHex(...)");
                    String string2 = string.toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                    String string3 = "0x" + string2;
                    object = string3;
                    if (string3 != null) break block3;
                }
                object = super.toString();
            }
            return object;
        }

        @Override
        @Nullable
        public AnimationUnit.Unit<?> parseUnit(@NotNull Function1<? super Integer, String> getValue2) {
            Intrinsics.checkNotNullParameter(getValue2, (String)"getValue");
            try {
                Color color;
                String string = (String)getValue2.invoke((Object)0);
                if (string == null) {
                    return null;
                }
                float component1 = Float.parseFloat(string);
                String string2 = (String)getValue2.invoke((Object)1);
                if (string2 == null) {
                    return null;
                }
                float component2 = Float.parseFloat(string2);
                String string3 = (String)getValue2.invoke((Object)2);
                if (string3 == null) {
                    return null;
                }
                float component3 = Float.parseFloat(string3);
                String string4 = (String)getValue2.invoke((Object)3);
                if (string4 == null) {
                    return null;
                }
                float component4 = Float.parseFloat(string4);
                Color it = color = new Color(component1, component2, component3, component4);
                boolean bl = false;
                return it.getColor() != null ? color : null;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        @Override
        @NotNull
        public String getPickerTitle() {
            return ComposePreviewBundle.message("animation.inspector.picker.color", new Object[0]);
        }

        static {
            String[] stringArray = new String[]{"red", "green", "blue", "alpha"};
            COMPONENT_NAMES = stringArray;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Color$Companion;", "", "<init>", "()V", "CLASS_NAME", "", "COMPONENT_NAMES", "", "getCOMPONENT_NAMES$intellij_android_compose_designer", "()[Ljava/lang/String;", "[Ljava/lang/String;", "create", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Color;", "property", "color", "Ljava/awt/Color;", "intellij.android.compose-designer"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final String[] getCOMPONENT_NAMES$intellij_android_compose_designer() {
                return COMPONENT_NAMES;
            }

            @NotNull
            public final Color create(@NotNull Object property) {
                Object value;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Method method = INSTANCE.findMethodByName("unbox-impl", property);
                Object object = value = method != null ? method.invoke(property, new Object[0]) : null;
                if (value instanceof Long) {
                    Object alpha;
                    Object object2;
                    Object object3;
                    Object object4;
                    Method method2 = INSTANCE.findMethodByName("getRed-impl", property);
                    if (method2 != null) {
                        Object[] objectArray = new Object[]{value};
                        object4 = method2.invoke(null, objectArray);
                    } else {
                        object4 = null;
                    }
                    Object red = object4;
                    Method method3 = INSTANCE.findMethodByName("getGreen-impl", property);
                    if (method3 != null) {
                        Object[] objectArray = new Object[]{value};
                        object3 = method3.invoke(null, objectArray);
                    } else {
                        object3 = null;
                    }
                    Object green = object3;
                    Method method4 = INSTANCE.findMethodByName("getBlue-impl", property);
                    if (method4 != null) {
                        Object[] objectArray = new Object[]{value};
                        object2 = method4.invoke(null, objectArray);
                    } else {
                        object2 = null;
                    }
                    Object blue = object2;
                    Method method5 = INSTANCE.findMethodByName("getAlpha-impl", property);
                    if (method5 != null) {
                        Object[] objectArray = new Object[]{value};
                        v9 = method5.invoke(null, objectArray);
                    } else {
                        v9 = alpha = null;
                    }
                    if (red instanceof Float && green instanceof Float && blue instanceof Float && alpha instanceof Float) {
                        return new Color(((Number)red).floatValue(), ((Number)green).floatValue(), ((Number)blue).floatValue(), ((Number)alpha).floatValue());
                    }
                }
                throw new ComposeParseException(Reflection.getOrCreateKotlinClass(Color.class).getSimpleName());
            }

            @NotNull
            public final Color create(@NotNull java.awt.Color color) {
                Intrinsics.checkNotNullParameter((Object)color, (String)"color");
                return new Color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$ComposeParseException;", "Ljava/lang/IllegalArgumentException;", "Lkotlin/IllegalArgumentException;", "className", "", "<init>", "(Ljava/lang/String;)V", "intellij.android.compose-designer"})
    @StabilityInferred(parameters=0)
    public static final class ComposeParseException
    extends IllegalArgumentException {
        public static final int $stable = 8;

        public ComposeParseException(@Nullable String className) {
            super("Can't parse " + className + " from library");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B)\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0004\"\u00028\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0006H\u0016R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$ComposeUnit;", "A", "Lcom/android/tools/idea/preview/animation/AnimationUnit$BaseUnit;", "components", "", "componentNames", "", "<init>", "([Ljava/lang/Object;[Ljava/lang/String;)V", "getComponentNames", "()[Ljava/lang/String;", "[Ljava/lang/String;", "toString", "componentId", "", "create", "property", "", "createProperties", "", "Lcom/android/tools/idea/compose/preview/animation/picker/AnimatedPropertyItem;", "prefix", "intellij.android.compose-designer"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nComposeUnit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeUnit.kt\ncom/android/tools/idea/compose/preview/animation/ComposeUnit$ComposeUnit\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,419:1\n1573#2:420\n1604#2,4:421\n*S KotlinDebug\n*F\n+ 1 ComposeUnit.kt\ncom/android/tools/idea/compose/preview/animation/ComposeUnit$ComposeUnit\n*L\n68#1:420\n68#1:421,4\n*E\n"})
    public static abstract class ComposeUnit<A>
    extends AnimationUnit.BaseUnit<A> {
        @NotNull
        private final String[] componentNames;
        public static final int $stable = 8;

        public ComposeUnit(@NotNull A[] components, @NotNull String[] componentNames) {
            Intrinsics.checkNotNullParameter(components, (String)"components");
            Intrinsics.checkNotNullParameter((Object)componentNames, (String)"componentNames");
            super(Arrays.copyOf(components, components.length));
            this.componentNames = componentNames;
        }

        @NotNull
        public final String[] getComponentNames() {
            return this.componentNames;
        }

        @Override
        @NotNull
        public String toString(int componentId) {
            return this.componentNames[componentId] + " " + super.toString(componentId);
        }

        @NotNull
        public abstract ComposeUnit<A> create(@NotNull Object var1);

        /*
         * WARNING - void declaration
         */
        @NotNull
        public List<AnimatedPropertyItem> createProperties(@NotNull String prefix) {
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Iterable $this$mapIndexed$iv = this.getComponents();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void component;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new AnimatedPropertyItem(this.componentNames[index], String.valueOf(component), (Function1<? super String, ? extends Pair<? extends EditingErrorCategory, String>>)((Function1)ComposeUnit::createProperties$lambda$0$0), "Any"));
            }
            return (List)destination$iv$iv;
        }

        private static final Pair createProperties$lambda$0$0(String it) {
            return EditingSupportKt.EDITOR_NO_ERROR;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0016B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J$\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Dp;", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$ComposeUnit;", "", "Lcom/android/tools/idea/preview/animation/AnimationUnit$NumberUnit;", "component", "<init>", "(F)V", "create", "property", "", "createProperties", "", "Lcom/android/tools/idea/compose/preview/animation/picker/AnimatedPropertyItem;", "prefix", "", "toString", "parseUnit", "Lcom/android/tools/idea/preview/animation/AnimationUnit$Unit;", "getValue", "Lkotlin/Function1;", "", "getPickerTitle", "Companion", "intellij.android.compose-designer"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nComposeUnit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeUnit.kt\ncom/android/tools/idea/compose/preview/animation/ComposeUnit$Dp\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,419:1\n1#2:420\n*E\n"})
    public static final class Dp
    extends ComposeUnit<Float>
    implements AnimationUnit.NumberUnit<Float> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        public static final int $stable = 8;
        @NotNull
        public static final String CLASS_NAME = "androidx.compose.ui.unit.Dp";

        public Dp(float component) {
            Object[] objectArray = new Float[]{Float.valueOf(component)};
            Float[] floatArray = objectArray;
            objectArray = new String[]{"dp"};
            super((A[])floatArray, (String[])objectArray);
        }

        @NotNull
        public Dp create(@NotNull Object property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            return Companion.create(property);
        }

        @Override
        @NotNull
        public List<AnimatedPropertyItem> createProperties(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            return CollectionsKt.listOf((Object)new AnimatedPropertyItem(prefix, String.valueOf(((Number)this.getComponents().get(0)).floatValue()), FloatValidationKt.getDpValidation(), "Float"));
        }

        @Override
        @NotNull
        public String toString() {
            return this.getComponents().get(0) + "dp";
        }

        @Override
        @Nullable
        public AnimationUnit.Unit<?> parseUnit(@NotNull Function1<? super Integer, String> getValue2) {
            AnimationUnit.Unit unit;
            Intrinsics.checkNotNullParameter(getValue2, (String)"getValue");
            try {
                Dp dp;
                String string = (String)getValue2.invoke((Object)0);
                if (string != null) {
                    float it = Float.parseFloat(string);
                    boolean bl = false;
                    dp = new Dp(it);
                } else {
                    dp = null;
                }
                unit = dp;
            }
            catch (NumberFormatException numberFormatException) {
                unit = null;
            }
            return unit;
        }

        @Override
        @NotNull
        public String getPickerTitle() {
            return ComposePreviewBundle.message("animation.inspector.picker.dp", new Object[0]);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Dp$Companion;", "", "<init>", "()V", "CLASS_NAME", "", "create", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Dp;", "property", "intellij.android.compose-designer"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Dp create(@NotNull Object property) {
                Object value;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Method method = INSTANCE.findMethodByName("getValue", property);
                Object object = value = method != null ? method.invoke(property, new Object[0]) : null;
                if (value instanceof Float) {
                    return new Dp(((Number)value).floatValue());
                }
                throw new ComposeParseException(Reflection.getOrCreateKotlinClass(Dp.class).getSimpleName());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0015B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0016\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$IntOffset;", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$ComposeUnit;", "", "Lcom/android/tools/idea/preview/animation/AnimationUnit$NumberUnit;", "x", "y", "<init>", "(II)V", "create", "property", "", "createProperties", "", "Lcom/android/tools/idea/compose/preview/animation/picker/AnimatedPropertyItem;", "prefix", "", "parseUnit", "Lcom/android/tools/idea/preview/animation/AnimationUnit$Unit;", "getValue", "Lkotlin/Function1;", "getPickerTitle", "Companion", "intellij.android.compose-designer"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nComposeUnit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeUnit.kt\ncom/android/tools/idea/compose/preview/animation/ComposeUnit$IntOffset\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,419:1\n1573#2:420\n1604#2,4:421\n*S KotlinDebug\n*F\n+ 1 ComposeUnit.kt\ncom/android/tools/idea/compose/preview/animation/ComposeUnit$IntOffset\n*L\n145#1:420\n145#1:421,4\n*E\n"})
    public static final class IntOffset
    extends ComposeUnit<Integer>
    implements AnimationUnit.NumberUnit<Integer> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        public static final int $stable = 8;
        @NotNull
        public static final String CLASS_NAME = "androidx.compose.ui.unit.IntOffset";
        @NotNull
        private static final String[] COMPONENT_NAMES;

        public IntOffset(int x, int y) {
            Object[] objectArray = new Integer[]{x, y};
            Integer[] integerArray = objectArray;
            objectArray = new String[]{"x", "y"};
            super((A[])integerArray, (String[])objectArray);
        }

        @NotNull
        public IntOffset create(@NotNull Object property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            return Companion.create(property);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<AnimatedPropertyItem> createProperties(@NotNull String prefix) {
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Iterable $this$mapIndexed$iv = this.getComponents();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void component;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = ((Number)item$iv$iv).intValue();
                int n3 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new AnimatedPropertyItem(COMPONENT_NAMES[index], String.valueOf((int)component), (Function1<? super String, ? extends Pair<? extends EditingErrorCategory, String>>)((Function1)IntValidation.INSTANCE), "Int"));
            }
            return (List)destination$iv$iv;
        }

        @Override
        @Nullable
        public AnimationUnit.Unit<?> parseUnit(@NotNull Function1<? super Integer, String> getValue2) {
            Intrinsics.checkNotNullParameter(getValue2, (String)"getValue");
            try {
                String string = (String)getValue2.invoke((Object)0);
                if (string == null) {
                    return null;
                }
                int component1 = Integer.parseInt(string);
                String string2 = (String)getValue2.invoke((Object)1);
                if (string2 == null) {
                    return null;
                }
                int component2 = Integer.parseInt(string2);
                return new IntOffset(component1, component2);
            }
            catch (NumberFormatException numberFormatException) {
                AnimationUnit.Unit<?> unit = null;
                return unit;
            }
        }

        @Override
        @NotNull
        public String getPickerTitle() {
            return ComposePreviewBundle.message("animation.inspector.picker.int.offset", new Object[0]);
        }

        static {
            String[] stringArray = new String[]{"x", "y"};
            COMPONENT_NAMES = stringArray;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$IntOffset$Companion;", "", "<init>", "()V", "CLASS_NAME", "", "COMPONENT_NAMES", "", "getCOMPONENT_NAMES$intellij_android_compose_designer", "()[Ljava/lang/String;", "[Ljava/lang/String;", "create", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$IntOffset;", "property", "intellij.android.compose-designer"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final String[] getCOMPONENT_NAMES$intellij_android_compose_designer() {
                return COMPONENT_NAMES;
            }

            @NotNull
            public final IntOffset create(@NotNull Object property) {
                Object value;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Method method = INSTANCE.findMethodByName("unbox-impl", property);
                Object object = value = method != null ? method.invoke(property, new Object[0]) : null;
                if (value instanceof Long) {
                    Object y;
                    Object object2;
                    Method method2 = INSTANCE.findMethodByName("getX-impl", property);
                    if (method2 != null) {
                        Object[] objectArray = new Object[]{value};
                        object2 = method2.invoke(null, objectArray);
                    } else {
                        object2 = null;
                    }
                    Object x = object2;
                    Method method3 = INSTANCE.findMethodByName("getY-impl", property);
                    if (method3 != null) {
                        Object[] objectArray = new Object[]{value};
                        v5 = method3.invoke(null, objectArray);
                    } else {
                        v5 = y = null;
                    }
                    if (x instanceof Integer && y instanceof Integer) {
                        return new IntOffset(((Number)x).intValue(), ((Number)y).intValue());
                    }
                }
                throw new ComposeParseException(Reflection.getOrCreateKotlinClass(IntOffset.class).getSimpleName());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0015B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0016\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$IntSize;", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$ComposeUnit;", "", "Lcom/android/tools/idea/preview/animation/AnimationUnit$NumberUnit;", "width", "height", "<init>", "(II)V", "create", "property", "", "createProperties", "", "Lcom/android/tools/idea/compose/preview/animation/picker/AnimatedPropertyItem;", "prefix", "", "parseUnit", "Lcom/android/tools/idea/preview/animation/AnimationUnit$Unit;", "getValue", "Lkotlin/Function1;", "getPickerTitle", "Companion", "intellij.android.compose-designer"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nComposeUnit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeUnit.kt\ncom/android/tools/idea/compose/preview/animation/ComposeUnit$IntSize\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,419:1\n1573#2:420\n1604#2,4:421\n*S KotlinDebug\n*F\n+ 1 ComposeUnit.kt\ncom/android/tools/idea/compose/preview/animation/ComposeUnit$IntSize\n*L\n107#1:420\n107#1:421,4\n*E\n"})
    public static final class IntSize
    extends ComposeUnit<Integer>
    implements AnimationUnit.NumberUnit<Integer> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        public static final int $stable = 8;
        @NotNull
        public static final String CLASS_NAME = "androidx.compose.ui.unit.IntSize";
        @NotNull
        private static final String[] COMPONENT_NAMES;

        public IntSize(int width, int height) {
            Object[] objectArray = new Integer[]{width, height};
            Integer[] integerArray = objectArray;
            objectArray = new String[]{"width", "height"};
            super((A[])integerArray, (String[])objectArray);
        }

        @NotNull
        public IntSize create(@NotNull Object property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            return Companion.create(property);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<AnimatedPropertyItem> createProperties(@NotNull String prefix) {
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Iterable $this$mapIndexed$iv = this.getComponents();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void component;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = ((Number)item$iv$iv).intValue();
                int n3 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new AnimatedPropertyItem(COMPONENT_NAMES[index], String.valueOf((int)component), (Function1<? super String, ? extends Pair<? extends EditingErrorCategory, String>>)((Function1)IntValidation.INSTANCE), "Int"));
            }
            return (List)destination$iv$iv;
        }

        @Override
        @Nullable
        public AnimationUnit.Unit<?> parseUnit(@NotNull Function1<? super Integer, String> getValue2) {
            Intrinsics.checkNotNullParameter(getValue2, (String)"getValue");
            try {
                String string = (String)getValue2.invoke((Object)0);
                if (string == null) {
                    return null;
                }
                int component1 = Integer.parseInt(string);
                String string2 = (String)getValue2.invoke((Object)1);
                if (string2 == null) {
                    return null;
                }
                int component2 = Integer.parseInt(string2);
                return new IntSize(component1, component2);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        @Override
        @NotNull
        public String getPickerTitle() {
            return ComposePreviewBundle.message("animation.inspector.picker.int.size", new Object[0]);
        }

        static {
            String[] stringArray = new String[]{"width", "height"};
            COMPONENT_NAMES = stringArray;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$IntSize$Companion;", "", "<init>", "()V", "CLASS_NAME", "", "COMPONENT_NAMES", "", "getCOMPONENT_NAMES$intellij_android_compose_designer", "()[Ljava/lang/String;", "[Ljava/lang/String;", "create", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$IntSize;", "property", "intellij.android.compose-designer"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final String[] getCOMPONENT_NAMES$intellij_android_compose_designer() {
                return COMPONENT_NAMES;
            }

            @NotNull
            public final IntSize create(@NotNull Object property) {
                Object value;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Method method = INSTANCE.findMethodByName("unbox-impl", property);
                Object object = value = method != null ? method.invoke(property, new Object[0]) : null;
                if (value instanceof Long) {
                    Object height;
                    Object object2;
                    Method method2 = INSTANCE.findMethodByName("getWidth-impl", property);
                    if (method2 != null) {
                        Object[] objectArray = new Object[]{value};
                        object2 = method2.invoke(null, objectArray);
                    } else {
                        object2 = null;
                    }
                    Object width = object2;
                    Method method3 = INSTANCE.findMethodByName("getHeight-impl", property);
                    if (method3 != null) {
                        Object[] objectArray = new Object[]{value};
                        v5 = method3.invoke(null, objectArray);
                    } else {
                        v5 = height = null;
                    }
                    if (width instanceof Integer && height instanceof Integer) {
                        return new IntSize(((Number)width).intValue(), ((Number)height).intValue());
                    }
                }
                throw new ComposeParseException(Reflection.getOrCreateKotlinClass(IntSize.class).getSimpleName());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0016B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Offset;", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$ComposeUnit;", "", "Lcom/android/tools/idea/preview/animation/AnimationUnit$NumberUnit;", "component1", "component2", "<init>", "(FF)V", "create", "property", "", "createProperties", "", "Lcom/android/tools/idea/compose/preview/animation/picker/AnimatedPropertyItem;", "prefix", "", "parseUnit", "Lcom/android/tools/idea/preview/animation/AnimationUnit$Unit;", "getValue", "Lkotlin/Function1;", "", "getPickerTitle", "Companion", "intellij.android.compose-designer"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nComposeUnit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeUnit.kt\ncom/android/tools/idea/compose/preview/animation/ComposeUnit$Offset\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,419:1\n1573#2:420\n1604#2,4:421\n*S KotlinDebug\n*F\n+ 1 ComposeUnit.kt\ncom/android/tools/idea/compose/preview/animation/ComposeUnit$Offset\n*L\n305#1:420\n305#1:421,4\n*E\n"})
    public static final class Offset
    extends ComposeUnit<Float>
    implements AnimationUnit.NumberUnit<Float> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        public static final int $stable = 8;
        @NotNull
        public static final String CLASS_NAME = "androidx.compose.ui.geometry.Offset";
        @NotNull
        private static final String[] COMPONENT_NAMES;

        public Offset(float component1, float component2) {
            Object[] objectArray = new Float[]{Float.valueOf(component1), Float.valueOf(component2)};
            Float[] floatArray = objectArray;
            objectArray = new String[]{"x", "y"};
            super((A[])floatArray, (String[])objectArray);
        }

        @NotNull
        public Offset create(@NotNull Object property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            return Companion.create(property);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<AnimatedPropertyItem> createProperties(@NotNull String prefix) {
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Iterable $this$mapIndexed$iv = this.getComponents();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void component;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                float f = ((Number)item$iv$iv).floatValue();
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new AnimatedPropertyItem(COMPONENT_NAMES[index], String.valueOf((float)component), FloatValidationKt.getFloatValidation(), "Float"));
            }
            return (List)destination$iv$iv;
        }

        @Override
        @Nullable
        public AnimationUnit.Unit<?> parseUnit(@NotNull Function1<? super Integer, String> getValue2) {
            Intrinsics.checkNotNullParameter(getValue2, (String)"getValue");
            try {
                String string = (String)getValue2.invoke((Object)0);
                if (string == null) {
                    return null;
                }
                float component1 = Float.parseFloat(string);
                String string2 = (String)getValue2.invoke((Object)1);
                if (string2 == null) {
                    return null;
                }
                float component2 = Float.parseFloat(string2);
                return new Offset(component1, component2);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        @Override
        @NotNull
        public String getPickerTitle() {
            return ComposePreviewBundle.message("animation.inspector.picker.offset", new Object[0]);
        }

        static {
            String[] stringArray = new String[]{"x", "y"};
            COMPONENT_NAMES = stringArray;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Offset$Companion;", "", "<init>", "()V", "CLASS_NAME", "", "COMPONENT_NAMES", "", "getCOMPONENT_NAMES$intellij_android_compose_designer", "()[Ljava/lang/String;", "[Ljava/lang/String;", "create", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Offset;", "property", "intellij.android.compose-designer"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final String[] getCOMPONENT_NAMES$intellij_android_compose_designer() {
                return COMPONENT_NAMES;
            }

            @NotNull
            public final Offset create(@NotNull Object property) {
                Object value;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Method method = INSTANCE.findMethodByName("unbox-impl", property);
                Object object = value = method != null ? method.invoke(property, new Object[0]) : null;
                if (value instanceof Long) {
                    Object y;
                    Object object2;
                    Method method2 = INSTANCE.findMethodByName("getX-impl", property);
                    if (method2 != null) {
                        Object[] objectArray = new Object[]{value};
                        object2 = method2.invoke(null, objectArray);
                    } else {
                        object2 = null;
                    }
                    Object x = object2;
                    Method method3 = INSTANCE.findMethodByName("getY-impl", property);
                    if (method3 != null) {
                        Object[] objectArray = new Object[]{value};
                        v5 = method3.invoke(null, objectArray);
                    } else {
                        v5 = y = null;
                    }
                    if (x instanceof Float && y instanceof Float) {
                        return new Offset(((Number)x).floatValue(), ((Number)y).floatValue());
                    }
                }
                throw new ComposeParseException(Reflection.getOrCreateKotlinClass(Offset.class).getSimpleName());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0018B'\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00132\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Rect;", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$ComposeUnit;", "", "Lcom/android/tools/idea/preview/animation/AnimationUnit$NumberUnit;", "component1", "component2", "component3", "component4", "<init>", "(FFFF)V", "create", "property", "", "createProperties", "", "Lcom/android/tools/idea/compose/preview/animation/picker/AnimatedPropertyItem;", "prefix", "", "parseUnit", "Lcom/android/tools/idea/preview/animation/AnimationUnit$Unit;", "getValue", "Lkotlin/Function1;", "", "getPickerTitle", "Companion", "intellij.android.compose-designer"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nComposeUnit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeUnit.kt\ncom/android/tools/idea/compose/preview/animation/ComposeUnit$Rect\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,419:1\n1573#2:420\n1604#2,4:421\n*S KotlinDebug\n*F\n+ 1 ComposeUnit.kt\ncom/android/tools/idea/compose/preview/animation/ComposeUnit$Rect\n*L\n264#1:420\n264#1:421,4\n*E\n"})
    public static final class Rect
    extends ComposeUnit<Float>
    implements AnimationUnit.NumberUnit<Float> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        public static final int $stable = 8;
        @NotNull
        public static final String CLASS_NAME = "androidx.compose.ui.geometry.Rect";
        @NotNull
        private static final String[] COMPONENT_NAMES;

        public Rect(float component1, float component2, float component3, float component4) {
            Object[] objectArray = new Float[]{Float.valueOf(component1), Float.valueOf(component2), Float.valueOf(component3), Float.valueOf(component4)};
            Float[] floatArray = objectArray;
            objectArray = new String[]{"left", "top", "right", "bottom"};
            super((A[])floatArray, (String[])objectArray);
        }

        @NotNull
        public Rect create(@NotNull Object property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            return Companion.create(property);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<AnimatedPropertyItem> createProperties(@NotNull String prefix) {
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Iterable $this$mapIndexed$iv = this.getComponents();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void component;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                float f = ((Number)item$iv$iv).floatValue();
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new AnimatedPropertyItem(COMPONENT_NAMES[index], String.valueOf((float)component), FloatValidationKt.getFloatValidation(), "Float"));
            }
            return (List)destination$iv$iv;
        }

        @Override
        @Nullable
        public AnimationUnit.Unit<?> parseUnit(@NotNull Function1<? super Integer, String> getValue2) {
            Intrinsics.checkNotNullParameter(getValue2, (String)"getValue");
            try {
                String string = (String)getValue2.invoke((Object)0);
                if (string == null) {
                    return null;
                }
                float component1 = Float.parseFloat(string);
                String string2 = (String)getValue2.invoke((Object)1);
                if (string2 == null) {
                    return null;
                }
                float component2 = Float.parseFloat(string2);
                String string3 = (String)getValue2.invoke((Object)2);
                if (string3 == null) {
                    return null;
                }
                float component3 = Float.parseFloat(string3);
                String string4 = (String)getValue2.invoke((Object)3);
                if (string4 == null) {
                    return null;
                }
                float component4 = Float.parseFloat(string4);
                return new Rect(component1, component2, component3, component4);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        @Override
        @NotNull
        public String getPickerTitle() {
            return ComposePreviewBundle.message("animation.inspector.picker.rect", new Object[0]);
        }

        static {
            String[] stringArray = new String[]{"left", "top", "right", "bottom"};
            COMPONENT_NAMES = stringArray;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Rect$Companion;", "", "<init>", "()V", "CLASS_NAME", "", "COMPONENT_NAMES", "", "getCOMPONENT_NAMES$intellij_android_compose_designer", "()[Ljava/lang/String;", "[Ljava/lang/String;", "create", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Rect;", "property", "intellij.android.compose-designer"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final String[] getCOMPONENT_NAMES$intellij_android_compose_designer() {
                return COMPONENT_NAMES;
            }

            @NotNull
            public final Rect create(@NotNull Object property) {
                Object bottom;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Method method = INSTANCE.findMethodByName("getLeft", property);
                Object left = method != null ? method.invoke(property, new Object[0]) : null;
                Method method2 = INSTANCE.findMethodByName("getTop", property);
                Object top = method2 != null ? method2.invoke(property, new Object[0]) : null;
                Method method3 = INSTANCE.findMethodByName("getRight", property);
                Object right = method3 != null ? method3.invoke(property, new Object[0]) : null;
                Method method4 = INSTANCE.findMethodByName("getBottom", property);
                Object object = bottom = method4 != null ? method4.invoke(property, new Object[0]) : null;
                if (left instanceof Float && right instanceof Float && top instanceof Float && bottom instanceof Float) {
                    return new Rect(((Number)left).floatValue(), ((Number)top).floatValue(), ((Number)right).floatValue(), ((Number)bottom).floatValue());
                }
                throw new ComposeParseException(Reflection.getOrCreateKotlinClass(Rect.class).getSimpleName());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0016B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Size;", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$ComposeUnit;", "", "Lcom/android/tools/idea/preview/animation/AnimationUnit$NumberUnit;", "component1", "component2", "<init>", "(FF)V", "create", "property", "", "createProperties", "", "Lcom/android/tools/idea/compose/preview/animation/picker/AnimatedPropertyItem;", "prefix", "", "parseUnit", "Lcom/android/tools/idea/preview/animation/AnimationUnit$Unit;", "getValue", "Lkotlin/Function1;", "", "getPickerTitle", "Companion", "intellij.android.compose-designer"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nComposeUnit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeUnit.kt\ncom/android/tools/idea/compose/preview/animation/ComposeUnit$Size\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,419:1\n1573#2:420\n1604#2,4:421\n*S KotlinDebug\n*F\n+ 1 ComposeUnit.kt\ncom/android/tools/idea/compose/preview/animation/ComposeUnit$Size\n*L\n219#1:420\n219#1:421,4\n*E\n"})
    public static final class Size
    extends ComposeUnit<Float>
    implements AnimationUnit.NumberUnit<Float> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        public static final int $stable = 8;
        @NotNull
        public static final String CLASS_NAME = "androidx.compose.ui.geometry.Size";
        @NotNull
        private static final String[] COMPONENT_NAMES;

        public Size(float component1, float component2) {
            Object[] objectArray = new Float[]{Float.valueOf(component1), Float.valueOf(component2)};
            Float[] floatArray = objectArray;
            objectArray = new String[]{"width", "height"};
            super((A[])floatArray, (String[])objectArray);
        }

        @NotNull
        public Size create(@NotNull Object property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            return Companion.create(property);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<AnimatedPropertyItem> createProperties(@NotNull String prefix) {
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Iterable $this$mapIndexed$iv = this.getComponents();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void component;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                float f = ((Number)item$iv$iv).floatValue();
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new AnimatedPropertyItem(COMPONENT_NAMES[index], String.valueOf((float)component), FloatValidationKt.getFloatValidation(), "Float"));
            }
            return (List)destination$iv$iv;
        }

        @Override
        @Nullable
        public AnimationUnit.Unit<?> parseUnit(@NotNull Function1<? super Integer, String> getValue2) {
            Intrinsics.checkNotNullParameter(getValue2, (String)"getValue");
            try {
                String string = (String)getValue2.invoke((Object)0);
                if (string == null) {
                    return null;
                }
                float component1 = Float.parseFloat(string);
                String string2 = (String)getValue2.invoke((Object)1);
                if (string2 == null) {
                    return null;
                }
                float component2 = Float.parseFloat(string2);
                return new Size(component1, component2);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        @Override
        @NotNull
        public String getPickerTitle() {
            return ComposePreviewBundle.message("animation.inspector.picker.size", new Object[0]);
        }

        static {
            String[] stringArray = new String[]{"width", "height"};
            COMPONENT_NAMES = stringArray;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Size$Companion;", "", "<init>", "()V", "CLASS_NAME", "", "COMPONENT_NAMES", "", "getCOMPONENT_NAMES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "create", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Size;", "property", "intellij.android.compose-designer"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final String[] getCOMPONENT_NAMES() {
                return COMPONENT_NAMES;
            }

            @NotNull
            public final Size create(@NotNull Object property) {
                Object value;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Method method = INSTANCE.findMethodByName("unbox-impl", property);
                Object object = value = method != null ? method.invoke(property, new Object[0]) : null;
                if (value instanceof Long) {
                    Object height;
                    Object object2;
                    Method method2 = INSTANCE.findMethodByName("getWidth-impl", property);
                    if (method2 != null) {
                        Object[] objectArray = new Object[]{value};
                        object2 = method2.invoke(null, objectArray);
                    } else {
                        object2 = null;
                    }
                    Object width = object2;
                    Method method3 = INSTANCE.findMethodByName("getHeight-impl", property);
                    if (method3 != null) {
                        Object[] objectArray = new Object[]{value};
                        v5 = method3.invoke(null, objectArray);
                    } else {
                        v5 = height = null;
                    }
                    if (width instanceof Float && height instanceof Float) {
                        return new Size(((Number)width).floatValue(), ((Number)height).floatValue());
                    }
                }
                throw new ComposeParseException(Reflection.getOrCreateKotlinClass(Size.class).getSimpleName());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

