/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.animation;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.compose.preview.analytics.AnimationToolingEvent;
import com.android.tools.idea.compose.preview.analytics.AnimationToolingUsageTracker;
import com.android.tools.idea.preview.animation.AnimationTracker;
import com.google.wireless.android.sdk.stats.ComposeAnimationToolingEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u000e\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0007H\u0016J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\b\u0010\u0016\u001a\u00020\u0007H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\b\u0010\u0019\u001a\u00020\u0007H\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\b\u0010\u001b\u001a\u00020\u0007H\u0016J\b\u0010\u001c\u001a\u00020\u0007H\u0016J\b\u0010\u001d\u001a\u00020\u0007H\u0016J\b\u0010\u001e\u001a\u00020\u0007H\u0016J\b\u0010\u001f\u001a\u00020\u0007H\u0016J\b\u0010 \u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeAnimationTracker;", "Lcom/android/tools/idea/preview/animation/AnimationTracker;", "eventLogger", "Lcom/android/tools/idea/compose/preview/analytics/AnimationToolingUsageTracker;", "<init>", "(Lcom/android/tools/idea/compose/preview/analytics/AnimationToolingUsageTracker;)V", "logEvent", "", "type", "Lcom/google/wireless/android/sdk/stats/ComposeAnimationToolingEvent$ComposeAnimationToolingEventType;", "openAnimationInspector", "closeAnimationInspector", "animationInspectorAvailable", "triggerPlayAction", "triggerPauseAction", "enableLoopAction", "disableLoopAction", "changeAnimationSpeed", "speedMultiplier", "", "triggerJumpToStartAction", "triggerJumpToEndAction", "changeStartState", "changeEndState", "triggerSwapStatesAction", "clickAnimationInspectorTimeline", "expandAnimationCard", "collapseAnimationCard", "openAnimationInTab", "closeAnimationTab", "lockAnimation", "unlockAnimation", "openPicker", "intellij.android.compose-designer"})
@StabilityInferred(parameters=0)
public final class ComposeAnimationTracker
implements AnimationTracker {
    @NotNull
    private final AnimationToolingUsageTracker eventLogger;
    public static final int $stable = 8;

    public ComposeAnimationTracker(@NotNull AnimationToolingUsageTracker eventLogger) {
        Intrinsics.checkNotNullParameter((Object)eventLogger, (String)"eventLogger");
        this.eventLogger = eventLogger;
    }

    private final void logEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType type) {
        this.eventLogger.logEvent(new AnimationToolingEvent(type));
    }

    @Override
    public void openAnimationInspector() {
        this.logEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.OPEN_ANIMATION_INSPECTOR);
    }

    @Override
    public void closeAnimationInspector() {
        this.logEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.CLOSE_ANIMATION_INSPECTOR);
    }

    @Override
    public void animationInspectorAvailable() {
        this.logEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.ANIMATION_INSPECTOR_AVAILABLE);
    }

    @Override
    public void triggerPlayAction() {
        this.logEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.TRIGGER_PLAY_ACTION);
    }

    @Override
    public void triggerPauseAction() {
        this.logEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.TRIGGER_PAUSE_ACTION);
    }

    @Override
    public void enableLoopAction() {
        this.logEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.ENABLE_LOOP_ACTION);
    }

    @Override
    public void disableLoopAction() {
        this.logEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.DISABLE_LOOP_ACTION);
    }

    @Override
    public void changeAnimationSpeed(float speedMultiplier) {
        AnimationToolingEvent event = new AnimationToolingEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.CHANGE_ANIMATION_SPEED).withAnimationMultiplier(speedMultiplier);
        this.eventLogger.logEvent(event);
    }

    @Override
    public void triggerJumpToStartAction() {
        this.logEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.TRIGGER_JUMP_TO_START_ACTION);
    }

    @Override
    public void triggerJumpToEndAction() {
        this.logEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.TRIGGER_JUMP_TO_END_ACTION);
    }

    @Override
    public void changeStartState() {
        this.logEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.CHANGE_START_STATE);
    }

    @Override
    public void changeEndState() {
        this.logEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.CHANGE_END_STATE);
    }

    @Override
    public void triggerSwapStatesAction() {
        this.logEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.TRIGGER_SWAP_STATES_ACTION);
    }

    @Override
    public void clickAnimationInspectorTimeline() {
        this.logEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.CLICK_ANIMATION_INSPECTOR_TIMELINE);
    }

    @Override
    public void expandAnimationCard() {
        this.logEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.EXPAND_ANIMATION_CARD);
    }

    @Override
    public void collapseAnimationCard() {
        this.logEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.COLLAPSE_ANIMATION_CARD);
    }

    @Override
    public void openAnimationInTab() {
        this.logEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.OPEN_ANIMATION_IN_TAB);
    }

    @Override
    public void closeAnimationTab() {
        this.logEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.CLOSE_ANIMATION_TAB);
    }

    @Override
    public void lockAnimation() {
        this.logEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.LOCK_ANIMATION);
    }

    @Override
    public void unlockAnimation() {
        this.logEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.UNLOCK_ANIMATION);
    }

    @Override
    public void openPicker() {
        this.logEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.OPEN_PICKER);
    }
}

