/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.compose.preview.ComposeViewInfo;
import com.android.tools.idea.compose.preview.PxBounds;
import com.android.tools.idea.compose.preview.util.UtilsKt;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\f"}, d2={"subComponentProvider", "Ljava/awt/Rectangle;", "sceneView", "Lcom/android/tools/idea/common/surface/SceneView;", "x", "", "y", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "findSubComponent", "deepestViewInfo", "Lcom/android/tools/idea/compose/preview/ComposeViewInfo;", "intellij.android.compose-designer"})
public final class ComposePreviewSubComponentProviderKt {
    @NotNull
    public static final Rectangle subComponentProvider(@NotNull SceneView sceneView, int x, int y, @NotNull Logger logger) {
        Collection<ComposeViewInfo> smallestViewInfos;
        Intrinsics.checkNotNullParameter((Object)sceneView, (String)"sceneView");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Collection<ComposeViewInfo> collection = smallestViewInfos = UtilsKt.getSmallestViewInfos(sceneView, x, y, logger);
        if (collection == null || collection.isEmpty()) {
            logger.info("Could not find the view to zoom to, zooming to the whole Preview.");
            return new Rectangle(new Point(0, 0), sceneView.getScaledContentSize());
        }
        if (smallestViewInfos.size() > 1) {
            logger.warn("Expected 1 view to zoom to, but found " + smallestViewInfos.size() + ", choosing the last one.");
        }
        return ComposePreviewSubComponentProviderKt.findSubComponent((ComposeViewInfo)CollectionsKt.last((Iterable)smallestViewInfos), sceneView);
    }

    @NotNull
    public static final Rectangle findSubComponent(@NotNull ComposeViewInfo deepestViewInfo, @NotNull SceneView sceneView) {
        Intrinsics.checkNotNullParameter((Object)deepestViewInfo, (String)"deepestViewInfo");
        Intrinsics.checkNotNullParameter((Object)sceneView, (String)"sceneView");
        PxBounds it = deepestViewInfo.getBounds();
        boolean bl = false;
        Point topLeftCorner = new Point(Coordinates.getSwingDimension(sceneView, it.getLeft()), Coordinates.getSwingDimension(sceneView, it.getTop()));
        Dimension size = new Dimension(Coordinates.getSwingDimension(sceneView, it.getWidth()), Coordinates.getSwingDimension(sceneView, it.getHeight()));
        return new Rectangle(topLeftCorner, size);
    }
}

