/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.util;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class NlTreeDumper {
    private final Map<NlComponent, Integer> myComponentIds;
    private final boolean myIncludeIdentity;
    private final boolean myShowBoundaries;

    public NlTreeDumper() {
        this(true, true);
    }

    public NlTreeDumper(boolean includeIdentity, boolean showBoundaries) {
        this.myComponentIds = includeIdentity ? new HashMap() : Collections.emptyMap();
        this.myIncludeIdentity = includeIdentity;
        this.myShowBoundaries = showBoundaries;
    }

    @NotNull
    public static String dumpTree(@NotNull List<NlComponent> roots) {
        return new NlTreeDumper(false, true).toTree(roots);
    }

    @NotNull
    public String toTree(@NotNull List<NlComponent> roots) {
        StringBuilder sb = new StringBuilder(200);
        for (NlComponent root : roots) {
            this.describe(sb, root, 0, new HashSet<NlComponent>());
        }
        return sb.toString().trim();
    }

    private void describe(@NotNull StringBuilder sb, @NotNull NlComponent component, int depth, @NotNull HashSet<NlComponent> visited) {
        boolean isLoop = !visited.add(component);
        for (int i = 0; i < depth; ++i) {
            sb.append("    ");
        }
        if (isLoop) {
            sb.append("!!LOOP!! ");
        }
        sb.append(this.describe(component)).append('\n');
        if (isLoop) {
            return;
        }
        for (NlComponent child : component.getChildren()) {
            this.describe(sb, child, depth + 1, visited);
        }
    }

    @NotNull
    private String describe(@NotNull NlComponent root) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)root).omitNullValues().add("tag", (Object)("<" + root.getTagName() + ">"));
        if (this.myShowBoundaries && NlComponentHelperKt.getHasNlComponentInfo(root)) {
            helper.add("bounds", (Object)("[" + NlComponentHelperKt.getX(root) + "," + NlComponentHelperKt.getY(root) + ":" + NlComponentHelperKt.getW(root) + "x" + NlComponentHelperKt.getH(root)));
        }
        if (this.myIncludeIdentity) {
            helper.add("instance", this.getInstanceId(root));
        }
        return helper.toString();
    }

    private int getInstanceId(@NotNull NlComponent root) {
        Integer id = this.myComponentIds.get(root);
        if (id == null) {
            id = this.myComponentIds.size();
            this.myComponentIds.put(root, id);
        }
        return id;
    }
}

