/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.idea.common.annotations.InputEventMask;
import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.editor.ActionUtils;
import com.android.tools.idea.common.editor.DesignToolsSplitEditor;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.NlTreeWriter;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceShortcut;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionHandler;
import com.android.tools.idea.common.surface.InteractionHandlerKt;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.surface.SceneViewHelper;
import com.android.tools.idea.common.surface.ScrollInteraction;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.model.NlDropEvent;
import com.android.tools.idea.uibuilder.surface.interaction.DragDropInteraction;
import com.android.tools.idea.uibuilder.surface.interaction.PanInteraction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u000fH\u0016J \u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\"\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u000fH\u0016J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001a\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u0011\u001a\u00020\u000fH\u0016J\u0010\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\u000fH\u0016J\u001a\u0010\"\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u0011\u001a\u00020\u000fH\u0016J$\u0010#\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u000fH\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010\t2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\r2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010(\u001a\u00020\rH\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/android/tools/idea/common/surface/InteractionHandlerBase;", "Lcom/android/tools/idea/common/surface/InteractionHandler;", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "<init>", "(Lcom/android/tools/idea/common/surface/DesignSurface;)V", "cursorWhenNoInteraction", "Ljava/awt/Cursor;", "createInteractionOnDragEnter", "Lcom/android/tools/idea/common/surface/Interaction;", "dragEvent", "Ljava/awt/dnd/DropTargetDragEvent;", "mouseReleaseWhenNoInteraction", "", "x", "", "y", "modifiersEx", "zoom", "type", "Lcom/android/tools/adtui/actions/ZoomType;", "mouseX", "mouseY", "hoverWhenNoInteraction", "stayHovering", "popupMenuTrigger", "mouseEvent", "Ljava/awt/event/MouseEvent;", "createInteractionOnMouseWheelMoved", "mouseWheelEvent", "Ljava/awt/event/MouseWheelEvent;", "singleClick", "onCaretMoved", "line", "doubleClick", "getCursorWhenNoInteraction", "keyPressedWithoutInteraction", "keyEvent", "Ljava/awt/event/KeyEvent;", "keyReleasedWithoutInteraction", "mouseExited", "intellij.android.designer"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nInteractionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InteractionHandler.kt\ncom/android/tools/idea/common/surface/InteractionHandlerBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,488:1\n1374#2:489\n1460#2,5:490\n1869#2,2:495\n1491#2:497\n1516#2,3:498\n1519#2,3:508\n1563#2:511\n1634#2,3:512\n1374#2:519\n1460#2,5:520\n1869#2,2:525\n382#3,7:501\n37#4:515\n36#4,3:516\n216#5,2:527\n*S KotlinDebug\n*F\n+ 1 InteractionHandler.kt\ncom/android/tools/idea/common/surface/InteractionHandlerBase\n*L\n256#1:489\n256#1:490,5\n256#1:495,2\n353#1:497\n353#1:498,3\n353#1:508,3\n365#1:511\n365#1:512,3\n377#1:519\n377#1:520,5\n378#1:525,2\n353#1:501,7\n365#1:515\n365#1:516,3\n361#1:527,2\n*E\n"})
public abstract class InteractionHandlerBase
implements InteractionHandler {
    @NotNull
    private final DesignSurface<?> surface;
    @Nullable
    private Cursor cursorWhenNoInteraction;
    public static final int $stable = 8;

    public InteractionHandlerBase(@NotNull DesignSurface<?> surface2) {
        Intrinsics.checkNotNullParameter(surface2, (String)"surface");
        this.surface = surface2;
    }

    @Override
    @Nullable
    public Interaction createInteractionOnDragEnter(@NotNull DropTargetDragEvent dragEvent) {
        List dragged;
        Intrinsics.checkNotNullParameter((Object)dragEvent, (String)"dragEvent");
        NlDropEvent event = new NlDropEvent(dragEvent);
        Point location = dragEvent.getLocation();
        int mouseX = location.x;
        int mouseY = location.y;
        SceneView sceneView = this.surface.getSceneViewAtOrPrimary(mouseX, mouseY);
        if (sceneView == null) {
            event.reject();
            return null;
        }
        NlTreeWriter treeWriter2 = sceneView.getSceneManager().getModel().getTreeWriter();
        DnDTransferItem item = DnDTransferItem.getTransferItem(event.getTransferable(), true);
        if (item == null) {
            event.reject();
            return null;
        }
        DragType dragType = event.getDropAction() == 1 ? DragType.COPY : DragType.MOVE;
        InsertType insertType = treeWriter2.determineInsertType(dragType, item, true, true);
        if (item.isFromPalette()) {
            this.surface.getSelectionModel().clear();
            v0 = treeWriter2.createComponents(item, insertType);
        } else {
            v0 = dragged = (List)new ArrayList(this.surface.getSelectionModel().getSelection());
        }
        if (dragged.isEmpty()) {
            event.reject();
            return null;
        }
        DragDropInteraction interaction = new DragDropInteraction(this.surface, dragged);
        interaction.setType(dragType);
        interaction.setTransferItem(item);
        event.accept(insertType);
        return interaction;
    }

    @Override
    public void mouseReleaseWhenNoInteraction(int x, int y, @InputEventMask int modifiersEx) {
        block0: {
            boolean allowToggle = (modifiersEx & (1 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) != 0;
            SceneView sceneView = this.surface.getSceneViewAtOrPrimary(x, y);
            if (sceneView == null) break block0;
            SceneViewHelper.selectComponentAt(sceneView, x, y, modifiersEx, allowToggle, false);
        }
    }

    @Override
    public void zoom(@NotNull ZoomType type, int mouseX, int mouseY) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.surface.getZoomController().zoom(type, mouseX, mouseY);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void hoverWhenNoInteraction(int mouseX, int mouseY, @InputEventMask int modifiersEx) {
        void $this$forEach$iv;
        void $this$flatMapTo$iv$iv;
        SceneView sceneView = this.surface.getSceneViewAtOrPrimary(mouseX, mouseY);
        if (sceneView != null) {
            SceneContext context = sceneView.getContext();
            context.setMouseLocation(mouseX, mouseY);
            sceneView.getScene().mouseHover(context, Coordinates.getAndroidXDip(sceneView, mouseX), Coordinates.getAndroidYDip(sceneView, mouseY), modifiersEx);
            this.cursorWhenNoInteraction = sceneView.getScene().getMouseCursor();
        } else {
            this.cursorWhenNoInteraction = null;
        }
        Iterable $this$flatMap$iv = this.surface.getSceneManagers();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SceneManager it = (SceneManager)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getSceneViews();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SceneView it = (SceneView)element$iv;
            boolean bl = false;
            it.onHover(mouseX, mouseY);
        }
    }

    @Override
    public void stayHovering(int mouseX, int mouseY) {
        this.surface.onHover(mouseX, mouseY);
    }

    @Override
    public void popupMenuTrigger(@NotNull MouseEvent mouseEvent) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        int x = mouseEvent.getX();
        int y = mouseEvent.getY();
        int modifiersEx = mouseEvent.getModifiersEx();
        SceneView sceneView = this.surface.getSceneViewAtOrPrimary(x, y);
        if (sceneView != null) {
            NlComponent component = SceneViewHelper.selectComponentAt(sceneView, x, y, modifiersEx, false, true);
            DefaultActionGroup defaultActionGroup = this.surface.getActionManager().getPopupMenuActions(component, mouseEvent);
            Intrinsics.checkNotNullExpressionValue((Object)defaultActionGroup, (String)"getPopupMenuActions(...)");
            DefaultActionGroup actions = defaultActionGroup;
            ActionUtils.showPopup$default(this.surface, mouseEvent, actions, "LayoutEditor", null, 8, null);
        }
    }

    @Override
    @Nullable
    public Interaction createInteractionOnMouseWheelMoved(@NotNull MouseWheelEvent mouseWheelEvent) {
        Intrinsics.checkNotNullParameter((Object)mouseWheelEvent, (String)"mouseWheelEvent");
        int x = mouseWheelEvent.getX();
        int y = mouseWheelEvent.getY();
        SceneView sceneView = this.surface.getSceneViewAtOrPrimary(x, y);
        if (sceneView == null) {
            return null;
        }
        SceneView sceneView2 = sceneView;
        NlComponent nlComponent = Coordinates.findComponent(sceneView2, x, y);
        if (nlComponent == null) {
            return null;
        }
        NlComponent component = nlComponent;
        return ScrollInteraction.createScrollInteraction(sceneView2, component);
    }

    @Override
    public void singleClick(@NotNull MouseEvent mouseEvent, @InputEventMask int modifiersEx) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        int x = mouseEvent.getX();
        int y = mouseEvent.getY();
        FileEditor selectedEditor = FileEditorManager.getInstance((Project)this.surface.getProject()).getSelectedEditor();
        if (selectedEditor instanceof DesignToolsSplitEditor) {
            DesignToolsSplitEditor splitEditor = (DesignToolsSplitEditor)selectedEditor;
            SceneView sceneView = this.surface.getSceneViewAtOrPrimary(x, y);
            if (sceneView == null) {
                return;
            }
            SceneView sceneView2 = sceneView;
            NlComponent component = Coordinates.findComponent(sceneView2, x, y);
            if (component != null) {
                InteractionHandlerKt.navigateToComponent(component, false);
            }
        }
    }

    @Override
    public void onCaretMoved(int line) {
    }

    @Override
    public void doubleClick(@NotNull MouseEvent mouseEvent, @InputEventMask int modifiersEx) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        int x = mouseEvent.getX();
        int y = mouseEvent.getY();
        SceneView sceneView = this.surface.getSceneViewAtOrPrimary(x, y);
        if (sceneView == null) {
            return;
        }
        SceneView sceneView2 = sceneView;
        NlComponent component = Coordinates.findComponent(sceneView2, x, y);
        if (component != null) {
            this.surface.notifyComponentActivate(component, Coordinates.getAndroidX(sceneView2, x), Coordinates.getAndroidY(sceneView2, y));
        }
    }

    @Override
    @Nullable
    public Cursor getCursorWhenNoInteraction(int mouseX, int mouseY, @InputEventMask int modifiersEx) {
        return this.cursorWhenNoInteraction;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Interaction keyPressedWithoutInteraction(@NotNull KeyEvent keyEvent) {
        Intrinsics.checkNotNullParameter((Object)keyEvent, (String)"keyEvent");
        int keyCode = keyEvent.getKeyCode();
        if (keyCode == DesignSurfaceShortcut.PAN.getKeyCode()) {
            return new PanInteraction(this.surface.getPannable());
        }
        if (keyEvent.isAltDown() || keyEvent.isMetaDown() || keyEvent.isShiftDown() || keyEvent.isControlDown()) {
            return null;
        }
        switch (keyCode) {
            case 8: 
            case 127: {
                void $this$toTypedArray$iv;
                Collection<XmlFile> collection;
                void $this$mapTo$iv$iv;
                Collection $this$map$iv;
                void $this$groupByTo$iv$iv;
                if (ConstraintComponentUtilities.clearSelectedConstraint(this.surface)) break;
                List<NlComponent> selection = this.surface.getSelectionModel().getSelection();
                Iterable $this$groupBy$iv = selection;
                boolean $i$f$groupBy22 = false;
                Iterable iterable = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object;
                    NlComponent it = (NlComponent)element$iv$iv;
                    boolean bl = false;
                    NlModel key$iv$iv = it.getModel();
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                Map modelComponentsMap = destination$iv$iv;
                Iterable $i$f$groupBy22 = modelComponentsMap.keySet();
                Runnable runnable = () -> InteractionHandlerBase.keyPressedWithoutInteraction$lambda$1(modelComponentsMap);
                String string = null;
                String string2 = "Delete Components";
                Project project = this.surface.getProject();
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    NlModel bl = (NlModel)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl3 = false;
                    collection.add(it.getFile());
                }
                collection = (List)destination$iv$iv2;
                $this$map$iv = collection;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                XmlFile[] xmlFileArray = thisCollection$iv.toArray(new XmlFile[0]);
                WriteCommandAction.runWriteCommandAction((Project)project, (String)string2, string, (Runnable)runnable, (PsiFile[])((PsiFile[])Arrays.copyOf(xmlFileArray, xmlFileArray.length)));
            }
        }
        return null;
    }

    @Override
    public void keyReleasedWithoutInteraction(@NotNull KeyEvent keyEvent) {
        Intrinsics.checkNotNullParameter((Object)keyEvent, (String)"keyEvent");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void mouseExited() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.surface.getSceneManagers();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SceneManager it = (SceneManager)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getSceneViews();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SceneView it = (SceneView)element$iv;
            boolean bl = false;
            it.getScene().mouseHover(it.getContext(), Integer.MIN_VALUE, Integer.MIN_VALUE, 0);
            it.onHover(Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
    }

    private static final void keyPressedWithoutInteraction$lambda$1(Map $modelComponentsMap) {
        Map $this$forEach$iv = $modelComponentsMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
            NlModel model = (NlModel)k;
            List nlComponents = (List)entry.getValue();
            model.getTreeWriter().delete(nlComponents);
        }
    }
}

