/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.actions.PasteWithIdOptionAction;
import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.ItemTransferable;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.NlTreeWriterKt;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006B\u0019\b\u0004\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0004\b\n\u0010\fJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001e\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020&2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020&0,H'J\u0010\u0010-\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010.\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010/\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u00100\u001a\u00020\u001eH\u0002J\u0018\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u00020\u001e2\u0006\u00103\u001a\u00020\u001eH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00018\u00008\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\u0004\u0018\u00018\u00008DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0014X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010%\u001a\u0004\u0018\u00010&8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0016\u00104\u001a\u0004\u0018\u0001058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u00068"}, d2={"Lcom/android/tools/idea/common/surface/DesignSurfaceActionHandler;", "T", "Lcom/android/tools/idea/common/surface/DesignSurface;", "Lcom/intellij/ide/DeleteProvider;", "Lcom/intellij/ide/CutProvider;", "Lcom/intellij/ide/CopyProvider;", "Lcom/intellij/ide/PasteProvider;", "surface", "myCopyPasteManager", "Lcom/intellij/openapi/ide/CopyPasteManager;", "<init>", "(Lcom/android/tools/idea/common/surface/DesignSurface;Lcom/intellij/openapi/ide/CopyPasteManager;)V", "(Lcom/android/tools/idea/common/surface/DesignSurface;)V", "surfaceRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "surfaceOrNull", "getSurfaceOrNull", "()Lcom/android/tools/idea/common/surface/DesignSurface;", "flavor", "Ljava/awt/datatransfer/DataFlavor;", "getFlavor", "()Ljava/awt/datatransfer/DataFlavor;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "performCopy", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isCopyEnabled", "", "isCopyVisible", "performCut", "isCutEnabled", "isCutVisible", "deleteElement", "canDeleteElement", "pasteTarget", "Lcom/android/tools/idea/common/model/NlComponent;", "getPasteTarget", "()Lcom/android/tools/idea/common/model/NlComponent;", "canHandleChildren", "component", "pasted", "", "performPaste", "isPastePossible", "isPasteEnabled", "hasNonEmptySelection", "pasteOperation", "checkOnly", "generateNewIds", "clipboardData", "Lcom/android/tools/idea/common/model/DnDTransferItem;", "getClipboardData", "()Lcom/android/tools/idea/common/model/DnDTransferItem;", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public abstract class DesignSurfaceActionHandler<T extends DesignSurface<?>>
implements DeleteProvider,
CutProvider,
CopyProvider,
PasteProvider {
    @NotNull
    private final CopyPasteManager myCopyPasteManager;
    @NotNull
    private final WeakReference<T> surfaceRef;
    public static final int $stable = 8;

    protected DesignSurfaceActionHandler(@NotNull T surface2, @NotNull CopyPasteManager myCopyPasteManager) {
        Intrinsics.checkNotNullParameter(surface2, (String)"surface");
        Intrinsics.checkNotNullParameter((Object)myCopyPasteManager, (String)"myCopyPasteManager");
        this.myCopyPasteManager = myCopyPasteManager;
        this.surfaceRef = new WeakReference<T>(surface2);
    }

    public DesignSurfaceActionHandler(@NotNull T surface2) {
        Intrinsics.checkNotNullParameter(surface2, (String)"surface");
        CopyPasteManager copyPasteManager = CopyPasteManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)copyPasteManager, (String)"getInstance(...)");
        this(surface2, copyPasteManager);
    }

    @Nullable
    protected final T getSurfaceOrNull() {
        DesignSurface designSurface2 = (DesignSurface)this.surfaceRef.get();
        if (designSurface2 == null) {
            return null;
        }
        DesignSurface surface2 = designSurface2;
        if (surface2.isDisposed()) {
            return null;
        }
        return (T)surface2;
    }

    @NotNull
    protected abstract DataFlavor getFlavor();

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        T t = this.getSurfaceOrNull();
        if (t == null) {
            return;
        }
        T surface2 = t;
        if (!((DesignSurface)surface2).getSelectionModel().isEmpty()) {
            this.myCopyPasteManager.setContents((Transferable)((DesignSurface)surface2).getSelectionAsTransferable());
        }
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return this.hasNonEmptySelection();
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    public void performCut(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        T t = this.getSurfaceOrNull();
        if (t == null) {
            return;
        }
        T surface2 = t;
        if (!((DesignSurface)surface2).getSelectionModel().isEmpty()) {
            ItemTransferable transferable = ((DesignSurface)surface2).getSelectionAsTransferable();
            try {
                Object object = transferable.getTransferData(this.getFlavor());
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.tools.idea.common.model.DnDTransferItem");
                DnDTransferItem transferItem = (DnDTransferItem)object;
                transferItem.setIsCut();
                this.myCopyPasteManager.setContents((Transferable)transferable);
            }
            catch (UnsupportedFlavorException e) {
                this.performCopy(dataContext);
            }
            this.deleteElement(dataContext);
        }
    }

    public boolean isCutEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return this.hasNonEmptySelection();
    }

    public boolean isCutVisible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        T t = this.getSurfaceOrNull();
        if (t == null) {
            return;
        }
        T surface2 = t;
        NlModel nlModel = ((DesignSurface)surface2).getModel();
        if (nlModel == null) {
            return;
        }
        NlModel model = nlModel;
        SelectionModel selectionModel = ((DesignSurface)surface2).getSelectionModel();
        model.getTreeWriter().delete((Collection<? extends NlComponent>)selectionModel.getSelection());
        selectionModel.clear();
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return this.hasNonEmptySelection();
    }

    @VisibleForTesting
    @Nullable
    public abstract NlComponent getPasteTarget();

    @VisibleForTesting
    public abstract boolean canHandleChildren(@NotNull NlComponent var1, @NotNull List<? extends NlComponent> var2);

    public void performPaste(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Boolean bl = (Boolean)PasteWithIdOptionAction.Companion.getPASTE_WITH_NEW_IDS_KEY().getData(dataContext);
        boolean generateNewIds = bl != null ? bl : true;
        this.pasteOperation(false, generateNewIds);
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return this.getPasteTarget() != null && this.getClipboardData() != null;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return this.pasteOperation(true, false);
    }

    private final boolean hasNonEmptySelection() {
        T t = this.getSurfaceOrNull();
        if (t == null) {
            return false;
        }
        T surface2 = t;
        return !((DesignSurface)surface2).getSelectionModel().isEmpty();
    }

    private final boolean pasteOperation(boolean checkOnly, boolean generateNewIds) {
        T t = this.getSurfaceOrNull();
        if (t == null) {
            return false;
        }
        T surface2 = t;
        NlComponent nlComponent = this.getPasteTarget();
        if (nlComponent == null) {
            return false;
        }
        NlComponent receiver = nlComponent;
        NlModel nlModel = receiver.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)nlModel, (String)"getModel(...)");
        NlModel model = nlModel;
        DnDTransferItem dnDTransferItem = this.getClipboardData();
        if (dnDTransferItem == null) {
            return false;
        }
        DnDTransferItem transferItem = dnDTransferItem;
        DragType dragType = transferItem.isCut() ? DragType.MOVE : DragType.PASTE;
        InsertType insertType = model.getTreeWriter().determineInsertType(dragType, transferItem, checkOnly, generateNewIds);
        List<NlComponent> pasted = model.getTreeWriter().createComponents(transferItem, insertType);
        NlComponent before = null;
        if (this.canHandleChildren(receiver, pasted)) {
            before = receiver.getChild(0);
        } else {
            while (!this.canHandleChildren(receiver, pasted)) {
                before = receiver.getNextSibling();
                if (receiver.getParent() != null) continue;
                return false;
            }
        }
        if (!model.getTreeWriter().canAddComponents(pasted, receiver, before, checkOnly)) {
            return false;
        }
        if (checkOnly) {
            return true;
        }
        transferItem.consumeCut();
        NlTreeWriterKt.addComponentsAndSelectedIfCreated$default(model.getTreeWriter(), pasted, receiver, before, insertType, ((DesignSurface)surface2).getSelectionModel(), null, 32, null);
        if (insertType.isPasteOperation()) {
            ((DesignSurface)surface2).getSelectionModel().setSelection(pasted);
        }
        return true;
    }

    private final DnDTransferItem getClipboardData() {
        Transferable contents;
        Transferable transferable = contents = this.myCopyPasteManager.getContents();
        return transferable != null ? DnDTransferItem.getTransferItem(transferable, false) : null;
    }
}

