/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.scene.Region;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SnappingInfo;
import java.awt.Point;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0016J\u0018\u0010$\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\r\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/common/scene/Placeholder;", "", "host", "Lcom/android/tools/idea/common/scene/SceneComponent;", "<init>", "(Lcom/android/tools/idea/common/scene/SceneComponent;)V", "getHost", "()Lcom/android/tools/idea/common/scene/SceneComponent;", "associatedComponent", "getAssociatedComponent", "isLiveUpdatableForComponent", "", "draggedComponent", "dominate", "getDominate", "()Z", "region", "Lcom/android/tools/idea/common/scene/Region;", "getRegion", "()Lcom/android/tools/idea/common/scene/Region;", "findNextSibling", "appliedComponent", "newParent", "snap", "info", "Lcom/android/tools/idea/common/scene/SnappingInfo;", "retPoint", "Ljava/awt/Point;", "updateLiveAttribute", "", "sceneComponent", "attributes", "Lcom/android/tools/idea/common/model/NlAttributesHolder;", "x", "", "y", "updateAttribute", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public abstract class Placeholder {
    @NotNull
    private final SceneComponent host;
    @NotNull
    private final SceneComponent associatedComponent;
    private final boolean dominate;
    public static final int $stable = 8;

    public Placeholder(@NotNull SceneComponent host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.associatedComponent = this.host = host;
        this.dominate = true;
    }

    @NotNull
    public final SceneComponent getHost() {
        return this.host;
    }

    @NotNull
    public SceneComponent getAssociatedComponent() {
        return this.associatedComponent;
    }

    public boolean isLiveUpdatableForComponent(@NotNull SceneComponent draggedComponent) {
        Intrinsics.checkNotNullParameter((Object)draggedComponent, (String)"draggedComponent");
        return false;
    }

    public boolean getDominate() {
        return this.dominate;
    }

    @NotNull
    public abstract Region getRegion();

    @Nullable
    public SceneComponent findNextSibling(@NotNull SceneComponent appliedComponent, @NotNull SceneComponent newParent) {
        SceneComponent sceneComponent;
        Intrinsics.checkNotNullParameter((Object)appliedComponent, (String)"appliedComponent");
        Intrinsics.checkNotNullParameter((Object)newParent, (String)"newParent");
        if (!Intrinsics.areEqual((Object)appliedComponent.getParent(), (Object)newParent)) {
            return null;
        }
        List<SceneComponent> siblings = newParent.getChildren();
        int index = siblings.indexOf(appliedComponent);
        if (index == -1) {
            sceneComponent = null;
        } else {
            Intrinsics.checkNotNull(siblings);
            sceneComponent = (SceneComponent)CollectionsKt.getOrNull(siblings, (int)(index + 1));
        }
        return sceneComponent;
    }

    public boolean snap(@NotNull SnappingInfo info, @NotNull Point retPoint) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)retPoint, (String)"retPoint");
        return false;
    }

    public void updateLiveAttribute(@NotNull SceneComponent sceneComponent, @NotNull NlAttributesHolder attributes, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)sceneComponent, (String)"sceneComponent");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
    }

    public abstract void updateAttribute(@NotNull SceneComponent var1, @NotNull NlAttributesHolder var2);
}

