/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.repository.GoogleMavenArtifactId;
import com.android.ide.common.resources.ResourceItemResolver;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.AttributesHelperKt;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponentBackend;
import com.android.tools.idea.common.model.NlComponentBackendEmpty;
import com.android.tools.idea.common.model.NlComponentBackendXml;
import com.android.tools.idea.common.model.NlComponentModificationDelegate;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.QualifiedName;
import com.android.tools.idea.rendering.parsers.PsiXmlTag;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.util.ListenerCollection;
import com.android.tools.rendering.parsers.AttributeSnapshot;
import com.android.tools.rendering.parsers.RenderXmlTag;
import com.android.tools.rendering.parsers.TagSnapshot;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class NlComponent
implements NlAttributesHolder {
    @VisibleForTesting
    public static final String ID_DYNAMIC = "@+id/_dynamic";
    @Nullable
    private XmlModelComponentMixin myMixin;
    private final List<NlComponent> children = new ArrayList<NlComponent>();
    @Nullable
    private List<NlComponent> cachedChildrenCopy = null;
    private NlComponent myParent;
    @NotNull
    private final NlModel myModel;
    @Nullable
    private TagSnapshot mySnapshot;
    @NotNull
    private NlComponentBackend myBackend;
    private final HashMap<Object, Object> myClientProperties = new HashMap();
    private final ListenerCollection<ChangeListener> myListeners = ListenerCollection.createWithDirectExecutor();
    private final ChangeEvent myChangeEvent = new ChangeEvent(this);
    private NlComponentModificationDelegate myComponentModificationDelegate;
    @Nullable
    AttributesTransaction myCurrentTransaction;
    long myAccessibilityId = -1L;
    private Navigatable myNavigatable;

    public NlComponent(@NotNull NlModel model, @NotNull XmlTag tag) {
        this.myModel = model;
        this.myBackend = new NlComponentBackendXml(model.getProject(), tag);
    }

    public NlComponent(@NotNull NlModel model, long accessibilityId) {
        this.myModel = model;
        this.myBackend = new NlComponentBackendEmpty();
        this.myAccessibilityId = accessibilityId;
    }

    @TestOnly
    public NlComponent(@NotNull NlModel model, @NotNull XmlTag tag, @NotNull SmartPsiElementPointer<XmlTag> tagPointer) {
        this.myModel = model;
        this.myBackend = new NlComponentBackendXml(model.getProject(), tag, tagPointer);
    }

    public void setComponentModificationDelegate(@Nullable NlComponentModificationDelegate delegate) {
        this.myComponentModificationDelegate = delegate;
    }

    @Nullable
    public NlComponentModificationDelegate getComponentModificationDelegate() {
        return this.myComponentModificationDelegate;
    }

    public void setMixin(@NotNull XmlModelComponentMixin mixin) {
        assert (this.myMixin == null);
        this.myMixin = mixin;
    }

    @Nullable
    public XmlModelComponentMixin getMixin() {
        return this.myMixin;
    }

    public void setAccessibilityId(long id) {
        this.myAccessibilityId = id;
    }

    public long getAccessibilityId() {
        return this.myAccessibilityId;
    }

    public void setNavigatable(@NotNull Navigatable navigatable) {
        this.myNavigatable = navigatable;
    }

    @Nullable
    public Navigatable getNavigatable() {
        if (this.myNavigatable != null) {
            return this.myNavigatable;
        }
        return this.myBackend.getDefaultNavigatable();
    }

    @Nullable
    public XmlTag getTag() {
        return this.myBackend.getTag();
    }

    @Deprecated
    @NotNull
    public XmlTag getTagDeprecated() {
        return this.myBackend.getTagDeprecated();
    }

    @NotNull
    public NlModel getModel() {
        return this.myModel;
    }

    public void setTag(@NotNull XmlTag tag) {
        this.myBackend.setTagElement(tag);
    }

    @Deprecated
    @Nullable
    public TagSnapshot getSnapshot() {
        return this.mySnapshot;
    }

    public void setSnapshot(@Nullable TagSnapshot snapshot) {
        this.mySnapshot = snapshot;
    }

    public void addChild(@NotNull NlComponent component) {
        this.addChild(component, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(@NotNull NlComponent component, @Nullable NlComponent before) {
        if (component == this) {
            throw new IllegalArgumentException();
        }
        List<NlComponent> list = this.children;
        synchronized (list) {
            int index;
            this.cachedChildrenCopy = null;
            int n = index = before != null ? this.children.indexOf(before) : -1;
            if (index != -1) {
                this.children.add(index, component);
            } else {
                this.children.add(component);
            }
        }
        component.setParent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(@NotNull NlComponent component) {
        if (component == this) {
            throw new IllegalArgumentException();
        }
        List<NlComponent> list = this.children;
        synchronized (list) {
            this.cachedChildrenCopy = null;
            this.children.remove(component);
        }
        component.setParent(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChildren(@Nullable List<NlComponent> components) {
        List<NlComponent> list = this.children;
        synchronized (list) {
            this.cachedChildrenCopy = null;
            this.children.clear();
            if (components == null) {
                return;
            }
            this.children.addAll(components);
        }
        for (NlComponent component : components) {
            if (component == this) {
                throw new IllegalArgumentException();
            }
            component.setParent(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<NlComponent> getChildren() {
        ImmutableList childrenCopy = this.cachedChildrenCopy;
        if (childrenCopy == null) {
            List<NlComponent> list = this.children;
            synchronized (list) {
                this.cachedChildrenCopy = childrenCopy = ImmutableList.copyOf(this.children);
            }
        }
        return childrenCopy;
    }

    public int getChildCount() {
        return this.getChildren().size();
    }

    @Nullable
    public NlComponent getChild(int index) {
        List<NlComponent> children = this.getChildren();
        return index >= 0 && index < children.size() ? children.get(index) : null;
    }

    @NotNull
    public Stream<NlComponent> flatten() {
        return Stream.concat(Stream.of(this), this.getChildren().stream().flatMap(NlComponent::flatten));
    }

    @Nullable
    public NlComponent getNextSibling() {
        if (this.myParent == null) {
            return null;
        }
        for (int index = 0; index < this.myParent.getChildCount(); ++index) {
            if (this.myParent.getChild(index) != this) continue;
            return this.myParent.getChild(index + 1);
        }
        return null;
    }

    @Nullable
    public NlComponent findViewByTag(@NotNull XmlTag tag) {
        if (this.getTagDeprecated() == tag) {
            return this;
        }
        for (NlComponent child : this.getChildren()) {
            NlComponent result = child.findViewByTag(tag);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void findViewsByTag(@NotNull XmlTag tag, @NotNull ImmutableList.Builder<NlComponent> builder) {
        for (NlComponent child : this.getChildren()) {
            child.findViewsByTag(tag, builder);
        }
        if (this.getTagDeprecated() == tag) {
            builder.add((Object)this);
        }
    }

    @NotNull
    public ImmutableList<NlComponent> findViewsByTag(@NotNull XmlTag tag) {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.findViewsByTag(tag, (ImmutableList.Builder<NlComponent>)builder);
        return builder.build();
    }

    @Nullable
    public NlComponent findViewByAccessibilityId(long id) {
        if (this.myAccessibilityId == id) {
            return this;
        }
        for (NlComponent child : this.getChildren()) {
            NlComponent result = child.findViewByAccessibilityId(id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public boolean isRoot() {
        return !(this.getTagDeprecated().getParent() instanceof XmlTag);
    }

    @NotNull
    public NlComponent getRoot() {
        NlComponent parent;
        NlComponent component = this;
        while (!component.isRoot() && (parent = component.getParent()) != null) {
            component = parent;
        }
        return component;
    }

    @Nullable
    public String getId() {
        String id = this.myCurrentTransaction != null ? this.myCurrentTransaction.getAndroidAttribute("id") : this.resolveAttribute("http://schemas.android.com/apk/res/android", "id");
        return id != null ? ResourcesUtil.stripPrefixFromId((String)id) : null;
    }

    public void clearTransaction() {
        if (this.myCurrentTransaction != null) {
            this.myCurrentTransaction.finishTransaction();
        }
    }

    @Nullable
    public NlComponent getParent() {
        return this.myParent;
    }

    private void setParent(@Nullable NlComponent parent) {
        this.myParent = parent;
    }

    @NotNull
    public String getTagName() {
        return this.myBackend.getTagName();
    }

    @NotNull
    public NlComponentBackend getBackend() {
        return this.myBackend;
    }

    public String toString() {
        if (this.getMixin() != null) {
            return this.getMixin().toString();
        }
        return String.format("<%s>", this.myBackend.getTagName());
    }

    @Override
    public void setAttribute(@Nullable String namespace, @NotNull String attribute, @Nullable String value) {
        TagSnapshot snapshot;
        String previous;
        XmlTag tag = this.getTagDeprecated();
        if (!tag.isValid()) {
            return;
        }
        String prefix = null;
        if (namespace != null) {
            this.transferNamespaces(this);
            prefix = IdeResourcesUtil.ensureNamespaceImported((XmlFile)((XmlFile)tag.getContainingFile()), (String)namespace, null);
        }
        if (!Objects.equals(previous = this.myBackend.getAttribute(attribute, namespace), value)) {
            this.myBackend.setAttribute(attribute, namespace, value);
        }
        if ((snapshot = this.mySnapshot) != null) {
            snapshot.setAttribute(attribute, namespace, prefix, value);
        }
    }

    @NotNull
    public AttributesTransaction startAttributeTransaction() {
        if (this.myCurrentTransaction == null) {
            this.myCurrentTransaction = new AttributesTransaction(this);
        }
        return this.myCurrentTransaction;
    }

    @Nullable
    public AttributesTransaction getAttributeTransaction() {
        return this.myCurrentTransaction;
    }

    @Nullable
    public String getLiveAttribute(@Nullable String namespace, @NotNull String attribute) {
        if (this.myCurrentTransaction != null) {
            return this.myCurrentTransaction.getAttribute(namespace, attribute);
        }
        return this.getAttribute(namespace, attribute);
    }

    public String getLiveAttributeWithoutStyleResolution(@Nullable String namespace, @NotNull String attribute) {
        if (this.myCurrentTransaction != null) {
            return this.myCurrentTransaction.getAttribute(namespace, attribute);
        }
        return this.getAttributeImpl(namespace, attribute, false);
    }

    @Override
    @Nullable
    public String getAttribute(@Nullable String namespace, @NotNull String attribute) {
        return this.getAttributeImpl(namespace, attribute, true);
    }

    @Nullable
    private String getAttributeImpl(@Nullable String namespace, @NotNull String attribute, boolean styleResolution) {
        TagSnapshot snapshot = this.mySnapshot;
        if (snapshot != null) {
            String value = snapshot.getAttribute(attribute, namespace);
            if (ID_DYNAMIC.equals(value) && attribute.equals("id") && this.getTagName().equals("ListView") && this.myBackend.getAttribute(attribute, namespace) == null) {
                return null;
            }
            if (value != null) {
                return value;
            }
            if (styleResolution) {
                ResourceNamespace resNamespace;
                String style = snapshot.getAttribute("style", "");
                if (style == null) {
                    return null;
                }
                ResourceUrl url = ResourceUrl.parse((String)style);
                if (url == null) {
                    return null;
                }
                ResourceReference styleRef = url.resolve(ResourceNamespace.RES_AUTO, ResourceNamespace.Resolver.EMPTY_RESOLVER);
                if (styleRef == null) {
                    return null;
                }
                ResourceNamespace resourceNamespace = resNamespace = namespace != null ? ResourceNamespace.fromNamespaceUri((String)namespace) : ResourceNamespace.TODO();
                if (resNamespace == null) {
                    return null;
                }
                ResourceItemResolver resourceItemResolver = this.myModel.getConfiguration().getResourceItemResolver();
                StyleResourceValue styleResValue = resourceItemResolver.getStyle(styleRef);
                if (styleResValue == null) {
                    return null;
                }
                StyleItemResourceValue item = resourceItemResolver.findItemInStyle(styleResValue, ResourceReference.attr((ResourceNamespace)resNamespace, (String)attribute));
                return item != null ? item.getValue() : null;
            }
        }
        return this.myBackend.getAttribute(attribute, namespace);
    }

    @Nullable
    public String resolveAttribute(@Nullable String namespace, @NotNull String attribute) {
        String value = this.getAttribute(namespace, attribute);
        if (value != null) {
            return value;
        }
        if (this.getMixin() != null) {
            return this.getMixin().getAttribute(namespace, attribute);
        }
        return null;
    }

    @NotNull
    public List<AttributeSnapshot> getAttributes() {
        return this.getAttributesImpl();
    }

    @NotNull
    public List<AttributeSnapshot> getAttributesImpl() {
        TagSnapshot snapshot = this.mySnapshot;
        if (snapshot != null) {
            return snapshot.attributes;
        }
        PsiXmlTag tag = new PsiXmlTag(this.getTagDeprecated());
        if (tag.isValid()) {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                return (List)application.runReadAction(() -> NlComponent.lambda$getAttributesImpl$0((RenderXmlTag)tag));
            }
            return AttributeSnapshot.createAttributesForTag((RenderXmlTag)tag);
        }
        return Collections.emptyList();
    }

    @Nullable
    public String ensureNamespace(@NotNull String suggestedPrefix, @NotNull String namespace) {
        XmlTag tag = this.getBackend().getTag();
        if (tag == null) {
            return null;
        }
        this.transferNamespaces(this);
        return IdeResourcesUtil.ensureNamespaceImported((XmlFile)((XmlFile)tag.getContainingFile()), (String)namespace, (String)suggestedPrefix);
    }

    public boolean isShowing() {
        return this.mySnapshot != null;
    }

    @Nullable
    public static String extractId(@Nullable String str) {
        if (str == null) {
            return null;
        }
        int index = str.lastIndexOf("@id/");
        if (index != -1) {
            return str.substring(index + 4);
        }
        index = str.lastIndexOf("@+id/");
        if (index != -1) {
            return str.substring(index + 5);
        }
        return null;
    }

    public void removeObsoleteAttributes() {
        Set<QualifiedName> obsoleteAttributes = AttributesHelperKt.getObsoleteAttributes(this);
        AttributesTransaction transaction = this.startAttributeTransaction();
        obsoleteAttributes.forEach(qualifiedName -> transaction.removeAttribute(qualifiedName.getNamespace(), qualifiedName.getName()));
        transaction.commit();
    }

    public final void putClientProperty(Object key, Object value) {
        this.myClientProperties.put(key, value);
    }

    public final Object getClientProperty(Object key) {
        return this.myClientProperties.get(key);
    }

    public final Object removeClientProperty(Object key) {
        return this.myClientProperties.remove(key);
    }

    public void addLiveChangeListener(ChangeListener listener2) {
        this.myListeners.add((Object)listener2);
    }

    public void removeLiveChangeListener(ChangeListener listener2) {
        this.myListeners.remove((Object)listener2);
    }

    public void fireLiveChangeEvent() {
        this.myListeners.forEach(listener2 -> listener2.stateChanged(this.myChangeEvent));
    }

    @NotNull
    public String assignId() {
        return this.assignId(this.getTagName());
    }

    public String ensureId() {
        if (this.getId() != null) {
            return this.getId();
        }
        return this.assignId();
    }

    @NotNull
    public String assignId(@NotNull String baseName) {
        return this.assignId(baseName, this.getModel().getTreeWriter().getIds());
    }

    @NotNull
    private String assignId(@NotNull Set<String> ids) {
        ViewHandler handler = NlComponentHelperKt.getViewHandler(this, () -> {});
        String baseName = handler != null ? handler.generateBaseId(this) : this.getTagName();
        return this.assignId(baseName, ids);
    }

    @NotNull
    private String assignId(@NotNull String baseName, @NotNull Set<String> ids) {
        String newId = NlComponent.generateId(baseName, ids, ResourceFolderType.LAYOUT, this.getModel().getModule());
        NlAttributesHolder attributes = this.myCurrentTransaction == null ? this : this.myCurrentTransaction;
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "id", "@+id/" + newId);
        this.getModel().getTreeWriter().getPendingIds().add(newId);
        return newId;
    }

    public void incrementId(@NotNull Set<String> ids) {
        String id = this.getId();
        if (id == null || id.isEmpty()) {
            ids.add(this.assignId(ids));
        } else {
            String baseName = id.replaceAll("[0-9]*$", "");
            if (baseName != null && !baseName.isEmpty()) {
                ids.add(this.assignId(baseName, ids));
            }
        }
    }

    @NotNull
    private static String generateId(@NotNull String baseName, @NotNull Set<String> ids, ResourceFolderType type, Module module) {
        String idValue = StringUtil.decapitalize((String)baseName.substring(baseName.lastIndexOf(46) + 1));
        Project project = module.getProject();
        idValue = IdeResourcesUtil.prependResourcePrefix((Module)module, (String)idValue, (ResourceFolderType)type);
        Object nextIdValue = idValue;
        int index = 0;
        NamesValidator validator = LanguageNamesValidation.INSTANCE.forLanguage((Language)JavaLanguage.INSTANCE);
        while (ids.contains(nextIdValue) || validator.isKeyword((String)nextIdValue, project)) {
            if (++index == 1 && !validator.isKeyword((String)nextIdValue, project)) {
                nextIdValue = idValue;
                continue;
            }
            nextIdValue = idValue + index;
        }
        return idValue + String.valueOf(index == 0 ? "" : Integer.valueOf(index));
    }

    @Nullable
    public String getTooltipText() {
        XmlModelComponentMixin mixin = this.getMixin();
        if (mixin != null) {
            return mixin.getTooltipText();
        }
        return null;
    }

    public boolean canAddTo(NlComponent receiver) {
        XmlModelComponentMixin mixin = this.getMixin();
        if (mixin != null) {
            return mixin.canAddTo(receiver);
        }
        return true;
    }

    public void moveTo(@NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType type, @NotNull Set<String> ids) {
        XmlModelComponentMixin mixin = this.getMixin();
        if (mixin != null) {
            mixin.beforeMove(type, receiver, ids);
        }
        NlComponent oldParent = this.getParent();
        this.addTags(receiver, before, type);
        if (mixin != null) {
            mixin.afterMove(type, oldParent, receiver);
        }
    }

    public void addTags(@NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType type) {
        XmlTag beforeTag;
        NlComponent parent = this.getParent();
        if (parent != null) {
            parent.removeChild(this);
        }
        XmlTag tag = this.getBackend().getTag();
        XmlTag receiverTag = receiver.getBackend().getTag();
        XmlTag xmlTag = beforeTag = before != null ? before.getBackend().getTag() : null;
        if (receiverTag == null || tag == null) {
            return;
        }
        if (receiverTag == tag) {
            return;
        }
        receiver.addChild(this, before);
        this.transferNamespaces(receiver);
        if (beforeTag != null) {
            this.setTag((XmlTag)receiverTag.addBefore((PsiElement)tag, (PsiElement)beforeTag));
        } else {
            this.setTag(receiverTag.addSubTag(tag, false));
        }
        if (type == InsertType.MOVE) {
            tag.delete();
        }
    }

    public void postCreateFromTransferrable(@NotNull DnDTransferComponent dndComponent) {
        XmlModelComponentMixin mixin = this.getMixin();
        if (mixin != null) {
            mixin.postCreateFromTransferrable(dndComponent);
        }
    }

    public boolean postCreate(@NotNull InsertType insertType) {
        XmlModelComponentMixin mixin = this.getMixin();
        if (mixin != null) {
            return mixin.postCreate(insertType);
        }
        return true;
    }

    private void transferNamespaces(@NotNull NlComponent receiver) {
        NlComponent root = receiver.getRoot();
        while (receiver != null && receiver != root) {
            XmlTag tag = receiver.getTag();
            if (tag != null && !tag.getLocalNamespaceDeclarations().isEmpty()) {
                receiver.transferLocalNamespaces(root);
            }
            receiver = receiver.getParent();
        }
        if (receiver != this) {
            this.transferLocalNamespaces(root);
        }
    }

    private void transferLocalNamespaces(@NotNull NlComponent root) {
        XmlTag rootTag = root.getTag();
        XmlTag tag = this.getTag();
        if (tag == null || rootTag == null || rootTag == tag) {
            return;
        }
        Map prefixToNamespace = rootTag.getLocalNamespaceDeclarations();
        HashMap namespaceToPrefix = Maps.newHashMap();
        for (Map.Entry entry : prefixToNamespace.entrySet()) {
            namespaceToPrefix.put((String)entry.getValue(), (String)entry.getKey());
        }
        HashMap oldPrefixToPrefix = Maps.newHashMap();
        for (Map.Entry entry : tag.getLocalNamespaceDeclarations().entrySet()) {
            String namespace = (String)entry.getValue();
            String prefix = (String)entry.getKey();
            String currentPrefix = (String)namespaceToPrefix.get(namespace);
            if (currentPrefix == null) {
                XmlFile file2 = this.getModel().getFile();
                String newPrefix = IdeResourcesUtil.ensureNamespaceImported((XmlFile)file2, (String)namespace, (String)prefix);
                if (prefix.equals(newPrefix)) continue;
                oldPrefixToPrefix.put(prefix, newPrefix);
                namespaceToPrefix.put(namespace, newPrefix);
                continue;
            }
            if (prefix.equals(currentPrefix)) continue;
            oldPrefixToPrefix.put(prefix, currentPrefix);
        }
        if (!oldPrefixToPrefix.isEmpty()) {
            NlComponent.updatePrefixes(tag, oldPrefixToPrefix);
        }
        this.removeNamespaceAttributes();
    }

    private static void updatePrefixes(@NotNull XmlTag tag, @NotNull Map<String, String> oldPrefixToPrefix) {
        for (XmlAttribute xmlAttribute : tag.getAttributes()) {
            String newPrefix;
            String prefix = xmlAttribute.getNamespacePrefix();
            if (prefix.isEmpty()) continue;
            if (prefix.equals("xmlns")) {
                newPrefix = oldPrefixToPrefix.get(xmlAttribute.getLocalName());
                if (newPrefix == null) continue;
                xmlAttribute.setName("xmlns:" + newPrefix);
                continue;
            }
            newPrefix = oldPrefixToPrefix.get(prefix);
            if (newPrefix == null) continue;
            xmlAttribute.setName(newPrefix + ":" + xmlAttribute.getLocalName());
        }
        for (XmlAttribute xmlAttribute : tag.getSubTags()) {
            NlComponent.updatePrefixes((XmlTag)xmlAttribute, oldPrefixToPrefix);
        }
    }

    private void removeNamespaceAttributes() {
        XmlTag tag = this.getTag();
        if (tag != null) {
            for (XmlAttribute attribute : tag.getAttributes()) {
                if (!attribute.getName().startsWith("xmlns:")) continue;
                attribute.delete();
            }
        }
    }

    public Set<GoogleMavenArtifactId> getDependencies() {
        XmlModelComponentMixin mixin = this.getMixin();
        if (mixin != null) {
            return mixin.getDependencies();
        }
        return ImmutableSet.of();
    }

    private static /* synthetic */ List lambda$getAttributesImpl$0(RenderXmlTag tag) {
        return AttributeSnapshot.createAttributesForTag((RenderXmlTag)tag);
    }

    public static abstract class XmlModelComponentMixin {
        private final NlComponent myComponent;

        public XmlModelComponentMixin(@NotNull NlComponent component) {
            this.myComponent = component;
        }

        @NotNull
        protected NlComponent getComponent() {
            return this.myComponent;
        }

        @Nullable
        public String getAttribute(@Nullable String namespace, @NotNull String attribute) {
            return null;
        }

        public String toString() {
            return String.format("<%s>", this.myComponent.getTagName());
        }

        @Nullable
        public String getTooltipText() {
            return null;
        }

        public boolean canAddTo(@NotNull NlComponent receiver) {
            return true;
        }

        public Set<GoogleMavenArtifactId> getDependencies() {
            return ImmutableSet.of();
        }

        public void beforeMove(@NotNull InsertType insertType, @NotNull NlComponent receiver, @NotNull Set<String> ids) {
        }

        public void afterMove(@NotNull InsertType insertType, @Nullable NlComponent previousParent, @NotNull NlComponent receiver) {
        }

        public boolean postCreate(@NotNull InsertType insertType) {
            return true;
        }

        public void postCreateFromTransferrable(DnDTransferComponent dndComponent) {
        }

        public abstract boolean maybeHandleDeletion(@NotNull Collection<NlComponent> var1);

        @NotNull
        public abstract Icon getIcon();
    }
}

