/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.common.error.DesignerCommonIssueNode;
import com.android.tools.idea.common.error.IssueNode;
import com.android.tools.idea.common.error.MyOpenFileDescriptor;
import com.android.tools.idea.common.error.OpenLayoutValidationNavigatable;
import com.android.tools.idea.common.error.SelectWearDevicesNavigatable;
import com.android.tools.idea.common.error.SelectWindowSizeDevicesNavigatable;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.InteractionHandlerKt;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintRenderIssue;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.ui.tree.LeafState;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/common/error/VisualLintIssueNode;", "Lcom/android/tools/idea/common/error/IssueNode;", "visualLintIssue", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintRenderIssue;", "parent", "Lcom/android/tools/idea/common/error/DesignerCommonIssueNode;", "<init>", "(Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintRenderIssue;Lcom/android/tools/idea/common/error/DesignerCommonIssueNode;)V", "getLeafState", "Lcom/intellij/ui/tree/LeafState;", "getChildren", "", "getNavigatable", "Lcom/intellij/pom/Navigatable;", "hashCode", "", "equals", "", "other", "", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class VisualLintIssueNode
extends IssueNode {
    @NotNull
    private final VisualLintRenderIssue visualLintIssue;
    public static final int $stable = 8;

    public VisualLintIssueNode(@NotNull VisualLintRenderIssue visualLintIssue, @Nullable DesignerCommonIssueNode parent) {
        Intrinsics.checkNotNullParameter((Object)visualLintIssue, (String)"visualLintIssue");
        super(null, visualLintIssue, parent);
        this.visualLintIssue = visualLintIssue;
    }

    @Override
    @NotNull
    public LeafState getLeafState() {
        return LeafState.DEFAULT;
    }

    @Override
    @NotNull
    public List<DesignerCommonIssueNode> getChildren() {
        return CollectionsKt.emptyList();
    }

    @Override
    @Nullable
    public Navigatable getNavigatable() {
        OpenLayoutValidationNavigatable openLayoutValidationNavigatable;
        OpenFileDescriptor navigatable;
        if (this.getProject() == null) {
            return null;
        }
        Navigatable navigatable2 = this.visualLintIssue.getNavigatable();
        OpenFileDescriptor openFileDescriptor = navigatable = navigatable2 instanceof OpenFileDescriptor ? (OpenFileDescriptor)navigatable2 : null;
        if (navigatable != null) {
            return (Navigatable)new MyOpenFileDescriptor(navigatable);
        }
        NlComponent targetComponent = (NlComponent)CollectionsKt.firstOrNull(this.visualLintIssue.getComponents());
        NlModel nlModel = (NlModel)CollectionsKt.firstOrNull((Iterable)this.visualLintIssue.getModels());
        if (Device.isWear(nlModel != null && (nlModel = nlModel.getConfiguration()) != null ? nlModel.getDevice() : null)) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            v3 = new SelectWearDevicesNavigatable(project);
        } else {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            v3 = openLayoutValidationNavigatable = (OpenLayoutValidationNavigatable)new SelectWindowSizeDevicesNavigatable(project);
        }
        if (targetComponent == null) {
            return openLayoutValidationNavigatable;
        }
        return new Navigatable(targetComponent, openLayoutValidationNavigatable, this){
            final /* synthetic */ NlComponent $targetComponent;
            final /* synthetic */ OpenLayoutValidationNavigatable $openLayoutValidationNavigatable;
            final /* synthetic */ VisualLintIssueNode this$0;
            {
                this.$targetComponent = $targetComponent;
                this.$openLayoutValidationNavigatable = $openLayoutValidationNavigatable;
                this.this$0 = $receiver;
            }

            public void navigate(boolean requestFocus) {
                InteractionHandlerKt.navigateToComponent(this.$targetComponent, true);
                this.$openLayoutValidationNavigatable.navigate(requestFocus);
            }

            public boolean canNavigate() {
                return this.this$0.getProject() != null;
            }

            public boolean canNavigateToSource() {
                return this.this$0.getProject() != null;
            }
        };
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[2];
        NodeDescriptor nodeDescriptor = this.getParentDescriptor();
        objectArray[0] = nodeDescriptor != null ? nodeDescriptor.getElement() : null;
        objectArray[1] = this.visualLintIssue.rangeBasedHashCode();
        return Objects.hash(objectArray);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        VisualLintIssueNode visualLintIssueNode = object2 instanceof VisualLintIssueNode ? (VisualLintIssueNode)((Object)object2) : null;
        if (visualLintIssueNode == null) {
            return false;
        }
        VisualLintIssueNode that = visualLintIssueNode;
        NodeDescriptor nodeDescriptor = that.getParentDescriptor();
        NodeDescriptor nodeDescriptor2 = this.getParentDescriptor();
        return Intrinsics.areEqual((Object)(nodeDescriptor != null ? nodeDescriptor.getElement() : null), (Object)(nodeDescriptor2 != null ? nodeDescriptor2.getElement() : null)) && that.visualLintIssue.rangeBasedHashCode() == this.visualLintIssue.rangeBasedHashCode();
    }
}

