/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.error.DesignerCommonIssueNode;
import com.android.tools.idea.common.error.DesignerCommonIssueRoot;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueNode;
import com.android.tools.idea.common.error.QuickFixableCellRenderer;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.util.containers.UtilKt;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/common/error/ShowQuickFixesAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class ShowQuickFixesAction
extends AnAction {
    public static final int $stable = 8;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent event) {
        IssueNode node;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Presentation presentation = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        String string = ActionsBundle.actionText((String)"ProblemsView.QuickFixes");
        if (string == null) {
            string = "Show Quick Fix";
        }
        presentation2.setText(string);
        Object object = event.getData(PlatformDataKeys.SELECTED_ITEM);
        IssueNode issueNode = node = object instanceof IssueNode ? (IssueNode)((Object)object) : null;
        if (node == null) {
            presentation2.setEnabled(false);
            return;
        }
        Stream<Issue.Fix> fixes = node.getIssue().getFixes();
        Stream<Issue.Suppress> suppress = node.getIssue().getSuppresses();
        if (UtilKt.isEmpty(fixes) && UtilKt.isEmpty(suppress)) {
            presentation2.setText("No Quick Fix for This Issue");
            presentation2.setEnabled(false);
        } else {
            presentation2.setEnabled(true);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event.getData(PlatformDataKeys.SELECTED_ITEM);
        IssueNode issueNode = object instanceof IssueNode ? (IssueNode)((Object)object) : null;
        if (issueNode == null) {
            return;
        }
        IssueNode node = issueNode;
        Issue issue = node.getIssue();
        List<Issue.Fix> list = issue.getFixes().toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        Collection collection = list;
        List<Issue.Suppress> list2 = issue.getSuppresses().toList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"toList(...)");
        List fixable = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        JBPopup jBPopup = JBPopupFactory.getInstance().createPopupChooserBuilder(fixable).setRenderer((ListCellRenderer)((Object)new QuickFixableCellRenderer())).setItemChosenCallback(arg_0 -> ShowQuickFixesAction.actionPerformed$lambda$1(arg_0 -> ShowQuickFixesAction.actionPerformed$lambda$0(node, arg_0), arg_0)).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup popup2 = jBPopup;
        InputEvent inputEvent = event.getInputEvent();
        MouseEvent mouseEvent = inputEvent instanceof MouseEvent ? (MouseEvent)inputEvent : null;
        if (mouseEvent == null) {
            popup2.showInBestPositionFor(event.getDataContext());
            return;
        }
        MouseEvent mouse = mouseEvent;
        Object object2 = mouse.getSource();
        ActionButton actionButton = object2 instanceof ActionButton ? (ActionButton)object2 : null;
        if (actionButton == null) {
            popup2.showInBestPositionFor(event.getDataContext());
            return;
        }
        ActionButton button = actionButton;
        popup2.showUnderneathOf((Component)button);
    }

    private static final Unit actionPerformed$lambda$0(IssueNode $node, Issue.QuickFixable it) {
        block1: {
            it.getAction().run();
            DesignerCommonIssueNode rootNode = $node.getParent();
            while (rootNode != null && !(rootNode instanceof DesignerCommonIssueRoot)) {
                NodeDescriptor nodeDescriptor = rootNode.getParentDescriptor();
                Object object = nodeDescriptor != null ? nodeDescriptor.getElement() : null;
                rootNode = object instanceof DesignerCommonIssueNode ? (DesignerCommonIssueNode)((Object)object) : null;
            }
            DesignerCommonIssueNode designerCommonIssueNode = rootNode;
            Object object = designerCommonIssueNode instanceof DesignerCommonIssueRoot ? (DesignerCommonIssueRoot)designerCommonIssueNode : null;
            if (object == null || (object = object.getIssueProvider()) == null) break block1;
            object.update();
        }
        return Unit.INSTANCE;
    }

    private static final void actionPerformed$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

