/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.editor;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.editor.DesignToolsSplitEditorKt;
import com.android.tools.idea.common.editor.DesignerEditor;
import com.android.tools.idea.common.editor.DesignerEditorPanel;
import com.android.tools.idea.common.editor.SplitEditor;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000201B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001aH\u0016J\b\u0010\u001e\u001a\u00020\u001aH\u0016J\u0017\u0010'\u001a\u0004\u0018\u00010\u001a2\u0006\u0010(\u001a\u00020)H\u0002\u00a2\u0006\u0002\u0010*J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020,H\u0016R\u0011\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00060\u0010R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0018\u00010\u0012R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0018\u00010\u0012R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0018\u00010\u0012R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u001f\u001a\f0 R\b\u0012\u0004\u0012\u00020\u00020\u00018TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001e\u0010#\u001a\f0 R\b\u0012\u0004\u0012\u00020\u00020\u00018TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u001e\u0010%\u001a\f0 R\b\u0012\u0004\u0012\u00020\u00020\u00018TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\"\u00a8\u00062"}, d2={"Lcom/android/tools/idea/common/editor/DesignToolsSplitEditor;", "Lcom/android/tools/idea/common/editor/SplitEditor;", "Lcom/android/tools/idea/common/editor/DesignerEditor;", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "designerEditor", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/fileEditor/TextEditor;Lcom/android/tools/idea/common/editor/DesignerEditor;Lcom/intellij/openapi/project/Project;)V", "getDesignerEditor", "()Lcom/android/tools/idea/common/editor/DesignerEditor;", "propertiesComponent", "Lcom/intellij/ide/util/PropertiesComponent;", "kotlin.jvm.PlatformType", "backgroundEditorHighlighter", "Lcom/android/tools/idea/common/editor/DesignToolsSplitEditor$CompoundBackgroundHighlighter;", "textViewToolbarAction", "Lcom/android/tools/idea/common/editor/DesignToolsSplitEditor$MyToolBarAction;", "splitViewToolbarAction", "designViewToolbarAction", "modePropertyName", "", "getModePropertyName", "()Ljava/lang/String;", "clearLastModeProperty", "", "getBackgroundHighlighter", "Lcom/intellij/codeHighlighting/BackgroundEditorHighlighter;", "selectNotify", "deselectNotify", "showEditorAction", "Lcom/android/tools/idea/common/editor/SplitEditor$SplitEditorAction;", "getShowEditorAction", "()Lcom/android/tools/idea/common/editor/SplitEditor$SplitEditorAction;", "showEditorAndPreviewAction", "getShowEditorAndPreviewAction", "showPreviewAction", "getShowPreviewAction", "setModeProperty", "state", "Lcom/android/tools/idea/common/editor/DesignerEditorPanel$State;", "(Lcom/android/tools/idea/common/editor/DesignerEditorPanel$State;)Lkotlin/Unit;", "getState", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "level", "Lcom/intellij/openapi/fileEditor/FileEditorStateLevel;", "setState", "MyToolBarAction", "CompoundBackgroundHighlighter", "intellij.android.designer"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDesignToolsSplitEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesignToolsSplitEditor.kt\ncom/android/tools/idea/common/editor/DesignToolsSplitEditor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,226:1\n1#2:227\n295#3,2:228\n*S KotlinDebug\n*F\n+ 1 DesignToolsSplitEditor.kt\ncom/android/tools/idea/common/editor/DesignToolsSplitEditor\n*L\n177#1:228,2\n*E\n"})
public class DesignToolsSplitEditor
extends SplitEditor<DesignerEditor> {
    @NotNull
    private final DesignerEditor designerEditor;
    @NotNull
    private final Project project;
    private final PropertiesComponent propertiesComponent;
    @NotNull
    private final CompoundBackgroundHighlighter backgroundEditorHighlighter;
    @Nullable
    private MyToolBarAction textViewToolbarAction;
    @Nullable
    private MyToolBarAction splitViewToolbarAction;
    @Nullable
    private MyToolBarAction designViewToolbarAction;
    public static final int $stable = 8;

    public DesignToolsSplitEditor(@NotNull TextEditor textEditor2, @NotNull DesignerEditor designerEditor, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)textEditor2, (String)"textEditor");
        Intrinsics.checkNotNullParameter((Object)designerEditor, (String)"designerEditor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(textEditor2, (FileEditor)designerEditor, "Design", DesignToolsSplitEditorKt.access$defaultLayout(designerEditor));
        this.designerEditor = designerEditor;
        this.project = project;
        this.propertiesComponent = PropertiesComponent.getInstance();
        this.backgroundEditorHighlighter = new CompoundBackgroundHighlighter();
        this.clearLastModeProperty();
    }

    @NotNull
    public final DesignerEditor getDesignerEditor() {
        return this.designerEditor;
    }

    private final String getModePropertyName() {
        VirtualFile virtualFile = this.getFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file2 = virtualFile;
        String string = "%s_%s";
        Object[] objectArray = new Object[]{"SPLIT_EDITOR_MODE", file2.getPath()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private final void clearLastModeProperty() {
        PropertiesComponent.getInstance().setValue("DesignLayout", null);
    }

    @NotNull
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return this.backgroundEditorHighlighter;
    }

    public void selectNotify() {
        super.selectNotify();
        FileEditorManagerEx fileEditorManagerEx = FileEditorManagerEx.Companion.getInstanceEx(this.project);
        Editor editor = this.getTextEditor().getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        fileEditorManagerEx.runWhenLoaded(editor, () -> DesignToolsSplitEditor.selectNotify$lambda$0(this));
    }

    public void deselectNotify() {
        super.deselectNotify();
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)this.project).getSelectedEditors();
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getSelectedEditors(...)");
        if (!ArraysKt.contains((Object[])fileEditorArray, (Object)((Object)this))) {
            this.designerEditor.getComponent().deactivate();
        }
    }

    @Override
    @NotNull
    protected SplitEditor.SplitEditorAction getShowEditorAction() {
        if (this.textViewToolbarAction == null) {
            this.textViewToolbarAction = new MyToolBarAction(super.getShowEditorAction(), DesignerEditorPanel.State.DEACTIVATED);
        }
        MyToolBarAction myToolBarAction = this.textViewToolbarAction;
        Intrinsics.checkNotNull((Object)((Object)myToolBarAction));
        return myToolBarAction;
    }

    @Override
    @NotNull
    protected SplitEditor.SplitEditorAction getShowEditorAndPreviewAction() {
        if (this.splitViewToolbarAction == null) {
            this.splitViewToolbarAction = new MyToolBarAction(super.getShowEditorAndPreviewAction(), DesignerEditorPanel.State.SPLIT);
        }
        MyToolBarAction myToolBarAction = this.splitViewToolbarAction;
        Intrinsics.checkNotNull((Object)((Object)myToolBarAction));
        return myToolBarAction;
    }

    @Override
    @NotNull
    protected SplitEditor.SplitEditorAction getShowPreviewAction() {
        if (this.designViewToolbarAction == null) {
            this.designViewToolbarAction = new MyToolBarAction(super.getShowPreviewAction(), DesignerEditorPanel.State.FULL);
        }
        MyToolBarAction myToolBarAction = this.designViewToolbarAction;
        Intrinsics.checkNotNull((Object)((Object)myToolBarAction));
        return myToolBarAction;
    }

    private final Unit setModeProperty(DesignerEditorPanel.State state) {
        Unit unit;
        String string = this.getModePropertyName();
        if (string != null) {
            String it = string;
            boolean bl = false;
            this.propertiesComponent.setValue(it, state.name());
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        FileEditorState fileEditorState = this.myEditor.getState(level);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorState, (String)"getState(...)");
        return fileEditorState;
    }

    /*
     * WARNING - void declaration
     */
    public void setState(@NotNull FileEditorState state) {
        block5: {
            Object v0;
            block4: {
                void $this$firstOrNull$iv;
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                this.myEditor.setState(state);
                String propertyName = this.getModePropertyName();
                String propertyValue = null;
                if (propertyName != null) {
                    propertyValue = this.propertiesComponent.getValue(propertyName);
                }
                if (propertyValue == null) {
                    return;
                }
                DesignerEditorPanel.State panelState = DesignerEditorPanel.State.valueOf(propertyValue);
                if (panelState == this.designerEditor.getComponent().getState()) {
                    return;
                }
                Iterable iterable = this.getActions();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SplitEditor.SplitEditorAction it = (SplitEditor.SplitEditorAction)((Object)element$iv);
                    boolean bl = false;
                    if (!(it instanceof MyToolBarAction && ((MyToolBarAction)it).getPanelState() == panelState)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            SplitEditor.SplitEditorAction splitEditorAction = v0;
            if (splitEditorAction == null) break block5;
            SplitEditor.SplitEditorAction it = splitEditorAction;
            boolean bl = false;
            SplitEditor.selectAction$default(this, it, false, null, 4, null);
        }
    }

    private static final void selectNotify$lambda$0(DesignToolsSplitEditor this$0) {
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)this$0.project).getSelectedEditors();
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getSelectedEditors(...)");
        if (ArraysKt.contains((Object[])fileEditorArray, (Object)((Object)this$0))) {
            this$0.designerEditor.getComponent().activate();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/common/editor/DesignToolsSplitEditor$CompoundBackgroundHighlighter;", "Lcom/intellij/codeHighlighting/BackgroundEditorHighlighter;", "<init>", "(Lcom/android/tools/idea/common/editor/DesignToolsSplitEditor;)V", "createPassesForEditor", "", "Lcom/intellij/codeHighlighting/HighlightingPass;", "()[Lcom/intellij/codeHighlighting/HighlightingPass;", "intellij.android.designer"})
    private final class CompoundBackgroundHighlighter
    implements BackgroundEditorHighlighter {
        @NotNull
        public HighlightingPass[] createPassesForEditor() {
            Object[] textEditorHighlighter;
            Object[] objectArray = DesignToolsSplitEditor.this.getDesignerEditor().getBackgroundHighlighter().createPassesForEditor();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"createPassesForEditor(...)");
            Object[] designEditorPasses = objectArray;
            Object[] objectArray2 = textEditorHighlighter = DesignToolsSplitEditor.this.myEditor.getBackgroundHighlighter();
            if (textEditorHighlighter == null || (objectArray2 = objectArray2.createPassesForEditor()) == null) {
                objectArray2 = HighlightingPass.EMPTY_ARRAY;
            }
            Object[] textEditorPasses = objectArray2;
            Intrinsics.checkNotNull((Object)textEditorPasses);
            return (HighlightingPass[])ArraysKt.plus((Object[])designEditorPasses, (Object[])textEditorPasses);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\f0\u0001R\b\u0012\u0004\u0012\u00020\u00030\u0002B!\u0012\u0010\u0010\u0004\u001a\f0\u0001R\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\fH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/common/editor/DesignToolsSplitEditor$MyToolBarAction;", "Lcom/android/tools/idea/common/editor/SplitEditor$SplitEditorAction;", "Lcom/android/tools/idea/common/editor/SplitEditor;", "Lcom/android/tools/idea/common/editor/DesignerEditor;", "delegate", "panelState", "Lcom/android/tools/idea/common/editor/DesignerEditorPanel$State;", "<init>", "(Lcom/android/tools/idea/common/editor/DesignToolsSplitEditor;Lcom/android/tools/idea/common/editor/SplitEditor$SplitEditorAction;Lcom/android/tools/idea/common/editor/DesignerEditorPanel$State;)V", "getPanelState", "()Lcom/android/tools/idea/common/editor/DesignerEditorPanel$State;", "setSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "state", "", "userExplicitlySelected", "onUserSelectedAction", "intellij.android.designer"})
    private final class MyToolBarAction
    extends SplitEditor.SplitEditorAction {
        @NotNull
        private final DesignerEditorPanel.State panelState;

        public MyToolBarAction(@NotNull SplitEditor.SplitEditorAction delegate, DesignerEditorPanel.State panelState) {
            Intrinsics.checkNotNullParameter((Object)((Object)delegate), (String)"delegate");
            Intrinsics.checkNotNullParameter((Object)((Object)panelState), (String)"panelState");
            super(DesignToolsSplitEditor.this, delegate.getName(), delegate.getIcon(), delegate.getDelegate(), panelState != DesignerEditorPanel.State.FULL);
            this.panelState = panelState;
        }

        @NotNull
        public final DesignerEditorPanel.State getPanelState() {
            return this.panelState;
        }

        @Override
        public void setSelected(@NotNull AnActionEvent e, boolean state, boolean userExplicitlySelected) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            DesignToolsSplitEditor.this.getDesignerEditor().getComponent().setState(this.panelState);
            DesignToolsSplitEditor.this.setModeProperty(this.panelState);
            super.setSelected(e, state, userExplicitlySelected);
            DesignToolsSplitEditor.this.clearLastModeProperty();
        }

        @Override
        public void onUserSelectedAction() {
            DesignToolsSplitEditor.this.getDesignerEditor().getComponent().getSurface().getAnalyticsManager().trackSelectEditorMode(this.panelState);
        }
    }
}

