/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.actions.ConfigurationAction;
import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.actions.ThemeSelectionDialog;
import com.android.tools.idea.actions.ThemeUtils;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.xml.AttrNameSplitter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import icons.StudioIcons;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeMenuAction
extends DropDownAction {
    public ThemeMenuAction() {
        super("Theme for Preview", "Theme for Preview", StudioIcons.LayoutEditor.Toolbar.THEME_BUTTON);
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        this.updatePresentation(e);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private void updatePresentation(@NotNull AnActionEvent e) {
        boolean visible;
        Collection configurations = (Collection)e.getData(DesignerDataKeys.CONFIGURATIONS);
        Project project = e.getProject();
        Presentation presentation = e.getPresentation();
        presentation.putClientProperty(ActionUtil.SHOW_TEXT_IN_TOOLBAR, (Object)true);
        if (configurations == null || project == null || DumbService.getInstance((Project)project).isDumb()) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(true);
        Configuration configuration = (Configuration)Iterables.getFirst((Iterable)configurations, null);
        boolean bl = visible = configuration != null;
        if (visible) {
            String brief = ThemeMenuAction.getThemeLabel(configuration.getTheme(), true);
            presentation.setText(brief, false);
        }
        presentation.setVisible(visible);
    }

    @NotNull
    public static String getThemeLabel(@Nullable String theme, boolean brief) {
        int index;
        if (theme == null) {
            return "";
        }
        theme = IdeResourcesUtil.styleToTheme((String)theme);
        if (brief && (index = theme.lastIndexOf(46)) < theme.length() - 1) {
            return theme.substring(index + 1);
        }
        return theme;
    }

    protected boolean updateActions(@NotNull DataContext context) {
        this.removeAll();
        Collection configurations = (Collection)context.getData(DesignerDataKeys.CONFIGURATIONS);
        if (configurations == null) {
            return true;
        }
        Configuration configuration = (Configuration)Iterables.getFirst((Iterable)configurations, null);
        this.addThemeActions(configuration);
        this.add((AnAction)new MoreThemesAction());
        return true;
    }

    private void addThemeActions(@NotNull Configuration configuration) {
        ThemeResolver themeResolver = new ThemeResolver(configuration);
        StyleResourceValue[] baseThemes = themeResolver.requiredBaseThemes();
        String currentThemeName = this.getCurrentTheme(configuration);
        String defaultTheme = this.getDefaultTheme(configuration);
        String themeName = ThemeUtils.getPreferredThemeName(defaultTheme);
        this.add(new SetThemeAction(themeName, themeName + " [default]", ThemeMenuAction.isSameTheme(defaultTheme, currentThemeName)));
        this.addSeparator();
        ImmutableSet excludedThemes = ImmutableSet.of((Object)defaultTheme);
        Function1<ConfiguredThemeEditorStyle, Boolean> filter2 = ThemeUtils.createFilter(themeResolver, (Set<String>)excludedThemes, baseThemes);
        List<String> projectThemeWithoutDefaultTheme = ThemeUtils.getProjectThemeNames(themeResolver, filter2);
        this.addThemes(projectThemeWithoutDefaultTheme, currentThemeName, false);
        List<String> recommendedThemes = ThemeUtils.getRecommendedThemeNames(themeResolver, filter2);
        this.addThemes(recommendedThemes, currentThemeName, true);
        Project project = ConfigurationManager.getFromConfiguration((Configuration)configuration).getProject();
        HashSet<String> existingThemes = new HashSet<String>();
        existingThemes.addAll((Collection<String>)excludedThemes);
        existingThemes.addAll(projectThemeWithoutDefaultTheme);
        existingThemes.addAll(recommendedThemes);
        List<String> recentUsedThemes = ThemeUtils.getRecentlyUsedThemes(project, existingThemes);
        this.addThemes(recentUsedThemes, currentThemeName, true);
    }

    @NotNull
    private String getCurrentTheme(@NotNull Configuration configuration) {
        String theme = configuration.getTheme();
        theme = ThemeMenuAction.convertToNonResourcePrefixName(theme);
        return theme;
    }

    @NotNull
    private String getDefaultTheme(@NotNull Configuration configuration) {
        String theme = configuration.getPreferredTheme();
        return ThemeMenuAction.convertToNonResourcePrefixName(theme);
    }

    private void addThemes(List<String> themes, @Nullable String currentSelectedTheme, boolean builtInTheme) {
        if (themes.isEmpty()) {
            return;
        }
        for (String theme : themes) {
            String displayName = ThemeMenuAction.getThemeLabel(theme);
            if (builtInTheme) {
                displayName = ThemeUtils.getPreferredThemeName(displayName);
            }
            this.add(new SetThemeAction(theme, displayName, ThemeMenuAction.isSameTheme(theme, currentSelectedTheme)));
        }
        this.addSeparator();
    }

    @NotNull
    private static String getThemeLabel(@NotNull String theme) {
        return AttrNameSplitter.findLocalName((String)theme.substring(theme.indexOf(47) + 1));
    }

    private static boolean isSameTheme(@Nullable String left, @Nullable String right) {
        if (left == null) {
            return right == null;
        }
        return right != null && ThemeMenuAction.convertToNonResourcePrefixName(left).equals(ThemeMenuAction.convertToNonResourcePrefixName(right));
    }

    @NotNull
    private static String convertToNonResourcePrefixName(@NotNull String theme) {
        if (theme.startsWith("@android:style/")) {
            theme = theme.replace("@android:style/", "android:");
        }
        if (theme.startsWith("@style/")) {
            theme = theme.replace("@style/", "");
        }
        return theme;
    }

    @VisibleForTesting
    public static class MoreThemesAction
    extends DumbAwareAction {
        public MoreThemesAction() {
            super("More Themes...");
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String theme;
            ThemeSelectionDialog dialog;
            Collection configurations = (Collection)e.getData(DesignerDataKeys.CONFIGURATIONS);
            if (configurations == null) {
                return;
            }
            Configuration configuration = (Configuration)Iterables.getFirst((Iterable)configurations, null);
            if (configuration != null && (dialog = new ThemeSelectionDialog(configuration)).showAndGet() && (theme = dialog.getTheme()) != null) {
                configuration.setTheme(theme);
                ThemeUtils.addRecentlyUsedTheme(ConfigurationManager.getFromConfiguration((Configuration)configuration).getProject(), theme);
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }

    private class SetThemeAction
    extends ConfigurationAction {
        private final String myTheme;
        private final boolean mySelected;

        public SetThemeAction(@NotNull String theme, String themeDisplayName, boolean selected) {
            super(themeDisplayName);
            this.myTheme = theme;
            this.mySelected = selected;
        }

        public void update(@NotNull AnActionEvent event) {
            Presentation presentation = event.getPresentation();
            Toggleable.setSelected((Presentation)presentation, (boolean)this.mySelected);
        }

        @Override
        protected void updatePresentation(@NotNull AnActionEvent event) {
            ThemeMenuAction.this.updatePresentation(event);
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            configuration.setTheme(this.myTheme);
            Project project = ConfigurationManager.getFromConfiguration((Configuration)configuration).getProject();
            if (ThemeUtils.getRecentlyUsedThemes(project).contains(this.myTheme)) {
                ThemeUtils.addRecentlyUsedTheme(project, this.myTheme);
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }
}

