/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.ide.common.resources.Locale;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceRepositoryUtil;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.configurations.Configuration;
import com.android.tools.configurations.ConfigurationModelModule;
import com.android.tools.idea.actions.ConfigurationAction;
import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.actions.RtlAction;
import com.android.tools.idea.configurations.ConfigurationFileUtil;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.StudioConfigurationModelModule;
import com.android.tools.idea.editors.strings.StringResourceEditorProvider;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.rendering.StudioRenderServiceKt;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.res.ResourceRepositoryManager;
import com.google.common.collect.Iterables;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocaleMenuAction
extends DropDownAction {
    public LocaleMenuAction() {
        super("Locale for Preview", "Locale for Preview", null);
    }

    protected boolean updateActions(@NotNull DataContext context) {
        this.removeAll();
        Collection configurations = (Collection)context.getData(DesignerDataKeys.CONFIGURATIONS);
        if (configurations == null) {
            return true;
        }
        Configuration configuration = (Configuration)Iterables.getFirst((Iterable)configurations, null);
        String currentLocalLabel = Locale.getLocaleLabel((Locale)(configuration == null ? Locale.ANY : configuration.getLocale()), (boolean)false);
        List<Locale> locales = this.getRelevantLocales(configuration);
        if (configuration != null && !locales.isEmpty()) {
            String title = Locale.getLocaleLabel((Locale)Locale.ANY, (boolean)false);
            this.add(new SetLocaleAction(title, Locale.ANY, currentLocalLabel.equals(title)));
            this.addSeparator();
            Collections.sort(locales, Locale.LANGUAGE_CODE_COMPARATOR);
            for (Locale locale : locales) {
                title = Locale.getLocaleLabel((Locale)locale, (boolean)false);
                VirtualFile better = ConfigurationMatcher.getBetterMatch((Configuration)configuration, null, null, (Locale)locale, null);
                if (better != null) {
                    VirtualFile file2 = ConfigurationFileUtil.getVirtualFile((Configuration)configuration);
                    title = ConfigurationAction.getBetterMatchLabel(Locale.getLocaleLabel((Locale)locale, (boolean)true), better, file2);
                }
                this.add(new SetLocaleAction(title, locale, currentLocalLabel.equals(title)));
            }
            this.addSeparator();
        }
        this.add(new EditTranslationAction());
        if (configuration != null && !LocaleMenuAction.hasAnyRtlLocales(configuration, locales)) {
            this.add((AnAction)new RtlAction());
        }
        return true;
    }

    private static boolean hasAnyRtlLocales(@NotNull Configuration configuration, @NotNull List<Locale> locales) {
        Module module = ((StudioConfigurationModelModule)configuration.getConfigModule()).getModule();
        LayoutLibrary layoutlib = StudioRenderServiceKt.getLayoutLibrary((Module)module, (IAndroidTarget)configuration.getTarget());
        if (layoutlib == null) {
            return false;
        }
        return locales.stream().anyMatch(locale -> layoutlib.isRtl(locale.toLocaleId()));
    }

    @NotNull
    private List<Locale> getRelevantLocales(@Nullable Configuration configuration) {
        ResourceRepositoryManager repoManager;
        ArrayList<Locale> locales = new ArrayList<Locale>();
        if (configuration == null) {
            return Collections.emptyList();
        }
        ConfigurationModelModule module = configuration.getConfigModule();
        LocaleQualifier specificLocale = configuration.getEditedConfig().getLocaleQualifier();
        if (specificLocale != null) {
            VirtualFile file2 = ConfigurationFileUtil.getVirtualFile((Configuration)configuration);
            List variations = IdeResourcesUtil.getResourceVariations((VirtualFile)file2, (boolean)false);
            for (VirtualFile variation : variations) {
                FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)variation.getParent().getName());
                if (config == null || config.getLocaleQualifier() != null) continue;
                specificLocale = null;
                break;
            }
        }
        SortedSet languages = (repoManager = module.getResourceRepositoryManager()) != null ? ResourceRepositoryUtil.getLocales((ResourceRepository)repoManager.getProjectResources()) : Collections.emptySet();
        for (LocaleQualifier l : languages) {
            if (specificLocale != null && !specificLocale.isMatchFor((ResourceQualifier)l)) continue;
            locales.add(Locale.create((LocaleQualifier)l));
        }
        return locales;
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        this.updatePresentation(e);
        e.getPresentation().putClientProperty(ActionUtil.SHOW_TEXT_IN_TOOLBAR, (Object)true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private void updatePresentation(@NotNull AnActionEvent e) {
        boolean visible;
        e.getPresentation().putClientProperty(ActionUtil.SHOW_TEXT_IN_TOOLBAR, (Object)true);
        Collection configurations = (Collection)e.getData(DesignerDataKeys.CONFIGURATIONS);
        if (configurations == null) {
            return;
        }
        Configuration configuration = (Configuration)Iterables.getFirst((Iterable)configurations, null);
        Presentation presentation = e.getPresentation();
        boolean bl = visible = configuration != null;
        if (visible) {
            Locale locale = configuration.getLocale();
            presentation.setIcon(StudioIcons.LayoutEditor.Toolbar.LANGUAGE);
            String brief = Locale.getLocaleLabel((Locale)locale, (boolean)true);
            presentation.setText(brief);
        } else {
            presentation.setIcon(StudioIcons.LayoutEditor.Toolbar.LANGUAGE);
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    private class SetLocaleAction
    extends ConfigurationAction {
        private final Locale myLocale;
        private final boolean myIsCurrentLocale;

        public SetLocaleAction(@NotNull String title, Locale locale, boolean isCurrentLocale) {
            super(title, null);
            this.myLocale = locale;
            this.myIsCurrentLocale = isCurrentLocale;
        }

        public void update(@NotNull AnActionEvent event) {
            Presentation presentation = event.getPresentation();
            Toggleable.setSelected((Presentation)presentation, (boolean)this.myIsCurrentLocale);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent event) {
            super.actionPerformed(event);
            LocaleMenuAction.this.updateActions(event.getDataContext());
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (commit) {
                this.setProjectWideLocale(configuration);
            } else {
                configuration.getEditedConfig().setLayoutDirectionQualifier(null);
                configuration.setLocale(this.myLocale);
            }
        }

        @Override
        protected void pickedBetterMatch(@NotNull Configuration configuration, @NotNull VirtualFile file2, @NotNull VirtualFile old) {
            super.pickedBetterMatch(configuration, file2, old);
            this.setProjectWideLocale(configuration);
        }

        private void setProjectWideLocale(@NotNull Configuration configuration) {
            configuration.getSettings().setLocale(this.myLocale);
        }
    }

    private static class EditTranslationAction
    extends AnAction {
        public EditTranslationAction() {
            super("Edit Translations...", null, null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Collection configurations = (Collection)e.getData(DesignerDataKeys.CONFIGURATIONS);
            if (configurations == null) {
                return;
            }
            Configuration configuration = (Configuration)Iterables.getFirst((Iterable)configurations, null);
            if (configuration != null) {
                Module module = ((StudioConfigurationModelModule)configuration.getConfigModule()).getModule();
                StringResourceEditorProvider.openEditor((Module)module);
            }
        }
    }
}

