/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.RealNumbers;
import org.assertj.core.util.VisibleForTesting;

public class Floats
extends RealNumbers<Float> {
    private static final Floats INSTANCE = new Floats();

    public static Floats instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Floats() {
    }

    public Floats(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    @Override
    protected Float zero() {
        return Float.valueOf(0.0f);
    }

    @Override
    protected Float one() {
        return Float.valueOf(1.0f);
    }

    @Override
    protected Float NaN() {
        return Float.valueOf(Float.NaN);
    }

    @Override
    protected Float absDiff(Float actual, Float other) {
        return Float.valueOf(this.isNanOrInfinite(actual) || this.isNanOrInfinite(other) ? Math.abs(actual.floatValue() - other.floatValue()) : Math.abs(this.absBigDecimalDiff(actual, other).floatValue()));
    }

    @Override
    protected boolean isFinite(Float value2) {
        return Float.isFinite(value2.floatValue());
    }

    @Override
    protected boolean isNotFinite(Float value2) {
        return !Float.isFinite(value2.floatValue());
    }

    @Override
    protected boolean isInfinite(Float value2) {
        return Float.isInfinite(value2.floatValue());
    }

    @Override
    protected boolean isNotInfinite(Float value2) {
        return !Float.isInfinite(value2.floatValue());
    }

    @Override
    protected boolean isNaN(Float value2) {
        return Float.isNaN(value2.floatValue());
    }
}

