/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.core.handlers;

import com.anthropic.core.JsonMissing;
import com.anthropic.core.JsonValue;
import com.anthropic.core.http.HttpResponse;
import com.anthropic.errors.AnthropicInvalidDataException;
import com.anthropic.errors.BadRequestException;
import com.anthropic.errors.InternalServerException;
import com.anthropic.errors.NotFoundException;
import com.anthropic.errors.PermissionDeniedException;
import com.anthropic.errors.RateLimitException;
import com.anthropic.errors.UnauthorizedException;
import com.anthropic.errors.UnexpectedStatusCodeException;
import com.anthropic.errors.UnprocessableEntityException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00012\f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0000\u00a8\u0006\u0007"}, d2={"errorBodyHandler", "Lcom/anthropic/core/http/HttpResponse$Handler;", "Lcom/anthropic/core/JsonValue;", "jsonMapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "errorHandler", "Lcom/anthropic/core/http/HttpResponse;", "anthropic-java-core"})
@JvmName(name="ErrorHandler")
@SourceDebugExtension(value={"SMAP\nErrorHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ErrorHandler.kt\ncom/anthropic/core/handlers/ErrorHandler\n+ 2 JsonHandler.kt\ncom/anthropic/core/handlers/JsonHandler\n*L\n1#1,85:1\n13#2,8:86\n*S KotlinDebug\n*F\n+ 1 ErrorHandler.kt\ncom/anthropic/core/handlers/ErrorHandler\n*L\n23#1:86,8\n*E\n"})
public final class ErrorHandler {
    public static final /* synthetic */ HttpResponse.Handler errorBodyHandler(JsonMapper jsonMapper) {
        Intrinsics.checkNotNullParameter((Object)jsonMapper, (String)"jsonMapper");
        boolean $i$f$jsonHandler = false;
        HttpResponse.Handler handler = new HttpResponse.Handler<JsonValue>(jsonMapper){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public JsonValue handle(@NotNull HttpResponse response) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    object = this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<JsonValue>(){});
                }
                catch (Exception e) {
                    throw new AnthropicInvalidDataException("Error reading response", e);
                }
                return object;
            }
        };
        return new HttpResponse.Handler<JsonValue>((HttpResponse.Handler<JsonValue>)handler){
            final /* synthetic */ HttpResponse.Handler<JsonValue> $handler;
            {
                this.$handler = $handler;
            }

            @NotNull
            public JsonValue handle(@NotNull HttpResponse response) {
                JsonValue jsonValue;
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    jsonValue = this.$handler.handle(response);
                }
                catch (Exception e) {
                    jsonValue = JsonMissing.Companion.of();
                }
                return jsonValue;
            }
        };
    }

    public static final /* synthetic */ HttpResponse.Handler errorHandler(HttpResponse.Handler errorBodyHandler2) {
        Intrinsics.checkNotNullParameter((Object)errorBodyHandler2, (String)"errorBodyHandler");
        return new HttpResponse.Handler<HttpResponse>((HttpResponse.Handler<JsonValue>)errorBodyHandler2){
            final /* synthetic */ HttpResponse.Handler<JsonValue> $errorBodyHandler;
            {
                this.$errorBodyHandler = $errorBodyHandler;
            }

            @NotNull
            public HttpResponse handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                int statusCode = response.statusCode();
                if (!(200 <= statusCode ? statusCode < 300 : false)) {
                    if (statusCode == 400) {
                        throw BadRequestException.Companion.builder().headers(response.headers()).body(this.$errorBodyHandler.handle(response)).build();
                    }
                    if (statusCode == 401) {
                        throw UnauthorizedException.Companion.builder().headers(response.headers()).body(this.$errorBodyHandler.handle(response)).build();
                    }
                    if (statusCode == 403) {
                        throw PermissionDeniedException.Companion.builder().headers(response.headers()).body(this.$errorBodyHandler.handle(response)).build();
                    }
                    if (statusCode == 404) {
                        throw NotFoundException.Companion.builder().headers(response.headers()).body(this.$errorBodyHandler.handle(response)).build();
                    }
                    if (statusCode == 422) {
                        throw UnprocessableEntityException.Companion.builder().headers(response.headers()).body(this.$errorBodyHandler.handle(response)).build();
                    }
                    if (statusCode == 429) {
                        throw RateLimitException.Companion.builder().headers(response.headers()).body(this.$errorBodyHandler.handle(response)).build();
                    }
                    boolean bl = 500 <= statusCode ? statusCode < 600 : false;
                    if (bl) {
                        throw InternalServerException.Companion.builder().statusCode(statusCode).headers(response.headers()).body(this.$errorBodyHandler.handle(response)).build();
                    }
                    throw UnexpectedStatusCodeException.Companion.builder().statusCode(statusCode).headers(response.headers()).body(this.$errorBodyHandler.handle(response)).build();
                }
                return response;
            }
        };
    }
}

