/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.ide.common.blame.MessageJsonSerializer;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.manifmerger.AttributeOperationType;
import com.android.manifmerger.NodeOperationType;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import com.android.manifmerger.XmlLoader;
import com.android.manifmerger.XmlNode;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.io.LineReader;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;

public class Actions {
    @VisibleForTesting
    static final String HEADER = "-- Merging decision tree log ---\n";
    private final Map<XmlNode.NodeKey, DecisionTreeRecord> mRecords;

    public Actions(Map<XmlNode.NodeKey, DecisionTreeRecord> records) {
        this.mRecords = records;
    }

    @NotNull
    public Set<XmlNode.NodeKey> getNodeKeys() {
        return this.mRecords.keySet();
    }

    @NotNull
    public ImmutableList<NodeRecord> getNodeRecords(@NotNull XmlNode.NodeKey key) {
        return this.mRecords.containsKey(key) ? this.mRecords.get(key).getNodeRecords() : ImmutableList.of();
    }

    @NotNull
    public ImmutableList<XmlNode.NodeName> getRecordedAttributeNames(XmlNode.NodeKey nodeKey) {
        DecisionTreeRecord decisionTreeRecord = this.mRecords.get(nodeKey);
        if (decisionTreeRecord == null) {
            return ImmutableList.of();
        }
        return decisionTreeRecord.getAttributesRecords().keySet().asList();
    }

    @NotNull
    public ImmutableList<AttributeRecord> getAttributeRecords(XmlNode.NodeKey elementKey, XmlNode.NodeName attributeName) {
        DecisionTreeRecord decisionTreeRecord = this.mRecords.get(elementKey);
        if (decisionTreeRecord == null) {
            return ImmutableList.of();
        }
        return decisionTreeRecord.getAttributeRecords(attributeName);
    }

    void log(@NotNull ILogger logger) {
        logger.verbose(this.getLogs(), new Object[0]);
    }

    void log(@NotNull FileWriter fileWriter) throws IOException {
        fileWriter.append(this.getLogs());
    }

    private String getLogs() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(HEADER);
        for (Map.Entry<XmlNode.NodeKey, DecisionTreeRecord> record : this.mRecords.entrySet()) {
            stringBuilder.append(record.getKey()).append("\n");
            for (NodeRecord nodeRecord : record.getValue().getNodeRecords()) {
                nodeRecord.print(stringBuilder);
                stringBuilder.append('\n');
            }
            for (Map.Entry attributeRecords : record.getValue().mAttributeRecords.entrySet()) {
                stringBuilder.append('\t').append(attributeRecords.getKey()).append('\n');
                for (AttributeRecord attributeRecord : (List)attributeRecords.getValue()) {
                    stringBuilder.append("\t\t");
                    attributeRecord.print(stringBuilder);
                    stringBuilder.append('\n');
                }
            }
        }
        return stringBuilder.toString();
    }

    @NotNull
    public String persist() {
        GsonBuilder gson = new GsonBuilder().setPrettyPrinting();
        gson.enableComplexMapKeySerialization();
        MessageJsonSerializer.registerTypeAdapters((GsonBuilder)gson);
        return gson.create().toJson((Object)this);
    }

    @Nullable
    public static Actions load(@NotNull InputStream inputStream) {
        return (Actions)Actions.getGsonParser().fromJson((Reader)new InputStreamReader(inputStream), Actions.class);
    }

    @Nullable
    public static Actions load(String xml) {
        return (Actions)Actions.getGsonParser().fromJson(xml, Actions.class);
    }

    @NotNull
    private static Gson getGsonParser() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.enableComplexMapKeySerialization();
        gsonBuilder.registerTypeAdapter(XmlNode.NodeName.class, (Object)new NodeNameDeserializer());
        MessageJsonSerializer.registerTypeAdapters((GsonBuilder)gsonBuilder);
        return gsonBuilder.create();
    }

    public ImmutableMultimap<Integer, Record> getResultingSourceMapping(@NotNull XmlDocument xmlDocument) throws ParserConfigurationException, SAXException, IOException {
        SourceFile inMemory = SourceFile.UNKNOWN;
        XmlDocument loadedWithLineNumbers = XmlLoader.load(xmlDocument.getSelectors(), xmlDocument.getSystemPropertyResolver(), inMemory, xmlDocument.prettyPrint(), XmlDocument.Type.MAIN, null, xmlDocument.getModel());
        ImmutableMultimap.Builder mappingBuilder = ImmutableMultimap.builder();
        for (XmlElement xmlElement : loadedWithLineNumbers.getRootNode().getMergeableElements()) {
            this.parse(xmlElement, (ImmutableMultimap.Builder<Integer, Record>)mappingBuilder);
        }
        return mappingBuilder.build();
    }

    private void parse(@NotNull XmlElement element, @NotNull ImmutableMultimap.Builder<Integer, Record> mappings) {
        DecisionTreeRecord decisionTreeRecord = this.mRecords.get(element.getId());
        if (decisionTreeRecord != null) {
            NodeRecord nodeRecord = Actions.findNodeRecord(decisionTreeRecord);
            if (nodeRecord != null) {
                mappings.put((Object)element.getPosition().getStartLine(), (Object)nodeRecord);
            }
            for (XmlAttribute xmlAttribute : element.getAttributes()) {
                AttributeRecord attributeRecord = Actions.findAttributeRecord(decisionTreeRecord, xmlAttribute);
                if (attributeRecord == null) continue;
                mappings.put((Object)xmlAttribute.getPosition().getStartLine(), (Object)attributeRecord);
            }
        }
        for (XmlElement xmlElement : element.getMergeableElements()) {
            this.parse(xmlElement, mappings);
        }
    }

    @NotNull
    public String blame(@NotNull XmlDocument xmlDocument) throws IOException, SAXException, ParserConfigurationException {
        String line;
        ImmutableMultimap<Integer, Record> resultingSourceMapping = this.getResultingSourceMapping(xmlDocument);
        LineReader lineReader = new LineReader((Readable)new StringReader(xmlDocument.prettyPrint()));
        StringBuilder actualMappings = new StringBuilder();
        int count = 0;
        while ((line = lineReader.readLine()) != null) {
            actualMappings.append(count + 1).append(line).append("\n");
            if (resultingSourceMapping.containsKey((Object)count)) {
                for (Record record : resultingSourceMapping.get((Object)count)) {
                    actualMappings.append(count + 1).append("-->").append(record.getActionLocation().toString()).append("\n");
                }
            }
            ++count;
        }
        return actualMappings.toString();
    }

    @Nullable
    private static NodeRecord findNodeRecord(@NotNull DecisionTreeRecord decisionTreeRecord) {
        for (NodeRecord nodeRecord : decisionTreeRecord.getNodeRecords()) {
            if (nodeRecord.getActionType() != ActionType.ADDED) continue;
            return nodeRecord;
        }
        return null;
    }

    @Nullable
    public NodeRecord findNodeRecord(@NotNull XmlNode.NodeKey nodeKey) {
        for (NodeRecord nodeRecord : this.getNodeRecords(nodeKey)) {
            if (nodeRecord.getActionType() != ActionType.ADDED) continue;
            return nodeRecord;
        }
        return null;
    }

    @Nullable
    private static AttributeRecord findAttributeRecord(@NotNull DecisionTreeRecord decisionTreeRecord, @NotNull XmlAttribute xmlAttribute) {
        for (AttributeRecord attributeRecord : decisionTreeRecord.getAttributeRecords(xmlAttribute.getName())) {
            if (attributeRecord.getActionType() != ActionType.ADDED) continue;
            return attributeRecord;
        }
        return null;
    }

    @Nullable
    public AttributeRecord findAttributeRecord(@NotNull XmlNode.NodeKey nodeKey, @NotNull XmlNode.NodeName attributeName) {
        for (AttributeRecord attributeRecord : this.getAttributeRecords(nodeKey, attributeName)) {
            if (attributeRecord.getActionType() != ActionType.ADDED) continue;
            return attributeRecord;
        }
        return null;
    }

    static class DecisionTreeRecord {
        private final List<NodeRecord> mNodeRecords = new ArrayList<NodeRecord>();
        @NotNull
        final Map<XmlNode.NodeName, List<AttributeRecord>> mAttributeRecords = new HashMap<XmlNode.NodeName, List<AttributeRecord>>();

        @NotNull
        ImmutableList<NodeRecord> getNodeRecords() {
            return ImmutableList.copyOf(this.mNodeRecords);
        }

        @NotNull
        ImmutableMap<XmlNode.NodeName, List<AttributeRecord>> getAttributesRecords() {
            return ImmutableMap.copyOf(this.mAttributeRecords);
        }

        DecisionTreeRecord() {
        }

        void addNodeRecord(@NotNull NodeRecord nodeRecord) {
            this.mNodeRecords.add((NodeRecord)Preconditions.checkNotNull((Object)nodeRecord));
        }

        @NotNull
        ImmutableList<AttributeRecord> getAttributeRecords(XmlNode.NodeName attributeName) {
            List<AttributeRecord> attributeRecords = this.mAttributeRecords.get(attributeName);
            return attributeRecords == null ? ImmutableList.of() : ImmutableList.copyOf(attributeRecords);
        }
    }

    public static class NodeRecord
    extends Record {
        @NotNull
        private final NodeOperationType mNodeOperationType;

        NodeRecord(@NotNull ActionType actionType, @NotNull SourceFilePosition actionLocation, @NotNull XmlNode.NodeKey targetId, @Nullable String reason, @NotNull NodeOperationType nodeOperationType) {
            super(actionType, actionLocation, targetId, reason);
            this.mNodeOperationType = (NodeOperationType)Preconditions.checkNotNull((Object)nodeOperationType);
        }

        @NotNull
        public String toString() {
            return "Id=" + this.mTargetId.toString() + " actionType=" + String.valueOf((Object)this.getActionType()) + " location=" + String.valueOf(this.getActionLocation()) + " opType=" + String.valueOf(this.mNodeOperationType);
        }
    }

    public static class AttributeRecord
    extends Record {
        @Nullable
        private final AttributeOperationType mOperationType;

        AttributeRecord(@NotNull ActionType actionType, @NotNull SourceFilePosition actionLocation, @NotNull XmlNode.NodeKey targetId, @Nullable String reason, @Nullable AttributeOperationType operationType) {
            super(actionType, actionLocation, targetId, reason);
            this.mOperationType = operationType;
        }

        @Nullable
        public AttributeOperationType getOperationType() {
            return this.mOperationType;
        }

        @NotNull
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("Id", (Object)this.mTargetId).add("actionType=", (Object)this.getActionType()).add("location", (Object)this.getActionLocation()).add("opType", (Object)this.getOperationType()).toString();
        }
    }

    private static class NodeNameDeserializer
    implements JsonDeserializer<XmlNode.NodeName> {
        private NodeNameDeserializer() {
        }

        public XmlNode.NodeName deserialize(@NotNull JsonElement json, Type typeOfT, @NotNull JsonDeserializationContext context) throws JsonParseException {
            if (json.getAsJsonObject().get("mNamespaceURI") != null) {
                return (XmlNode.NodeName)context.deserialize(json, XmlNode.NamespaceAwareName.class);
            }
            return (XmlNode.NodeName)context.deserialize(json, XmlNode.Name.class);
        }
    }

    public static abstract class Record {
        @NotNull
        protected final ActionType mActionType;
        @NotNull
        protected final SourceFilePosition mActionLocation;
        @NotNull
        protected final XmlNode.NodeKey mTargetId;
        @Nullable
        protected final String mReason;

        private Record(@NotNull ActionType actionType, @NotNull SourceFilePosition actionLocation, @NotNull XmlNode.NodeKey targetId, @Nullable String reason) {
            this.mActionType = (ActionType)((Object)Preconditions.checkNotNull((Object)((Object)actionType)));
            this.mActionLocation = (SourceFilePosition)Preconditions.checkNotNull((Object)actionLocation);
            this.mTargetId = (XmlNode.NodeKey)Preconditions.checkNotNull((Object)targetId);
            this.mReason = reason;
        }

        @NotNull
        public ActionType getActionType() {
            return this.mActionType;
        }

        @NotNull
        public SourceFilePosition getActionLocation() {
            return this.mActionLocation;
        }

        @NotNull
        public XmlNode.NodeKey getTargetId() {
            return this.mTargetId;
        }

        @Nullable
        public String getReason() {
            return this.mReason;
        }

        public void print(@NotNull StringBuilder stringBuilder) {
            stringBuilder.append((Object)this.mActionType).append(" from ").append(this.mActionLocation);
            if (this.mReason != null) {
                stringBuilder.append(" reason: ").append(this.mReason);
            }
        }
    }

    public static enum ActionType {
        ADDED,
        INJECTED,
        MERGED,
        REJECTED,
        IMPLIED,
        CONVERTED;

    }
}

